/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.AttachListDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.BatchDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.BatchDownLoadStatus;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.data.model.SysBatchDownloadTask;
import com.jxdinfo.hussar.formdesign.application.data.service.BatchDownLodService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.properties.HussarFormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.view.Filter;
import com.jxdinfo.hussar.formdesign.file.fileoperate.util.ZipUtil;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class DownLoadCompent {
    @Resource
    private HussarFormDesignProperties hussarFormDesignFrameProperties;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private OssService ossService;
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    @Resource
    private ISysApplicationExternalService appExternalService;
    @Resource
    private BatchDownLodService batchDownLodService;
    private static final int MAX_QUERY_COUNT = 500;
    private static final int MAX_NAME = 50;
    private static final int START_NAME = 0;
    private static final Logger logger = LoggerFactory.getLogger(DownLoadCompent.class);

    public static String getFormatTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void handleAttachmentsInList(AttachListDownloadDto attachListDownloadDto, HttpServletResponse response, SysBatchDownloadTask task, String dataSourceKey) {
        HashMap<String, Integer> nameRepeat = new HashMap<String, Integer>();
        Long taskId = task.getTaskId();
        long timeStart = System.currentTimeMillis();
        logger.info("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadCompent.getFormatTime(timeStart));
        try {
            String projectBackPath = this.formDesignProperties.getBackProjectPath();
            String zipFolderName = attachListDownloadDto.getFileName();
            projectBackPath = projectBackPath + File.separator + System.currentTimeMillis() + File.separator;
            String zipFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), projectBackPath, zipFolderName});
            Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
            List fields = attachListDownloadDto.getFields();
            HashMap<String, String> fieldDirMap = new HashMap<String, String>(fields.size());
            for (Widget field : fields) {
                String fieldDir = FileUtil.posixPath((String[])new String[]{zipFolderPath, field.getTitle()});
                if (new File(fieldDir).exists()) continue;
                Files.createDirectories(Paths.get(fieldDir, new String[0]), new FileAttribute[0]);
                fieldDirMap.put(field.getTitle(), fieldDir);
            }
            List<EngineResultEntity> data = this.getDataDetails(attachListDownloadDto);
            for (EngineResultEntity businessData : data) {
                for (Widget field : fields) {
                    List<Long> fileIds = new ArrayList<Long>();
                    if (HussarUtils.isBlank((CharSequence)field.getParentKey())) {
                        String fieldValue = (String)businessData.get((Object)field.getName());
                        if (HussarUtils.isNotBlank((CharSequence)fieldValue)) {
                            fileIds = Arrays.stream(fieldValue.split(",")).map(Long::valueOf).collect(Collectors.toList());
                        }
                    } else {
                        List subTableData = (List)businessData.get((Object)field.getParentKey());
                        if (HussarUtils.isNotEmpty((Object)subTableData)) {
                            for (EngineResultEntity entity : subTableData) {
                                String fieldValue = (String)entity.get((Object)field.getName());
                                if (!HussarUtils.isNotBlank((CharSequence)fieldValue)) continue;
                                fileIds.addAll(Arrays.stream(fieldValue.split(",")).map(Long::valueOf).collect(Collectors.toList()));
                            }
                        }
                    }
                    if (!HussarUtils.isNotEmpty(fileIds)) continue;
                    this.copyFilesToFolder(fileIds, (String)fieldDirMap.get(field.getTitle()), nameRepeat);
                }
            }
            this.zipFile(zipFolderPath, zipFolderName, taskId, task);
        }
        catch (Exception e) {
            long timeEnd = System.currentTimeMillis();
            task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.FAIL.getStatus()));
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
            logger.error("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u7ed3\u675f\u3002\u4e0b\u8f7d\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadCompent.getFormatTime(timeEnd));
        }
        finally {
            this.batchDownLodService.updateById((Object)task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HussarDs(value="#dataSourceKey")
    public void handleBatchDownload(BatchDownloadDto batchDownloadDto, HttpServletResponse response, SysBatchDownloadTask task, String dataSourceKey) {
        HashMap<String, Integer> nameRepeat = new HashMap<String, Integer>();
        Long taskId = task.getTaskId();
        long timeStart = System.currentTimeMillis();
        logger.info("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u5f00\u59cb\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadCompent.getFormatTime(timeStart));
        try {
            String projectBackPath = this.formDesignProperties.getBackProjectPath();
            String downloadType = batchDownloadDto.getType();
            String zipFolderName = batchDownloadDto.getFileName();
            projectBackPath = projectBackPath + File.separator + System.currentTimeMillis() + File.separator;
            String zipFolderPath = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), projectBackPath, zipFolderName});
            Files.createDirectories(Paths.get(zipFolderPath, new String[0]), new FileAttribute[0]);
            switch (downloadType) {
                case "list": {
                    List data = batchDownloadDto.getData();
                    for (BatchDownloadDto.MyDetail myDetail : data) {
                        String id = myDetail.getId();
                        String title = myDetail.getTitle();
                        String detailFolderName = title + "#" + id.substring(id.length() - 4);
                        String detailFolderPath = FileUtil.posixPath((String[])new String[]{zipFolderPath, detailFolderName});
                        Files.createDirectory(Paths.get(detailFolderPath, new String[0]), new FileAttribute[0]);
                        for (BatchDownloadDto.MyField myField : myDetail.getFields()) {
                            String name = myField.getName();
                            String label = myField.getLabel();
                            String fieldFolderName = label + "#" + name.substring(name.length() - 4);
                            String fieldFolderPath = FileUtil.posixPath((String[])new String[]{detailFolderPath, fieldFolderName});
                            Files.createDirectory(Paths.get(fieldFolderPath, new String[0]), new FileAttribute[0]);
                            this.copyFilesToFolder(myField.getFileIds(), fieldFolderPath, nameRepeat);
                        }
                    }
                    break;
                }
                case "detail": {
                    List fields = ((BatchDownloadDto.MyDetail)batchDownloadDto.getData().get(0)).getFields();
                    for (BatchDownloadDto.MyField myField : fields) {
                        String label = myField.getLabel();
                        String fieldFolderPath = FileUtil.posixPath((String[])new String[]{zipFolderPath, label});
                        if (!new File(fieldFolderPath).exists()) {
                            Files.createDirectory(Paths.get(fieldFolderPath, new String[0]), new FileAttribute[0]);
                        }
                        this.copyFilesToFolder(myField.getFileIds(), fieldFolderPath, nameRepeat);
                    }
                    break;
                }
                case "field": {
                    List fileIds = ((BatchDownloadDto.MyField)((BatchDownloadDto.MyDetail)batchDownloadDto.getData().get(0)).getFields().get(0)).getFileIds();
                    this.copyFilesToFolder(fileIds, zipFolderPath, nameRepeat);
                    break;
                }
                default: {
                    throw new HussarException("\u4e0b\u8f7d\u7c7b\u578b\u4e0d\u7b26\u5408\u89c4\u8303");
                }
            }
            this.zipFile(zipFolderPath, zipFolderName, taskId, task);
        }
        catch (Exception e) {
            long timeEnd = System.currentTimeMillis();
            task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.FAIL.getStatus()));
            logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
            logger.error("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u7ed3\u675f\u3002\u4e0b\u8f7d\u5931\u8d25\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadCompent.getFormatTime(timeEnd));
        }
        finally {
            this.batchDownLodService.updateById((Object)task);
        }
    }

    public void copyFilesToFolder(List<Long> fileIds, String basicPath, Map<String, Integer> nameRepeat) {
        String[] ids = new String[fileIds.size()];
        for (int i = 0; i < fileIds.size(); ++i) {
            ids[i] = String.valueOf(fileIds.get(i));
        }
        List attachmentManagerModels = this.ossService.getByFileIds(ids);
        for (AttachmentManagerModel attachmentManagerModel : attachmentManagerModels) {
            String attachmentDir = attachmentManagerModel.getAttachmentDir();
            Long attachmentId = attachmentManagerModel.getId();
            String attachmentType = attachmentManagerModel.getAttachmentType();
            String sourcePath = FileUtil.posixPath((String[])new String[]{attachmentDir, attachmentId + "." + attachmentType});
            String attachmentName = attachmentManagerModel.getAttachmentName();
            String pre = "";
            int index = attachmentName.lastIndexOf(".");
            if (index > -1) {
                pre = attachmentName.substring(0, index);
            }
            if (pre.length() > 50) {
                pre = pre.substring(0, 50);
            }
            attachmentName = pre + "." + attachmentManagerModel.getAttachmentType();
            attachmentManagerModel.setAttachmentName(attachmentName);
            String destinationPath = FileUtil.posixPath((String[])new String[]{basicPath, attachmentName});
            if (new File(destinationPath).exists()) {
                String fileName;
                if (nameRepeat.containsKey(destinationPath)) {
                    Integer repeatCount = nameRepeat.get(destinationPath);
                    fileName = attachmentManagerModel.getAttachmentName().substring(0, attachmentManagerModel.getAttachmentName().lastIndexOf(".")) + "(" + (repeatCount + 1) + ")." + attachmentType;
                    nameRepeat.put(destinationPath, repeatCount + 1);
                } else {
                    fileName = attachmentManagerModel.getAttachmentName().substring(0, attachmentManagerModel.getAttachmentName().lastIndexOf(".")) + "(1)." + attachmentType;
                    nameRepeat.put(destinationPath, 1);
                }
                destinationPath = FileUtil.posixPath((String[])new String[]{basicPath, fileName});
            }
            this.copyFileById(attachmentId, destinationPath);
        }
    }

    public Long zipFile(String zipFolderPath, String zipFolderName, Long taskId, SysBatchDownloadTask task) throws Exception {
        File parentDir = new File(zipFolderPath).getParentFile();
        String zipPath = parentDir.getAbsolutePath() + File.separator + UUID.randomUUID() + ".zip";
        ZipUtil.zip((String)zipFolderPath, (String)zipPath);
        MockMultipartFile multipartFile = new MockMultipartFile(zipFolderName + ".zip", zipFolderName + ".zip", ".zip", Files.newInputStream(Paths.get(zipPath, new String[0]), new OpenOption[0]));
        ApiResponse longApiResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        Long data = (Long)longApiResponse.getData();
        long timeEnd = System.currentTimeMillis();
        logger.info("\u6279\u91cf\u4e0b\u8f7d\u4efb\u52a1\uff1a{}\u7ed3\u675f\u3002\u4e0b\u8f7d\u6210\u529f\uff0c\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)taskId, (Object)DownLoadCompent.getFormatTime(timeEnd));
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.SUCCESS.getStatus()));
        task.setFileId(data);
        return data;
    }

    public static String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }

    private void copyFile(String sourcePath, String destinationPath) {
        Path source = Paths.get(sourcePath, new String[0]);
        Path destination = Paths.get(destinationPath, new String[0]);
        try {
            Files.createFile(destination, new FileAttribute[0]);
            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void copyFileById(Long sourceFileId, String destinationPath) {
        ApiResponse download = this.ossService.backgroundDownload(sourceFileId);
        byte[] data = (byte[])download.getData();
        try {
            FileUtils.writeByteArrayToFile((File)new File(destinationPath), (byte[])data);
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u5f02\u5e38", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
    }

    private List<EngineResultEntity> getDataDetails(AttachListDownloadDto attachListDownloadDto) {
        List<Object> data = new ArrayList<EngineResultEntity>();
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        List filters = attachListDownloadDto.getFilter();
        List dataIds = attachListDownloadDto.getIdList();
        if (HussarUtils.isNotEmpty((Object)dataIds)) {
            Filter idsFilter = new Filter();
            idsFilter.setField("RECORD_ID");
            idsFilter.setMatch("AND");
            idsFilter.setRule("_in");
            idsFilter.setVal(String.join((CharSequence)",", attachListDownloadDto.getIdList()));
            filters.add(idsFilter);
        }
        queryParams.put("superQueryConditionDto", filters);
        SysForm form = this.appExternalService.getFormDetailById(Long.valueOf(Long.parseLong(attachListDownloadDto.getFormId())));
        AppContextUtil.setAppId((String)Long.toString(form.getAppId()));
        int i = 1;
        while (true) {
            queryParams.put("current", i);
            queryParams.put("size", 500);
            ResponseEntity tableQueryRes = this.hussarAppFormService.tableQuery(attachListDownloadDto.getFormId(), attachListDownloadDto.getViewId(), queryParams, attachListDownloadDto.getAppId());
            if (((ApiResponse)Objects.requireNonNull(tableQueryRes.getBody())).isSuccess()) {
                PageVo pageVo = (PageVo)((ApiResponse)tableQueryRes.getBody()).getData();
                List maxPageData = pageVo.getData();
                data.addAll(maxPageData);
                if (maxPageData.size() < 500) {
                    break;
                }
            } else {
                logger.error("\u67e5\u8be2\u6570\u636e\u5931\u8d25");
                break;
            }
            ++i;
        }
        if ("1".equals(form.getFormType())) {
            data = data.stream().filter(engineResultEntity -> HussarUtils.isNotEmpty((Object)engineResultEntity.get((Object)"PROCESS_KEY"))).collect(Collectors.toList());
        }
        return data;
    }

    public String copyOssFile(Long ossFileId) {
        String copyFilePath = this.hussarFormDesignFrameProperties.getWorkspace() + File.separator + UUID.randomUUID();
        File file = new File(copyFilePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            AttachmentManagerModel model = this.ossService.getModelById(ossFileId);
            String attachmentName = model.getAttachmentName();
            copyFilePath = copyFilePath + File.separator + attachmentName;
            ApiResponse download = this.ossService.backgroundDownload(ossFileId);
            byte[] data = (byte[])download.getData();
            MockMultipartFile multipartFile = new MockMultipartFile(attachmentName, data);
            File upload = new File(copyFilePath);
            multipartFile.transferTo(upload);
        }
        catch (Exception e) {
            logger.error("\u590d\u5236\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new BaseException((Throwable)e);
        }
        return copyFilePath;
    }

    public long geneFileId() {
        Random random = new Random();
        long fileId = random.nextLong() >>> 16 & 0xFFFFL;
        ApiResponse exist = this.ossService.isExist(Long.valueOf(fileId));
        if (((Boolean)exist.getData()).booleanValue()) {
            return this.geneFileId();
        }
        return fileId;
    }
}

