/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.datasource.util.DbUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleExecType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.server.dao.ChildTableMapper;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.NoCodeRuleUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleExcHisDto;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoWithDetailsDto;
import com.jxdinfo.hussar.formdesign.application.rule.model.RuleActionResult;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleExecAction;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleExcHisService;
import com.jxdinfo.hussar.formdesign.application.rule.service.ISysRuleTriggerActionService;
import com.jxdinfo.hussar.formdesign.back.common.relation.datasource.config.rules.DbType;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.formdesign.no.code.tool.JsonParser;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicLevelTreeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
@HussarTokenDs
public class NoCodeRuleExec {
    private static final Logger logger = LoggerFactory.getLogger(NoCodeRuleExec.class);
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private ISysRuleExcHisService sysRuleExcHisService;
    @Resource
    private ISysRuleTriggerActionService sysRuleTriggerActionService;
    @Resource
    private ChildTableMapper childTableMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static final Long SECURITY_LEVEL_TYPE_ID = 1450742089372590091L;
    private static final String NORMAL_FORM = "0";
    private static final String FLOW_FROM = "1";
    @Resource
    private CanvasService canvasService;
    private static final Integer ExcSuccess = 0;
    private static final Integer ExcFail = 1;
    private static final String SECOND_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String MINUTE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String DAY_FORMAT = "yyyy-MM-dd";
    private static final String MONTH_FORMAT = "yyyy-MM";
    private static final String YEAR_FORMAT = "yyyy";
    private static final int ADDRESS_LEVEL_ONE = 1;
    private static final int ADDRESS_LEVEL_TWO = 2;
    private static final int ADDRESS_LEVEL_THREE = 3;
    private static final String CREATE_TIME = "CREATETIME_DATE";
    private static final String UPDATE_TIME = "UPDATETIME_DATE";
    private static final String CHILDREN_TABLE = "JXDNChildrenTable";
    private static final String JXDN_GROUPS = "JXDNGroups";
    private static final String CACHE_NAME = "RULE_CACHE";
    private static final String[] MULTI_TYPES = new String[]{"JXDNLinkFormMulti", "JXDNSelectMulti", "JXDNCheckBoxGroup", "JXDNOrgMulti", "JXDNUserMulti"};

    @OperateLogTypeCache(mode=3)
    public void excRule(String sourceAppId, String sourceFormId, JSONObject businessData, SysRuleInfoWithDetailsDto ruleInfoWithDetails, SecurityUser loginUser, String traceId, List<String> ruleIdList) {
        List gruleExcActions = ruleInfoWithDetails.getSysRuleExcActions();
        if (HussarUtils.isEmpty((Object)gruleExcActions)) {
            logger.error("\u5f00\u59cb\u6267\u884c\u52a8\u4f5c\uff0c\u6ca1\u6709\u6267\u884c\u52a8\u4f5c\uff0c\u6267\u884c\u7ed3\u675f,\u94fe\u8defid:{}", (Object)traceId);
        }
        logger.info("\u5f00\u59cb\u6267\u884c\u52a8\u4f5c\uff0c\u52a8\u4f5c\u6570\u91cf{},\u94fe\u8defid:{}", (Object)gruleExcActions.size(), (Object)traceId);
        HashMap<String, SysForm> formMap = new HashMap<String, SysForm>();
        ArrayList<RuleActionResult> excResultList = new ArrayList<RuleActionResult>();
        ArrayList<String> ruleIds = new ArrayList<String>();
        ruleIds.addAll(ruleIdList);
        for (SysRuleExecAction sysRuleExecAction : gruleExcActions) {
            Long execActionRuleId = sysRuleExecAction.getRuleId();
            Long actionId = sysRuleExecAction.getActionId();
            String execId = String.format("%s_%s", execActionRuleId, actionId);
            if (ruleIds.contains(execId)) {
                logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u52a8\u4f5c\uff0c\u56e0\u91cd\u590d\u6267\u884c\u8fdb\u884c\u62e6\u622a\uff0c\u62e6\u622a\u4fe1\u606f\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u4e1a\u52a1\u89c4\u5219\u7f16\u7801\u961f\u5217\uff1a{}", (Object)JsonUtil.toJson((Object)sysRuleExecAction), (Object)JsonUtil.toJson(ruleIds));
                continue;
            }
            ruleIds.add(execId);
            logger.info("\u5f00\u59cb\u6267\u884c\u5355\u4e2a\u52a8\u4f5c\u4e86{},\u94fe\u8defid:{}", (Object)JSONObject.toJSONString((Object)sysRuleExecAction), (Object)traceId);
            String type = sysRuleExecAction.getExecAction();
            RuleActionResult ruleActionResult = new RuleActionResult();
            SysForm form = null;
            Long formId = sysRuleExecAction.getFormId();
            if (formMap.containsKey(formId)) {
                form = (SysForm)formMap.get(formId);
            } else {
                form = this.applicationService.getFormDetailById(formId);
                formMap.put(String.valueOf(formId), form);
            }
            switch (Objects.requireNonNull(NoCodeRuleExecType.getNoCodeRuleExecTypeByType((String)type))) {
                case ExecTypeCreate: {
                    try {
                        ruleActionResult = this.actionAdd(businessData, sysRuleExecAction, false, loginUser, traceId, ruleIds);
                    }
                    catch (Exception e) {
                        ruleActionResult = RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeCreate.getValue(), (String)form.getFormName(), (String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5f02\u5e38");
                        logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u65b0\u589e\u52a8\u4f5c\u5f02\u5e38\uff1a\u6267\u884c\u8868\u5355\uff1a{},\u94fe\u8defid:{}", new Object[]{form.getId(), traceId, e});
                    }
                    break;
                }
                case ExecTypeUpdate: {
                    HashSet<Long> dateIds;
                    JSONObject newBusinessDate;
                    JSONArray dependChildFiledNameArray;
                    List<Map<String, Object>> childList;
                    String dependChildFiledName;
                    try {
                        dependChildFiledName = this.getDependChildFiledName(sysRuleExecAction);
                        if (HussarUtils.isNotEmpty((Object)dependChildFiledName)) {
                            childList = new ArrayList();
                            if (businessData.get((Object)dependChildFiledName) instanceof JSONArray) {
                                dependChildFiledNameArray = (JSONArray)businessData.get((Object)dependChildFiledName);
                                childList = NoCodeRuleUtil.convertJsonArrayToMapList(dependChildFiledNameArray);
                            } else {
                                childList = (ArrayList<Map<String, Object>>)businessData.get((Object)dependChildFiledName);
                            }
                            if (HussarUtils.isEmpty((Object)childList)) {
                                ruleActionResult = RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeUpdate.getValue(), (String)form.getFormName(), (int)0);
                                break;
                            }
                            newBusinessDate = JSONObject.parseObject((String)businessData.toJSONString());
                            dateIds = new HashSet();
                            boolean isFirst = true;
                            for (Map<String, Object> map : childList) {
                                List<Map> oneChildDate = Arrays.asList(map);
                                newBusinessDate.replace((Object)dependChildFiledName, oneChildDate);
                                this.actionUpdate(sourceFormId, newBusinessDate, sysRuleExecAction, false, loginUser, traceId, dateIds, isFirst, ruleIds);
                                isFirst = false;
                            }
                            ruleActionResult = RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeUpdate.getValue(), (String)form.getFormName(), (int)dateIds.size());
                            break;
                        }
                        ruleActionResult = this.actionUpdate(sourceFormId, businessData, sysRuleExecAction, false, loginUser, traceId, null, true, ruleIds);
                    }
                    catch (Exception e) {
                        logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u4fee\u6539\u52a8\u4f5c\u5f02\u5e38\uff1a\u6267\u884c\u8868\u5355\uff1a{},\u94fe\u8defid:{}", new Object[]{form.getId(), traceId, e});
                        ruleActionResult = RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeUpdate.getValue(), (String)form.getFormName(), (String)("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
                    }
                    break;
                }
                case ExecTypeCreateOrUpdate: {
                    HashSet<Long> dateIds;
                    JSONObject newBusinessDate;
                    JSONArray dependChildFiledNameArray;
                    List<Map<String, Object>> childList;
                    String dependChildFiledName;
                    try {
                        dependChildFiledName = this.getDependChildFiledName(sysRuleExecAction);
                        if (HussarUtils.isNotEmpty((Object)dependChildFiledName)) {
                            childList = new ArrayList();
                            if (businessData.get((Object)dependChildFiledName) instanceof JSONArray) {
                                dependChildFiledNameArray = (JSONArray)businessData.get((Object)dependChildFiledName);
                                childList = NoCodeRuleUtil.convertJsonArrayToMapList(dependChildFiledNameArray);
                            } else {
                                childList = (ArrayList)businessData.get((Object)dependChildFiledName);
                            }
                            if (HussarUtils.isEmpty((Object)childList)) {
                                ruleActionResult = this.actionAdd(businessData, sysRuleExecAction, true, loginUser, traceId, ruleIds);
                                break;
                            }
                            newBusinessDate = JSONObject.parseObject((String)businessData.toJSONString());
                            dateIds = new HashSet();
                            int addNum = 0;
                            boolean bl = true;
                            for (Map<String, Object> map2 : childList) {
                                boolean bl2;
                                List<Map> oneChildDate = Arrays.asList(map2);
                                newBusinessDate.replace((Object)dependChildFiledName, oneChildDate);
                                List<Map<String, Object>> filteredData = this.getFilteredData(sourceFormId, newBusinessDate, sysRuleExecAction);
                                if (HussarUtils.isNotEmpty(filteredData)) {
                                    this.actionUpdate(sourceFormId, newBusinessDate, sysRuleExecAction, true, loginUser, traceId, dateIds, bl2, ruleIds);
                                } else {
                                    this.actionAdd(newBusinessDate, sysRuleExecAction, true, loginUser, traceId, ruleIds);
                                    ++addNum;
                                }
                                bl2 = false;
                            }
                            ruleActionResult = RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeCreateOrUpdate.getValue(), (String)form.getFormName(), (int)(dateIds.size() + addNum));
                            break;
                        }
                        List<Map<String, Object>> filteredData = this.getFilteredData(sourceFormId, businessData, sysRuleExecAction);
                        if (HussarUtils.isNotEmpty(filteredData)) {
                            ruleActionResult = this.actionUpdate(sourceFormId, businessData, sysRuleExecAction, true, loginUser, traceId, null, true, ruleIds);
                            break;
                        }
                        ruleActionResult = this.actionAdd(businessData, sysRuleExecAction, true, loginUser, traceId, ruleIds);
                    }
                    catch (Exception e) {
                        ruleActionResult = RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeCreateOrUpdate.getValue(), (String)form.getFormName(), (String)("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
                        logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u4fee\u6539\u6216\u65b0\u589e\u52a8\u4f5c\u5f02\u5e38\uff1a\u6267\u884c\u8868\u5355\uff1a{},\u94fe\u8defid:{}", new Object[]{form.getId(), traceId, e});
                    }
                    break;
                }
                case ExecTypeDelete: {
                    try {
                        ruleActionResult = this.actionRemove(sourceFormId, businessData, sysRuleExecAction, loginUser, traceId, ruleIds);
                    }
                    catch (Exception e) {
                        ruleActionResult = RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeDelete.getValue(), (String)form.getFormName(), (String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5f02\u5e38");
                        logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u5220\u9664\u52a8\u4f5c\u5f02\u5e38\uff1a\u6267\u884c\u8868\u5355\uff1a{},\u94fe\u8defid:{}", new Object[]{form.getId(), traceId, e});
                    }
                    break;
                }
                case ExecTypeChildrenCreate: {
                    try {
                        ruleActionResult = this.actionChildrenCreate(sourceFormId, businessData, sysRuleExecAction, null, loginUser, traceId, ruleIds);
                    }
                    catch (Exception e) {
                        ruleActionResult = RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeChildrenCreate.getValue(), (String)form.getFormName(), (String)("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
                        logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u65b0\u589e\u5b50\u8868\u52a8\u4f5c\u5f02\u5e38\uff1a\u6267\u884c\u8868\u5355\uff1a{},\u94fe\u8defid:{}", new Object[]{form.getId(), traceId, e});
                    }
                    break;
                }
                case ExecTypeChildrenDelete: {
                    HashSet<Long> dateIds;
                    JSONObject newBusinessDate;
                    List<Map<String, Object>> childList;
                    String dependChildFiledName;
                    try {
                        dependChildFiledName = this.getDependChildFiledNameForChildUpdate(sysRuleExecAction, "ExecTypeChildrenDelete");
                        if (HussarUtils.isNotEmpty((Object)dependChildFiledName)) {
                            childList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)dependChildFiledName)), Map.class);
                            if (HussarUtils.isEmpty(childList)) {
                                ruleActionResult = RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeChildrenDelete.getValue(), (String)form.getFormName(), (int)0);
                                break;
                            }
                            newBusinessDate = JSONObject.parseObject((String)businessData.toJSONString());
                            dateIds = new HashSet<Long>();
                            for (Map map : childList) {
                                List<Map> list = Arrays.asList(map);
                                newBusinessDate.replace((Object)dependChildFiledName, list);
                                this.actionChildrenDelete(sourceFormId, newBusinessDate, sysRuleExecAction, dateIds, loginUser, traceId, ruleIds);
                            }
                            ruleActionResult = RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeChildrenDelete.getValue(), (String)form.getFormName(), (int)dateIds.size());
                            break;
                        }
                        ruleActionResult = this.actionChildrenDelete(sourceFormId, businessData, sysRuleExecAction, null, loginUser, traceId, ruleIds);
                        break;
                    }
                    catch (Exception e) {
                        ruleActionResult = RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeChildrenDelete.getValue(), (String)form.getFormName(), (String)("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f:" + e.getMessage()));
                        logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u5220\u9664\u5b50\u8868\u52a8\u4f5c\u5f02\u5e38\uff1a\u6267\u884c\u8868\u5355\uff1a{},\u94fe\u8defid:{}", new Object[]{form.getId(), traceId, e});
                    }
                }
            }
            excResultList.add(ruleActionResult);
        }
        if (!excResultList.isEmpty()) {
            this.saveExcLog(sourceAppId, sourceFormId, businessData, ruleInfoWithDetails, loginUser, excResultList);
        }
        logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5b8c\u6bd5\uff0c\u89e6\u53d1\u8868\u5355\uff1a{}\uff0c\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u4e1a\u52a1\u89c4\u5219\uff1a{},\u94fe\u8defid:{}", new Object[]{ruleInfoWithDetails.getSysRuleTriggerAction().getFormId(), businessData, JSONObject.toJSONString((Object)ruleInfoWithDetails), traceId});
    }

    private String getDependChildFiledName(SysRuleExecAction sysRuleExecAction) {
        String actionFilterString = sysRuleExecAction.getActionFilter();
        JSONObject actionFilter = (JSONObject)JSONObject.parseObject((String)actionFilterString, JSONObject.class);
        JSONArray cond = actionFilter.getJSONArray("cond");
        for (Object item : cond) {
            JSONObject dependJson;
            String childFileName;
            JSONObject jsonItem = (JSONObject)JSON.toJSON(item);
            if (!"depend".equals(jsonItem.getString("mode")) || !HussarUtils.isNotEmpty((Object)(childFileName = (dependJson = (JSONObject)jsonItem.get((Object)"depend")).getString("parent")))) continue;
            return childFileName;
        }
        return null;
    }

    private String getDependChildFiledNameForChildUpdate(SysRuleExecAction sysRuleExecAction, String type) {
        List execContentList = "ExecTypeChildrenDelete".equalsIgnoreCase(type) ? JSONArray.parseArray((String)JSONObject.parseObject((String)sysRuleExecAction.getActionFilter()).getString("cond"), JSONObject.class) : JSONObject.parseArray((String)JSONObject.parseObject((String)sysRuleExecAction.getActionFilter()).getString("cond"), JSONObject.class);
        for (JSONObject jsonObject : execContentList) {
            String json;
            JSONObject dependObj;
            String parent;
            Object depend = jsonObject.get((Object)"depend");
            if (!HussarUtils.isNotEmpty((Object)depend) || !HussarUtils.isNotEmpty((Object)(parent = (dependObj = JSONObject.parseObject((String)(json = JsonUtil.toJson((Object)depend)))).getString("parent")))) continue;
            return parent;
        }
        return null;
    }

    private void saveExcLog(String sourceAppId, String sourceFormId, JSONObject businessData, SysRuleInfoWithDetailsDto ruleInfoWithDetails, SecurityUser loginUser, ArrayList<RuleActionResult> excResultList) {
        Long ruleId = ruleInfoWithDetails.getRuleId();
        String triggerDetails = this.getTriggerDetails(businessData, ruleInfoWithDetails);
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(sourceFormId)));
        String keyName = form.getTableName();
        String triggerDataId = "";
        if (HussarUtils.isNotEmpty((Object)keyName) && HussarUtils.isEmpty((Object)(triggerDataId = businessData.getString(keyName)))) {
            triggerDataId = businessData.getString("RECORD_ID");
        }
        SysRuleExcHisDto sysRuleExcHis = new SysRuleExcHisDto();
        sysRuleExcHis.setRuleId(Long.valueOf(ruleId));
        sysRuleExcHis.setAppId(Long.valueOf(sourceAppId));
        sysRuleExcHis.setFormId(Long.valueOf(sourceFormId));
        sysRuleExcHis.setTriggerDataId(Long.valueOf(triggerDataId));
        sysRuleExcHis.setTriggerDetails(triggerDetails);
        sysRuleExcHis.setExcTime(LocalDateTime.now());
        sysRuleExcHis.setExcUserId(loginUser.getUserId().toString());
        sysRuleExcHis.setExcUser(loginUser.getUserName());
        boolean success = excResultList.stream().allMatch(ruleActionResult -> ruleActionResult.getExcResult() == ExcSuccess);
        sysRuleExcHis.setExcResult(success ? ExcSuccess : ExcFail);
        JSONArray jsonArray = new JSONArray();
        for (RuleActionResult excResult : excResultList) {
            JSONObject jsonObject = new JSONObject();
            Integer resultCode = excResult.getExcResult();
            String excType = excResult.getExcType();
            String resultMessage = excResult.getResultMessage();
            jsonObject.put("excType", (Object)excType);
            jsonObject.put("resultMessage", (Object)resultMessage);
            jsonObject.put("excResult", (Object)resultCode);
            jsonArray.add((Object)jsonObject);
        }
        sysRuleExcHis.setExcResultContent(JSON.toJSONString((Object)jsonArray, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        this.sysRuleExcHisService.addRuleExcHis(sysRuleExcHis);
    }

    private String getTriggerDetails(JSONObject businessData, SysRuleInfoWithDetailsDto ruleInfoWithDetails) {
        SysRuleTriggerAction sysRuleTriggerAction = ruleInfoWithDetails.getSysRuleTriggerAction();
        Long formId = sysRuleTriggerAction.getFormId();
        String triggerAction = sysRuleTriggerAction.getTriggerAction();
        SysForm form = this.applicationService.getFormDetailById(formId);
        String formName = form.getFormName();
        String title = businessData.getString("title");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("triggerAction", (Object)triggerAction);
        jsonObject.put("formTitle", (Object)formName);
        jsonObject.put("dataTitle", (Object)title);
        return jsonObject.toString();
    }

    private RuleActionResult actionChildrenDelete(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction, HashSet<Long> dateIds, SecurityUser loginUser, String traceId, List<String> ruleIds) {
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
        TransmittableThreadLocalHolder.set((String)"traceId", (Object)traceId);
        EngineUserUtil.setUser((UserDetails)loginUser);
        Long formId = sysRuleExecAction.getFormId();
        SysForm form = this.applicationService.getFormDetailById(formId);
        String target = sysRuleExecAction.getTarget();
        JSONObject jsonTarget = JSONObject.parseObject((String)target);
        String appId = jsonTarget.getString("appId");
        String execType = NoCodeRuleExecType.ExecTypeChildrenDelete.getValue();
        ArrayList<Map<String, Object>> allChild = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> filteredData = this.getFilteredData(sourceFormId, businessData, sysRuleExecAction, allChild);
        if (HussarUtils.isEmpty(filteredData)) {
            logger.info("\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u76ee\u6807\u8868,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e,\u4e0d\u9700\u8981\u5220\u9664\u5b50\u8868,\u94fe\u8defid\uff1a{}", (Object)traceId);
            return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
        }
        if (dateIds != null) {
            Set collect = filteredData.stream().map(date -> Long.valueOf(date.get("RECORD_ID").toString())).collect(Collectors.toSet());
            dateIds.addAll(collect);
        }
        int dataNum = this.removeValues(formId, allChild, filteredData);
        logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5220\u9664\u5b50\u8868\u52a8\u4f5c\u4e2d\uff0c\u8981\u5220\u9664\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.toJson(filteredData));
        String dataSourceKey = DataModelUtil.currentDsName();
        for (Map<String, Object> filteredDatum : allChild) {
            try {
                String triggerRecordId = filteredDatum.get("RECORD_ID").toString();
                String lockKey = String.format("%s_%s_%s", dataSourceKey, formId, triggerRecordId);
                if (FLOW_FROM.equals(form.getFormType())) {
                    this.appFormService.processUpdateWithRuleWithLock(String.valueOf(formId), filteredDatum, appId, false, ruleIds, lockKey);
                    continue;
                }
                this.appFormService.formSaveWithRuleWithLock(String.valueOf(formId), filteredDatum, appId, ruleIds, lockKey);
            }
            catch (Exception e) {
                logger.error("\u5220\u9664\u5b50\u8868\u6570\u636e\u662f\u53d1\u751f\u5f02\u5e38,\u8868\u5355id:{},,\u94fe\u8defid\uff1a{}", new Object[]{formId, traceId, e});
                --dataNum;
            }
        }
        TransmittableThreadLocalHolder.clear((String)"traceId");
        if (dataNum == 0) {
            return RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeChildrenDelete.getValue(), (String)form.getFormName(), (String)"\u5220\u9664\u5b50\u8868\u6570\u636e\u5931\u8d25");
        }
        return RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeChildrenDelete.getValue(), (String)form.getFormName(), (int)dataNum);
    }

    private int removeValues(Long formId, List<Map<String, Object>> filteredData, List<Map<String, Object>> filteredChildData) {
        for (Map<String, Object> filteredDatum : filteredData) {
            String recordId = filteredDatum.get("RECORD_ID").toString();
            for (Map<String, Object> filteredChildDatum : filteredChildData) {
                String needRemoveRecordId = filteredDatum.get("RECORD_ID").toString();
                if (!recordId.equals(needRemoveRecordId)) continue;
                Map<String, Object> allChild = this.getChildList(String.valueOf(formId), filteredDatum);
                Map<String, Object> child = this.getChildList(String.valueOf(formId), filteredChildDatum);
                for (Map.Entry<String, Object> entry : allChild.entrySet()) {
                    String allChildName = entry.getKey();
                    Object allChildObject = entry.getValue();
                    String json = JsonUtil.toJson((Object)allChildObject);
                    List allChildList = (List)JSON.parseObject((String)json, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                    Object childObject = child.get(entry.getKey());
                    if (HussarUtils.isEmpty((Object)childObject)) continue;
                    String childJson = JsonUtil.toJson((Object)childObject);
                    List childList = (List)JSON.parseObject((String)childJson, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                    allChildList.removeIf(childList::contains);
                    filteredDatum.put(allChildName, allChildList);
                }
            }
        }
        return filteredData.size();
    }

    private Map<String, Object> getChildList(String formId, Map<String, Object> params) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(formId).getData();
        ArrayList tableNames = new ArrayList();
        List widgetList = canvas.childTables();
        widgetList.forEach(widget -> tableNames.add(widget.getName()));
        List childList = new ArrayList();
        String childName = null;
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (!tableNames.stream().anyMatch(name -> key.contains((CharSequence)name))) continue;
            if (HussarUtils.isNotEmpty((Object)entry.getValue())) {
                String json = JsonUtil.toJson((Object)entry.getValue());
                childList = JSONObject.parseArray((String)json, JSONObject.class);
            }
            childName = key;
            map.put(childName, childList);
        }
        return map;
    }

    private RuleActionResult actionChildrenCreate(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction, HashSet<Long> dateIds, SecurityUser loginUser, String traceId, List<String> ruleIds) {
        Map<String, Object> updatedData;
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
        TransmittableThreadLocalHolder.set((String)"traceId", (Object)traceId);
        EngineUserUtil.setUser((UserDetails)loginUser);
        Long formId = sysRuleExecAction.getFormId();
        SysForm form = this.applicationService.getFormDetailById(formId);
        String formName = form.getTableName();
        String target = sysRuleExecAction.getTarget();
        JSONObject jsonTarget = JSONObject.parseObject((String)target);
        String appId = jsonTarget.getString("appId");
        String execType = NoCodeRuleExecType.ExecTypeChildrenCreate.getValue();
        List<Map<String, Object>> filteredData = this.getFilteredDataChild(sourceFormId, businessData, sysRuleExecAction);
        if (HussarUtils.isEmpty(filteredData)) {
            logger.info("\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u76ee\u6807\u8868,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e,\u4e0d\u9700\u8981\u65b0\u589e\u5b50\u8868,\u94fe\u8defid\uff1a{}", (Object)traceId);
            return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
        }
        if (dateIds != null) {
            Set collect = filteredData.stream().map(date -> Long.valueOf(date.get("RECORD_ID").toString())).collect(Collectors.toSet());
            dateIds.addAll(collect);
        }
        if (HussarUtils.isEmpty(updatedData = this.getUpdatedDataChild(businessData, sysRuleExecAction))) {
            logger.info("\u6839\u636e\u6761\u4ef6\u7ec4\u88c5\u4fee\u6539\u540e\u7684\u6570\u636e,\u7ed3\u679c\u4e3a\u7a7a,\u4e0d\u9700\u8981\u4fee\u6539,\u94fe\u8defid\uff1a{}", (Object)traceId);
            return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
        }
        int dataNum = this.createChildrenValues(filteredData, updatedData, formName);
        logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u65b0\u589e\u5b50\u8868\u52a8\u4f5c\u4e2d\uff0c\u7ec4\u88c5\u4fee\u6539\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.toJson(filteredData));
        String dataSourceKey = DataModelUtil.currentDsName();
        FormCanvasSchema data1 = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData();
        List widgetList = data1.childTables();
        Set childTableNames = widgetList.stream().map(Widget::getName).collect(Collectors.toSet());
        if (HussarUtils.isNotEmpty(filteredData)) {
            for (Map<String, Object> params : filteredData) {
                String childTableName = "";
                for (String key : params.keySet()) {
                    if (!childTableNames.contains(key)) continue;
                    childTableName = key;
                    break;
                }
                String recordId = params.get("RECORD_ID").toString();
                String childTableNameUpperCase = childTableName.toUpperCase();
                DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
                String jdbcUrl = bean.getCurrentDatasource().getUrl();
                String dbType = DbUtil.getDbType((String)jdbcUrl).toUpperCase();
                Integer max = HussarUtils.equals((Object)DbType.GAUSS.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.HIGHGO.name(), (Object)dbType) || HussarUtils.equals((Object)DbType.POSTGRE_SQL.name(), (Object)dbType) ? this.childTableMapper.getMaxSEQ(childTableNameUpperCase.toLowerCase(), recordId) : this.childTableMapper.getMaxSeq(childTableNameUpperCase, recordId);
                max = max == null ? 0 : max;
                List dataList = (List)params.get(childTableName);
                for (Map data : dataList) {
                    Integer n = max;
                    Integer n2 = max = Integer.valueOf(max + 1);
                    data.put("SEQ", max);
                }
                params.put(childTableName, dataList);
                String triggerId = params.get("RECORD_ID").toString();
                String lockKey = String.format("%s_%s_%s", dataSourceKey, formId, triggerId);
                try {
                    Map newParam = (Map)JSON.parseObject((String)JSON.toJSONString(params, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
                    boolean ifUpdateMain = true;
                    if (FLOW_FROM.equals(form.getFormType())) {
                        this.appFormService.processIncrementUpdateWithRule(String.valueOf(formId), form.getTableName(), newParam, appId, ifUpdateMain, ruleIds, lockKey);
                        continue;
                    }
                    this.appFormService.formIncrementSaveWithRule(String.valueOf(formId), form.getTableName(), newParam, appId, ifUpdateMain, ruleIds, lockKey);
                }
                catch (Exception e) {
                    logger.error("\u65b0\u589e\u5b50\u8868\u6570\u636e\u662f\u53d1\u751f\u5f02\u5e38,\u8868\u5355id:{}:,\u94fe\u8defid\uff1a{}", new Object[]{formId, traceId, e});
                    --dataNum;
                }
            }
        }
        TransmittableThreadLocalHolder.clear((String)"traceId");
        if (dataNum == 0) {
            return RuleActionResult.fail((String)NoCodeRuleExecType.ExecTypeChildrenCreate.getValue(), (String)form.getFormName(), (String)"\u65b0\u589e\u5b50\u8868\u6570\u636e\u5931\u8d25");
        }
        return RuleActionResult.success((String)NoCodeRuleExecType.ExecTypeChildrenCreate.getValue(), (String)form.getFormName(), (int)dataNum);
    }

    private List<Map<String, Object>> getFilteredDataChild(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction) {
        String target = sysRuleExecAction.getTarget();
        JSONObject jsonTarget = JSONObject.parseObject((String)target);
        String appId = jsonTarget.getString("appId");
        String recordId = businessData.getString("RECORD_ID");
        String actionFilterString = sysRuleExecAction.getActionFilter();
        if (HussarUtils.isNotEmpty((Object)actionFilterString)) {
            List childList;
            JSONObject actionFilter = (JSONObject)JSONObject.parseObject((String)actionFilterString, JSONObject.class);
            JSONArray cond = actionFilter.getJSONArray("cond");
            ArrayList<String> filterdChildTableName = new ArrayList<String>();
            int childNum = 1;
            String dependChildFiledName = this.getDependChildFiledNameForChildUpdate(sysRuleExecAction, "ExecTypeChildrenCreate");
            if (HussarUtils.isNotEmpty((Object)dependChildFiledName) && HussarUtils.isNotEmpty((Object)(childList = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)dependChildFiledName)), Map.class)))) {
                childNum = childList.size();
            }
            ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
            for (int i = 0; i < childNum; ++i) {
                ArrayList<Map<String, Object>> selectionList = new ArrayList<Map<String, Object>>();
                for (Object item : cond) {
                    HashMap<String, Object> conditionMap = new HashMap<String, Object>();
                    JSONObject jsonItem = (JSONObject)JSON.toJSON(item);
                    JSONObject newData = this.getNewData(jsonItem, businessData, new JSONObject(), i, String.valueOf(sysRuleExecAction.getFormId()), true, null);
                    Map.Entry entry = (Map.Entry)newData.entrySet().iterator().next();
                    if (HussarUtils.isEmpty(entry.getValue())) {
                        conditionMap.put("rule", "_isNull");
                        conditionMap.put("val", "");
                        this.buildConditionMap(conditionMap, jsonItem, entry);
                    } else if ("depend".equals(jsonItem.getString("mode")) && "JXDNDate".equals(jsonItem.getString("type"))) {
                        this.processDateFilter(sourceFormId, String.valueOf(sysRuleExecAction.getFormId()), entry, jsonItem, conditionMap);
                        this.buildConditionMap(conditionMap, jsonItem, entry);
                    } else if ("depend".equals(jsonItem.getString("mode")) && "JXDNAddress".equals(jsonItem.getString("type"))) {
                        this.processAddressFilter(sourceFormId, String.valueOf(sysRuleExecAction.getFormId()), entry, jsonItem, conditionMap);
                        this.buildConditionMap(conditionMap, jsonItem, entry);
                    } else if ("depend".equals(jsonItem.getString("mode")) && ("JXDNSelectMulti".equals(jsonItem.getString("type")) || "JXDNCheckBoxGroup".equals(jsonItem.getString("type")))) {
                        this.processSelectMultiFilter(entry, jsonItem, selectionList);
                    } else if ("depend".equals(jsonItem.getString("mode")) && ("JXDNOrgMulti".equals(jsonItem.getString("type")) || "JXDNUserMulti".equals(jsonItem.getString("type")))) {
                        this.processUserMultiFilter(entry, jsonItem, selectionList);
                    } else {
                        conditionMap.put("rule", "_eq");
                        conditionMap.put("val", entry.getValue());
                        this.buildConditionMap(conditionMap, jsonItem, entry);
                    }
                    if (HussarUtils.isNotEmpty(conditionMap)) {
                        selectionList.add(conditionMap);
                    }
                    if (!StringUtil.isNotEmpty((Object)jsonItem.get((Object)"parent"))) continue;
                    filterdChildTableName.add(jsonItem.getString("parent"));
                }
                ArrayList<Map<String, Object>> recordIdQueryList = new ArrayList<Map<String, Object>>();
                recordIdQueryList.addAll(selectionList);
                SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(String.valueOf(sysRuleExecAction.getFormId()))));
                if (FLOW_FROM.equals(form.getFormType())) {
                    HashMap<String, String> filterFlow = new HashMap<String, String>();
                    filterFlow.put("rule", "_isNotNull");
                    filterFlow.put("val", "");
                    filterFlow.put("field", "PROCESS_KEY");
                    filterFlow.put("match", "AND");
                    selectionList.add(filterFlow);
                }
                HashMap<String, ArrayList<Map<String, Object>>> param = new HashMap<String, ArrayList<Map<String, Object>>>();
                param.put("superQueryConditionDto", selectionList);
                ResponseEntity response = this.formOperateExposedService.tableQueryByCondition(appId, String.valueOf(sysRuleExecAction.getFormId()), param);
                PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(response.getBody())).getData();
                List dataTemp = pageData.getData();
                boolean b = this.containsKeyValue(dataTemp, "RECORD_ID", recordId);
                if (sourceFormId.equals(sysRuleExecAction.getFormId()) && !b) {
                    HashMap<String, String> recordFilterFlow = new HashMap<String, String>();
                    recordFilterFlow.put("rule", "eq");
                    recordFilterFlow.put("val", recordId);
                    recordFilterFlow.put("field", "RECORD_ID");
                    recordFilterFlow.put("match", "AND");
                    recordIdQueryList.add(recordFilterFlow);
                    HashMap<String, ArrayList<Map<String, Object>>> redcordParam = new HashMap<String, ArrayList<Map<String, Object>>>();
                    redcordParam.put("superQueryConditionDto", recordIdQueryList);
                    ResponseEntity recordResponse = this.formOperateExposedService.tableQueryByCondition(appId, String.valueOf(sysRuleExecAction.getFormId()), redcordParam);
                    PageVo recordPageData = (PageVo)((ApiResponse)Objects.requireNonNull(recordResponse.getBody())).getData();
                    List recordDataTemp = recordPageData.getData();
                    dataTemp.addAll(recordDataTemp);
                }
                FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(sysRuleExecAction.getFormId())).getData();
                List widgets = canvas.childTables();
                List childName = widgets.stream().map(Widget::getName).collect(Collectors.toList());
                for (Map map : dataTemp) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!childName.contains(entry.getKey()) || filterdChildTableName.contains(entry.getKey())) continue;
                        map.put(entry.getKey(), null);
                    }
                }
                if (dataTemp.isEmpty()) continue;
                dataList.addAll(dataTemp);
            }
            return dataList;
        }
        return null;
    }

    private Map<String, Object> getUpdatedDataChild(JSONObject businessData, SysRuleExecAction sysRuleExecAction) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        String contentString = sysRuleExecAction.getExecContent();
        if (HussarUtils.isNotEmpty((Object)contentString)) {
            List contents = JSONArray.parseArray((String)contentString, JSONObject.class);
            int childNum = 1;
            String childTableName = null;
            for (JSONObject content : contents) {
                JSONObject dependJson;
                JSONObject newBusinessData = new JSONObject();
                JSONObject parentData = new JSONObject();
                if ("depend".equals(content.get((Object)"mode")) && HussarUtils.isNotEmpty((Object)content.get((Object)"depend")) && HussarUtils.isNotEmpty((Object)(dependJson = (JSONObject)JSONObject.parseObject((String)content.getString("depend"), JSONObject.class)).get((Object)"parent")) && HussarUtils.isEmpty((Object)dependJson.get((Object)"grandparent")) && businessData.get(dependJson.get((Object)"parent")) != null) {
                    childNum = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get(dependJson.get((Object)"parent"))), JSONObject.class).size();
                    childTableName = (String)dependJson.get((Object)"parent");
                }
                JSONObject newData = this.getNewData(content, businessData, newBusinessData, 0, String.valueOf(sysRuleExecAction.getFormId()), false, null);
                if (!StringUtil.isEmpty((Object)content.get((Object)"parent"))) continue;
                Map<String, Object> map2 = NoCodeRuleExec.jsonToMap(newData);
                updateMap.putAll(map2);
            }
            if (childNum > 0) {
                ArrayList<HashMap<String, Object>> childMapList = new ArrayList<HashMap<String, Object>>();
                for (int i = 0; i < childNum; ++i) {
                    HashMap<String, Object> childMap = new HashMap<String, Object>();
                    String targetChildTableName = "";
                    for (JSONObject content : contents) {
                        if (HussarUtils.isNotEmpty((Object)content.get((Object)"grandparent"))) {
                            targetChildTableName = (String)content.get((Object)"grandparent");
                        }
                        if (!StringUtil.isNotEmpty((Object)content.get((Object)"parent")) || !HussarUtils.isEmpty((Object)content.get((Object)"grandparent"))) continue;
                        JSONObject newBusinessData = new JSONObject();
                        JSONObject parentData = new JSONObject();
                        JSONObject newDataChild = this.getNewData(content, businessData, newBusinessData, i, String.valueOf(sysRuleExecAction.getFormId()), false, null);
                        parentData.put(content.getString("parent"), (Object)newDataChild);
                        Map<String, Object> map3 = NoCodeRuleExec.jsonToMap(parentData);
                        map3.forEach((key, value) -> {
                            if (childMap.containsKey(key)) {
                                Map childMapKey = (Map)childMap.get(key);
                                Map childValue = (Map)value;
                                childValue.putAll(childMapKey);
                            }
                        });
                        childMap.putAll(map3);
                    }
                    this.getGrandChildData(targetChildTableName, businessData, childTableName, i, contents, String.valueOf(sysRuleExecAction.getFormId()), childMap);
                    childMapList.add(childMap);
                }
                Map collect = childMapList.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
                updateMap.putAll(collect);
            }
        }
        return updateMap;
    }

    private RuleActionResult actionRemove(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction, SecurityUser user, String traceId, List<String> ruleIds) {
        Long formId = sysRuleExecAction.getFormId();
        SysForm form = this.applicationService.getFormDetailById(formId);
        String actionFilter = sysRuleExecAction.getActionFilter();
        logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u89e3\u6790\u6267\u884c\u52a8\u4f5c\u4e3a\u5220\u9664\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
        String execType = NoCodeRuleExecType.ExecTypeDelete.getValue();
        List<Map<String, Object>> filteredData = null;
        if (HussarUtils.isNotEmpty((Object)actionFilter)) {
            filteredData = this.getFilteredData(sourceFormId, businessData, sysRuleExecAction);
            String keyName = form.getTableName();
            ArrayList processInsIds = new ArrayList();
            StringBuilder ids = new StringBuilder();
            Map parse = (Map)JsonUtil.parse((String)sysRuleExecAction.getTarget(), Map.class);
            String appId = (String)parse.get("appId");
            if (filteredData.size() > 0) {
                if (HussarUtils.isNotEmpty((Object)keyName)) {
                    for (Map<String, Object> map : filteredData) {
                        String id = (String)map.get(keyName);
                        StringBuilder stringBuilder = new StringBuilder(id);
                        String cacheKey = String.format("%s:%s:%s", form.getAppId(), formId, id);
                        HashMap<String, Object> cacheMap = new HashMap<String, Object>();
                        cacheMap.put("traceId", traceId);
                        cacheMap.put("ruleIds", ruleIds);
                        HussarCacheUtil.put((String)CACHE_NAME, (Object)cacheKey, cacheMap, (long)1800L);
                        ids.append((CharSequence)stringBuilder).append(",");
                    }
                    ids.delete(ids.length() - 1, ids.length());
                }
                TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
                TransmittableThreadLocalHolder.set((String)"traceId", (Object)traceId);
                EngineUserUtil.setUser((UserDetails)user);
                if (FLOW_FROM.equals(form.getFormType())) {
                    ApiResponse apiResponse = this.appFormService.processDeleteBatchWithRule(String.valueOf(formId), ids.toString(), appId, false, ruleIds);
                    if (apiResponse.isSuccess()) {
                        int size = (Integer)apiResponse.getData();
                        return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)size);
                    }
                    return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u6267\u884c\u5220\u9664\u4e1a\u52a1\u89c4\u5219\u5220\u9664\u8868\u5355\u6570\u636e\u5931\u8d25");
                }
                if (NORMAL_FORM.equals(form.getFormType())) {
                    ResponseEntity apiResponseResponseEntity = this.appFormService.deleteBatchWithRule(String.valueOf(formId), ids.toString(), appId, null, ruleIds);
                    ApiResponse body = (ApiResponse)apiResponseResponseEntity.getBody();
                    Boolean data = (Boolean)body.getData();
                    if (data.booleanValue()) {
                        return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)filteredData.size());
                    }
                    return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u6267\u884c\u5220\u9664\u4e1a\u52a1\u89c4\u5219\u5220\u9664\u8868\u5355\u6570\u636e\u5931\u8d25");
                }
            } else {
                logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\uff0c\u6267\u884c\u5220\u9664\u5220\u9664\u52a8\u4f5c\uff0c\u9700\u6267\u884c\u5220\u9664\u7684\u6570\u636e\u91cf\u4e3a0\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
                TransmittableThreadLocalHolder.set((String)"traceId", (Object)traceId);
                return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
            }
        }
        return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u6267\u884c\u5220\u9664\u4e1a\u52a1\u89c4\u5219\uff0c\u6570\u636e\u5f02\u5e38\u6267\u884c\u5931\u8d25");
    }

    private RuleActionResult actionUpdate(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction, boolean upsertFlag, SecurityUser loginUser, String traceId, HashSet<Long> dateIds, boolean isFirst, List<String> ruleIds) {
        Map<String, Object> updatedData;
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)loginUser);
        TransmittableThreadLocalHolder.set((String)"traceId", (Object)traceId);
        EngineUserUtil.setUser((UserDetails)loginUser);
        Long formId = sysRuleExecAction.getFormId();
        SysForm form = this.applicationService.getFormDetailById(formId);
        String formName = form.getTableName();
        String target = sysRuleExecAction.getTarget();
        JSONObject jsonTarget = JSONObject.parseObject((String)target);
        String appId = jsonTarget.getString("appId");
        String targetFormId = jsonTarget.getString("formId");
        boolean targetFormChild = false;
        FormCanvasSchema targetCanvas = (FormCanvasSchema)this.canvasSchemaService.get(targetFormId).getData();
        List widgetList = targetCanvas.childTables();
        if (!widgetList.isEmpty()) {
            targetFormChild = true;
        }
        String execType = null;
        execType = upsertFlag ? NoCodeRuleExecType.ExecTypeCreateOrUpdate.getValue() : NoCodeRuleExecType.ExecTypeUpdate.getValue();
        ArrayList<Map<String, Object>> allChild = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> filteredData = this.getFilteredData(sourceFormId, businessData, sysRuleExecAction, allChild);
        if (HussarUtils.isEmpty(filteredData)) {
            logger.info("\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u67e5\u8be2\u76ee\u6807\u8868,\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e,\u4e0d\u9700\u8981\u4fee\u6539,\u94fe\u8defid\uff1a{}", (Object)traceId);
            return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
        }
        if (dateIds != null) {
            Set collect = filteredData.stream().map(date -> Long.valueOf(date.get("RECORD_ID").toString())).collect(Collectors.toSet());
            dateIds.addAll(collect);
        }
        if (HussarUtils.isEmpty(updatedData = this.getUpdatedData(businessData, sysRuleExecAction))) {
            logger.info("\u6839\u636e\u6761\u4ef6\u7ec4\u88c5\u4fee\u6539\u540e\u7684\u6570\u636e,\u7ed3\u679c\u4e3a\u7a7a,\u4e0d\u9700\u8981\u4fee\u6539,\u94fe\u8defid\uff1a{}", (Object)traceId);
            return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
        }
        boolean isMainToMain = false;
        String execContent = sysRuleExecAction.getExecContent();
        List mapList = (List)JSONObject.parseObject((String)execContent, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        for (Map map : mapList) {
            String depentParent;
            String mode = (String)map.get("mode");
            String parent = (String)map.get("parent");
            JSONObject depend = (JSONObject)map.get("depend");
            String string = depentParent = HussarUtils.isNotEmpty((Object)depend) ? (String)depend.get((Object)"parent") : null;
            if (!"acc".equals(mode) && !"deduct".equals(mode) && !"custom_deduct".equals(mode) && !"custom_acc".equals(mode) || !HussarUtils.isEmpty((Object)parent) || !HussarUtils.isEmpty((Object)depentParent)) continue;
            isMainToMain = true;
        }
        int dataNum = this.updateOnlyValues(updatedData, filteredData, formName);
        logger.info("\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u4fee\u6539\u52a8\u4f5c\u4e2d\uff0c\u7ec4\u88c5\u4fee\u6539\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JsonUtil.toJson(allChild));
        String dataSourceKey = DataModelUtil.currentDsName();
        if (HussarUtils.isNotEmpty(filteredData)) {
            for (Map<String, Object> params : filteredData) {
                String triggerId = params.get("RECORD_ID").toString();
                String lockKey = String.format("%s_%s_%s", dataSourceKey, formId, triggerId);
                try {
                    if (targetFormChild) {
                        boolean ifUpdateMain = true;
                        if (isMainToMain && !isFirst) {
                            ifUpdateMain = false;
                        }
                        if (FLOW_FROM.equals(form.getFormType())) {
                            this.appFormService.processIncrementUpdateWithRule(String.valueOf(formId), form.getTableName(), params, appId, ifUpdateMain, ruleIds, lockKey);
                            continue;
                        }
                        this.appFormService.formIncrementSaveWithRule(String.valueOf(formId), form.getTableName(), params, appId, ifUpdateMain, ruleIds, lockKey);
                        continue;
                    }
                    if (FLOW_FROM.equals(form.getFormType())) {
                        this.appFormService.processUpdateWithRuleWithLock(String.valueOf(formId), params, appId, false, ruleIds, lockKey);
                        continue;
                    }
                    this.appFormService.formSaveWithRuleWithLock(String.valueOf(formId), params, appId, ruleIds, lockKey);
                }
                catch (Exception e) {
                    logger.error("\u4fee\u6539\u6570\u636e\u662f\u53d1\u751f\u5f02\u5e38,\u8868\u5355id:{}:\u94fe\u8defid\uff1a{}", new Object[]{formId, traceId, e});
                    --dataNum;
                }
            }
        }
        TransmittableThreadLocalHolder.clear((String)"traceId");
        if (dataNum == 0) {
            return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u4fee\u6539\u6570\u636e\u5931\u8d25");
        }
        return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)dataNum);
    }

    private int updateValues(List<Map<String, Object>> filteredData, Map<String, Object> updatedData, List<Map<String, Object>> filteredChildData) {
        for (int i = 0; i < filteredData.size(); ++i) {
            Map<String, Object> sourceMap = filteredData.get(i);
            for (Map.Entry<String, Object> entry : updatedData.entrySet()) {
                String updateKey = entry.getKey();
                Object updateValue = entry.getValue();
                if (sourceMap.containsKey(updateKey)) {
                    if (updateValue instanceof Map && sourceMap.get(updateKey) instanceof List) {
                        Map<String, Object> filteredChildMap = filteredChildData.get(i);
                        if (!HussarUtils.isNotEmpty((Object)filteredChildMap.get(updateKey)) || !HussarUtils.isNotEmpty((Object)sourceMap.get(updateKey))) continue;
                        this.updateValues((List)filteredChildMap.get(updateKey), (Map)updateValue, null);
                        this.mergeData(updateKey, (List)sourceMap.get(updateKey), (List)filteredChildMap.get(updateKey));
                        continue;
                    }
                    sourceMap.put(updateKey, updateValue);
                    continue;
                }
                sourceMap.put(updateKey, updateValue);
            }
        }
        return filteredData.size();
    }

    private int updateOnlyValues(Map<String, Object> updatedData, List<Map<String, Object>> filteredChildData, String formName) {
        for (Map<String, Object> child : filteredChildData) {
            HashSet<String> keysToRemove = new HashSet<String>(child.keySet());
            for (String string : keysToRemove) {
                if (updatedData.containsKey(string) || string.equals("RECORD_ID") || string.equals(formName)) continue;
                child.remove(string);
            }
            for (Map.Entry entry : updatedData.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map && child.get(key) instanceof List) {
                    this.updateOnlyValues((Map)value, (List)child.get(key), formName);
                    continue;
                }
                child.put(key, value);
            }
        }
        return filteredChildData.size();
    }

    private int createChildrenValues(List<Map<String, Object>> filteredData, Map<String, Object> updatedData, String formName) {
        for (int i = 0; i < filteredData.size(); ++i) {
            Map<String, Object> sourceMap = filteredData.get(i);
            HashSet<String> keysToRemove = new HashSet<String>(sourceMap.keySet());
            for (String string : keysToRemove) {
                if (updatedData.containsKey(string) || string.equals("RECORD_ID") || string.equals(formName)) continue;
                sourceMap.remove(string);
            }
            for (Map.Entry entry : updatedData.entrySet()) {
                String updateKey = (String)entry.getKey();
                Object updateValue = entry.getValue();
                if (sourceMap.containsKey(updateKey)) {
                    if (updateValue instanceof Map && sourceMap.get(updateKey) instanceof List) {
                        ArrayList childrenValueList = new ArrayList();
                        childrenValueList.add(updateValue);
                        sourceMap.put(updateKey, childrenValueList);
                        continue;
                    }
                    sourceMap.put(updateKey, updateValue);
                    continue;
                }
                sourceMap.put(updateKey, updateValue);
            }
        }
        return filteredData.size();
    }

    private void mergeData(String updateKey, List<Map<String, Object>> filteredData, List<Map<String, Object>> filteredChildData) {
        block0: for (int i = 0; i < filteredData.size(); ++i) {
            for (Map<String, Object> filteredChildDatum : filteredChildData) {
                if (!filteredData.get(i).get(updateKey).equals(filteredChildDatum.get(updateKey))) continue;
                filteredData.set(i, filteredChildDatum);
                continue block0;
            }
        }
    }

    private Map<String, Object> getUpdatedData(JSONObject businessData, SysRuleExecAction sysRuleExecAction) {
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        String contentString = sysRuleExecAction.getExecContent();
        if (HussarUtils.isNotEmpty((Object)contentString)) {
            List contents = JSONArray.parseArray((String)contentString, JSONObject.class);
            for (JSONObject content : contents) {
                Map<String, Object> map;
                JSONObject dependJson;
                JSONObject newBusinessData = new JSONObject();
                JSONObject parentData = new JSONObject();
                int childNum = 1;
                if ("depend".equals(content.get((Object)"mode")) && HussarUtils.isNotEmpty((Object)content.get((Object)"depend")) && HussarUtils.isNotEmpty((Object)(dependJson = (JSONObject)JSONObject.parseObject((String)content.getString("depend"), JSONObject.class)).get((Object)"parent")) && businessData.get(dependJson.get((Object)"parent")) != null) {
                    childNum = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get(dependJson.get((Object)"parent"))), JSONObject.class).size();
                }
                if (childNum <= 0) continue;
                JSONObject newData = this.getNewData(content, businessData, newBusinessData, childNum - 1, String.valueOf(sysRuleExecAction.getFormId()), false, null);
                if (StringUtil.isNotEmpty((Object)content.get((Object)"parent"))) {
                    parentData.put(content.getString("parent"), (Object)newData);
                    map = NoCodeRuleExec.jsonToMap(parentData);
                    map.forEach((key, value) -> {
                        if (updateMap.containsKey(key)) {
                            Map childMap = (Map)updateMap.get(key);
                            Map childValue = (Map)value;
                            this.mergeCusMap(childValue, childMap);
                        }
                    });
                    updateMap.putAll(map);
                    continue;
                }
                map = NoCodeRuleExec.jsonToMap(newData);
                this.mergeCusMap(updateMap, map);
            }
        }
        return updateMap;
    }

    private void mergeCusMap(Map<String, Object> updateMap, Map<String, Object> map) {
        Object ruleCus = updateMap.get("$RULE_CUS");
        map.forEach((key, value) -> {
            if ("$RULE_CUS".equals(key)) {
                Map mapValue = (Map)value;
                if (HussarUtils.isNotEmpty((Object)ruleCus)) {
                    String ruleCusStr = JsonUtil.toJson((Object)ruleCus);
                    Map ruleCusMap = JsonUtil.toMap((String)ruleCusStr);
                    ruleCusMap.putAll(mapValue);
                    updateMap.put("$RULE_CUS", ruleCusMap);
                } else {
                    updateMap.put((String)key, value);
                }
            } else {
                updateMap.put((String)key, value);
            }
        });
    }

    private List<Map<String, Object>> getFilteredData(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction, ArrayList<Map<String, Object>> allChild) {
        String target = sysRuleExecAction.getTarget();
        JSONObject jsonTarget = JSONObject.parseObject((String)target);
        String appId = jsonTarget.getString("appId");
        String recordId = businessData.getString("RECORD_ID");
        String actionFilterString = sysRuleExecAction.getActionFilter();
        if (HussarUtils.isNotEmpty((Object)actionFilterString)) {
            JSONObject actionFilter = (JSONObject)JSONObject.parseObject((String)actionFilterString, JSONObject.class);
            JSONArray cond = actionFilter.getJSONArray("cond");
            ArrayList<Map<String, Object>> selectionList = new ArrayList<Map<String, Object>>();
            ArrayList<String> filterdChildTableName = new ArrayList<String>();
            for (Object item : cond) {
                HashMap<String, Object> conditionMap = new HashMap<String, Object>();
                JSONObject jsonItem = (JSONObject)JSON.toJSON(item);
                JSONObject newData = this.getNewData(jsonItem, businessData, new JSONObject(), 0, String.valueOf(sysRuleExecAction.getFormId()), true, null);
                Map.Entry entry = (Map.Entry)newData.entrySet().iterator().next();
                if (HussarUtils.isEmpty(entry.getValue())) {
                    conditionMap.put("rule", "_isNull");
                    conditionMap.put("val", "");
                    this.buildConditionMap(conditionMap, jsonItem, entry);
                } else if ("depend".equals(jsonItem.getString("mode")) && "JXDNDate".equals(jsonItem.getString("type"))) {
                    this.processDateFilter(sourceFormId, String.valueOf(sysRuleExecAction.getFormId()), entry, jsonItem, conditionMap);
                    this.buildConditionMap(conditionMap, jsonItem, entry);
                } else if ("depend".equals(jsonItem.getString("mode")) && "JXDNAddress".equals(jsonItem.getString("type"))) {
                    this.processAddressFilter(sourceFormId, String.valueOf(sysRuleExecAction.getFormId()), entry, jsonItem, conditionMap);
                    this.buildConditionMap(conditionMap, jsonItem, entry);
                } else if ("depend".equals(jsonItem.getString("mode")) && ("JXDNSelectMulti".equals(jsonItem.getString("type")) || "JXDNCheckBoxGroup".equals(jsonItem.getString("type")))) {
                    this.processSelectMultiFilter(entry, jsonItem, selectionList);
                } else if ("depend".equals(jsonItem.getString("mode")) && ("JXDNOrgMulti".equals(jsonItem.getString("type")) || "JXDNUserMulti".equals(jsonItem.getString("type")))) {
                    this.processUserMultiFilter(entry, jsonItem, selectionList);
                } else {
                    conditionMap.put("rule", "_eq");
                    conditionMap.put("val", entry.getValue());
                    this.buildConditionMap(conditionMap, jsonItem, entry);
                }
                if (HussarUtils.isNotEmpty(conditionMap)) {
                    selectionList.add(conditionMap);
                }
                if (!StringUtil.isNotEmpty((Object)jsonItem.get((Object)"parent"))) continue;
                filterdChildTableName.add(jsonItem.getString("parent"));
            }
            ArrayList<Map<String, Object>> recordIdQueryList = new ArrayList<Map<String, Object>>();
            recordIdQueryList.addAll(selectionList);
            SysForm form = this.applicationService.getFormDetailById(sysRuleExecAction.getFormId());
            if (FLOW_FROM.equals(form.getFormType())) {
                HashMap<String, String> filterFlow = new HashMap<String, String>();
                filterFlow.put("rule", "_isNotNull");
                filterFlow.put("val", "");
                filterFlow.put("field", "PROCESS_KEY");
                filterFlow.put("match", "AND");
                selectionList.add(filterFlow);
            }
            HashMap<String, ArrayList<Map<String, Object>>> param = new HashMap<String, ArrayList<Map<String, Object>>>();
            param.put("superQueryConditionDto", selectionList);
            ResponseEntity response = this.formOperateExposedService.tableQueryByCondition(appId, String.valueOf(sysRuleExecAction.getFormId()), param);
            PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(response.getBody())).getData();
            List dataTemp = pageData.getData();
            boolean b = this.containsKeyValue(dataTemp, "RECORD_ID", recordId);
            if (sourceFormId.equals(sysRuleExecAction.getFormId()) && !b) {
                HashMap<String, String> recordFilterFlow = new HashMap<String, String>();
                recordFilterFlow.put("rule", "eq");
                recordFilterFlow.put("val", recordId);
                recordFilterFlow.put("field", "RECORD_ID");
                recordFilterFlow.put("match", "AND");
                recordIdQueryList.add(recordFilterFlow);
                HashMap<String, ArrayList<Map<String, Object>>> redcordParam = new HashMap<String, ArrayList<Map<String, Object>>>();
                redcordParam.put("superQueryConditionDto", recordIdQueryList);
                ResponseEntity recordResponse = this.formOperateExposedService.tableQueryByCondition(appId, String.valueOf(sysRuleExecAction.getFormId()), redcordParam);
                PageVo recordPageData = (PageVo)((ApiResponse)Objects.requireNonNull(recordResponse.getBody())).getData();
                List recordDataTemp = recordPageData.getData();
                dataTemp.addAll(recordDataTemp);
            }
            FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(sysRuleExecAction.getFormId())).getData();
            List widgets = canvas.childTables();
            List childName = widgets.stream().map(Widget::getName).collect(Collectors.toList());
            Iterator listIterator = dataTemp.iterator();
            while (listIterator.hasNext()) {
                Map map = (Map)listIterator.next();
                for (Map.Entry entry : map.entrySet()) {
                    Object childValue;
                    if (childName.contains(entry.getKey()) && !filterdChildTableName.contains(entry.getKey())) {
                        map.put(entry.getKey(), null);
                    }
                    if (!childName.contains(entry.getKey()) || !filterdChildTableName.contains(entry.getKey())) continue;
                    if (businessData.get(entry.getValue()) instanceof JSONArray) {
                        childValue = (JSONArray)entry.getValue();
                        if (!childValue.isEmpty()) continue;
                        listIterator.remove();
                        continue;
                    }
                    childValue = (ArrayList)entry.getValue();
                    if (!((ArrayList)childValue).isEmpty()) continue;
                    listIterator.remove();
                }
            }
            if (!dataTemp.isEmpty()) {
                List idList = dataTemp.stream().map(data -> Long.valueOf(data.get("RECORD_ID").toString())).collect(Collectors.toList());
                HashMap newParam = new HashMap();
                HashMap<String, Object> filter = new HashMap<String, Object>();
                filter.put("rule", "_in");
                filter.put("val", idList);
                filter.put("field", "RECORD_ID");
                filter.put("match", "AND");
                ArrayList<HashMap<String, Object>> filters = new ArrayList<HashMap<String, Object>>();
                filters.add(filter);
                newParam.put("superQueryConditionDto", filters);
                ResponseEntity newResponse = this.formOperateExposedService.tableQueryByCondition(appId, String.valueOf(sysRuleExecAction.getFormId()), newParam);
                PageVo newPageData = (PageVo)((ApiResponse)Objects.requireNonNull(newResponse.getBody())).getData();
                if (allChild != null) {
                    allChild.addAll(newPageData.getData());
                }
            }
            return dataTemp;
        }
        return null;
    }

    private boolean containsKeyValue(List<Map<String, Object>> list, String key, Object value) {
        for (Map<String, Object> map : list) {
            if (!map.containsKey(key) || !map.get(key).equals(value)) continue;
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> getFilteredData(String sourceFormId, JSONObject businessData, SysRuleExecAction sysRuleExecAction) {
        return this.getFilteredData(sourceFormId, businessData, sysRuleExecAction, null);
    }

    private void processUserMultiFilter(Map.Entry<String, Object> entry, JSONObject jsonItem, List<Map<String, Object>> selectionList) {
        String[] split;
        String value = entry.getValue().toString();
        for (String str : split = value.split(",")) {
            HashMap<String, Object> conditionMap = new HashMap<String, Object>();
            conditionMap.put("rule", "_like");
            conditionMap.put("val", str);
            this.buildConditionMap(conditionMap, jsonItem, entry);
            selectionList.add(conditionMap);
        }
    }

    private void processSelectMultiFilter(Map.Entry<String, Object> entry, JSONObject jsonItem, List<Map<String, Object>> selectionList) {
        String value = entry.getValue().toString();
        JSONArray jsonArray = JSON.parseArray((String)value);
        for (Object item : jsonArray) {
            HashMap<String, Object> conditionMap = new HashMap<String, Object>();
            String itemStr = item.toString();
            conditionMap.put("rule", "_like");
            conditionMap.put("val", itemStr);
            this.buildConditionMap(conditionMap, jsonItem, entry);
            selectionList.add(conditionMap);
        }
    }

    private void buildConditionMap(HashMap<String, Object> conditionMap, JSONObject jsonItem, Map.Entry<String, Object> entry) {
        conditionMap.put("match", "AND");
        if (StringUtil.isNotEmpty((Object)jsonItem.get((Object)"parent"))) {
            conditionMap.put("field", String.format("%s.%s", jsonItem.getString("parent"), entry.getKey()));
        } else {
            conditionMap.put("field", entry.getKey());
        }
    }

    private void processAddressFilter(String sourceFormId, String targetFormId, Map.Entry<String, Object> entry, JSONObject ruleInfo, HashMap<String, Object> conditionMap) {
        JSONObject dependJson = (JSONObject)ruleInfo.get((Object)"depend");
        int sourceAddressLevel = (Integer)this.getFieldProperty(sourceFormId, dependJson.getString("field"), "addressLevel");
        int targetAddressLevel = (Integer)this.getFieldProperty(targetFormId, ruleInfo.getString("field"), "addressLevel");
        String sourceAddressCode = entry.getValue().toString();
        if (sourceAddressLevel == targetAddressLevel) {
            conditionMap.put("rule", "_eq");
            conditionMap.put("val", entry.getValue());
        } else if (sourceAddressLevel < targetAddressLevel) {
            conditionMap.put("rule", "_rightLike");
            conditionMap.put("val", entry.getValue());
        } else {
            String newCode = null;
            switch (targetAddressLevel) {
                case 1: {
                    newCode = sourceAddressCode.substring(0, 2);
                    break;
                }
                case 2: {
                    newCode = sourceAddressCode.substring(0, 4);
                    break;
                }
                case 3: {
                    newCode = sourceAddressCode.substring(0, 6);
                }
            }
            conditionMap.put("rule", "_rightLike");
            conditionMap.put("val", newCode);
        }
    }

    private void processDateFilter(String sourceFormId, String targetFormId, Map.Entry<String, Object> entry, JSONObject ruleInfo, HashMap<String, Object> conditionMap) {
        JSONObject dependJson = (JSONObject)ruleInfo.get((Object)"depend");
        String sourceFormatter = (String)this.getFieldProperty(sourceFormId, dependJson.getString("field"), "format");
        String targetFormatter = (String)this.getFieldProperty(targetFormId, ruleInfo.getString("field"), "format");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT);
        LocalDateTime sourceDate = null;
        if (entry.getValue() instanceof LocalDateTime) {
            sourceDate = (LocalDateTime)entry.getValue();
        } else {
            String dateStr = entry.getValue().toString().replaceAll("T", " ");
            sourceDate = LocalDateTime.parse(dateStr, dtf);
        }
        String startTime = null;
        String endTime = null;
        if (Objects.equals(sourceFormatter, targetFormatter) && DATE_TIME_FORMAT.equals(sourceFormatter)) {
            conditionMap.put("rule", "_eq");
            conditionMap.put("val", entry.getValue());
        } else {
            if (YEAR_FORMAT.equals(sourceFormatter) || YEAR_FORMAT.equals(targetFormatter)) {
                int year = sourceDate.getYear();
                startTime = year + "-1-1 00:00:00";
                endTime = year + "-12-31 23:59:59";
            } else if (MONTH_FORMAT.equals(sourceFormatter) || MONTH_FORMAT.equals(targetFormatter)) {
                startTime = sourceDate.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).format(dtf);
                endTime = sourceDate.withDayOfMonth(sourceDate.toLocalDate().lengthOfMonth()).withHour(23).withMinute(59).withSecond(59).format(dtf);
            } else if (DAY_FORMAT.equals(sourceFormatter) || DAY_FORMAT.equals(targetFormatter)) {
                startTime = sourceDate.with(LocalTime.MIN).format(dtf);
                endTime = sourceDate.with(LocalTime.MAX).format(dtf);
            } else if (MINUTE_FORMAT.equals(sourceFormatter) || MINUTE_FORMAT.equals(targetFormatter)) {
                startTime = sourceDate.withSecond(0).format(dtf);
                endTime = sourceDate.withSecond(59).format(dtf);
            }
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)startTime);
            jsonArray.add((Object)endTime);
            conditionMap.put("rule", "_between");
            conditionMap.put("val", jsonArray);
        }
    }

    private static Map<String, Object> jsonToMap(JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                map.put(key, NoCodeRuleExec.jsonToMap((JSONObject)value));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    private RuleActionResult actionAdd(JSONObject businessData, SysRuleExecAction sysRuleExecAction, boolean upsertFlag, SecurityUser user, String traceId, List<String> ruleIds) {
        String contentString;
        String cacheKey = "";
        Long formId = sysRuleExecAction.getFormId();
        SysForm form = this.applicationService.getFormDetailById(formId);
        String createSource = form.getCreateSource();
        boolean isFromForm = Objects.equals(createSource, "2");
        Long actionFormId = null;
        if (isFromForm) {
            actionFormId = form.getId();
        }
        String execType = null;
        if (upsertFlag) {
            contentString = sysRuleExecAction.getUpsert();
            execType = NoCodeRuleExecType.ExecTypeCreateOrUpdate.getValue();
        } else {
            contentString = sysRuleExecAction.getExecContent();
            execType = NoCodeRuleExecType.ExecTypeCreate.getValue();
        }
        logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u89e3\u6790\u6267\u884c\u52a8\u4f5c\u4e3a\u65b0\u589e\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{}\uff0c\u94fe\u8defid:{}", new Object[]{formId, businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
        if (HussarUtils.isNotEmpty((Object)contentString)) {
            ArrayList<JSONObject> importList = new ArrayList<JSONObject>();
            List conditions = JSONArray.parseArray((String)contentString, JSONObject.class);
            int newBusinessDataNum = 1;
            boolean newChildNum = true;
            HashMap<String, Integer> execChildParentsAndNum = new HashMap<String, Integer>();
            HashMap execChildParentsAndGrandChildNum = new HashMap();
            for (JSONObject condition : conditions) {
                int num = 1;
                if ("depend".equals(condition.get((Object)"mode")) && HussarUtils.isNotEmpty((Object)condition.get((Object)"depend"))) {
                    JSONObject dependJson = (JSONObject)JSONObject.parseObject((String)condition.getString("depend"), JSONObject.class);
                    if (HussarUtils.isNotEmpty((Object)dependJson.get((Object)"parent")) && HussarUtils.isEmpty((Object)condition.get((Object)"parent")) && businessData.get(dependJson.get((Object)"parent")) != null) {
                        newBusinessDataNum = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get(dependJson.get((Object)"parent"))), JSONObject.class).size();
                    }
                    if (HussarUtils.isNotEmpty((Object)condition.get((Object)"parent")) && HussarUtils.isEmpty((Object)condition.get((Object)"grandparent"))) {
                        if (HussarUtils.isNotEmpty((Object)dependJson.get((Object)"parent")) && businessData.get(dependJson.get((Object)"parent")) != null) {
                            num = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get(dependJson.get((Object)"parent"))), JSONObject.class).size();
                        }
                        if (!execChildParentsAndNum.containsKey(condition.get((Object)"parent")) || (Integer)execChildParentsAndNum.get(condition.get((Object)"parent")) == 1) {
                            execChildParentsAndNum.put(condition.get((Object)"parent").toString(), num);
                        }
                    }
                }
                if (!"custom".equals(condition.get((Object)"mode")) || !HussarUtils.isNotEmpty((Object)condition.get((Object)"parent")) || execChildParentsAndNum.containsKey(condition.get((Object)"parent")) && (Integer)execChildParentsAndNum.get(condition.get((Object)"parent")) != 1) continue;
                execChildParentsAndNum.put(condition.get((Object)"parent").toString(), num);
            }
            logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u9700\u8981\u751f\u6210\u7684\u5b50\u8868\u7684\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid:{}", new Object[]{JSONObject.toJSONString(execChildParentsAndNum), formId, businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
            if (newBusinessDataNum < 1) {
                logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u6709\u89e6\u53d1\u8868\u5b50\u8868\u5bf9\u6267\u884c\u8868\u4e3b\u8868\u8d4b\u503c\u5e76\u4e14\u89e6\u53d1\u8868\u5b50\u8868\u6570\u91cf\u4e3a0\uff0c\u4e0d\u4ea7\u751f\u4e1a\u52a1\u6570\u636e\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
                return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)0);
            }
            for (int i = 0; i < newBusinessDataNum; ++i) {
                JSONObject newBusinessData = new JSONObject();
                for (JSONObject condition : conditions) {
                    if (!HussarUtils.isEmpty((Object)condition.get((Object)"parent"))) continue;
                    newBusinessData = this.getNewData(condition, businessData, newBusinessData, i, String.valueOf(formId), false, null);
                }
                for (Map.Entry entry : execChildParentsAndNum.entrySet()) {
                    String childParent = (String)entry.getKey();
                    Integer childNum = (Integer)entry.getValue();
                    String dependParent = "";
                    for (int j = 0; j < childNum; ++j) {
                        JSONObject newChildData = new JSONObject();
                        for (JSONObject condition : conditions) {
                            if (!HussarUtils.isNotEmpty((Object)condition.get((Object)"parent")) || !condition.get((Object)"parent").equals(childParent) || !HussarUtils.isEmpty((Object)condition.get((Object)"grandparent"))) continue;
                            newChildData = this.getNewData(condition, businessData, newChildData, j, String.valueOf(formId), false, null);
                        }
                        this.getGrandChildDataForAdd(childParent, businessData, j, conditions, String.valueOf(formId), newChildData);
                        List<Object> childs = new ArrayList<JSONObject>();
                        if (newBusinessData.containsKey((Object)childParent)) {
                            childs = (List)newBusinessData.get((Object)childParent);
                        }
                        childs.add(newChildData);
                        newBusinessData.put(childParent, childs);
                    }
                }
                if (!HussarUtils.isNotEmpty((Object)newBusinessData)) continue;
                importList.add(newBusinessData);
            }
            int successNum = 0;
            int failNum = 0;
            if (HussarUtils.isNotEmpty(importList)) {
                logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u89e3\u6790\u6267\u884c\u52a8\u4f5c\u5b8c\u6bd5\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u6267\u884c\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, JSONObject.toJSONString(importList), businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
                TransmittableThreadLocalHolder.set((String)"appId", (Object)form.getAppId());
                TransmittableThreadLocalHolder.set((String)"loginUser", (Object)user);
                TransmittableThreadLocalHolder.set((String)"traceId", (Object)traceId);
                EngineUserUtil.setUser((UserDetails)user);
                FormCanvasSchema canvas = (FormCanvasSchema)this.canvasSchemaService.get(String.valueOf(formId)).getData();
                if (HussarUtils.isEmpty((Object)canvas)) {
                    logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u83b7\u53d6\u76ee\u6807\u8868\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25\uff0c\u6b64\u4e1a\u52a1\u89c4\u5219\u8df3\u8fc7\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u8868\u5355\u4fe1\u606f\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, JSONObject.toJSONString((Object)canvas), traceId});
                    return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u83b7\u53d6\u76ee\u6807\u8868\u8868\u5355\u753b\u5e03\u4fe1\u606f\u5931\u8d25");
                }
                if (FLOW_FROM.equals(canvas.getFormType())) {
                    for (JSONObject jSONObject : importList) {
                        String id = jSONObject.getString("RECORD_ID");
                        if (HussarUtils.isEmpty((Object)id)) {
                            id = String.valueOf(EngineUtil.getId());
                            jSONObject.put("RECORD_ID", (Object)id);
                            jSONObject.put(form.getTableName(), (Object)id);
                        }
                        HashMap<String, Object> flowFormSubmitParams = new HashMap<String, Object>();
                        if (isFromForm) {
                            jSONObject.put("FORM_ID", (Object)actionFormId);
                        }
                        flowFormSubmitParams.put("formData", jSONObject);
                        flowFormSubmitParams.put("processDefinitionKey", canvas.getIdentity());
                        try {
                            cacheKey = String.format("%s:%s:%s", form.getAppId(), formId, id);
                            HashMap<String, Object> cacheMap = new HashMap<String, Object>();
                            cacheMap.put("traceId", traceId);
                            cacheMap.put("ruleIds", ruleIds);
                            HussarCacheUtil.put((String)CACHE_NAME, (Object)cacheKey, cacheMap, (long)1800L);
                            this.appFormService.flowFormSubmitWithRule(String.valueOf(formId), flowFormSubmitParams, ruleIds);
                            ++successNum;
                        }
                        catch (Exception e) {
                            ++failNum;
                            logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u8868\u5355\u4fe1\u606f\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, JSONObject.toJSONString(flowFormSubmitParams), traceId, e});
                            logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u63d0\u4ea4\u6d41\u7a0b\u5931\u8d25:" + e);
                        }
                    }
                } else if (NORMAL_FORM.equals(canvas.getFormType())) {
                    for (JSONObject jSONObject : importList) {
                        Map parse = (Map)JSONObject.parseObject((String)sysRuleExecAction.getTarget(), Map.class);
                        String appId = (String)parse.get("appId");
                        Map params = (Map)JSONObject.parseObject((String)jSONObject.toJSONString(), Map.class);
                        if (isFromForm) {
                            params.put("FORM_ID", actionFormId);
                        }
                        try {
                            this.appFormService.formSaveWithRule(String.valueOf(sysRuleExecAction.getFormId()), params, appId, ruleIds);
                            ++successNum;
                        }
                        catch (Exception e) {
                            ++failNum;
                            logger.error("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u4fdd\u5b58\u8868\u5355\u6570\u636e\u5931\u8d25\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u8868\u5355\u4fe1\u606f\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, JSONObject.toJSONString((Object)params), traceId, e});
                        }
                    }
                }
                logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u5b8c\u6bd5\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u6267\u884c\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, JSONObject.toJSONString(importList), businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
            } else {
                logger.info("\u6267\u884c\u4e1a\u52a1\u89c4\u5219\u52a8\u4f5c\u4e2d\uff0c\u89e3\u6790\u6267\u884c\u52a8\u4f5c\u5b8c\u6bd5\uff0c\u5f85\u65b0\u589e\u6570\u636e\u4e3a0\uff0c\u6267\u884c\u52a8\u4f5c\u7ed3\u675f\uff0c\u6267\u884c\u8868\u5355\uff1a{}\uff0c\u6267\u884c\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u89e6\u53d1\u8868\u4e1a\u52a1\u6570\u636e\uff1a{}\uff0c\u6267\u884c\u52a8\u4f5c\uff1a{},\u94fe\u8defid:{}", new Object[]{formId, JSONObject.toJSONString(importList), businessData, JSONObject.toJSONString((Object)sysRuleExecAction), traceId});
            }
            TransmittableThreadLocalHolder.clear((String)"appId");
            HussarCacheUtil.evict((String)CACHE_NAME, (Object)cacheKey);
            if (successNum == 0 && failNum != 0) {
                return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5931\u8d25");
            }
            return RuleActionResult.success((String)execType, (String)form.getFormName(), (int)successNum);
        }
        return RuleActionResult.fail((String)execType, (String)form.getFormName(), (String)"\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u52a8\u4f5c\u4e3a\u7a7a");
    }

    private void getGrandChildData(String childParent, JSONObject businessData, String childTableName, int childNum, List<JSONObject> conditions, String formId, Map<String, Object> newChildData) {
        List childData = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)childTableName)), JSONObject.class);
        JSONObject childJson = null;
        if (HussarUtils.isNotEmpty((Object)childData)) {
            childJson = (JSONObject)childData.get(childNum);
        }
        HashMap<String, Integer> grandChildMap = new HashMap<String, Integer>();
        for (JSONObject con : conditions) {
            Optional value = JsonParser.value((Object)con, (String)"$.depend.parent", String.class);
            if (!value.isPresent() || !childParent.equals(con.get((Object)"grandparent")) || grandChildMap.containsKey(value.get())) continue;
            grandChildMap.put(String.valueOf(con.get((Object)"parent")), JSONArray.parseArray((String)String.valueOf(childJson.get(value.get()))).size());
        }
        Iterator iterator = grandChildMap.entrySet().iterator();
        Map grandChildDataMap = (Map)newChildData.get(childParent);
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String grandParent = (String)entry.getKey();
            Integer grandNum = (Integer)entry.getValue();
            ArrayList<JSONObject> grandChildData = new ArrayList<JSONObject>();
            for (int j = 0; j < grandNum; ++j) {
                JSONObject newGrandChildData = new JSONObject();
                for (JSONObject con : conditions) {
                    if (!childParent.equals(con.get((Object)"grandparent")) || !grandParent.equals(con.get((Object)"parent"))) continue;
                    newGrandChildData = this.getNewData(con, businessData, newGrandChildData, j, formId, false, childJson);
                }
                grandChildData.add(newGrandChildData);
            }
            grandChildDataMap.put(grandParent, grandChildData);
        }
        newChildData.replace(childParent, grandChildDataMap);
    }

    private void getGrandChildDataForAdd(String childParent, JSONObject businessData, int childNum, List<JSONObject> conditions, String formId, JSONObject newChildData) {
        HashMap<String, String> grandChildMap = new HashMap<String, String>();
        for (JSONObject con : conditions) {
            Optional parent = JsonParser.value((Object)con, (String)"$.depend.parent", String.class);
            Optional grandparent = JsonParser.value((Object)con, (String)"$.depend.grandparent", String.class);
            if (!parent.isPresent() || !grandparent.isPresent() || !childParent.equals(con.get((Object)"grandparent")) || grandChildMap.containsKey(con.get((Object)"parent"))) continue;
            grandChildMap.put((String)con.get((Object)"parent"), String.format("%s.%s", grandparent.get(), parent.get()));
        }
        for (Map.Entry entry : grandChildMap.entrySet()) {
            String grandParent = (String)entry.getKey();
            String dependChild = ((String)entry.getValue()).substring(0, ((String)entry.getValue()).indexOf("."));
            String dependGrand = ((String)entry.getValue()).substring(((String)entry.getValue()).indexOf(".") + 1);
            ArrayList<JSONObject> grandChildData = new ArrayList<JSONObject>();
            List childData = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)dependChild)), JSONObject.class);
            JSONObject childJson = null;
            if (HussarUtils.isNotEmpty((Object)childData)) {
                childJson = (JSONObject)childData.get(childNum);
            }
            if (HussarUtils.isEmpty(childJson) || HussarUtils.isEmpty((Object)childJson.getJSONArray(dependGrand))) continue;
            int grandNum = childJson.getJSONArray(dependGrand).size();
            for (int j = 0; j < grandNum; ++j) {
                JSONObject newGrandChildData = new JSONObject();
                for (JSONObject con : conditions) {
                    if (!childParent.equals(con.get((Object)"grandparent")) || !grandParent.equals(con.get((Object)"parent"))) continue;
                    newGrandChildData = this.getNewData(con, businessData, newGrandChildData, j, formId, false, childJson);
                }
                grandChildData.add(newGrandChildData);
            }
            newChildData.put(grandParent, grandChildData);
        }
    }

    private JSONObject getNewData(JSONObject condition, JSONObject businessData, JSONObject newData, int childNumber, String formId, boolean filterFlag, JSONObject childForGrandChild) {
        switch (condition.getString("mode")) {
            case "empty": {
                String field = condition.getString("field");
                String label = String.format("%s_%s", field, "label");
                String code = String.format("%s_%s", field, "code");
                String detailed = String.format("%s_%s", field, "detailed");
                String id = String.format("%s_%s", field, "id");
                String fieldType = condition.getString("type");
                String refId = String.format("%s_%s", field, "ref_id");
                if ("JXDNSwitch".equals(fieldType)) {
                    newData.put(field, (Object)0);
                    break;
                }
                if (filterFlag) {
                    if ("JXDNAddress".equals(fieldType)) {
                        newData.put(code, (Object)"");
                        break;
                    }
                    newData.put(field, (Object)"");
                    break;
                }
                newData.put(field, (Object)"");
                newData.put(label, (Object)"");
                newData.put(code, (Object)"");
                newData.put(detailed, (Object)"");
                newData.put(id, (Object)"");
                newData.put(refId, (Object)"");
                break;
            }
            case "custom": {
                this.processCustomField(condition, newData, formId, filterFlag);
                break;
            }
            case "depend": {
                JSONObject dependJsonobject;
                if (HussarUtils.isEmpty((Object)condition.get((Object)"depend")) || HussarUtils.isEmpty((Object)(dependJsonobject = (JSONObject)JSONObject.parseObject((String)condition.getString("depend"), JSONObject.class)).get((Object)"field"))) break;
                if (HussarUtils.isEmpty((Object)dependJsonobject.get((Object)"parent"))) {
                    this.processDependField(condition, businessData, newData, formId, filterFlag, false);
                    break;
                }
                if (HussarUtils.isNotEmpty((Object)dependJsonobject.get((Object)"parent")) && HussarUtils.isEmpty((Object)dependJsonobject.get((Object)"grandparent"))) {
                    List childData = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)dependJsonobject.getString("parent"))), JSONObject.class);
                    if (!HussarUtils.isNotEmpty((Object)childData)) break;
                    JSONObject childJson = (JSONObject)childData.get(childNumber);
                    this.processDependField(condition, childJson, newData, formId, filterFlag, true);
                    break;
                }
                if (!HussarUtils.isNotEmpty((Object)childForGrandChild)) break;
                List grandChildTables = (List)childForGrandChild.get((Object)dependJsonobject.getString("parent"));
                JSONObject grandChildJson = (JSONObject)grandChildTables.get(childNumber);
                this.processDependField(condition, grandChildJson, newData, formId, filterFlag, true);
                break;
            }
            case "acc": {
                JSONObject dependJsonobject = (JSONObject)JSONObject.parseObject((String)condition.getString("depend"), JSONObject.class);
                if (HussarUtils.isEmpty((Object)dependJsonobject.get((Object)"field"))) break;
                if (HussarUtils.isEmpty((Object)dependJsonobject.get((Object)"parent"))) {
                    this.totalDependField(condition, businessData, newData, "acc");
                    break;
                }
                List childData = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)dependJsonobject.getString("parent"))), JSONObject.class);
                if (!HussarUtils.isNotEmpty((Object)childData)) break;
                JSONObject childJson = (JSONObject)childData.get(childNumber);
                this.totalDependField(condition, childJson, newData, "acc");
                break;
            }
            case "deduct": {
                JSONObject dependJsonobject = (JSONObject)JSONObject.parseObject((String)condition.getString("depend"), JSONObject.class);
                if (HussarUtils.isEmpty((Object)dependJsonobject.get((Object)"field"))) break;
                if (HussarUtils.isEmpty((Object)dependJsonobject.get((Object)"parent"))) {
                    this.totalDependField(condition, businessData, newData, "ded");
                    break;
                }
                List childData = JSONArray.parseArray((String)JSONObject.toJSONString((Object)businessData.get((Object)dependJsonobject.getString("parent"))), JSONObject.class);
                if (!HussarUtils.isNotEmpty((Object)childData)) break;
                JSONObject childJson = (JSONObject)childData.get(childNumber);
                this.totalDependField(condition, childJson, newData, "ded");
                break;
            }
            case "custom_acc": {
                this.totalCustomField(condition, newData, "acc");
                break;
            }
            case "custom_deduct": {
                this.totalCustomField(condition, newData, "ded");
                break;
            }
            case "current_data_secrecy": {
                this.processDependField(condition, businessData, newData, formId, filterFlag, false);
                break;
            }
            case "system_secrecy": {
                this.processCustomField(condition, newData, formId, filterFlag);
            }
        }
        return newData;
    }

    private void totalCustomField(JSONObject condition, JSONObject newData, String type) {
        String field = condition.getString("field");
        String fieldType = condition.getString("type");
        if ("JXDNNumber".equals(fieldType)) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            HashMap<String, HashMap<String, Object>> map2 = new HashMap<String, HashMap<String, Object>>();
            map1.put("type", type);
            map1.put("value", condition.get((Object)"value"));
            map2.put(field, map1);
            newData.put("$RULE_CUS", map2);
            newData.put(field, null);
        }
    }

    private void totalDependField(JSONObject condition, JSONObject businessData, JSONObject newData, String type) {
        String fieldType = condition.getString("type");
        JSONObject dependJson = (JSONObject)JSONObject.parseObject((String)condition.getString("depend"), JSONObject.class);
        String field = condition.getString("field");
        String dependField = dependJson.getString("field");
        if ("JXDNNumber".equals(fieldType)) {
            HashMap<String, Object> map1 = new HashMap<String, Object>();
            HashMap<String, HashMap<String, Object>> map2 = new HashMap<String, HashMap<String, Object>>();
            map1.put("type", type);
            Object value = businessData.get((Object)dependField);
            if (HussarUtils.isEmpty((Object)value)) {
                value = 0;
            }
            map1.put("value", value);
            map2.put(field, map1);
            newData.put("$RULE_CUS", map2);
            newData.put(field, null);
        }
    }

    private void processDependField(JSONObject condition, JSONObject businessData, JSONObject newData, String formId, boolean filterFlag, boolean isChild) {
        String fieldType = condition.getString("type");
        JSONObject dependJson = (JSONObject)JSONObject.parseObject((String)condition.getString("depend"), JSONObject.class);
        String field = condition.getString("field");
        String code = String.format("%s_%s", field, "code");
        String label = String.format("%s_%s", field, "label");
        String id = String.format("%s_%s", field, "id");
        String refId = String.format("%s_%s", field, "ref_id");
        String refChildId = String.format("%s_%s", field, "ref_child_id");
        String detailed = String.format("%s_%s", field, "detailed");
        String dependField = dependJson.getString("field");
        String dependType = dependJson.getString("type");
        String dependCode = String.format("%s_%s", dependField, "code");
        String dependLabel = String.format("%s_%s", dependField, "label");
        String dependDetailed = String.format("%s_%s", dependField, "detailed");
        String dependId = String.format("%s_%s", dependField, "id");
        String dependRefId = String.format("%s_%s", dependField, "ref_id");
        String dependRefChildId = String.format("%s_%s", dependField, "ref_child_id");
        switch (fieldType) {
            case "JXDNRadioGroup": 
            case "JXDNSelect": {
                Object reLabel;
                if ("PROCESS_STATE".equals(field)) {
                    newData.put(field, businessData.get((Object)dependField));
                    break;
                }
                Object dependLabelData = businessData.get((Object)dependLabel);
                Object object = reLabel = dependLabelData == null ? businessData.get((Object)dependField) : dependLabelData;
                if (!filterFlag) {
                    newData.put(field, businessData.get((Object)dependField));
                }
                newData.put(label, reLabel);
                break;
            }
            case "JXDNCheckBoxGroup": 
            case "JXDNSelectMulti": {
                String resLabel;
                String dependContent = businessData.getString(dependField);
                String string = resLabel = businessData.get((Object)dependLabel) == null ? dependContent : businessData.get((Object)dependLabel);
                if (resLabel != null && !"JXDNCheckBoxGroup".equals(dependType) && !"JXDNSelectMulti".equals(dependType)) {
                    JSONArray jsArray = new JSONArray();
                    jsArray.add((Object)resLabel);
                    resLabel = jsArray;
                }
                if (!filterFlag) {
                    newData.put(field, businessData.get((Object)dependField));
                }
                newData.put(label, (Object)resLabel);
                break;
            }
            case "JXDNAddress": {
                if (!filterFlag) {
                    String resultDetailed;
                    String resultCode = businessData.getString(dependCode) == null ? businessData.getString(dependField) : businessData.getString(dependCode);
                    String resultLabel = businessData.getString(dependLabel) == null ? businessData.getString(dependField) : businessData.getString(dependLabel);
                    String string = resultDetailed = businessData.getString(dependDetailed) == null ? businessData.getString(dependField) : businessData.getString(dependDetailed);
                    if (HussarUtils.isNotEmpty((Object)resultCode) && HussarUtils.isNotEmpty((Object)resultLabel)) {
                        JSONObject jsonObject = this.formatAddress(formId, resultLabel, resultCode, field);
                        newData.put(code, jsonObject.get((Object)"code"));
                        newData.put(label, jsonObject.get((Object)"label"));
                    } else {
                        newData.put(code, null);
                        newData.put(label, null);
                    }
                    newData.put(detailed, (Object)resultDetailed);
                    break;
                }
                Object resultCode = businessData.get((Object)dependCode) == null ? businessData.get((Object)dependField) : businessData.get((Object)dependCode);
                newData.put(code, resultCode);
                break;
            }
            case "JXDNUser": 
            case "JXDNUserMulti": 
            case "JXDNOrg": 
            case "JXDNOrgMulti": {
                Object resultId;
                Object object = resultId = businessData.get((Object)dependId) == null ? businessData.get((Object)dependField) : businessData.get((Object)dependId);
                if (!HussarUtils.isNotEmpty((Object)resultId)) break;
                if (field.endsWith("_user")) {
                    String userName = field.replace("_user", "Name");
                    if (dependField.endsWith("_user")) {
                        String dependName = dependField.replace("_user", "Name");
                        if (!filterFlag) {
                            newData.put(userName, (Object)businessData.getString(dependName));
                        }
                    } else if (!filterFlag) {
                        newData.put(userName, (Object)businessData.getString(dependLabel));
                    }
                    newData.put(field, (Object)resultId.toString());
                    break;
                }
                if (!filterFlag) {
                    Object resultLabel = null;
                    if (businessData.get((Object)dependLabel) == null && dependField.endsWith("_user")) {
                        String userName = dependField.replace("_user", "Name");
                        resultLabel = businessData.get((Object)userName);
                        JSONArray jsonArray = new JSONArray();
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)resultId.toString());
                        jsonObject.put("label", resultLabel);
                        jsonArray.add((Object)jsonObject);
                        newData.put(field, (Object)jsonArray);
                    } else {
                        resultLabel = businessData.get((Object)dependLabel);
                        newData.put(field, businessData.get((Object)dependField));
                    }
                    newData.put(label, resultLabel);
                }
                newData.put(id, (Object)resultId.toString());
                break;
            }
            case "JXDNImage": 
            case "JXDNFile": {
                if (!filterFlag) {
                    JSONArray objects;
                    JSONArray jSONArray = objects = businessData.getJSONArray(dependLabel) == null ? null : businessData.getJSONArray(dependLabel);
                    if (objects != null) {
                        List<Object> resultLabel = this.formatMaxShow(formId, objects, field);
                        String resultLabelJson = JsonUtil.toJson(resultLabel);
                        newData.put(label, (Object)resultLabelJson);
                    } else {
                        newData.put(label, null);
                    }
                }
                newData.put(field, businessData.get((Object)dependField));
                break;
            }
            case "JXDNDate": {
                if (filterFlag) {
                    newData.put(field, businessData.get((Object)dependField));
                    break;
                }
                DateTimeFormatter dtfSecond = DateTimeFormatter.ofPattern(SECOND_TIME_FORMAT);
                DateTimeFormatter dtfDate = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT);
                Object date = businessData.get((Object)dependField);
                if (date == null || Objects.equals(date.toString(), "")) {
                    newData.put(field, (Object)"");
                    break;
                }
                LocalDateTime sourceDate = null;
                if (date instanceof LocalDateTime) {
                    sourceDate = (LocalDateTime)date;
                } else {
                    String dateStr = date.toString().replaceAll("T", " ");
                    try {
                        sourceDate = LocalDateTime.parse(dateStr, dtfSecond);
                    }
                    catch (DateTimeParseException e) {
                        try {
                            sourceDate = LocalDateTime.parse(dateStr, dtfDate);
                        }
                        catch (DateTimeParseException ex) {
                            throw new IllegalArgumentException("Invalid date format: " + dateStr);
                        }
                    }
                }
                this.processDependDate(newData, sourceDate, formId, field);
                break;
            }
            case "JXDNLinkForm": {
                if (!filterFlag) {
                    Widget widget = this.getWidget(formId, field, "JXDNLinkForm");
                    String val = businessData.getString(dependField);
                    if (HussarUtils.isNotEmpty((Object)widget) && HussarUtils.isNotEmpty((Object)val)) {
                        JSONObject linkTableInfo = widget.getProps().getJSONObject("linkTableInfo");
                        String linkFormName = linkTableInfo.getString("formName");
                        String linkFormId = linkTableInfo.getString("formId");
                        String linkAppId = linkTableInfo.getString("appId");
                        String filedName = linkTableInfo.getJSONObject("linkFieldInfo").getString("name");
                        String childTableName = linkTableInfo.getJSONObject("linkFieldInfo").getString("parent");
                        HashMap newParam = new HashMap();
                        HashMap<String, String> filter = new HashMap<String, String>();
                        filter.put("rule", "_eq");
                        filter.put("val", val);
                        filter.put("match", "AND");
                        filter.put("field", filedName);
                        ArrayList<HashMap<String, String>> filters = new ArrayList<HashMap<String, String>>();
                        filters.add(filter);
                        newParam.put("superQueryConditionDto", filters);
                        ResponseEntity response = this.formOperateExposedService.tableQueryByCondition(linkAppId, linkFormId, newParam);
                        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(response.getBody())).getData();
                        List dataTemp = pageData.getData();
                        Map maxMap = dataTemp.stream().max(Comparator.comparing(map -> Long.parseLong((String)map.get(linkFormName)))).orElse(null);
                        if (maxMap != null) {
                            if (childTableName == null) {
                                newData.put(refId, maxMap.get("RECORD_ID"));
                                newData.put(refChildId, null);
                            } else {
                                List childrenTable = (List)maxMap.get(childTableName);
                                Map maxChild = childrenTable.stream().filter(map -> val.equals(map.get(filedName))).max(Comparator.comparing(map -> Long.parseLong((String)map.get("RECORD_ID")))).orElse(null);
                                String refChildIdVal = maxChild != null ? (String)maxChild.get("RECORD_ID") : null;
                                newData.put(refId, maxMap.get("RECORD_ID"));
                                newData.put(refChildId, (Object)refChildIdVal);
                            }
                        } else {
                            newData.put(refId, null);
                            newData.put(refChildId, null);
                        }
                    } else {
                        newData.put(refId, null);
                        newData.put(refChildId, null);
                    }
                }
                newData.put(field, businessData.get((Object)dependField));
                break;
            }
            case "JXDNLinkFormMulti": {
                if (!filterFlag) {
                    String val;
                    Widget widget = this.getWidget(formId, field, "JXDNLinkFormMulti");
                    String string = val = dependField.startsWith("address") ? businessData.getString(dependField + "_label") : businessData.getString(dependField);
                    if (HussarUtils.isNotEmpty((Object)widget) && HussarUtils.isNotEmpty((Object)val)) {
                        JSONObject linkTableInfo = widget.getProps().getJSONObject("linkTableInfo");
                        String linkFormId = linkTableInfo.getString("formId");
                        String linkAppId = linkTableInfo.getString("appId");
                        String linkFiledName = linkTableInfo.getJSONObject("linkFieldInfo").getString("name");
                        linkFiledName = linkFiledName.startsWith("address") ? linkFiledName + "_label" : linkFiledName;
                        String linkFieldType = linkTableInfo.getJSONObject("linkFieldInfo").getString("type");
                        String childTableName = linkTableInfo.getJSONObject("linkFieldInfo").getString("parent");
                        HashMap newParam = new HashMap();
                        HashMap<String, Object> filter = new HashMap<String, Object>();
                        boolean isLinkFieldTypeMulti = Arrays.asList(MULTI_TYPES).contains(linkFieldType);
                        boolean isDependTypeMulti = Arrays.asList(MULTI_TYPES).contains(dependType);
                        List<String> valueList = Arrays.asList(val.split(","));
                        if (isDependTypeMulti && !isLinkFieldTypeMulti) {
                            filter.put("rule", "_in");
                            filter.put("val", valueList);
                        } else {
                            filter.put("rule", "_eq");
                            filter.put("val", val);
                        }
                        filter.put("field", linkFiledName);
                        filter.put("match", "AND");
                        ArrayList<HashMap<String, Object>> filters = new ArrayList<HashMap<String, Object>>();
                        filters.add(filter);
                        newParam.put("superQueryConditionDto", filters);
                        ResponseEntity response = this.formOperateExposedService.tableQueryByCondition(linkAppId, linkFormId, newParam);
                        PageVo pageData = (PageVo)((ApiResponse)Objects.requireNonNull(response.getBody())).getData();
                        List dataTemp = pageData.getData();
                        if (!dataTemp.isEmpty()) {
                            ArrayList<String> refIds = new ArrayList<String>();
                            StringBuilder vals = new StringBuilder();
                            if (HussarUtils.isEmpty((Object)childTableName)) {
                                for (String value : valueList) {
                                    for (Map map2 : dataTemp) {
                                        String linkValue = map2.get(linkFiledName).toString();
                                        if (value.equals(linkValue)) {
                                            refIds.add((String)map2.get("RECORD_ID"));
                                            continue;
                                        }
                                        refIds.add("");
                                    }
                                }
                                newData.put(refChildId, null);
                            } else {
                                ArrayList<String> refChildIds = new ArrayList<String>();
                                for (Map map3 : dataTemp) {
                                    List childrenTables = (List)map3.get(childTableName);
                                    for (Map childMap : childrenTables) {
                                        boolean shouldContinue;
                                        if (isDependTypeMulti && !isLinkFieldTypeMulti) {
                                            shouldContinue = !valueList.contains(childMap.get(linkFiledName));
                                        } else {
                                            boolean bl = shouldContinue = !val.equals(childMap.get(linkFiledName));
                                        }
                                        if (shouldContinue) continue;
                                        refIds.add((String)map3.get("RECORD_ID"));
                                        refChildIds.add((String)childMap.get("RECORD_ID"));
                                    }
                                }
                                newData.put(refChildId, (Object)String.join((CharSequence)",", refChildIds));
                            }
                            newData.put(refId, (Object)String.join((CharSequence)",", refIds));
                            newData.put(field, (Object)val);
                            break;
                        }
                        newData.put(refId, null);
                        newData.put(refChildId, null);
                        newData.put(field, (Object)val);
                        break;
                    }
                    newData.put(refId, null);
                    newData.put(refChildId, null);
                    newData.put(field, (Object)val);
                    break;
                }
                newData.put(field, businessData.get((Object)dependField));
                break;
            }
            case "JXDNSecurityLevel": {
                String valueString = JSONObject.toJSONString((Object)businessData.get((Object)field));
                Integer securityValue = Integer.valueOf(valueString);
                if (!filterFlag) {
                    Optional<DicLevelTreeVo> any;
                    String fieldLabel = field + "_label";
                    List dicListByType = this.sysDicRefService.getLevelDictByType(SECURITY_LEVEL_TYPE_ID);
                    if (HussarUtils.isNotEmpty((Object)dicListByType) && (any = dicListByType.stream().filter(d -> HussarUtils.equals((Object)d.getValue(), (Object)String.valueOf(securityValue))).findAny()).isPresent()) {
                        valueString = any.get().getLabel();
                    }
                    newData.put(fieldLabel, (Object)valueString);
                }
                newData.put(field, (Object)securityValue);
                break;
            }
            default: {
                String detailedContent = businessData.getString(dependDetailed) == null ? "" : businessData.getString(dependDetailed);
                String content = businessData.getString(dependLabel) == null ? businessData.getString(dependField) : businessData.getString(dependLabel) + detailedContent;
                newData.put(field, (Object)content);
            }
        }
    }

    private Widget getWidget(String formId, String field, String type) {
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)this.canvasService.get(formId).getData();
        List widgets = formCanvasSchema.widgetsWithChildren();
        ArrayList filteredWidgets = new ArrayList();
        widgets.stream().filter(widget -> CHILDREN_TABLE.equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> CHILDREN_TABLE.equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(widget -> CHILDREN_TABLE.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> JXDN_GROUPS.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> JXDN_GROUPS.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(child -> CHILDREN_TABLE.equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> JXDN_GROUPS.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(child -> CHILDREN_TABLE.equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).flatMap(widget -> widget.getChildren().stream()).filter(widget -> CHILDREN_TABLE.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> WidgetType.JXDNTab.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> WidgetType.JXDNTab.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> CHILDREN_TABLE.equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(widget -> WidgetType.JXDNTab.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> CHILDREN_TABLE.equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).flatMap(widget -> widget.getChildren().stream()).filter(widget -> CHILDREN_TABLE.equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(childWidget -> type.equals(childWidget.getType())).forEach(child -> filteredWidgets.add(child));
        widgets.stream().filter(w -> type.equals(w.getType())).forEach(widget -> filteredWidgets.add(widget));
        return filteredWidgets.stream().filter(widget1 -> field.equals(widget1.getName())).findFirst().orElse(null);
    }

    private void processDependDate(JSONObject newData, LocalDateTime dependTime, String formId, String targetField) {
        String formatter = (String)this.getFieldProperty(formId, targetField, "format");
        if (HussarUtils.isEmpty((Object)formatter)) {
            formatter = DATE_TIME_FORMAT;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT);
        String result = null;
        switch (formatter) {
            case "yyyy": {
                int year = dependTime.getYear();
                result = year + "-1-1 00:00:00";
                break;
            }
            case "yyyy-MM": {
                result = dependTime.withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).format(dtf);
                break;
            }
            case "yyyy-MM-dd": {
                result = dependTime.with(LocalTime.MIN).format(dtf);
                break;
            }
            case "yyyy-MM-dd HH:mm": {
                result = dependTime.withSecond(0).format(dtf);
                break;
            }
            default: {
                result = dependTime.format(dtf);
            }
        }
        newData.put(targetField, (Object)result);
    }

    private Object getFieldProperty(String formId, String fieldName, String propertyName) {
        if (CREATE_TIME.equals(fieldName.toUpperCase()) || UPDATE_TIME.equals(fieldName.toUpperCase())) {
            return DATE_TIME_FORMAT;
        }
        FormCanvasSchema formCanvasSchema = null;
        try {
            formCanvasSchema = (FormCanvasSchema)this.canvasService.get(formId).getData();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u83b7\u53d6\u65b0\u6570\u636e\u65b9\u6cd5\u4e2d,\u67e5\u8be2\u753b\u5e03\u5931\u8d25,id:{}", (Object)formId);
            throw new BaseException("\u7ec4\u88c5\u6570\u636e\u65f6,\u67e5\u8be2\u753b\u5e03\u4fe1\u606f\u5931\u8d25");
        }
        List widgets = formCanvasSchema.getWidgets();
        List fieldList = widgets.stream().filter(widget -> {
            List tabList;
            Iterator iterator;
            if (CHILDREN_TABLE.equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())) {
                List children = widget.getChildren();
                return children.stream().anyMatch(child -> {
                    if (CHILDREN_TABLE.equals(child.getType())) {
                        List grandChildren = child.getChildren();
                        return grandChildren.stream().anyMatch(grandChild -> Objects.equals(grandChild.getName(), fieldName));
                    }
                    return Objects.equals(child.getName(), fieldName);
                });
            }
            if (JXDN_GROUPS.equals(widget.getType())) {
                List groupChildList = widget.getChildren();
                return groupChildList.stream().anyMatch(groupChild -> {
                    if (CHILDREN_TABLE.equals(groupChild.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(groupChild.getType())) {
                        List children = groupChild.getChildren();
                        return children.stream().anyMatch(child -> {
                            if (CHILDREN_TABLE.equals(child.getType())) {
                                List grandChildren = child.getChildren();
                                return grandChildren.stream().anyMatch(grandChild -> Objects.equals(grandChild.getName(), fieldName));
                            }
                            return Objects.equals(child.getName(), fieldName);
                        });
                    }
                    return Objects.equals(groupChild.getName(), fieldName);
                });
            }
            if (WidgetType.JXDNTabs.getType().equals(widget.getType()) && (iterator = (tabList = widget.getChildren()).iterator()).hasNext()) {
                Widget tab = (Widget)iterator.next();
                List tabChildren = tab.getChildren();
                return tabChildren.stream().anyMatch(groupChild -> {
                    if (CHILDREN_TABLE.equals(groupChild.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(groupChild.getType())) {
                        List children = groupChild.getChildren();
                        return children.stream().anyMatch(child -> {
                            if (CHILDREN_TABLE.equals(child.getType())) {
                                List grandChildren = child.getChildren();
                                return grandChildren.stream().anyMatch(grandChild -> Objects.equals(grandChild.getName(), fieldName));
                            }
                            return Objects.equals(child.getName(), fieldName);
                        });
                    }
                    return Objects.equals(groupChild.getName(), fieldName);
                });
            }
            return Objects.equals(widget.getName(), fieldName);
        }).collect(Collectors.toList());
        Object result = null;
        if (!fieldList.isEmpty()) {
            Widget widget2 = (Widget)fieldList.get(0);
            if (CHILDREN_TABLE.equals(widget2.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget2.getType())) {
                List childWidgets = widget2.getChildren();
                List childFieldList = childWidgets.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                if (!childFieldList.isEmpty()) {
                    result = ((Widget)childFieldList.get(0)).getProps().get((Object)propertyName);
                } else {
                    for (Widget childWidget : childWidgets) {
                        List grandChildWidgets;
                        List grandChildFieldList;
                        if (!CHILDREN_TABLE.equals(childWidget.getType()) || (grandChildFieldList = (grandChildWidgets = childWidget.getChildren()).stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList())).isEmpty()) continue;
                        result = ((Widget)grandChildFieldList.get(0)).getProps().get((Object)propertyName);
                        break;
                    }
                }
            } else if (JXDN_GROUPS.equals(widget2.getType())) {
                List groupWidgets = widget2.getChildren();
                List childFieldList = groupWidgets.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                if (!childFieldList.isEmpty()) {
                    result = ((Widget)childFieldList.get(0)).getProps().get((Object)propertyName);
                } else {
                    block3: for (Widget groupWidget : groupWidgets) {
                        if (!CHILDREN_TABLE.equals(groupWidget.getType()) && !WidgetType.JXDNChildrenTableAgg.getType().equals(groupWidget.getType())) continue;
                        List groupChildWidgets = groupWidget.getChildren();
                        List groupChildFieldList = groupChildWidgets.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                        if (!groupChildFieldList.isEmpty()) {
                            result = ((Widget)groupChildFieldList.get(0)).getProps().get((Object)propertyName);
                            break;
                        }
                        for (Widget childWidget : groupChildWidgets) {
                            List grandChildWidgets;
                            List grandChildFieldList;
                            if (!CHILDREN_TABLE.equals(childWidget.getType()) || (grandChildFieldList = (grandChildWidgets = childWidget.getChildren()).stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList())).isEmpty()) continue;
                            result = ((Widget)grandChildFieldList.get(0)).getProps().get((Object)propertyName);
                            continue block3;
                        }
                    }
                }
            } else if (WidgetType.JXDNTabs.getType().equals(widget2.getType())) {
                List tabList = widget2.getChildren();
                block5: for (Widget tab : tabList) {
                    List tabChildren = tab.getChildren();
                    List childFieldList = tabChildren.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                    if (!childFieldList.isEmpty()) {
                        result = ((Widget)childFieldList.get(0)).getProps().get((Object)propertyName);
                        continue;
                    }
                    block6: for (Widget groupWidget : tabChildren) {
                        if (!CHILDREN_TABLE.equals(groupWidget.getType()) && !WidgetType.JXDNChildrenTableAgg.getType().equals(groupWidget.getType())) continue;
                        List groupChildWidgets = groupWidget.getChildren();
                        List groupChildFieldList = groupChildWidgets.stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList());
                        if (!groupChildFieldList.isEmpty()) {
                            result = ((Widget)groupChildFieldList.get(0)).getProps().get((Object)propertyName);
                            continue block5;
                        }
                        for (Widget childWidget : groupChildWidgets) {
                            List grandChildWidgets;
                            List grandChildFieldList;
                            if (!CHILDREN_TABLE.equals(childWidget.getType()) || (grandChildFieldList = (grandChildWidgets = childWidget.getChildren()).stream().filter(item -> Objects.equals(item.getName(), fieldName)).collect(Collectors.toList())).isEmpty()) continue;
                            result = ((Widget)grandChildFieldList.get(0)).getProps().get((Object)propertyName);
                            continue block6;
                        }
                    }
                }
            } else {
                result = widget2.getProps().get((Object)propertyName);
            }
        }
        return result;
    }

    private List<Object> formatMaxShow(String formId, JSONArray filsLabel, String fieldName) {
        if (!filsLabel.isEmpty()) {
            int max = (Integer)this.getFieldProperty(formId, fieldName, "max");
            List labelList = filsLabel.subList(0, Math.min(max, filsLabel.size()));
            ArrayList<Object> newLabelList = new ArrayList<Object>();
            for (Object object : labelList) {
                JSONObject jsonObject = (JSONObject)object;
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("id", jsonObject.get((Object)"id"));
                map.put("name", jsonObject.get((Object)"name"));
                map.put("size", jsonObject.get((Object)"size"));
                map.put("type", jsonObject.get((Object)"type"));
                if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"securityLevel"))) {
                    map.put("securityLevel", jsonObject.get((Object)"securityLevel"));
                }
                if (HussarUtils.isNotEmpty((Object)jsonObject.get((Object)"securityLevel_label"))) {
                    map.put("securityLevel_label", jsonObject.get((Object)"securityLevel_label"));
                }
                newLabelList.add(map);
            }
            return newLabelList;
        }
        return filsLabel;
    }

    private JSONObject formatAddress(String formId, String address, String code, String fieldName) {
        JSONObject jsonObject = new JSONObject();
        int level = (Integer)this.getFieldProperty(formId, fieldName, "addressLevel");
        String replace = address.replace(" ", "");
        String[] parts = replace.split("/");
        int maxLevel = Math.min(level, parts.length);
        StringBuilder labelAddress = new StringBuilder();
        for (int i = 0; i < maxLevel; ++i) {
            labelAddress.append(parts[i]);
            if (i >= maxLevel - 1) continue;
            labelAddress.append(" / ");
        }
        String labelAddressString = labelAddress.toString();
        String newCode = null;
        switch (maxLevel) {
            case 1: {
                newCode = code.substring(0, 2);
                break;
            }
            case 2: {
                newCode = code.substring(0, 4);
                break;
            }
            case 3: {
                newCode = code.substring(0, 6);
                break;
            }
            default: {
                newCode = code;
            }
        }
        jsonObject.put("label", (Object)labelAddressString);
        jsonObject.put("code", (Object)newCode);
        return jsonObject;
    }

    private void processCustomField(JSONObject condition, JSONObject newData, String formId, boolean filterFlag) {
        String field = condition.getString("field");
        String fieldType = condition.getString("type");
        String refId = String.format("%s_%s", field, "ref_id");
        String refChildId = String.format("%s_%s", field, "ref_child_id");
        String label = String.format("%s_%s", field, "label");
        String code = String.format("%s_%s", field, "code");
        String detailed = String.format("%s_%s", field, "detailed");
        String id = String.format("%s_%s", field, "id");
        switch (fieldType) {
            case "JXDNDate": {
                String dateResult = this.processDateField(condition, formId);
                newData.put(field, (Object)dateResult);
                break;
            }
            case "JXDNRadioGroup": 
            case "JXDNSelect": {
                if ("PROCESS_STATE".equals(field)) {
                    JSONObject value = (JSONObject)condition.get((Object)"value");
                    newData.put(field, value.get((Object)"value"));
                    break;
                }
                if (condition.get((Object)"value") instanceof JSONObject) {
                    JSONObject value = (JSONObject)condition.get((Object)"value");
                    if (!filterFlag) {
                        newData.put(field, value.get((Object)"value"));
                    }
                    newData.put(label, value.get((Object)"label"));
                    break;
                }
                if (!filterFlag) {
                    newData.put(field, condition.get((Object)"value"));
                }
                newData.put(label, condition.get((Object)"value"));
                break;
            }
            case "JXDNCheckBoxGroup": 
            case "JXDNSelectMulti": {
                if (condition.get((Object)"value") instanceof JSONArray) {
                    JSONArray valueArray = (JSONArray)condition.get((Object)"value");
                    StringBuilder valueResult = new StringBuilder();
                    JSONArray labelResult = new JSONArray();
                    for (int i = 0; i < valueArray.size(); ++i) {
                        JSONObject item = valueArray.getJSONObject(i);
                        valueResult.append(item.getString("value"));
                        if (i < valueArray.size() - 1) {
                            valueResult.append(",");
                        }
                        labelResult.add((Object)item.getString("label"));
                    }
                    if (!filterFlag) {
                        newData.put(field, (Object)valueResult.toString());
                    }
                    newData.put(label, (Object)labelResult.toString());
                    break;
                }
                JSONArray jsonArray = new JSONArray();
                jsonArray.add(condition.get((Object)"value"));
                if (!filterFlag) {
                    newData.put(field, condition.get((Object)"value"));
                }
                newData.put(label, (Object)jsonArray.toString());
                break;
            }
            case "JXDNAddress": {
                JSONObject conditionValue = (JSONObject)condition.get((Object)"value");
                String codeValue = conditionValue.getString("code");
                String codeDetailed = conditionValue.getString("detailed");
                String codeLabel = conditionValue.getString("label");
                if (!filterFlag) {
                    newData.put(code, (Object)codeValue);
                    newData.put(label, (Object)codeLabel);
                    newData.put(detailed, (Object)codeDetailed);
                    break;
                }
                newData.put(code, (Object)codeValue);
                break;
            }
            case "JXDNFile": 
            case "JXDNImage": {
                JSONObject imageConditionValue = (JSONObject)condition.get((Object)"value");
                JSONArray labelJSONArray = imageConditionValue.getJSONArray("label");
                String imageValue = (String)imageConditionValue.get((Object)"value");
                if (!filterFlag) {
                    newData.put(label, (Object)labelJSONArray);
                }
                newData.put(field, (Object)imageValue);
                break;
            }
            case "JXDNUser": 
            case "JXDNUserMulti": 
            case "JXDNOrg": 
            case "JXDNOrgMulti": {
                if (field.endsWith("_user")) {
                    String userName = field.replace("_user", "Name");
                    JSONArray customUserArray = (JSONArray)condition.get((Object)"value");
                    if (HussarUtils.isNotEmpty((Object)customUserArray)) {
                        JSONObject customUser = (JSONObject)customUserArray.get(0);
                        if (!filterFlag) {
                            newData.put(userName, (Object)customUser.getString("label"));
                        }
                        newData.put(field, (Object)customUser.getString("id"));
                        break;
                    }
                    if (!filterFlag) {
                        newData.put(userName, (Object)"");
                    }
                    newData.put(field, (Object)"");
                    break;
                }
                JSONArray resultArray = (JSONArray)condition.get((Object)"value");
                StringBuilder resultId = new StringBuilder();
                StringBuilder resultLabel = new StringBuilder();
                for (int i = 0; i < resultArray.size(); ++i) {
                    JSONObject item = resultArray.getJSONObject(i);
                    resultId.append(item.get((Object)"id"));
                    resultLabel.append(item.getString("label"));
                    if (i >= resultArray.size() - 1) continue;
                    resultId.append(",");
                    resultLabel.append(",");
                }
                if (!filterFlag) {
                    newData.put(label, (Object)resultLabel.toString());
                    newData.put(field, (Object)resultArray);
                }
                newData.put(id, (Object)resultId.toString());
                break;
            }
            case "JXDNLinkForm": {
                JSONObject linkFormCondition = (JSONObject)condition.get((Object)"value");
                if (!filterFlag) {
                    newData.put(refId, (Object)linkFormCondition.getString("id"));
                    newData.put(refChildId, (Object)linkFormCondition.getString("childId"));
                }
                newData.put(field, (Object)linkFormCondition.getString("value"));
                break;
            }
            case "JXDNLinkFormMulti": {
                JSONArray linkFormMultiCondition = (JSONArray)condition.get((Object)"value");
                String value = "";
                String refIdVal = "";
                String refChildIdVal = "";
                for (int i = 0; i < linkFormMultiCondition.size(); ++i) {
                    JSONObject item = linkFormMultiCondition.getJSONObject(i);
                    value = value + item.getString("value");
                    refIdVal = refIdVal + item.getString("id");
                    refChildIdVal = refChildIdVal + item.getString("childId");
                    if (i >= linkFormMultiCondition.size() - 1) continue;
                    value = value + ",";
                    refIdVal = refIdVal + ",";
                    refChildIdVal = refChildIdVal + ",";
                }
                if (!filterFlag) {
                    newData.put(refId, (Object)refIdVal);
                    newData.put(refChildId, (Object)refChildIdVal);
                }
                newData.put(field, (Object)value);
                break;
            }
            case "JXDNSecurityLevel": {
                String valueString = JSONObject.toJSONString((Object)condition.get((Object)"value"));
                Integer securityValue = Integer.valueOf(valueString);
                if (!filterFlag) {
                    Optional<DicLevelTreeVo> any;
                    String fieldLabel = field + "_label";
                    List dicListByType = this.sysDicRefService.getLevelDictByType(SECURITY_LEVEL_TYPE_ID);
                    if (HussarUtils.isNotEmpty((Object)dicListByType) && (any = dicListByType.stream().filter(d -> HussarUtils.equals((Object)d.getValue(), (Object)String.valueOf(securityValue))).findAny()).isPresent()) {
                        valueString = any.get().getLabel();
                    }
                    newData.put(fieldLabel, (Object)valueString);
                }
                newData.put(field, (Object)securityValue);
                break;
            }
            default: {
                newData.put(field, condition.get((Object)"value"));
            }
        }
    }

    private String processDateField(JSONObject condition, String formId) {
        String formatter = (String)this.getFieldProperty(formId, condition.getString("field"), "format");
        String customTimeStr = condition.getString("value");
        String result = null;
        if (HussarUtils.isNotEmpty((Object)formatter)) {
            switch (formatter) {
                case "yyyy": {
                    result = customTimeStr + "-01-01 00:00:00";
                    break;
                }
                case "yyyy-MM": {
                    result = customTimeStr + "-01 00:00:00";
                    break;
                }
                case "yyyy-MM-dd": {
                    result = customTimeStr + " 00:00:00";
                    break;
                }
                case "yyyy-MM-dd HH:mm": {
                    result = customTimeStr + ":00";
                    break;
                }
                default: {
                    result = customTimeStr;
                }
            }
        }
        return result;
    }
}

