/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.NoCodeRuleExecType;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleExec;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.TimingTriggerUtil;
import com.jxdinfo.hussar.formdesign.application.rule.dto.SysRuleInfoWithDetailsDto;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleExecAction;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleInfo;
import com.jxdinfo.hussar.formdesign.application.rule.model.SysRuleTriggerAction;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.workflow.manage.bpm.listener.visitor.HussarWorkflowBusinessRuleListener;
import com.jxdinfo.hussar.workflow.manage.util.WorkflowActivitiCmdAsynExecuteUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="HussarWorkflowBusinessRuleListenerImpl")
@HussarTokenDs
public class HussarWorkflowBusinessRuleListenerImpl
implements HussarWorkflowBusinessRuleListener {
    private static final Logger logger = LoggerFactory.getLogger(HussarWorkflowBusinessRuleListenerImpl.class);
    @Resource
    private NoCodeRuleExec noCodeRuleExec;
    @Resource
    private IHussarAppFormService hussarAppFormService;
    private static final String CACHE_NAME = "RULE_CACHE";

    public void notify(Map<String, Object> map) {
        logger.info("\u6d41\u7a0b\u4e1a\u52a1\u89c4\u5219\uff0c\u63a5\u6536\u5230\u7684\u4fe1\u606f\u4e3a\uff1a{}", map);
        final String appId = (String)map.get("appId");
        final String formId = (String)map.get("formId");
        Object ruleInfoObject = map.get("ruleInfoWithDetailsJson");
        List ruleInfoWithDetailsJsonList = (List)JSON.parseObject((String)JsonUtil.toJson((Object)ruleInfoObject), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        if (ruleInfoWithDetailsJsonList.isEmpty()) {
            logger.error("\u6d41\u7a0b\u4e1a\u52a1\u89c4\u5219\uff0c\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        for (Map ruleInfoWithDetailsJson : ruleInfoWithDetailsJsonList) {
            SecurityUser loginUser;
            final SysRuleInfoWithDetailsDto ruleInfoWithDetails = this.formatRuleInfo(appId, formId, ruleInfoWithDetailsJson);
            String traceId = IdUtil.randomUUID();
            List<String> ruleIds = new ArrayList<String>();
            String businessId = (String)map.get("businessId");
            final Map businessData = this.hussarAppFormService.queryAllTableInfo(formId, appId, businessId);
            String cacheKey = String.format("%s:%s:%s", appId, formId, businessId);
            Object cacheObject = HussarCacheUtil.get((String)CACHE_NAME, (Object)cacheKey);
            if (HussarUtils.isNotEmpty((Object)cacheObject)) {
                Object ruleIdsObject;
                Map cacheMap = (Map)JSONObject.parseObject((String)JsonUtil.toJson((Object)cacheObject), Map.class);
                if (HussarUtils.isNotEmpty(cacheMap.get("traceId"))) {
                    traceId = (String)cacheMap.get("traceId");
                }
                if (HussarUtils.isNotEmpty(ruleIdsObject = cacheMap.get("ruleIds"))) {
                    ruleIds = JSON.parseArray((String)JsonUtil.toJson(ruleIdsObject), String.class);
                }
            }
            SecurityUser securityUser = loginUser = BaseSecurityUtil.getUser() == null ? (SecurityUser)TransmittableThreadLocalHolder.get((String)"loginUser") : BaseSecurityUtil.getUser();
            if (HussarUtils.isEmpty((Object)loginUser)) {
                loginUser = TimingTriggerUtil.getRuleSecurityUser();
                TimingTriggerUtil.setRuleSecurityUser();
            }
            final String finalTraceId = traceId;
            final ArrayList<String> finalRuleIds = ruleIds;
            final SecurityUser finalLoginUser = loginUser;
            String exctType = ruleInfoWithDetailsJson.get("type").toString();
            if (NoCodeRuleExecType.ExecTypeCreate.getType().equals(exctType) || NoCodeRuleExecType.ExecTypeCreateOrUpdate.getType().equals(exctType)) {
                WorkflowActivitiCmdAsynExecuteUtil.asyncExecute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HussarWorkflowBusinessRuleListenerImpl.this.noCodeRuleExec.excRule(appId, formId, new JSONObject(businessData), ruleInfoWithDetails, finalLoginUser, finalTraceId, finalRuleIds);
                    }
                });
                continue;
            }
            this.noCodeRuleExec.excRule(appId, formId, new JSONObject(businessData), ruleInfoWithDetails, loginUser, finalTraceId, finalRuleIds);
        }
    }

    private SysRuleInfoWithDetailsDto formatRuleInfo(String appId, String formId, Map<String, Object> ruleInfoWithDetailsJson) {
        SysRuleInfoWithDetailsDto sysRuleInfoWithDetailsDto = new SysRuleInfoWithDetailsDto();
        ArrayList<SysRuleExecAction> sysRuleExecActions = new ArrayList<SysRuleExecAction>();
        SysRuleExecAction sysRuleExecAction = new SysRuleExecAction();
        String ruleId = ruleInfoWithDetailsJson.get("ruleId").toString();
        sysRuleExecAction.setRuleId(Long.valueOf(ruleId));
        sysRuleExecAction.setActionId(Long.valueOf(ruleId));
        Object targetObject = ruleInfoWithDetailsJson.get("target");
        JSONObject target = JSONObject.parseObject((String)JsonUtil.toJson((Object)targetObject));
        String targetFormId = target.getString("formId");
        sysRuleExecAction.setFormId(Long.valueOf(targetFormId));
        sysRuleExecAction.setExecAction(ruleInfoWithDetailsJson.get("type").toString());
        sysRuleExecAction.setActionFilter(JsonUtil.toJson((Object)ruleInfoWithDetailsJson.get("filter")));
        sysRuleExecAction.setExecContent(JsonUtil.toJson((Object)ruleInfoWithDetailsJson.get("values")));
        sysRuleExecAction.setTarget(JsonUtil.toJson((Object)target));
        sysRuleExecAction.setUpsert(JsonUtil.toJson((Object)ruleInfoWithDetailsJson.get("upsert")));
        sysRuleExecActions.add(sysRuleExecAction);
        SysRuleTriggerAction sysRuleTriggerAction = new SysRuleTriggerAction();
        sysRuleTriggerAction.setRuleId(Long.valueOf(ruleId));
        sysRuleTriggerAction.setTriggerId(Long.valueOf(ruleId));
        sysRuleTriggerAction.setFormId(Long.valueOf(formId));
        sysRuleTriggerAction.setTriggerAction(JsonUtil.toJson((Object)ruleInfoWithDetailsJson.get("triggerAction")));
        SysRuleInfo sysRuleInfo = new SysRuleInfo();
        sysRuleInfo.setRuleId(Long.valueOf(ruleId));
        sysRuleInfo.setAppId(Long.valueOf(appId));
        sysRuleInfo.setRuleName(ruleInfoWithDetailsJson.get("ruleName").toString());
        Object isEnable = ruleInfoWithDetailsJson.get("isEnable");
        if (isEnable instanceof Boolean) {
            sysRuleInfo.setEnable((Boolean)isEnable != false ? 1 : 0);
            sysRuleInfoWithDetailsDto.setEnable((Boolean)isEnable != false ? 1 : 0);
        } else {
            sysRuleInfo.setEnable(Integer.parseInt(String.valueOf(isEnable)));
            sysRuleInfoWithDetailsDto.setEnable(Integer.parseInt(String.valueOf(isEnable)));
        }
        sysRuleInfoWithDetailsDto.setSysRuleExcActions(sysRuleExecActions);
        sysRuleInfoWithDetailsDto.setSysRuleTriggerAction(sysRuleTriggerAction);
        sysRuleInfoWithDetailsDto.setSysRuleInfo(sysRuleInfo);
        sysRuleInfoWithDetailsDto.setRuleId(Long.valueOf(ruleId));
        sysRuleInfoWithDetailsDto.setRuleName(ruleInfoWithDetailsJson.get("ruleName").toString());
        return sysRuleInfoWithDetailsDto;
    }
}

