/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.CodeStatus;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysHandSign;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHandwrittenSignatureService;
import com.jxdinfo.hussar.formdesign.app.frame.server.dao.HandwrittenSignatureMapper;
import com.jxdinfo.hussar.formdesign.application.properties.HussarNocodePublicProperties;
import com.jxdinfo.hussar.formdesign.application.properties.SignatureProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class HandwrittenSignatureServiceImpl
extends HussarServiceImpl<HandwrittenSignatureMapper, SysHandSign>
implements IHandwrittenSignatureService {
    @Autowired
    private HandwrittenSignatureMapper handwrittenSignatureMapper;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private HussarNocodePublicProperties hussarNocodePublicProperties;
    @Resource
    private SignatureProperties signatureProperties;

    public ResponseEntity<ApiResponse<String>> requestSignature(String appId, String formId) {
        Random random = new Random();
        int randomNum = random.nextInt(900000) + 100000;
        String separator = "/";
        String randomCode = String.valueOf(randomNum);
        String key = "sign:" + randomCode;
        this.redisTemplate.opsForValue().set((Object)key, (Object)CodeStatus.NOTSCANNED.getType(), 30L, TimeUnit.MINUTES);
        String url = this.hussarNocodePublicProperties.getFrontIp() + this.signatureProperties.getSignaturePagePath() + separator + appId + separator + formId + separator + randomCode;
        return ResponseEntity.ok((Object)ApiResponse.success((Object)url, (String)"\u4e8c\u7ef4\u7801\u751f\u6210\u8def\u5f84\u83b7\u53d6\u6210\u529f"));
    }

    public ResponseEntity<ApiResponse<Boolean>> scanSignature(String randomCode) {
        String key = "sign:" + randomCode;
        String status = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (CodeStatus.NOTSCANNED.getType().equals(status)) {
            long expire = this.redisTemplate.getExpire((Object)key);
            this.redisTemplate.opsForValue().set((Object)key, (Object)CodeStatus.SCANNED.getType(), expire, TimeUnit.SECONDS);
            return ResponseEntity.ok((Object)ApiResponse.success((Object)true, (String)"\u7533\u8bf7\u901a\u8fc7\uff01"));
        }
        return ResponseEntity.ok((Object)ApiResponse.success((Object)false, (String)"\u4e8c\u7ef4\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
    }

    public ResponseEntity<ApiResponse<Boolean>> saveSignatureToRedis(JSONObject param) {
        String key = "sign:" + param.getString("randomCode");
        String status = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (CodeStatus.SCANNED.getType().equals(status)) {
            long expire = this.redisTemplate.getExpire((Object)key);
            this.redisTemplate.opsForValue().set((Object)key, (Object)CodeStatus.FILLED.getType(), expire, TimeUnit.SECONDS);
            String signature = "sign:content:" + param.getString("randomCode");
            String signatureData = param.getString("signature");
            this.redisTemplate.opsForValue().set((Object)signature, (Object)signatureData, 30L, TimeUnit.MINUTES);
            return ResponseEntity.ok((Object)ApiResponse.success((Object)true, (String)"\u7b7e\u540d\u4fdd\u5b58\u6210\u529f\uff01"));
        }
        return ResponseEntity.ok((Object)ApiResponse.success((Object)false, (String)"\u4e8c\u7ef4\u7801\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01"));
    }

    public ResponseEntity<ApiResponse<String>> getSignatureFromRedis(String randomCode) {
        String key = "sign:" + randomCode;
        String status = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (CodeStatus.FILLED.getType().equals(status)) {
            String signature = "sign:content:" + randomCode;
            String signatureData = (String)this.redisTemplate.opsForValue().get((Object)signature);
            return ResponseEntity.ok((Object)ApiResponse.success((Object)signatureData, (String)"\u7b7e\u540d\u83b7\u53d6\u6210\u529f\uff01"));
        }
        return ResponseEntity.ok((Object)ApiResponse.success((Object)"", (String)"\u672a\u67e5\u8be2\u5230\u7b7e\u540d"));
    }

    public ResponseEntity<ApiResponse<Boolean>> delSignatureFromRedis(String randomCode) {
        String key = "sign:" + randomCode;
        String signature = "sign:content:" + randomCode;
        this.redisTemplate.delete((Object)key);
        this.redisTemplate.delete((Object)signature);
        return ResponseEntity.ok((Object)ApiResponse.success((Object)true, (String)"\u7b7e\u540d\u5220\u9664\u6210\u529f\uff01"));
    }
}

