/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.formdesign.app.frame.api.service.FormFileService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.properties.OssProperties;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.enums.OssExceptionEnum;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class FormFileServiceImpl
implements FormFileService {
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private OssProperties ossProperties;
    private static Logger logger = LogManager.getLogger(FormFileServiceImpl.class);

    public void fileDownload(HttpServletResponse response, Long fileId) {
        if (!HussarUtils.isEmpty((Object)response) && !HussarUtils.isEmpty((Object)fileId)) {
            AttachmentManagerModel attachmentModel = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)fileId);
            if (!HussarUtils.isEmpty((Object)attachmentModel)) {
                String fileName = attachmentModel.getAttachmentName();
                String suffix = this.getSuffix(fileName);
                String path = attachmentModel.getAttachmentDir() + fileId + suffix;
                File file = new File(path);
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file), 10240);
                     BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());){
                    int len;
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                    response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                    response.setContentType("multipart/form-data");
                    response.setContentLengthLong(file.length());
                    byte[] buff = new byte[this.ossProperties.getDownloadBuffSize()];
                    while ((len = ((InputStream)bis).read(buff)) > 0) {
                        out.write(buff, 0, len);
                        out.flush();
                    }
                }
                catch (FileNotFoundException var45) {
                    logger.error("inputParams:{} and errorMessage:{}", (Object)fileName.toString(), (Object)var45.getMessage(), (Object)var45);
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_NOT_FOUND.getExceptionCode(), OssExceptionEnum.FILE_NOT_FOUND.getMessage());
                }
                catch (UnsupportedEncodingException var46) {
                    logger.error("inputParams:{} and errorMessage:{}", (Object)"\u7f16\u7801\u5f02\u5e38\uff1a", (Object)var46.getMessage(), (Object)var46);
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
                }
                catch (IOException var47) {
                    logger.error("inputParams:{} and errorMessage:{}", (Object)"IO\u5f02\u5e38\uff1a", (Object)var47.getMessage(), (Object)var47);
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
                }
            }
        } else {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
    }

    public void showImage(HttpServletResponse response, Long id) {
        if (!HussarUtils.isEmpty((Object)response) && !HussarUtils.isEmpty((Object)id)) {
            response.setContentType("text/html; charset=UTF-8");
            response.setContentType("application/octet-stream");
            AttachmentManagerModel image = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)id);
            if (!HussarUtils.isEmpty((Object)image)) {
                String fileName = image.getAttachmentName();
                String fileSavePath = image.getAttachmentDir();
                String suffix = this.getSuffix(fileName);
                String absolutePath = fileSavePath + id + suffix;
                File file = new File(absolutePath);
                try (FileInputStream fis = new FileInputStream(absolutePath);
                     ServletOutputStream os = response.getOutputStream();){
                    int len;
                    response.setContentLengthLong(file.length());
                    byte[] byt = new byte[this.ossProperties.getDownloadBuffSize()];
                    while ((len = fis.read(byt)) > 0) {
                        os.write(byt, 0, len);
                        os.flush();
                    }
                }
                catch (IOException var42) {
                    logger.error("errorMessage:{}", (Object)var42.getMessage(), (Object)var42);
                    response.setContentType("application/json");
                    throw new HussarException(OssExceptionEnum.FILE_SERVER_ERROR.getExceptionCode(), OssExceptionEnum.FILE_SERVER_ERROR.getMessage());
                }
            }
        } else {
            throw new HussarException(OssExceptionEnum.FILE_ID_NOT_EMPTY.getExceptionCode(), OssExceptionEnum.FILE_ID_NOT_EMPTY.getMessage());
        }
    }

    private String getSuffix(String fileName) {
        String suffix = "";
        int index = fileName.lastIndexOf(".");
        if (index > -1) {
            suffix = fileName.substring(index);
        }
        return suffix;
    }
}

