/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.config;

import com.jxdinfo.hussar.support.thread.config.HussarTpProperties;
import com.jxdinfo.hussar.support.thread.core.RejectedExecutionHandlerEnum;
import com.jxdinfo.hussar.support.thread.support.executor.HussarTaskExecutor;
import java.util.concurrent.RejectedExecutionHandler;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
public class HussarNoCodeThreadConfiguration {
    @Resource(name="hussarTaskExecutor")
    private HussarTaskExecutor hussarTaskExecutor;
    @Resource
    private HussarTpProperties hussarTpProperties;

    @Bean(value={"hussarUserTaskExecutor"})
    public ThreadPoolTaskExecutor hussarUserTaskExecutor() {
        return this.getThreadPoolTaskExecutor("user-task-async-");
    }

    @Bean(value={"hussarDataTaskExecutor"})
    public ThreadPoolTaskExecutor hussarDataTaskExecutor() {
        return this.getThreadPoolTaskExecutor("data-task-async-");
    }

    @NotNull
    private ThreadPoolTaskExecutor getThreadPoolTaskExecutor(String threadNamePrefix) {
        RejectedExecutionHandlerEnum handler = this.hussarTpProperties.getRejectedExecutionHandler();
        RejectedExecutionHandler rejectedExecutionHandler = null;
        rejectedExecutionHandler = handler == null ? RejectedExecutionHandlerEnum.instantiationHandler((String)null) : RejectedExecutionHandlerEnum.instantiationHandler((String)handler.getKey());
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.hussarTaskExecutor.createThreadPoolTaskExecutor(this.hussarTpProperties.getCorePoolSize(), this.hussarTpProperties.getMaxPoolSize(), this.hussarTpProperties.getQueueCapacity(), rejectedExecutionHandler);
        threadPoolTaskExecutor.setThreadNamePrefix(threadNamePrefix);
        return threadPoolTaskExecutor;
    }
}

