/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoCodeHttpUtil {
    private static OkHttpClient client;
    private static final Logger logger;
    private static final TrustManager[] trustAllCerts;

    private static OkHttpClient client() {
        if (client != null) {
            return client;
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            client = new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            }).connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).build();
            return client;
        }
        catch (Exception e) {
            throw new HussarException("\u521d\u59cb\u5316 HttpClient \u5931\u8d25");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> params) {
        HttpUrl httpUrl;
        try {
            httpUrl = HttpUrl.parse((String)url);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5730\u5740\u65e0\u6548\uff1a{}", (Object)url);
            throw new HussarException("Http \u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42\u5730\u5740\u65e0\u6548\u3002");
        }
        if (httpUrl == null) return null;
        HttpUrl.Builder urlBuilder = httpUrl.newBuilder();
        if (HussarUtils.isNotEmpty(params)) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                urlBuilder.addQueryParameter(param.getKey(), param.getValue());
            }
        }
        String urlWithParams = urlBuilder.build().toString();
        Request request = new Request.Builder().url(urlWithParams).build();
        try (Response response = NoCodeHttpUtil.client().newCall(request).execute();){
            if (response.isSuccessful()) {
                String string = Objects.requireNonNull(response.body()).string();
                return string;
            }
            logger.error("\u8bf7\u6c42\u54cd\u5e94\u5931\u8d25\uff1a{}", (Object)response);
            return null;
        }
        catch (IOException e) {
            throw new HussarException("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public static String sendPost(String url, Map<String, Object> bodyData) {
        String bodyJsonStr = JSON.toJSONString(bodyData);
        RequestBody requestBody = RequestBody.create((String)bodyJsonStr, (MediaType)MediaType.parse((String)"application/json;charset=UTF-8"));
        Request ssoRequest = new Request.Builder().url(url).addHeader("Content-Type", "application/json;charset=UTF-8").post(requestBody).build();
        logger.info("\u8bf7\u6c42\u5165\u53c2\uff1aurl\uff1a{} header\uff1a{} body\uff1a{}", new Object[]{ssoRequest.url(), ssoRequest.headers(), JSON.toJSONString(bodyData)});
        try {
            Response response = NoCodeHttpUtil.client().newCall(ssoRequest).execute();
            if (!response.isSuccessful()) {
                throw new HussarException("\u8bf7\u6c42\u5f02\u5e38" + response.message());
            }
            logger.info("\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)response.body()));
            return Objects.requireNonNull(response.body()).string();
        }
        catch (Exception e) {
            throw new HussarException("\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
    }

    static {
        logger = LoggerFactory.getLogger(NoCodeHttpUtil.class);
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

