/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.jxdinfo.hussar.formdesign.app.frame.server.util.SystemLoadFont;
import com.jxdinfo.hussar.mail.core.util.ReflectUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWaterRemarkUtils {
    private static final int WIDTH = 270;
    private static final int HEIGHT = 70;
    private static Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 15);
    private static String msyhFontPath = "fonts/MSYH.TTC";
    private static Font fontEncode = SystemLoadFont.styleFont(msyhFontPath, 0, 15.0f);
    private static Color color = new Color(0, 0, 0, 90);

    public static BufferedImage createWaterMarkImage(String text) {
        BufferedImage image = new BufferedImage(270, 70, 2);
        Graphics2D g = image.createGraphics();
        image = g.getDeviceConfiguration().createCompatibleImage(270, 70, 3);
        g.dispose();
        g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.rotate(Math.toRadians(-25.0), (double)image.getWidth() / 2.0, (double)image.getHeight() / 2.0);
        g.setColor(color);
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(fontEncode);
        g.setComposite(AlphaComposite.getInstance(3));
        FontMetrics fontMetrics = g.getFontMetrics(fontEncode);
        String[] textArray = text.split("\n");
        int x = image.getWidth() / 2;
        int y = image.getHeight() / 2;
        int x_begin = x;
        boolean fistLine = true;
        for (String s : textArray) {
            int textWidth = fontMetrics.stringWidth(s);
            if (fistLine) {
                x_begin = x - textWidth / 2;
                fistLine = false;
            }
            g.drawString(s, x_begin, y);
            y = y + font.getSize() + 5;
        }
        g.dispose();
        return image;
    }

    public static void putWaterMarkToExcel(Workbook wb, Sheet sheet, BufferedImage image, int startXCol, int startYRow, int betweenXCol, int betweenYRow, int XCount, int YCount, int waterMarkWidth, int waterMarkHeight) throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        if (null == image) {
            throw new RuntimeException("\u5411Excel\u4e0a\u9762\u6253\u5370\u6c34\u5370\uff0c\u8bfb\u53d6\u6c34\u5370\u56fe\u7247\u5931\u8d25\uff01");
        }
        ImageIO.write((RenderedImage)image, "png", byteArrayOut);
        Drawing drawing = sheet.createDrawingPatriarch();
        for (int yCount = 0; yCount < YCount; ++yCount) {
            for (int xCount = 0; xCount < XCount; ++xCount) {
                int xIndexInteger = startXCol + xCount * waterMarkWidth + xCount * betweenXCol;
                int yIndexInteger = startYRow + yCount * waterMarkHeight + yCount * betweenYRow;
                ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, xIndexInteger, yIndexInteger, xIndexInteger + waterMarkWidth, yIndexInteger + waterMarkHeight);
                Picture pic = drawing.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), 6));
                pic.resize();
            }
        }
    }

    public static void putWaterRemarkToExcel(Workbook wb, Sheet sheet, BufferedImage image, int startXCol, int startYRow, int betweenXCol, int betweenYRow, int XCount, int YCount, int waterRemarkWidth, int waterRemarkHeight) throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        if (null == image) {
            throw new RuntimeException("\u5411Excel\u4e0a\u9762\u6253\u5370\u6c34\u5370\uff0c\u8bfb\u53d6\u6c34\u5370\u56fe\u7247\u5931\u8d25(2)\u3002");
        }
        ImageIO.write((RenderedImage)image, "png", byteArrayOut);
        Drawing drawing = sheet.createDrawingPatriarch();
        for (int yCount = 0; yCount < YCount; ++yCount) {
            for (int xCount = 0; xCount < XCount; ++xCount) {
                int xIndexInteger = startXCol + xCount * waterRemarkWidth + xCount * betweenXCol;
                int yIndexInteger = startYRow + yCount * waterRemarkHeight + yCount * betweenYRow;
                ClientAnchor anchor = drawing.createAnchor(0, 0, 0, 0, xIndexInteger, yIndexInteger, xIndexInteger + waterRemarkWidth, yIndexInteger + waterRemarkHeight);
                Picture pic = drawing.createPicture(anchor, wb.addPicture(byteArrayOut.toByteArray(), 6));
                pic.resize();
            }
        }
    }

    public static void addWatermarkExcel(SXSSFWorkbook workbook, BufferedImage image) throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        if (null == image) {
            throw new RuntimeException("\u5411Excel\u4e0a\u9762\u6253\u5370\u6c34\u5370\uff0c\u8bfb\u53d6\u6c34\u5370\u56fe\u7247\u5931\u8d25(2)\u3002");
        }
        ImageIO.write((RenderedImage)image, "png", byteArrayOut);
        int pictureIdx = workbook.addPicture(byteArrayOut.toByteArray(), 6);
        XSSFPictureData pictureData = (XSSFPictureData)workbook.getAllPictures().get(pictureIdx);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            SXSSFSheet sheet = workbook.getSheetAt(i);
            XSSFSheet shReflect = (XSSFSheet)ReflectUtil.getFieldValue((Object)sheet, (String)"_sh");
            PackagePartName ppn = pictureData.getPackagePart().getPartName();
            String relType = XSSFRelation.IMAGES.getRelation();
            PackageRelationship pr = shReflect.getPackagePart().addRelationship(ppn, TargetMode.INTERNAL, relType, null);
            shReflect.getCTWorksheet().addNewPicture().setId(pr.getId());
        }
    }

    public static void addWatermarkExcel(XSSFWorkbook workbook, BufferedImage image) throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        if (null == image) {
            throw new RuntimeException("\u5411Excel\u4e0a\u9762\u6253\u5370\u6c34\u5370\uff0c\u8bfb\u53d6\u6c34\u5370\u56fe\u7247\u5931\u8d25(2)\u3002");
        }
        ImageIO.write((RenderedImage)image, "png", byteArrayOut);
        ByteArrayOutputStream imageOs = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", imageOs);
        int pictureIdx = workbook.addPicture(imageOs.toByteArray(), 6);
        XSSFPictureData pictureData = (XSSFPictureData)workbook.getAllPictures().get(pictureIdx);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            XSSFSheet sheet = workbook.getSheetAt(i);
            PackagePartName ppn = pictureData.getPackagePart().getPartName();
            String relType = XSSFRelation.IMAGES.getRelation();
            PackageRelationship pr = sheet.getPackagePart().addRelationship(ppn, TargetMode.INTERNAL, relType, null);
            sheet.getCTWorksheet().addNewPicture().setId(pr.getId());
        }
    }

    public static BufferedImage drawText(String text, Font font, Color textColor, Color backColor, double height, double width) {
        BufferedImage img = new BufferedImage((int)width, (int)height, 2);
        Graphics2D loGraphic = img.createGraphics();
        FontMetrics loFontMetrics = loGraphic.getFontMetrics(font);
        int liStrWidth = loFontMetrics.stringWidth(text);
        int liStrHeight = loFontMetrics.getHeight();
        loGraphic.setColor(backColor);
        loGraphic.fillRect(0, 0, (int)width, (int)height);
        loGraphic.translate(((int)width - liStrWidth) / 2, ((int)height - liStrHeight) / 2);
        loGraphic.translate(-((int)width - liStrWidth) / 2, -((int)height - liStrHeight) / 2);
        loGraphic.setFont(font);
        loGraphic.setColor(textColor);
        loGraphic.drawString(text, ((int)width - liStrWidth) / 6, ((int)height - liStrHeight) / 6);
        loGraphic.drawString(text, ((int)width - liStrWidth) / 3, ((int)height - liStrHeight) / 3);
        loGraphic.drawString(text, ((int)width - liStrWidth) / 2, ((int)height - liStrHeight) / 2);
        loGraphic.dispose();
        return img;
    }
}

