/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.formdesign.app.frame.api.module.SysExcelTaskNoCode;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppRegionService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelExport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExcelImport;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.ExelTaskUtil;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.application.service.ISysApplicationExternalService;
import com.jxdinfo.hussar.formdesign.application.form.constant.FormCreateTypeEnum;
import com.jxdinfo.hussar.formdesign.application.form.model.SysForm;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewMatchVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportPreviewVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportResultVo;
import com.jxdinfo.hussar.formdesign.application.form.vo.ExcelImportSheetVo;
import com.jxdinfo.hussar.formdesign.application.operatelog.data.tool.annotation.OperateLogTypeCache;
import com.jxdinfo.hussar.formdesign.common.response.FormDesignResponse;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.FormCanvasSchemaDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.model.canvas.WidgetDTO;
import com.jxdinfo.hussar.formdesign.external.nocode.api.service.FormOperateExposedService;
import com.jxdinfo.hussar.formdesign.no.code.constant.WidgetType;
import com.jxdinfo.hussar.formdesign.no.code.cured.CanvasSchemaService;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.region.vo.RegionVo;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUserUtil;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class ExcelImportAsync {
    private static Logger logger = LoggerFactory.getLogger(ExcelImportAsync.class);
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Value(value="${hussar.excel.maxRow:0x7fffffff}")
    private int maxRow;
    @Value(value="${hussar.excel.maxCell:0x7fffffff}")
    private int maxCell;
    private static final String PRIMARY_KEY_TITLE_NAME = "\u6570\u636eid\uff08\u4e0d\u53ef\u66f4\u6539\uff09";
    @Resource
    private CanvasSchemaService canvasSchemaService;
    @Resource
    private IHussarAppFormService appFormService;
    @Resource
    private ExcelExport excelExport;
    @Resource
    private ExcelImport excelImport;
    @Resource
    private FormOperateExposedService formOperateExposedService;
    @Autowired
    private IHussarAppRegionService hussarAppRegionService;
    @Resource
    private ISysApplicationExternalService applicationService;
    @Autowired
    private ExelTaskUtil exelTaskUtil;

    @OperateLogTypeCache(mode=1)
    @HussarDs(value="#dataSourceKey")
    public void excelImportAndSave(ExcelImportPreviewVo excelImportPreviewVo, HttpServletResponse response, Long taskId, UserDetails userDetails, String dataSourceKey) {
        JSONObject sysData = new JSONObject();
        logger.info("=======\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}======\u8fdb\u5165excelImportAndSave\u8fd4\u56de\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSONObject.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
        if (HussarUtils.isEmpty((Object)excelImportPreviewVo) || HussarUtils.isEmpty((Object)excelImportPreviewVo.getFormId())) {
            throw new BaseException("\u53c2\u6570\u4f20\u9012\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        SysForm form = this.applicationService.getFormDetailById(Long.valueOf(Long.parseLong(excelImportPreviewVo.getFormId())));
        AppContextUtil.setAppId((String)Long.toString(form.getAppId()));
        boolean containDataId = false;
        boolean containUser = false;
        boolean containOrg = false;
        boolean containAddress = false;
        List matches = excelImportPreviewVo.getMatches();
        if (HussarUtils.isNotEmpty((Object)matches)) {
            for (ExcelImportPreviewMatchVo excelImportPreviewMatchVo : matches) {
                if ("RECORD_ID".equals(excelImportPreviewMatchVo.getFieldName())) {
                    containDataId = true;
                }
                if (WidgetType.JXDNUser.getType().equals(excelImportPreviewMatchVo.getFieldType()) || WidgetType.JXDNUserMulti.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                    containUser = true;
                }
                if (WidgetType.JXDNOrg.getType().equals(excelImportPreviewMatchVo.getFieldType()) || WidgetType.JXDNOrgMulti.getType().equals(excelImportPreviewMatchVo.getFieldType())) {
                    containOrg = true;
                }
                if (!WidgetType.ADDRESS.getType().equals(excelImportPreviewMatchVo.getFieldType())) continue;
                containAddress = true;
            }
        }
        if (!(excelImportPreviewVo.getImportType() != 2 && excelImportPreviewVo.getImportType() != 3 || containDataId)) {
            throw new BaseException("data_id\u672a\u5339\u914d\u5b57\u6bb5\uff0c\u8bf7\u5148\u5bfc\u51fa\u6570\u636e\u53cadata_id");
        }
        ExcelImportResultVo excelImportResultVo = new ExcelImportResultVo();
        FormDesignResponse formCanvasSchema = this.canvasSchemaService.get(excelImportPreviewVo.getFormId());
        FormCanvasSchema canvas = (FormCanvasSchema)formCanvasSchema.getData();
        if (HussarUtils.isEmpty((Object)canvas)) {
            logger.error("\u83b7\u53d6\u8868\u5355\u5b57\u6bb5 ==> \u83b7\u53d6\u8868\u5355\u753b\u5e03\u5931\u8d25 appId: {} formId: {}", (Object)AppContextUtil.getAppId(), (Object)excelImportPreviewVo.getFormId());
        }
        List<Widget> widgets = new ArrayList<Widget>();
        List widgetsFromCanvas = canvas.widgets();
        List childTables = canvas.childTables();
        widgetsFromCanvas = JSON.parseArray((String)JSON.toJSONString((Object)widgetsFromCanvas, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Widget.class);
        childTables = JSON.parseArray((String)JSON.toJSONString((Object)childTables, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), Widget.class);
        widgets.addAll(widgetsFromCanvas);
        widgets.addAll(childTables);
        widgets.add(this.excelExport.createDataIdWidget(form));
        widgets.addAll(canvas.systemWidgets());
        widgets = this.excelImport.dealWidgets(widgets, null);
        this.excelImport.addChildIdWidgetRecursion(widgets);
        List<Object> allUsers = new ArrayList();
        List<Object> allOrgans = new ArrayList();
        List allRegionVos = new ArrayList();
        Map<Object, Object> parentIdRegionVoMap = new HashMap();
        if (containUser) {
            allUsers = this.excelImport.getAllUser();
        }
        if (containOrg) {
            allOrgans = this.excelImport.getAllOrgan();
        }
        if (containAddress) {
            allRegionVos = this.hussarAppRegionService.getRegionInfo();
            parentIdRegionVoMap = allRegionVos.stream().collect(Collectors.groupingBy(RegionVo::getParentId));
        }
        sysData.put("allUsers", allUsers);
        sysData.put("allOrgans", allOrgans);
        sysData.put("allRegionVos", allRegionVos);
        sysData.put("parentIdRegionVoMap", parentIdRegionVoMap);
        String cacheKey = excelImportPreviewVo.getCacheKey();
        String fileId = cacheKey.substring(0, cacheKey.lastIndexOf("."));
        AttachmentManagerModel model = (AttachmentManagerModel)this.attachmentManagerService.getById((Serializable)((Object)fileId));
        String attachmentDir = model.getAttachmentDir();
        String filePath = attachmentDir + excelImportPreviewVo.getCacheKey();
        FileInputStream fileInputStream = null;
        ExcelImportSheetVo excelImportSheetVo = null;
        try {
            fileInputStream = new FileInputStream(filePath);
            excelImportSheetVo = this.excelImport.analysisExcelAndReturnPreviewData(excelImportPreviewVo.getSheetIndex(), fileInputStream, null, excelImportPreviewVo.getCacheKey());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
            throw new BaseException((Throwable)e);
        }
        finally {
            if (HussarUtils.isNotEmpty(fileInputStream)) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage());
                }
            }
        }
        List rowsFromExcel = excelImportSheetVo.getRows();
        List matchs = excelImportPreviewVo.getMatches();
        if (rowsFromExcel.size() > this.maxRow) {
            excelImportResultVo.setInsertNum(0);
            excelImportResultVo.setFailNum(rowsFromExcel.size());
            logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u884c\u6570\u8d85\u957f");
            throw new BaseException("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u884c\u6570\u8d85\u957f,\u6700\u5927\u503c\u4e3a" + this.maxRow);
        }
        if (matchs.size() > this.maxCell) {
            excelImportResultVo.setInsertNum(0);
            excelImportResultVo.setFailNum(rowsFromExcel.size());
            logger.error("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5217\u6570\u8d85\u957f");
            throw new BaseException("\u5bfc\u5165\u4e1a\u52a1\u6570\u636e-\u5217\u6570\u8d85\u957f,\u6700\u5927\u503c\u4e3a" + this.maxCell);
        }
        excelImportResultVo = this.excelImport.dealExcelData(excelImportPreviewVo, rowsFromExcel, widgets, form, sysData);
        List importList = excelImportResultVo.getDataList();
        logger.info("\u672c\u6b21\u5bfc\u5165\u6570\u636e\u6570\u91cf\uff1a{}\uff0c\u64cd\u4f5c\u4eba\uff1a{}", (Object)importList.size(), (Object)userDetails.getUserName());
        if (importList.size() > 0) {
            if (HussarUtils.isNotEmpty((Object)form) && FormCreateTypeEnum.FORM_TO_FORM.getType().equals(form.getCreateSource())) {
                importList.forEach(importData -> importData.put("FORM_ID", (Object)form.getId()));
            }
            HashMap<String, List> params = new HashMap<String, List>();
            params.put("importList", importList);
            if (excelImportPreviewVo.getTriggerProcess() == 2) {
                logger.info("=====\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}==========getTriggerProcess()==2\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSONObject.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                HashMap<String, Object> flowFormSubmitsParams = new HashMap<String, Object>();
                ArrayList dataList = new ArrayList();
                for (JSONObject jSONObject : importList) {
                    HashMap<String, Object> flowData = new HashMap<String, Object>();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("formData", jSONObject.toJavaObject(Map.class));
                    flowData.put("processDefinitionKey", excelImportPreviewVo.getProcessDefinitionKey());
                    flowData.put("isExternal", false);
                    flowData.put("isEndProcess", false);
                    dataMap.put("flowData", flowData);
                    dataList.add(dataMap);
                }
                flowFormSubmitsParams.put("dataList", dataList);
                this.excelImport.flowFormSubmits(excelImportPreviewVo.getFormId(), flowFormSubmitsParams);
            } else if (excelImportPreviewVo.getTriggerProcess() == 3) {
                logger.info("===========\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}=========getTriggerProcess()==3\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSONObject.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                HashMap<String, Object> flowFormSubmitsParams = new HashMap<String, Object>();
                ArrayList dataList = new ArrayList();
                for (JSONObject jSONObject : importList) {
                    HashMap<String, Object> flowData = new HashMap<String, Object>();
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    dataMap.put("formData", jSONObject.toJavaObject(Map.class));
                    flowData.put("processDefinitionKey", excelImportPreviewVo.getProcessDefinitionKey());
                    flowData.put("isExternal", false);
                    flowData.put("isEndProcess", true);
                    dataMap.put("flowData", flowData);
                    dataList.add(dataMap);
                }
                flowFormSubmitsParams.put("dataList", dataList);
                this.excelImport.flowFormSubmits(excelImportPreviewVo.getFormId(), flowFormSubmitsParams);
            } else if (excelImportPreviewVo.getTriggerProcess() == 4 || excelImportPreviewVo.getTriggerProcess() == 1) {
                boolean targetFormChild;
                if (excelImportPreviewVo.getTriggerProcess() == 4) {
                    logger.info("=========\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}==========getTriggerProcess()==4\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSONObject.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                } else {
                    logger.info("=========\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}==========getTriggerProcess()==1\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSONObject.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
                }
                FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(form.getId().toString(), form.getAppId().toString());
                List canvasWidgets = formCanvasSchemaDTO.getWidgets();
                String json = JsonUtil.toJson((Object)canvasWidgets);
                List widgetDTOS = JsonUtil.parseArray((String)json, WidgetDTO.class);
                boolean bl = targetFormChild = widgetDTOS.stream().anyMatch(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType())) || widgets.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).anyMatch(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()));
                if (targetFormChild) {
                    HashMap<String, List> map = new HashMap<String, List>();
                    map.put(form.getTableName(), importList);
                    HashMap<String, HashMap<String, List>> typeMap = new HashMap<String, HashMap<String, List>>();
                    typeMap.put("saveAndUpdate", map);
                    this.formOperateExposedService.formIncrementSave(excelImportPreviewVo.getFormId(), typeMap, excelImportPreviewVo.getAppId());
                } else {
                    this.formOperateExposedService.tableSave(excelImportPreviewVo.getAppId(), excelImportPreviewVo.getFormId(), params);
                }
            }
        }
        excelImportResultVo.setDataList(null);
        SysExcelTaskNoCode task = new SysExcelTaskNoCode();
        task.setId(taskId);
        task.setTaskStatus(Integer.valueOf(4));
        task.setErrorMsg(excelImportResultVo.getFailMessages() == null ? "" : JSONObject.toJSONString((Object)excelImportResultVo.getFailMessages()));
        task.setDataSuccess(Integer.valueOf(excelImportResultVo.getInsertNum()));
        task.setDataError(Integer.valueOf(excelImportResultVo.getFailNum()));
        logger.info("============\u5f53\u524d\u7ebf\u7a0b\u540d\u79f0\uff1a{}=======excelImportAndSave\u65b9\u6cd5\u7ed3\u675f\uff0c\u5f53\u524d\u7528\u6237\uff1a{}", (Object)Thread.currentThread().getName(), (Object)JSONObject.toJSONString((Object)(EngineUserUtil.getUser().getUserId() + ":" + EngineUserUtil.getUser().getUserName())));
        HussarNoCodeThreadUtil.executeUserTask(() -> {
            RequestContextHolder.resetRequestAttributes();
            this.exelTaskUtil.updateExelTask(task, dataSourceKey);
        });
    }

    public List<Widget> createChildDataIdWidget(SysForm form) {
        ArrayList<Widget> widgetList = new ArrayList<Widget>();
        FormCanvasSchemaDTO formCanvasSchemaDTO = this.formOperateExposedService.getCanvas(form.getId().toString(), form.getAppId().toString());
        List widgets = formCanvasSchemaDTO.getWidgets();
        String json = JsonUtil.toJson((Object)widgets);
        List widgetDTOS = JsonUtil.parseArray((String)json, WidgetDTO.class);
        widgetDTOS.stream().filter(widget -> WidgetType.CHILDREN_TABLE.getType().equals(widget.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(widget.getType())).forEach(widget -> {
            String parentKey = widget.getName();
            Widget dataIdWidget = new Widget();
            dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        widgetDTOS.stream().filter(widget -> WidgetType.GROUP.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> {
            String parentKey = child.getName();
            Widget dataIdWidget = new Widget();
            dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        widgetDTOS.stream().filter(widget -> WidgetType.JXDNTabs.getType().equals(widget.getType())).flatMap(widget -> widget.getChildren().stream()).flatMap(childChildren -> childChildren.getChildren().stream()).filter(child -> WidgetType.CHILDREN_TABLE.getType().equals(child.getType()) || WidgetType.JXDNChildrenTableAgg.getType().equals(child.getType())).forEach(child -> {
            String parentKey = child.getName();
            Widget dataIdWidget = new Widget();
            dataIdWidget.setTitle(PRIMARY_KEY_TITLE_NAME);
            dataIdWidget.setName("RECORD_ID");
            dataIdWidget.setType(WidgetType.INPUT.getType());
            dataIdWidget.setDataType("string");
            dataIdWidget.setParentKey(parentKey);
            dataIdWidget.setIsInChild(true);
            widgetList.add(dataIdWidget);
        });
        return widgetList;
    }
}

