/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.rule.rabbit;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.formdesign.app.frame.server.rule.rules.NoCodeRuleAsync;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues={"nocodeRuleTrigger"}, autoStartup="${hussar.nocode.businessRule.rabbitmqenable:false}")
public class RabbitmqListenerTrigger {
    private static final Logger logger = LoggerFactory.getLogger(RabbitmqListenerTrigger.class);
    @Autowired
    private NoCodeRuleAsync noCodeRuleAsync;

    @RabbitHandler
    public void receive(String message) {
        JSONObject json = JSONObject.parseObject((String)message);
        String formId = json.getString("formId");
        String sourceAppId = json.getString("appId");
        JSONObject businessData = (JSONObject)JSONObject.parseObject((String)json.getString("businessData"), JSONObject.class);
        SecurityUser user = (SecurityUser)JSONObject.parseObject((String)json.getString("user"), SecurityUser.class);
        String triggerType = json.getString("triggerType");
        String traceId = json.getString("traceId");
        logger.info("\u8c03\u7528\u96f6\u4ee3\u7801\u4e1a\u52a1\u89c4\u5219:\u63a5\u6536\u5230rabbitmq\u63a8\u9001\u7684\u6d88\u606f\uff0cformId\uff1a{}\uff0ctriggerType\uff1a{}\uff0cbusinessData\uff1a{}\uff0cuser\uff1a{},\u94fe\u8defid\uff1a{}", new Object[]{formId, triggerType, businessData, JSONObject.toJSONString((Object)user), traceId});
        this.noCodeRuleAsync.localAsync(sourceAppId, formId, businessData, user, triggerType, traceId, new ArrayList<String>());
    }
}

