/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.server.impl;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.AttachListDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.dto.BatchDownloadDto;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.BatchDownLoadStatus;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.FormAttachmentService;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.DownLoadCompent;
import com.jxdinfo.hussar.formdesign.app.frame.server.util.HussarNoCodeThreadUtil;
import com.jxdinfo.hussar.formdesign.application.data.model.SysBatchDownloadTask;
import com.jxdinfo.hussar.formdesign.application.data.service.BatchDownLodService;
import com.jxdinfo.hussar.formdesign.back.common.relation.util.DataModelUtil;
import com.jxdinfo.hussar.formdesign.common.pool.thread.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.formdesign.app.frame.server.impl.formAttachmentServiceImpl")
public class FormAttachmentServiceImpl
implements FormAttachmentService {
    @Resource
    private BatchDownLodService batchDownLodService;
    @Autowired
    private DownLoadCompent downLoadCompent;

    public ApiResponse<SysBatchDownloadTask> downloadAttachmentsInList(AttachListDownloadDto attachListDownloadDto, HttpServletResponse response) throws IOException {
        SysBatchDownloadTask task = new SysBatchDownloadTask();
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        task.setTaskId(taskId);
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.DERIVING.getStatus()));
        this.batchDownLodService.save((Object)task);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.downLoadCompent.handleAttachmentsInList(attachListDownloadDto, response, task, dataSourceKey));
        return ApiResponse.success((Object)task);
    }

    public ApiResponse<SysBatchDownloadTask> batchDownload(BatchDownloadDto batchDownloadDto, HttpServletResponse response) throws Exception {
        SysBatchDownloadTask task = new SysBatchDownloadTask();
        Long taskId = System.currentTimeMillis() + (long)new Random().nextInt();
        task.setTaskId(taskId);
        task.setTaskStatus(Integer.valueOf(BatchDownLoadStatus.DERIVING.getStatus()));
        this.batchDownLodService.save((Object)task);
        TransmittableThreadLocalHolder.set((String)"loginUser", (Object)BaseSecurityUtil.getUser());
        String dataSourceKey = DataModelUtil.currentDsName();
        HussarNoCodeThreadUtil.executeUserTask(() -> this.downLoadCompent.handleBatchDownload(batchDownloadDto, response, task, dataSourceKey));
        return ApiResponse.success((Object)task);
    }

    private void compressFolder(String zipFolderPath, HttpServletResponse response) {
        Path sourcePath = Paths.get(zipFolderPath, new String[0]);
        response.setContentType("application/zip");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + sourcePath.getFileName().toString() + ".zip\"");
        try (ServletOutputStream os = response.getOutputStream();
             ZipOutputStream zipOut = new ZipOutputStream((OutputStream)os);){
            Files.walk(sourcePath, new FileVisitOption[0]).forEach(filePath -> {
                if (!Files.isDirectory(filePath, new LinkOption[0])) {
                    try {
                        ZipEntry zipEntry = new ZipEntry(sourcePath.relativize((Path)filePath).toString());
                        zipOut.putNextEntry(zipEntry);
                        Files.copy(filePath, zipOut);
                        zipOut.closeEntry();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean hasFiles(String folderPath) {
        Object[] files;
        File folder = new File(folderPath);
        if (folder.exists() && folder.isDirectory() && HussarUtils.isNotEmpty((Object[])(files = folder.listFiles()))) {
            for (Object file : files) {
                if (((File)file).isFile() && ((File)file).length() > 0L) {
                    return true;
                }
                if (!((File)file).isDirectory() || !this.hasFiles(((File)file).getAbsolutePath())) continue;
                return true;
            }
        }
        return false;
    }
}

