/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.app.frame.api.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.DateEnum;
import com.jxdinfo.hussar.formdesign.app.frame.api.enums.FilterConditionEnum;
import com.jxdinfo.hussar.formdesign.app.frame.api.service.IHussarAppFormService;
import com.jxdinfo.hussar.formdesign.app.frame.api.util.TimeRangeCalculator;
import com.jxdinfo.hussar.formdesign.common.util.SpringUtil;
import com.jxdinfo.hussar.formdesign.no.code.business.service.CanvasService;
import com.jxdinfo.hussar.formdesign.no.code.factory.PageBuilderFactory;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.FormCanvasSchema;
import com.jxdinfo.hussar.formdesign.no.code.model.canvas.Widget;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerVerify {
    @Resource
    private static CanvasService canvasService = (CanvasService)SpringUtil.getBean(CanvasService.class);
    @Resource
    private static IHussarAppFormService appFormService = (IHussarAppFormService)SpringUtil.getBean(IHussarAppFormService.class);
    private static final Logger logger = LoggerFactory.getLogger(TriggerVerify.class);

    public static Boolean conditionVerify(JSONObject businessData, String triggers, String formId, String triggerType) throws Exception {
        JSONObject actionContent = JSONObject.parseObject((String)triggers);
        logger.info("\u5f00\u59cb\u89e3\u6790\u89e6\u53d1\u52a8\u4f5c{}", (Object)actionContent.toString());
        List conditions = JSONArray.parseArray((String)actionContent.getString("cond"), JSONObject.class);
        boolean trigger = true;
        FormCanvasSchema formCanvasSchema = (FormCanvasSchema)canvasService.get(formId).getData();
        ArrayList formWidgets = new ArrayList();
        List widgetListE = formCanvasSchema.widgetsWithSys();
        if (HussarUtils.equals((Object)formCanvasSchema.getFormType(), (Object)"1")) {
            List processState = PageBuilderFactory.getProcessInfoWidgets();
            widgetListE.addAll(processState);
        }
        formWidgets.addAll(widgetListE);
        if (HussarUtils.isNotEmpty((Object)formCanvasSchema.childTables())) {
            ArrayList childWidgetsAll = new ArrayList();
            for (Widget childTable : formCanvasSchema.childTables()) {
                List childWidgets = childTable.getChildren();
                childWidgetsAll.addAll(childWidgets);
            }
            formWidgets.addAll(formCanvasSchema.childTables());
            formWidgets.addAll(childWidgetsAll);
        }
        List canvasWidgets = formWidgets.stream().map(Widget::getName).collect(Collectors.toList());
        for (JSONObject condition : conditions) {
            String method = condition.getString("method");
            String value = condition.getString("value");
            String field = condition.getString("field");
            if (!canvasWidgets.contains(field) && !"RECORD_ID".equals(field)) continue;
            String businessValue = businessData.getString(field);
            String format = "";
            String fieldType = condition.getString("fieldType");
            if ("JXDNAddress".equals(fieldType)) {
                businessValue = businessData.getString(condition.getString("field") + "_code");
            }
            if ("JXDNDate".equals(fieldType)) {
                for (Widget widget : formCanvasSchema.getWidgets()) {
                    if (!condition.getString("field").equals(widget.getName())) continue;
                    format = widget.getProps().getString("format");
                }
            }
            if (HussarUtils.isEmpty((Object)value) && !"is_not_null".equals(method) && !"is_null".equals(method) || (trigger = TriggerVerify.triggerVerify(method, value, businessValue, fieldType, format).booleanValue())) continue;
            break;
        }
        return trigger;
    }

    public static Boolean triggerVerify(String method, String value, String businessValue, String fieldType, String format) throws Exception {
        boolean trigger = true;
        if (HussarUtils.isEmpty((Object)businessValue) && "is_null".equals(method) || HussarUtils.isNotEmpty((Object)businessValue) && "is_not_null".equals(method)) {
            return trigger;
        }
        if (HussarUtils.isEmpty((Object)businessValue) && "is_not_null".equals(method) || HussarUtils.isNotEmpty((Object)businessValue) && "is_null".equals(method)) {
            return false;
        }
        LocalDateTime businessDateTime = LocalDateTime.now();
        LocalDateTime beginDateTime = LocalDateTime.now();
        LocalDateTime endDateTime = LocalDateTime.now();
        LocalDateTime ruleDateTime = LocalDateTime.now();
        if ("JXDNDate".equals(fieldType)) {
            businessDateTime = TriggerVerify.getBusinessTime(businessValue);
            businessValue = businessValue.replace("T", " ").split("\\.")[0];
            DateTimeFormatter ruleFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            if (!"date_enum".equals(method)) {
                if (!value.contains("[")) {
                    ruleDateTime = TriggerVerify.getRuleTime(value, format);
                } else {
                    List dateTimeScope = JSONArray.parseArray((String)value, String.class);
                    beginDateTime = TriggerVerify.getRuleTime((String)dateTimeScope.get(0), format);
                    endDateTime = TriggerVerify.getRuleTime((String)dateTimeScope.get(1), format);
                    List<LocalDateTime> dateTimes = TriggerVerify.getBeginEndTime(beginDateTime, endDateTime, format);
                    beginDateTime = dateTimes.get(0);
                    endDateTime = dateTimes.get(1);
                }
            }
        }
        FilterConditionEnum filterConditionEnumByValue = FilterConditionEnum.getFilterConditionEnumByValue(method);
        block6 : switch (Objects.requireNonNull(filterConditionEnumByValue)) {
            case USER_EQ: 
            case EQ: {
                String userId;
                Double ruleVal;
                Double businessVal;
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if ("JXDNNumber".equals(fieldType) || "JXDNAggregate".equals(fieldType)) {
                    businessVal = Double.parseDouble(businessValue);
                    if (businessVal.equals(ruleVal = Double.valueOf(Double.parseDouble(value)))) break;
                    trigger = false;
                    break;
                }
                if ("JXDNDate".equals(fieldType)) {
                    if (businessDateTime.equals(ruleDateTime)) break;
                    trigger = false;
                    break;
                }
                if (businessValue.equals(value)) break;
                trigger = false;
                if ("JXDNUser".equals(fieldType)) {
                    userId = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)value, String.class).get(0))).getString("id");
                    if (businessValue.equals(userId)) {
                        trigger = true;
                    }
                    try {
                        businessValue = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)businessValue, String.class).get(0))).getString("id");
                        if (businessValue.equals(userId)) {
                            trigger = true;
                        }
                    }
                    catch (Exception e) {
                        System.out.println();
                    }
                }
                if (!"JXDNOrg".equals(fieldType)) break;
                String orgIdRule = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)value, String.class).get(0))).getString("id");
                if (!(businessValue = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)businessValue, String.class).get(0))).getString("id")).equals(orgIdRule)) break;
                trigger = true;
                break;
            }
            case USER_NE: 
            case NOT_EQ: {
                String userId;
                Double ruleVal;
                Double businessVal;
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                if ("JXDNNumber".equals(fieldType) || "JXDNAggregate".equals(fieldType)) {
                    businessVal = Double.parseDouble(businessValue);
                    if (!businessVal.equals(ruleVal = Double.valueOf(Double.parseDouble(value)))) break;
                    trigger = false;
                    break;
                }
                if ("JXDNDate".equals(fieldType)) {
                    if (!businessDateTime.equals(ruleDateTime)) break;
                    trigger = false;
                    break;
                }
                if (!businessValue.equals(value)) break;
                trigger = false;
                if ("JXDNUser".equals(fieldType)) {
                    userId = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)value, String.class).get(0))).getString("id");
                    if (!businessValue.equals(userId)) {
                        trigger = true;
                    }
                    try {
                        businessValue = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)businessValue, String.class).get(0))).getString("id");
                        if (!businessValue.equals(userId)) {
                            trigger = true;
                        }
                    }
                    catch (Exception e) {
                        System.out.println();
                    }
                }
                if (!"JXDNOrg".equals(fieldType)) break;
                String orgIdRule = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)value, String.class).get(0))).getString("id");
                if ((businessValue = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)businessValue, String.class).get(0))).getString("id")).equals(orgIdRule)) break;
                trigger = true;
                break;
            }
            case ANY_MATCH: 
            case USER_MULTI_LIKE: {
                List<String> businessVals;
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                List ruleValues = JSONArray.parseArray((String)value, String.class);
                if (!businessValue.startsWith("[")) {
                    String[] businessValues = businessValue.split(",");
                    businessVals = Arrays.asList(businessValues);
                } else {
                    businessVals = JSONArray.parseArray((String)businessValue, String.class);
                }
                logger.info("\u4e1a\u52a1\u6570\u636e:{},\u89c4\u5219\u5185\u5bb9:{}", businessVals, (Object)ruleValues);
                trigger = false;
                if ("JXDNUserMulti".equals(fieldType) || "JXDNOrgMulti".equals(fieldType)) {
                    ruleValues = ruleValues.stream().map(ruleValue -> JSONObject.parseObject((String)ruleValue).getString("id")).collect(Collectors.toList());
                    businessVals = businessVals.stream().map(ruleValue -> JSONObject.parseObject((String)ruleValue).getString("id")).collect(Collectors.toList());
                }
                block53: for (String ruleValue2 : ruleValues) {
                    if (trigger) break block6;
                    for (String businessVal : businessVals) {
                        if (!ruleValue2.equals(businessVal)) continue;
                        trigger = true;
                        continue block53;
                    }
                }
                break;
            }
            case NOT_IN: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                List ruleValues = JSONArray.parseArray((String)value, String.class);
                if (!ruleValues.contains(businessValue)) break;
                trigger = false;
                break;
            }
            case USER_NOT_IN: {
                List businessValues;
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                List ruleValues = JSONArray.parseArray((String)value, String.class);
                try {
                    businessValues = JSONArray.parseArray((String)businessValue, String.class);
                    businessValue = (String)businessValues.get(0);
                }
                catch (Exception e) {
                    System.out.println();
                }
                if (!ruleValues.contains(businessValue)) break;
                trigger = false;
                List ids = ruleValues.stream().map(ruleValue -> JSONObject.parseObject((String)ruleValue).getString("id")).collect(Collectors.toList());
                if (!ids.contains(businessValue)) {
                    trigger = true;
                }
                try {
                    String userId = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)value, String.class).get(0))).getString("id");
                    if (ids.contains(userId)) break;
                    trigger = true;
                }
                catch (Exception e) {
                    System.out.println();
                }
                break;
            }
            case IN: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                List ruleValues = JSONArray.parseArray((String)value, String.class);
                if (ruleValues.contains(businessValue)) break;
                trigger = false;
                break;
            }
            case USER_IN: {
                List businessValues;
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                List ruleValues = JSONArray.parseArray((String)value, String.class);
                try {
                    businessValues = JSONArray.parseArray((String)businessValue, String.class);
                    businessValue = (String)businessValues.get(0);
                }
                catch (Exception e) {
                    System.out.println();
                }
                if (ruleValues.contains(businessValue)) break;
                trigger = false;
                List ids = ruleValues.stream().map(ruleValue -> JSONObject.parseObject((String)ruleValue).getString("id")).collect(Collectors.toList());
                if (ids.contains(businessValue)) {
                    trigger = true;
                }
                try {
                    String userId = JSONObject.parseObject((String)((String)JSONArray.parseArray((String)businessValue, String.class).get(0))).getString("id");
                    if (!ids.contains(userId)) break;
                    trigger = true;
                }
                catch (Exception e) {
                    System.out.println();
                }
                break;
            }
            case LIKE: 
            case FULL_LIKE: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if (businessValue.contains(value)) break;
                trigger = false;
                break;
            }
            case NOT_LIKE: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                if (!businessValue.contains(value)) break;
                trigger = false;
                break;
            }
            case LEFT_LIKE: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if ("JXDNAddress".equals(fieldType)) {
                    value = JSONObject.parseObject((String)value).getString("code");
                }
                if (businessValue.startsWith(value)) break;
                trigger = false;
                break;
            }
            case LEFT_NE: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                if ("JXDNAddress".equals(fieldType)) {
                    value = JSONObject.parseObject((String)value).getString("code");
                }
                if (!businessValue.startsWith(value)) break;
                trigger = false;
                break;
            }
            case RIGHT_LIKE: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if (businessValue.endsWith(value)) break;
                trigger = false;
                break;
            }
            case RIGHT_NE: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                if (!businessValue.endsWith(value)) break;
                trigger = false;
                break;
            }
            case IS_NULL: {
                if (!HussarUtils.isNotEmpty((Object)businessValue)) break;
                trigger = false;
                break;
            }
            case IS_NOT_NULL: {
                if (!HussarUtils.isEmpty((Object)businessValue)) break;
                trigger = false;
                break;
            }
            case GREATER: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if (Double.parseDouble(businessValue) > Double.parseDouble(value)) break;
                trigger = false;
                break;
            }
            case GREATER_EQ: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if ("JXDNDate".equals(fieldType)) {
                    ruleDateTime = TriggerVerify.getBeginEndTime(LocalDateTime.now(), ruleDateTime, format).get(1);
                    if (!businessDateTime.isBefore(ruleDateTime)) break;
                    trigger = false;
                    break;
                }
                if (!(Double.parseDouble(businessValue) < Double.parseDouble(value))) break;
                trigger = false;
                break;
            }
            case LESS: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if (Double.parseDouble(businessValue) < Double.parseDouble(value)) break;
                trigger = false;
                break;
            }
            case LESS_EQ: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if ("JXDNDate".equals(fieldType)) {
                    if (!businessDateTime.isAfter(ruleDateTime = TriggerVerify.getBeginEndTime(ruleDateTime, LocalDateTime.now(), format).get(0))) break;
                    trigger = false;
                    break;
                }
                if (!(Double.parseDouble(businessValue) > Double.parseDouble(value))) break;
                trigger = false;
                break;
            }
            case BETWEEN: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                if ("JXDNDate".equals(fieldType)) {
                    if (!businessDateTime.isBefore(beginDateTime) && !businessDateTime.isAfter(endDateTime)) break;
                    trigger = false;
                    break;
                }
                Double businessNum = (Double)JSONObject.parseObject((String)businessValue, Double.class);
                List scope = JSONArray.parseArray((String)value, Double.class);
                Double min = (Double)scope.get(0);
                Double max = (Double)scope.get(1);
                if (!(min > businessNum) && !(businessNum > max)) break;
                trigger = false;
                break;
            }
            case NOT_BETWEEN: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return true;
                }
                if ("JXDNDate".equals(fieldType)) {
                    if (beginDateTime.isBefore(businessDateTime) && businessDateTime.isBefore(endDateTime)) {
                        trigger = false;
                        break;
                    }
                    if (!beginDateTime.equals(businessDateTime) && !endDateTime.equals(businessDateTime)) break;
                    trigger = false;
                    break;
                }
                Double businessNum = (Double)JSONObject.parseObject((String)businessValue, Double.class);
                List scope = JSONArray.parseArray((String)value, Double.class);
                Double min = (Double)scope.get(0);
                Double max = (Double)scope.get(1);
                if (!(min <= businessNum) || !(businessNum <= max)) break;
                trigger = false;
                break;
            }
            case DATE_ENUM: {
                if (HussarUtils.isEmpty((Object)businessValue)) {
                    return false;
                }
                businessDateTime = businessDateTime.toLocalDate().atStartOfDay();
                LocalDate date = businessDateTime.toLocalDate();
                LocalDate today = LocalDate.now();
                LocalDate yesterday = today.minusDays(1L);
                LocalDate tomorrow = today.plusDays(1L);
                LocalDate startOfWeek = today.minusDays(today.getDayOfWeek().getValue() - 1);
                LocalDate endOfWeek = startOfWeek.plusDays(6L);
                LocalDate startOfLastWeek = startOfWeek.minusDays(7L);
                LocalDate endOfLastWeek = startOfWeek.minusDays(1L);
                LocalDate startOfNextWeek = endOfWeek.plusDays(1L);
                LocalDate endOfNextWeek = endOfWeek.plusDays(7L);
                LocalDate startOfMonth = today.withDayOfMonth(1);
                LocalDate endOfMonth = today.withDayOfMonth(today.lengthOfMonth());
                LocalDate endOfLastMonth = startOfMonth.minusDays(1L);
                LocalDate startOfLastMonth = endOfLastMonth.withDayOfMonth(1);
                LocalDate startOfNextMonth = endOfMonth.plusDays(1L);
                LocalDate endOfNextMonth = startOfNextMonth.withDayOfMonth(startOfNextMonth.lengthOfMonth());
                LocalDate startOfQuarter = today.withMonth((today.getMonthValue() - 1) / 3 * 3 + 1).withDayOfMonth(1);
                LocalDate endOfQuarter = startOfQuarter.plusMonths(2L).withDayOfMonth(startOfQuarter.plusMonths(2L).lengthOfMonth());
                LocalDate endOfLastQuarter = startOfQuarter.minusDays(1L);
                LocalDate startOfLastQuarter = endOfLastQuarter.minusMonths(2L).withDayOfMonth(1);
                LocalDate startOfNextQuarter = endOfQuarter.plusDays(1L);
                LocalDate endOfNextQuarter = startOfNextQuarter.plusMonths(2L).withDayOfMonth(startOfNextQuarter.plusMonths(2L).lengthOfMonth());
                LocalDate startOfYear = LocalDate.of(today.getYear(), 1, 1);
                LocalDate endOfYear = LocalDate.of(today.getYear(), 12, 31);
                Year lastYear = Year.now().minusYears(1L);
                LocalDate endOfLastYear = lastYear.atDay(1);
                LocalDate startOfLastYear = lastYear.atMonth(12).atEndOfMonth();
                Year nextYear = Year.now().plusYears(1L);
                LocalDate startOfNextYear = nextYear.atDay(1);
                LocalDate endOfNextYear = nextYear.atMonth(12).atEndOfMonth();
                DateEnum dateEnum = DateEnum.getDateEnumByValue(value);
                switch (Objects.requireNonNull(dateEnum)) {
                    case TODAY: {
                        if (date.equals(today)) break;
                        trigger = false;
                        break;
                    }
                    case YESTERDAY: {
                        if (date.equals(yesterday)) break;
                        trigger = false;
                        break;
                    }
                    case TOMORROW: {
                        if (date.equals(tomorrow)) break;
                        trigger = false;
                        break;
                    }
                    case THIS_WEEK: {
                        if (date.isAfter(startOfWeek.minusDays(1L)) && date.isBefore(endOfWeek.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case LAST_WEEK: {
                        if (date.isAfter(startOfLastWeek.minusDays(1L)) && date.isBefore(endOfLastWeek.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case NEXT_WEEK: {
                        if (date.isAfter(startOfNextWeek.minusDays(1L)) && date.isBefore(endOfNextWeek.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case THIS_MONTH: {
                        if (date.isAfter(startOfMonth.minusDays(1L)) && date.isBefore(endOfMonth.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case LAST_MONTH: {
                        if (!date.isAfter(startOfLastMonth.minusDays(1L)) || !date.isBefore(endOfLastMonth.plusDays(1L))) {
                            trigger = false;
                        }
                    }
                    case NEXT_MONTH: {
                        if (date.isAfter(startOfNextMonth.minusDays(1L)) && date.isBefore(endOfNextMonth.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case THIS_QUARTER: {
                        if (date.isAfter(startOfQuarter.minusDays(1L)) && date.isBefore(endOfQuarter.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case LAST_QUARTER: {
                        if (date.isAfter(startOfLastQuarter.minusDays(1L)) && date.isBefore(endOfLastQuarter.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case NEXT_QUARTER: {
                        if (date.isAfter(startOfNextQuarter.minusDays(1L)) && date.isBefore(endOfNextQuarter.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case THIS_YEAR: {
                        if (date.isAfter(startOfYear.minusDays(1L)) && date.isBefore(endOfYear.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case LAST_YEAR: {
                        if (date.isAfter(startOfLastYear.minusDays(1L)) && date.isBefore(endOfLastYear.plusDays(1L))) break;
                        trigger = false;
                        break;
                    }
                    case NEXT_YEAR: {
                        if (date.isAfter(startOfNextYear.minusDays(1L)) && date.isBefore(endOfNextYear.plusDays(1L))) break;
                        trigger = false;
                    }
                }
                break;
            }
            default: {
                trigger = false;
            }
        }
        return trigger;
    }

    public static LocalDateTime getBusinessTime(String businessValue) {
        businessValue = businessValue.replace("T", " ").split("\\.")[0];
        ArrayList<DateTimeFormatter> formatters = new ArrayList<DateTimeFormatter>();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        formatters.add(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        formatters.add(formatter);
        for (DateTimeFormatter dateTimeFormatter : formatters) {
            try {
                LocalDateTime businessDateTime = LocalDateTime.parse(businessValue, dateTimeFormatter);
                businessDateTime = LocalDateTime.parse(businessDateTime.format(formatter), formatter);
                return businessDateTime;
            }
            catch (DateTimeParseException e) {
                System.out.println("\u8be5\u683c\u5f0f\u4e0d\u5339\u914d");
            }
        }
        return null;
    }

    public static LocalDateTime getRuleTime(String value, String format) {
        DateTimeFormatter formatter;
        DateTimeFormatter outputFormatter = formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if ("".equals(format)) {
            return LocalDateTime.parse(value, formatter);
        }
        outputFormatter = DateTimeFormatter.ofPattern(format);
        LocalDateTime ruleDateTime = LocalDateTime.parse(value, formatter);
        String outputTime = ruleDateTime.format(DateTimeFormatter.ofPattern(format));
        try {
            LocalDateTime ruleDateTimeTemp = LocalDateTime.parse(outputTime, outputFormatter);
            ruleDateTime = LocalDateTime.parse(ruleDateTime.format(formatter), formatter);
            return ruleDateTime;
        }
        catch (Exception e) {
            System.out.println();
            try {
                LocalDate ruleDate = LocalDate.parse(outputTime, outputFormatter);
                LocalDateTime ruleDateTimeTemp = ruleDate.atStartOfDay();
                ruleDateTime = LocalDateTime.parse(ruleDateTime.format(formatter), formatter);
                return ruleDateTime;
            }
            catch (Exception e2) {
                System.out.println();
                try {
                    YearMonth ruleDate = YearMonth.parse(outputTime, outputFormatter);
                    LocalDate date = ruleDate.atDay(1);
                    LocalTime time = LocalTime.of(0, 0);
                    LocalDateTime dateTime = LocalDateTime.of(date, time);
                    ruleDateTime = LocalDateTime.parse(ruleDateTime.format(formatter), formatter);
                    return ruleDateTime;
                }
                catch (Exception e3) {
                    System.out.println();
                    Year ruleDate = Year.parse(outputTime, outputFormatter);
                    LocalDate date = ruleDate.atDay(1);
                    LocalTime time = LocalTime.of(0, 0);
                    LocalDateTime dateTime = LocalDateTime.of(date, time);
                    ruleDateTime = LocalDateTime.parse(dateTime.format(formatter), formatter);
                    return ruleDateTime;
                }
            }
        }
    }

    public static List<LocalDateTime> getBeginEndTime(LocalDateTime beginDateTime, LocalDateTime endDateTime, String format) {
        switch (format) {
            case "yyyy": {
                beginDateTime = beginDateTime.with(TemporalAdjusters.firstDayOfYear()).withHour(0).withMinute(0).withSecond(0);
                endDateTime = endDateTime.with(TemporalAdjusters.lastDayOfYear()).withHour(23).withMinute(59).withSecond(59);
                break;
            }
            case "yyyy-MM": {
                beginDateTime = beginDateTime.with(TemporalAdjusters.firstDayOfMonth()).withHour(0).withMinute(0).withSecond(0);
                endDateTime = endDateTime.with(TemporalAdjusters.lastDayOfMonth()).withHour(23).withMinute(59).withSecond(59);
                break;
            }
            case "yyyy-MM-dd": {
                beginDateTime = beginDateTime.toLocalDate().atStartOfDay();
                endDateTime = endDateTime.toLocalDate().atTime(23, 59, 59);
                break;
            }
            case "yyyy-MM-dd HH:mm": 
            case "yyyy-MM-dd HH:mm:ss": {
                beginDateTime = beginDateTime.withSecond(0);
                beginDateTime = beginDateTime.withSecond(59);
            }
        }
        ArrayList<LocalDateTime> dateTimes = new ArrayList<LocalDateTime>();
        dateTimes.add(beginDateTime);
        dateTimes.add(endDateTime);
        return dateTimes;
    }

    public static HashMap<String, Object> filterParamsFormat(JSONObject condObject) {
        HashMap<String, Object> filter = new HashMap<String, Object>();
        String method = condObject.getString("method");
        Object valueObject = condObject.get((Object)"value");
        String businessValue = "";
        String field = condObject.getString("field");
        String format = "";
        String fieldType = condObject.getString("fieldType");
        businessValue = TriggerVerify.getBusinessValueByFieldType(fieldType, valueObject, method);
        String rule = FilterConditionEnum.getSearchValueByValue(method);
        field = TriggerVerify.getFieldByFiledType(fieldType, field);
        filter.put("field", field);
        filter.put("rule", rule);
        filter.put("val", businessValue);
        filter.put("match", "AND");
        return filter;
    }

    public static String getFieldByFiledType(String fieldType, String field) {
        switch (fieldType) {
            case "JXDNUser": 
            case "JXDNUserMulti": {
                if ("createUser_user".equals(field) || "updateUser_user".equals(field)) break;
                field = String.format("%s_%s", field, "id");
                break;
            }
            case "JXDNOrg": 
            case "JXDNOrgMulti": {
                field = String.format("%s_%s", field, "id");
                break;
            }
            case "JXDNAddress": {
                field = String.format("%s_%s", field, "code");
                break;
            }
        }
        return field;
    }

    public static String getBusinessValueByFieldType(String fieldType, Object valueObject, String method) {
        String businessValue = "";
        switch (fieldType) {
            case "JXDNAddress": {
                if (HussarUtils.isEmpty((Object)valueObject)) break;
                JSONObject jsonObject = JSONObject.parseObject((String)JsonUtil.toJson((Object)valueObject));
                businessValue = jsonObject.getString("code");
                break;
            }
            case "JXDNUser": 
            case "JXDNOrgMulti": 
            case "JXDNOrg": 
            case "JXDNUserMulti": {
                if (HussarUtils.isEmpty((Object)valueObject)) break;
                List jsonObjects = JsonUtil.parseArray((String)JsonUtil.toJson((Object)valueObject), JSONObject.class);
                for (JSONObject jsonObject : jsonObjects) {
                    String id = jsonObject.getString("id");
                    if (HussarUtils.isEmpty((Object)businessValue)) {
                        businessValue = businessValue + id;
                        continue;
                    }
                    businessValue = businessValue + "," + id;
                }
                break;
            }
            case "JXDNDate": {
                if (FilterConditionEnum.DATE_ENUM.getValue().equals(method)) {
                    DateEnum dateEnum = DateEnum.getDateEnumByValue(valueObject.toString());
                    LocalDateTime[] timeRange = TimeRangeCalculator.getTimeRange(dateEnum);
                    LocalDateTime startLocalDateTime = timeRange[0];
                    LocalDateTime endLocalDateTime = timeRange[1];
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    String startDateTime = startLocalDateTime.format(formatter);
                    String endDateTime = endLocalDateTime.format(formatter);
                    String[] dateTimeArray = new String[]{startDateTime, endDateTime};
                    businessValue = JsonUtil.toJson((Object)dateTimeArray);
                    break;
                }
                businessValue = valueObject.toString();
                break;
            }
            default: {
                businessValue = valueObject.toString();
            }
        }
        return businessValue;
    }
}

