/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.util;

import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.model.PublishLogVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class PublishLogUtil {
    private static final String CACHE_NAME = "publishLog";
    private static final Long CACHE_TIME = 300L;
    public static final String PAGE = "\u9875\u9762";
    public static final String DATA_MODEL = "\u6570\u636e\u6a21\u578b";
    public static final String WORK_FLOW = "\u5de5\u4f5c\u6d41";
    public static final String SCRIPT = "\u811a\u672c";
    public static final String BACK = "\u540e\u7aef";
    public static final String FRONT = "\u524d\u7aef";
    public static final String PUBLISH_LOG_KEY_TEMPLATE = "%s:%s:publish_log:%s";
    public static final String PUBLISHING_KEY_TEMPLATE = "%s:%s:is_publishing:%s";
    public static final String BACK_SERVE_STARTING_KEY_TEMPLATE = "%s:%s:back_serve_starting:%s";
    public static final String FRONT_SERVE_STARTING_KEY_TEMPLATE = "%s:%s:front_serve_starting:%s";
    public static final String ENV_STAGE = "\u4e2a\u4eba\u73af\u5883";
    public static final String CODE_STAGE = "\u4ee3\u7801";
    public static final String MODEL_STAGE = "\u6a21\u578b";
    public static final String GIT_STAGE = "Git";
    public static final String COMPILE_STAGE = "\u7f16\u8bd1";
    public static final String START_STAGE = "\u542f\u52a8";
    public static final String STOP_STAGE = "\u505c\u6b62";
    public static final String ERROR_STAGE = "\u9519\u8bef";
    public static final String PUBLISH_START_STATUS = "0";
    public static final String PUBLISH_PROCESS_STATUS = "1";
    public static final String PUBLISH_WILL_END_STATUS = "2";
    public static final String PUBLISH_END_STATUS = "3";
    public static final String PUBLISH_LOG = "\u5f00\u59cb\u53d1\u5e03\u5230\u5f00\u53d1\u73af\u5883...";
    public static final String PUBLISH_SUCCESS_LOG = "\u53d1\u5e03\u5230\u5f00\u53d1\u73af\u5883\u6210\u529f\uff01";
    public static final String PUBLISH_FAIL_LOG = "\u53d1\u5e03\u5230\u5f00\u53d1\u73af\u5883\u5931\u8d25\uff01";
    public static final String PUBLISH_END_LOG = "\u53d1\u5e03\u7ed3\u675f\uff01";
    public static final String MODEL_PUBLISH_LOG = "\u5f00\u59cb\u53d1\u5e03\u6a21\u578b...";
    public static final String MODEL_PUBLISH_SUCCESS_LOG = "\u6a21\u578b\u53d1\u5e03\u6210\u529f\uff01";
    public static final String CODE_GENERATE_LOG = "\u5f00\u59cb\u751f\u6210\u5e94\u7528\u4ee3\u7801...";
    public static final String CODE_GENERATE_SUCCESS_LOG = "\u5e94\u7528\u4ee3\u7801\u751f\u6210\u6210\u529f\uff01";
    public static final String CODE_PUSH_LOG = "\u5f00\u59cb\u63a8\u9001\u751f\u6210\u4ee3\u7801\u5230\u8fdc\u7a0b\u4ed3\u5e93...";
    public static final String CODE_PUSH_SUCCESS_LOG = "\u63a8\u9001\u751f\u6210\u4ee3\u7801\u5230\u8fdc\u7a0b\u4ed3\u5e93\u6210\u529f\uff01";
    public static final String CODE_PUSH_FAIL_LOG = "\u63a8\u9001\u751f\u6210\u4ee3\u7801\u5230\u8fdc\u7a0b\u4ed3\u5e93\u5931\u8d25\uff01";
    public static final String BACK_COMPILE_LOG = "\u5f00\u59cb\u7f16\u8bd1\u540e\u7aef\u670d\u52a1...";
    public static final String BACK_COMPILE_SUCCESS_LOG = "\u540e\u7aef\u670d\u52a1\u7f16\u8bd1\u6210\u529f\uff01";
    public static final String BACK_COMPILE_FAIL_LOG = "\u540e\u7aef\u670d\u52a1\u7f16\u8bd1\u5931\u8d25\uff01";
    public static final String SERVE_START_LOG = "\u670d\u52a1\u5f00\u59cb\u542f\u52a8...";
    public static final String SERVE_RESTART_LOG = "\u5f00\u59cb\u91cd\u542f\u540e\u7aef\u670d\u52a1...";
    public static final String SERVE_START_SUCCESS_LOG = "\u670d\u52a1\u542f\u52a8\u6210\u529f\uff01";
    public static final String SERVE_START_FAIL_LOG = "\u670d\u52a1\u542f\u52a8\u5931\u8d25\uff01";
    public static final String SERVE_COMPILE_FAIL_LOG = "\u670d\u52a1\u7f16\u8bd1\u5931\u8d25\uff01";
    public static final String SERVE_START_OR_COMPILE_SUCCESS_LOG = "\u670d\u52a1\u542f\u52a8\uff08\u7f16\u8bd1\uff09\u6210\u529f\uff01";
    public static final String SERVE_STOP_LOG = "\u5f00\u59cb\u505c\u6b62\u670d\u52a1...";
    public static final String SERVE_STOP_SUCCESS_LOG = "\u670d\u52a1\u505c\u6b62\u6210\u529f\uff01";
    public static final String SERVE_STOP_FAIL_LOG = "\u670d\u52a1\u505c\u6b62\u5931\u8d25\uff01";
    public static final String FREEMARKER_ERROR_LOG = "FreeMarker\u6a21\u677f\u586b\u5145\u6570\u636e\u5931\u8d25";
    public static final String WORKFLOW_PUBLISH_ERROR_LOG_1 = "\u53d1\u5e03\u65b0\u7248\u672c\u5931\u8d25\uff0c\u672c\u6b21\u53d1\u5e03\u65b0\u7248\u672c\u9700\u8981\u751f\u6210\u4ee3\u7801\uff0c\u975e\u5f00\u53d1\u73af\u5883\u7981\u6b62\u751f\u6210\u4ee3\u7801\u3002";
    public static final String WORKFLOW_PUBLISH_ERROR_LOG_2 = "\u5de5\u4f5c\u6d41\u751f\u6210\u4ee3\u7801\u65f6\u51fa\u9519\uff1a\u5b58\u5728\u53d8\u91cf\u5173\u8054\u5f02\u5e38\u7684\u6570\u636e\u6e90";
    public static final String WORKFLOW_PUBLISH_ERROR_LOG_3 = "\u89e3\u6790\u5f15\u64ce\u6682\u4e0d\u652f\u6301\u81ea\u5b9a\u4e49\u53d8\u91cf";
    public static final String BACK_SERVE_ERROR_LOG_1 = "\u8bf7\u90e8\u7f72\u540e\u7aef\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01";
    public static final String BACK_SERVE_ERROR_LOG_2 = "spring boot\u9879\u76ee\u542f\u52a8\u5931\u8d25\uff01";
    public static final String FRONT_SERVE_ERROR_LOG_1 = "vue\u9879\u76ee\u542f\u52a8\u5931\u8d25!";
    public static final String SERVE_ERROR_LOG_1 = "\u8bf7\u90e8\u7f72\u542f\u52a8\u811a\u672c\u81f3\u5bf9\u5e94\u7684\u76ee\u5f55\uff01";
    public static final String ENV_ERROR_LOG = "\u4e2a\u4eba\u670d\u52a1\u5b9e\u4f8b\u672a\u542f\u52a8\u6216\u6b63\u5728\u542f\u52a8\u4e2d\uff0c\u8bf7\u7a0d\u5019\u2026\u2026\uff01";
    public static final String START_SERVE_LOG = "\u5f00\u59cb\u542f\u52a8\u670d\u52a1...";

    public static List<PublishLogVo> getPublishLogList(String key) {
        List logList;
        if (HussarUtils.isEmpty((Object)key)) {
            key = PublishLogUtil.getPublishLogCacheKey();
        }
        return HussarUtils.isNotEmpty((Object)(logList = (List)HussarCacheUtil.get((String)CACHE_NAME, (Object)key))) ? logList : new ArrayList();
    }

    public static Boolean isPublishingOrServeStarting(String tenantCode, String devUser, String branch) {
        String publishingKey = String.format(PUBLISHING_KEY_TEMPLATE, tenantCode, devUser, branch);
        String backServeStartingKey = String.format(BACK_SERVE_STARTING_KEY_TEMPLATE, tenantCode, devUser, branch);
        String frontServeStartingKey = String.format(FRONT_SERVE_STARTING_KEY_TEMPLATE, tenantCode, devUser, branch);
        Boolean isPublishing = (Boolean)HussarCacheUtil.get((String)CACHE_NAME, (Object)publishingKey);
        Boolean backServeStarting = (Boolean)HussarCacheUtil.get((String)CACHE_NAME, (Object)backServeStartingKey);
        Boolean frontServeStarting = (Boolean)HussarCacheUtil.get((String)CACHE_NAME, (Object)frontServeStartingKey);
        isPublishing = HussarUtils.isNotEmpty((Object)isPublishing) && isPublishing != false;
        backServeStarting = HussarUtils.isNotEmpty((Object)backServeStarting) && backServeStarting != false;
        frontServeStarting = HussarUtils.isNotEmpty((Object)frontServeStarting) && frontServeStarting != false;
        return isPublishing != false || backServeStarting != false || frontServeStarting != false;
    }

    public static void writePublishLog(Log log) {
        PublishLogVo lastLog;
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String tenantCode = HussarUtils.isNotEmpty((Object)log.getTenantCode()) ? log.getTenantCode() : BaseSecurityUtil.getUser().getTenantCode();
        String devUser = HussarUtils.isNotEmpty((Object)log.getDevUser()) ? log.getDevUser() : String.valueOf(BaseSecurityUtil.getUser().getUserId());
        String branch = HussarUtils.isNotEmpty((Object)log.getBranch()) ? log.getBranch() : (String)gitlabService.getCurrentBranch().getData();
        String key = String.format(PUBLISH_LOG_KEY_TEMPLATE, tenantCode, devUser, branch);
        List<PublishLogVo> logList = PublishLogUtil.getPublishLogList(key);
        PublishLogVo publishLog = new PublishLogVo();
        if (!logList.isEmpty() && !PUBLISH_END_STATUS.equals((lastLog = logList.get(logList.size() - 1)).getStatus())) {
            if (HussarUtils.isEmpty((Object)log.getResourceId())) {
                log.setResourceId(lastLog.getResourceId());
            }
            if (HussarUtils.isEmpty((Object)log.getAppCode())) {
                log.setAppCode(lastLog.getAppCode());
            }
        }
        publishLog.setResourceId(log.getResourceId());
        publishLog.setAppCode(log.getAppCode());
        publishLog.setStage(log.getStage());
        publishLog.setProcess(log.getProcess());
        publishLog.setErrorMsg(log.getErrorMsg());
        publishLog.setTimestamp(new Timestamp(System.currentTimeMillis()).toString());
        publishLog.setStatus(log.getStatus());
        logList.add(publishLog);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, logList, (long)CACHE_TIME);
    }

    public static void writeDirectPublishLog(PublishLogVo publishLog) {
        String key = PublishLogUtil.getPublishLogCacheKey();
        List<PublishLogVo> logList = PublishLogUtil.getPublishLogList(key);
        logList.add(publishLog);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, logList, (long)CACHE_TIME);
    }

    public static void cleanPublishLog() {
        String key = PublishLogUtil.getPublishLogCacheKey();
        HussarCacheUtil.evict((String)CACHE_NAME, (Object)key);
        PublishLogUtil.cleanServeStartLog();
    }

    public static void cleanServeStartLog() {
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String devUser = String.valueOf(BaseSecurityUtil.getUser().getUserId());
        String branch = (String)gitlabService.getCurrentBranch().getData();
        HussarCacheUtil.evict((String)CACHE_NAME, (Object)String.format(PUBLISHING_KEY_TEMPLATE, tenantCode, devUser, branch));
        HussarCacheUtil.evict((String)CACHE_NAME, (Object)String.format(BACK_SERVE_STARTING_KEY_TEMPLATE, tenantCode, devUser, branch));
        HussarCacheUtil.evict((String)CACHE_NAME, (Object)String.format(FRONT_SERVE_STARTING_KEY_TEMPLATE, tenantCode, devUser, branch));
    }

    public static void writePublishToEnvStartLog(String resourceId, String appCode, String resourceName) {
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String key = String.format(PUBLISHING_KEY_TEMPLATE, BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getUserId(), gitlabService.getCurrentBranch().getData());
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)true, (long)CACHE_TIME);
        Log publishLog = new Log(resourceId, appCode, null, resourceName + PUBLISH_LOG, null, PUBLISH_START_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
    }

    public static void writePublishingLog(String resourceId, String appCode, String stage, String process) {
        Log publishLog = new Log(resourceId, appCode, stage, process, null, PUBLISH_PROCESS_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
    }

    public static void writePublishSuccessLog(String resourceId, String appCode, String resourceName, String status) {
        Boolean isPublishing;
        Log publishLog = new Log(resourceId, appCode, null, resourceName + PUBLISH_SUCCESS_LOG, null, status, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String devUser = String.valueOf(BaseSecurityUtil.getUser().getUserId());
        String branch = (String)gitlabService.getCurrentBranch().getData();
        String key = String.format(PUBLISHING_KEY_TEMPLATE, tenantCode, devUser, branch);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)false, (long)CACHE_TIME);
        if (PUBLISH_WILL_END_STATUS.equals(status) && Boolean.FALSE.equals(isPublishing = PublishLogUtil.isPublishingOrServeStarting(tenantCode, devUser, branch))) {
            PublishLogUtil.writePublishEndLog(resourceId, appCode, resourceName);
        }
    }

    public static void writePublishFailLog(String resourceId, String appCode, String resourceName) {
        Log publishLog = new Log(resourceId, appCode, null, null, resourceName + PUBLISH_FAIL_LOG, PUBLISH_WILL_END_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String devUser = String.valueOf(BaseSecurityUtil.getUser().getUserId());
        String branch = (String)gitlabService.getCurrentBranch().getData();
        String key = String.format(PUBLISHING_KEY_TEMPLATE, tenantCode, devUser, branch);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)false, (long)CACHE_TIME);
        Boolean isPublishing = PublishLogUtil.isPublishingOrServeStarting(tenantCode, devUser, branch);
        if (Boolean.FALSE.equals(isPublishing)) {
            PublishLogUtil.writePublishEndLog(resourceId, appCode, resourceName);
        }
    }

    public static void writePublishEndLog(String resourceId, String appCode, String resourceName) {
        Log publishLog = new Log(resourceId, appCode, null, resourceName + PUBLISH_END_LOG, null, PUBLISH_END_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
    }

    public static void writePublishErrorLog(String resourceId, String appCode, String errorMsg) {
        Log publishLog = new Log(resourceId, appCode, ERROR_STAGE, null, errorMsg, PUBLISH_PROCESS_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
    }

    public static void writeStartServeLog(String process, int type) {
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String key = String.format(type == 1 ? BACK_SERVE_STARTING_KEY_TEMPLATE : FRONT_SERVE_STARTING_KEY_TEMPLATE, BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getUserId(), gitlabService.getCurrentBranch().getData());
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)true, (long)CACHE_TIME);
        Log publishLog = new Log(null, null, START_STAGE, process, null, PUBLISH_PROCESS_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
    }

    public static void writeStartServeFailLog(String errorMsg, int type) {
        Log publishLog = new Log(null, null, START_STAGE, null, errorMsg, PUBLISH_WILL_END_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String devUser = String.valueOf(BaseSecurityUtil.getUser().getUserId());
        String branch = (String)gitlabService.getCurrentBranch().getData();
        String key = String.format(type == 1 ? BACK_SERVE_STARTING_KEY_TEMPLATE : FRONT_SERVE_STARTING_KEY_TEMPLATE, tenantCode, devUser, branch);
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)false, (long)CACHE_TIME);
        Boolean isPublishing = PublishLogUtil.isPublishingOrServeStarting(tenantCode, devUser, branch);
        if (Boolean.FALSE.equals(isPublishing)) {
            PublishLogUtil.writePublishEndLog(null, null, "");
        }
    }

    public static void writeStopServeSuccessLog() {
        Log publishLog = new Log(null, null, STOP_STAGE, SERVE_STOP_SUCCESS_LOG, null, PUBLISH_END_STATUS, null, null, null);
        PublishLogUtil.writePublishLog(publishLog);
    }

    public static void writeRestartServeLog(Log log) {
        PublishLogUtil.writePublishLog(log);
        String key = String.format(BACK_SERVE_STARTING_KEY_TEMPLATE, BaseSecurityUtil.getUser().getTenantCode(), BaseSecurityUtil.getUser().getUserId(), log.getBranch());
        HussarCacheUtil.put((String)CACHE_NAME, (Object)key, (Object)true, (long)CACHE_TIME);
    }

    public static void writeBackServeStartedLog(Log log) {
        PublishLogUtil.writePublishLog(log);
        String backServeStartKey = String.format(BACK_SERVE_STARTING_KEY_TEMPLATE, log.getTenantCode(), log.getDevUser(), log.getBranch());
        HussarCacheUtil.put((String)CACHE_NAME, (Object)backServeStartKey, (Object)false, (long)CACHE_TIME);
        Boolean isPublishing = PublishLogUtil.isPublishingOrServeStarting(log.getTenantCode(), log.getDevUser(), log.getBranch());
        if (Boolean.FALSE.equals(isPublishing)) {
            Log publishEndLog = new Log(log.getResourceId(), log.getAppCode(), null, PUBLISH_END_LOG, null, PUBLISH_END_STATUS, log.getTenantCode(), log.getDevUser(), log.getBranch());
            PublishLogUtil.writePublishLog(publishEndLog);
        }
    }

    public static void writeFrontServeStartedLog(Log log) {
        Boolean isPublishing = PublishLogUtil.isPublishingOrServeStarting(log.getTenantCode(), log.getDevUser(), log.getBranch());
        if (Boolean.FALSE.equals(isPublishing)) {
            log.setStatus(PUBLISH_END_STATUS);
            PublishLogUtil.writePublishLog(log);
            return;
        }
        PublishLogUtil.writePublishLog(log);
        String frontServeStartKey = String.format(FRONT_SERVE_STARTING_KEY_TEMPLATE, log.getTenantCode(), log.getDevUser(), log.getBranch());
        HussarCacheUtil.put((String)CACHE_NAME, (Object)frontServeStartKey, (Object)false, (long)CACHE_TIME);
        isPublishing = PublishLogUtil.isPublishingOrServeStarting(log.getTenantCode(), log.getDevUser(), log.getBranch());
        if (Boolean.FALSE.equals(isPublishing)) {
            Log publishEndLog = new Log(log.getResourceId(), log.getAppCode(), null, PUBLISH_END_LOG, null, PUBLISH_END_STATUS, log.getTenantCode(), log.getDevUser(), log.getBranch());
            PublishLogUtil.writePublishLog(publishEndLog);
        }
    }

    public static void writePushSuccessLog(Log log) {
        Boolean isPublishing = PublishLogUtil.isPublishingOrServeStarting(log.getTenantCode(), log.getDevUser(), log.getBranch());
        if (Boolean.FALSE.equals(isPublishing)) {
            log.setStatus(PUBLISH_END_STATUS);
        }
        PublishLogUtil.writePublishLog(log);
    }

    private static String getPublishLogCacheKey() {
        IGitlabService gitlabService = (IGitlabService)SpringContextHolder.getBean(IGitlabService.class);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String devUser = String.valueOf(BaseSecurityUtil.getUser().getId());
        String branch = (String)gitlabService.getCurrentBranch().getData();
        return String.format(PUBLISH_LOG_KEY_TEMPLATE, tenantCode, devUser, branch);
    }

    public static class Log {
        String resourceId;
        String appCode;
        String stage;
        String process;
        String errorMsg;
        String status;
        String tenantCode;
        String devUser;
        String branch;

        public Log(String resourceId, String appCode, String stage, String process, String errorMsg, String status, String tenantCode, String devUser, String branch) {
            this.resourceId = resourceId;
            this.appCode = appCode;
            this.stage = stage;
            this.process = process;
            this.errorMsg = errorMsg;
            this.status = status;
            this.tenantCode = tenantCode;
            this.devUser = devUser;
            this.branch = branch;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public String getAppCode() {
            return this.appCode;
        }

        public void setAppCode(String appCode) {
            this.appCode = appCode;
        }

        public void setStage(String stage) {
            this.stage = stage;
        }

        public void setProcess(String process) {
            this.process = process;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public void setTenantCode(String tenantCode) {
            this.tenantCode = tenantCode;
        }

        public void setDevUser(String devUser) {
            this.devUser = devUser;
        }

        public void setBranch(String branch) {
            this.branch = branch;
        }

        public String getStage() {
            return this.stage;
        }

        public String getProcess() {
            return this.process;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public String getStatus() {
            return this.status;
        }

        public String getTenantCode() {
            return this.tenantCode;
        }

        public String getDevUser() {
            return this.devUser;
        }

        public String getBranch() {
            return this.branch;
        }
    }
}

