/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.formdesign.devtools.gitlab.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.DevCloudUtil;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.UrlUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.UserApi;
import org.gitlab4j.api.models.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class GitlabUtil {
    private static final Logger logger = LoggerFactory.getLogger(GitlabUtil.class);
    public static final String DEVELOP_BRANCH = "develop";

    public static ApiResponse<Boolean> createProject(GitDto gitDto) {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String commitMsg = gitDto.getCommitMsg();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            logger.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
            return ApiResponse.success((Object)false);
        }
        if (StringUtils.isEmpty((Object)commitMsg)) {
            commitMsg = "\u521d\u59cb\u5316\u9879\u76ee";
        }
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        gitUrl = UrlUtils.buildUrl(gitUrl);
        logger.info("\u5f00\u59cb\u521b\u5efa\u672c\u5730\u4ed3\u5e93\uff1a{}\uff0c\u8def\u5f84\uff1a{}", (Object)tenantCode, (Object)localDir);
        DevCloudUtil.createProject(localDir, gitUrl, tenantCode, commitMsg, accessToken);
        logger.info("\u4ed3\u5e93\u521b\u5efa\u6210\u529f\uff01");
        logger.info("\u5f00\u59cb\u63d0\u4ea4\u81f3\u8fdc\u7a0b\u4ed3\u5e93\u3002");
        DevCloudUtil.push(localDir, gitUrl, commitMsg, accessToken);
        logger.info("\u63d0\u4ea4\u81f3\u8fdc\u7a0b\u4ed3\u5e93\u6210\u529f\uff01");
        logger.info("\u5f00\u59cb\u521b\u5efa\u5206\u652f\uff1a{}", (Object)DEVELOP_BRANCH);
        DevCloudUtil.createDevBranch(localDir, accessToken, DEVELOP_BRANCH);
        logger.info("\u521b\u5efa\u5206\u652f\u6210\u529f!");
        return ApiResponse.success((Object)true);
    }

    public static ApiResponse<String> pushToGit(GitDto gitDto) {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String commitMsg = gitDto.getCommitMsg();
        String branch = gitDto.getBranch();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            return ApiResponse.success((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"");
        }
        if (StringUtils.isEmpty((Object)commitMsg)) {
            commitMsg = "\u63d0\u4ea4\u4ee3\u7801";
        }
        gitUrl = UrlUtils.buildUrl(gitUrl);
        logger.info("\u63d0\u4ea4\u4ee3\u7801\uff0c\u9879\u76ee\uff1a{}\uff0c\u5206\u652f\uff1a{}", (Object)tenantCode, (Object)branch);
        DevCloudUtil.push(localDir, gitUrl, tenantCode, commitMsg, accessToken, branch);
        logger.info("\u63d0\u4ea4\u4ee3\u7801\u6210\u529f\uff01");
        return ApiResponse.success((Object)"\u63d0\u4ea4\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> commit(GitDto gitDto) {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String commitMsg = gitDto.getCommitMsg();
        String branch = gitDto.getBranch();
        List filesToAdd = gitDto.getFilesToAdd();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            return ApiResponse.success((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"");
        }
        if (StringUtils.isEmpty((Object)commitMsg)) {
            commitMsg = "\u63d0\u4ea4\u4ee3\u7801\u81f3\u672c\u5730";
        }
        gitUrl = UrlUtils.buildUrl(gitUrl);
        DevCloudUtil.commit(localDir, gitUrl, tenantCode, commitMsg, accessToken, branch, path, filesToAdd);
        return ApiResponse.success((Object)"\u63d0\u4ea4\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> pushSpecifiedToGit(GitDto gitDto) {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String commitMsg = gitDto.getCommitMsg();
        String branch = gitDto.getBranch();
        List filesToAdd = gitDto.getFilesToAdd();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            return ApiResponse.success((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"");
        }
        if (StringUtils.isEmpty((Object)commitMsg)) {
            commitMsg = "\u63d0\u4ea4\u4ee3\u7801";
        }
        gitUrl = UrlUtils.buildUrl(gitUrl);
        DevCloudUtil.pushSpecifiedFile(localDir, gitUrl, tenantCode, commitMsg, accessToken, branch, path, filesToAdd);
        return ApiResponse.success((Object)"\u63d0\u4ea4\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> pushSpecifiedFileNotCommit(GitDto gitDto) {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String branch = gitDto.getBranch();
        List filesToAdd = gitDto.getFilesToAdd();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            return ApiResponse.success((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"");
        }
        gitUrl = UrlUtils.buildUrl(gitUrl);
        DevCloudUtil.pushSpecifiedFileNotCommit(localDir, gitUrl, tenantCode, accessToken, branch, path, filesToAdd);
        return ApiResponse.success((Object)"\u63d0\u4ea4\u6210\u529f", (String)"");
    }

    public static synchronized ApiResponse<String> pushSpecifiedToGitSync(GitDto gitDto) {
        GitlabUtil.commit(gitDto);
        GitlabUtil.pullNotReset(gitDto);
        return GitlabUtil.pushSpecifiedFileNotCommit(gitDto);
    }

    public static ApiResponse<String> pullToLocal(GitDto gitDto) throws HussarException {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String branch = gitDto.getBranch();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        gitUrl = UrlUtils.buildUrl(gitUrl, tenantCode);
        logger.info("\u62c9\u53d6\u4ee3\u7801\u5230\u672c\u5730\uff0c\u5730\u5740\uff1a{}\uff0c\u5206\u652f\uff1a{}", (Object)gitUrl, (Object)branch);
        DevCloudUtil.pull(gitUrl, path, branch, accessToken);
        logger.info("\u62c9\u53d6\u4ee3\u7801\u5230\u672c\u5730\u6210\u529f\uff01");
        return ApiResponse.success((Object)"\u62c9\u53d6\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> pullNotReset(GitDto gitDto) {
        String path = gitDto.getPath();
        String tenantCode = gitDto.getTenantCode();
        String branch = gitDto.getBranch();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        gitUrl = UrlUtils.buildUrl(gitUrl, tenantCode);
        logger.info("\u62c9\u53d6\u4ee3\u7801\u5230\u672c\u5730\uff0c\u5730\u5740\uff1a{}\uff0c\u5206\u652f\uff1a{}", (Object)gitUrl, (Object)branch);
        DevCloudUtil.pullNotReset(gitUrl, path, branch, accessToken);
        logger.info("\u62c9\u53d6\u4ee3\u7801\u5230\u672c\u5730\u6210\u529f\uff01");
        return ApiResponse.success((Object)"\u62c9\u53d6\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> createLocalBranch(GitDto gitDto) {
        String path = gitDto.getPath();
        String branch = gitDto.getBranch();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            logger.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
            return ApiResponse.success((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"");
        }
        logger.info("\u5f00\u59cb\u521b\u5efa\u5206\u652f\uff1a{}", (Object)branch);
        DevCloudUtil.createDevBranch(localDir, accessToken, branch);
        logger.info("\u521b\u5efa\u5206\u652f\u6210\u529f\uff01");
        return ApiResponse.success((Object)"\u521b\u5efa\u5206\u652f\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> createRemoteBranch(GitDto gitDto) {
        String tenantCode = gitDto.getTenantCode();
        String branch = gitDto.getBranch();
        String refName = gitDto.getRefName();
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        if (ToolUtil.isEmpty((Object)refName)) {
            refName = DEVELOP_BRANCH;
        }
        String id = DevCloudUtil.getProjectIdByGroupIdAndName(gitUri, tenantCode, accessToken, gitGroup);
        logger.info("\u57fa\u4e8e{}\u521b\u5efa\u5206\u652f\uff1a{}", (Object)refName, (Object)branch);
        DevCloudUtil.createRemoteBranch(gitUri, id, branch, refName, accessToken);
        logger.info("\u521b\u5efa\u5206\u652f\u6210\u529f\uff01");
        return ApiResponse.success((Object)"\u521b\u5efa\u5206\u652f\u6210\u529f", (String)"");
    }

    public static ApiResponse<String> checkoutBranch(GitDto gitDto) throws HussarException {
        String path = gitDto.getPath();
        String branch = gitDto.getBranch();
        String accessToken = gitDto.getAccessToken();
        File localDir = new File(path);
        if (!localDir.exists()) {
            logger.info("\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
            return ApiResponse.success((Object)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728", (String)"");
        }
        if (ToolUtil.isEmpty((Object)branch)) {
            branch = DEVELOP_BRANCH;
        }
        logger.info("\u5f00\u59cb\u5207\u6362\u5206\u652f\uff1a{}", (Object)branch);
        DevCloudUtil.checkoutBranch(localDir, accessToken, branch);
        logger.info("\u5207\u6362\u5206\u652f\u6210\u529f\uff01");
        return ApiResponse.success((Object)"\u521b\u5efa\u5206\u652f\u6210\u529f", (String)"");
    }

    public static ApiResponse<Boolean> branchExist(GitDto gitDto) {
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        String branch = gitDto.getBranch();
        String tenantCode = gitDto.getTenantCode();
        gitUrl = UrlUtils.buildUrl(gitUrl);
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        String id = DevCloudUtil.getProjectIdByGroupIdAndName(gitUri, tenantCode, accessToken, gitGroup);
        boolean exist = DevCloudUtil.branchExist(gitUri, branch, accessToken, id);
        return ApiResponse.success((Object)exist);
    }

    public static ApiResponse<Boolean> remoteMerge(GitDto gitDto) {
        String gitUrl = gitDto.getGitUri();
        String tenantCode = gitDto.getTenantCode();
        String accessToken = gitDto.getAccessToken();
        String sourceBranch = gitDto.getSourceBranch();
        String targetBranch = gitDto.getTargetBranch();
        String title = gitDto.getTitle();
        gitUrl = UrlUtils.buildUrl(gitUrl);
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        logger.info("\u5f00\u59cb\u5c06{}\u5206\u652f\u5408\u5e76\u81f3{}\u5206\u652f", (Object)sourceBranch, (Object)targetBranch);
        DevCloudUtil.merge(gitUri, gitGroup, tenantCode, sourceBranch, targetBranch, title, accessToken);
        logger.info("\u5408\u5e76\u5206\u652f\u6210\u529f\uff01");
        return ApiResponse.success((Object)true);
    }

    public static ApiResponse<Boolean> remoteMergeRequestCheck(GitDto gitDto) {
        String gitUrl = gitDto.getGitUri();
        String tenantCode = gitDto.getTenantCode();
        String accessToken = gitDto.getAccessToken();
        String sourceBranch = gitDto.getSourceBranch();
        gitUrl = UrlUtils.buildUrl(gitUrl);
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        logger.info("\u5f00\u59cb\u6821\u9a8c{}\u5206\u652f\u662f\u5426\u5b58\u5728\u5408\u5e76\u8bf7\u6c42", (Object)sourceBranch);
        boolean res = DevCloudUtil.checkMergeRequest(gitUri, gitGroup, tenantCode, sourceBranch, accessToken);
        logger.info("{}\u5206\u652f{}\u5408\u5e76\u8bf7\u6c42\uff01", (Object)sourceBranch, (Object)(res ? "\u5b58\u5728" : "\u4e0d\u5b58\u5728"));
        return ApiResponse.success((Object)res);
    }

    public static ApiResponse<Boolean> getGroupOrProjectId(GitDto gitDto) {
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        String groups = DevCloudUtil.getGroupOrProjectId(gitUri, gitGroup, accessToken, "groups");
        if (ToolUtil.isEmpty((Object)groups)) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    public static ApiResponse<Boolean> delProject(GitDto gitDto) {
        String gitUrl = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        String gitGroup = UrlUtils.getLastPartOfUrl(gitUrl);
        String gitUri = gitUrl.replace("/" + gitGroup, "");
        DevCloudUtil.delProject(gitUri, gitDto.getTenantCode(), accessToken, gitGroup);
        return ApiResponse.success((Object)true);
    }

    public static ApiResponse<Boolean> revertOrRemove(File localDir, List<String> fileToRevert) {
        DevCloudUtil.revertOrRemove(localDir, fileToRevert);
        return ApiResponse.success((Object)true);
    }

    public static ApiResponse<User> createUser(GitDto gitDto, User user) {
        String uri = gitDto.getGitUri();
        String accessToken = gitDto.getAccessToken();
        int index = uri.indexOf("/", uri.indexOf("/") + 2) + 1;
        String hostUrl = uri.substring(0, index);
        User newUser = new User();
        try (GitLabApi gitLabApi = new GitLabApi(hostUrl, accessToken);){
            UserApi userApi = gitLabApi.getUserApi();
            newUser = userApi.createUser(user, (CharSequence)"123456", false);
        }
        catch (GitLabApiException e) {
            if (e.getHttpStatus() == 401 || e.getHttpStatus() == 400) {
                throw new HussarException("\u8eab\u4efd\u9a8c\u8bc1\u672a\u901a\u8fc7");
            }
            throw new HussarException((Throwable)e);
        }
        return ApiResponse.success((Object)newUser);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ApiResponse<String> getCurrentBranch(String localGitPath) {
        File gitDir = new File(localGitPath);
        if (!gitDir.exists()) return ApiResponse.fail((String)("\u672c\u5730\u9879\u76ee\u4e0d\u5b58\u5728 " + localGitPath));
        if (!gitDir.isDirectory()) {
            return ApiResponse.fail((String)("\u672c\u5730\u9879\u76ee\u4e0d\u5b58\u5728 " + localGitPath));
        }
        try (Git git = Git.open((File)gitDir);){
            String currentBranch = git.getRepository().getBranch();
            if (HussarUtils.isEmpty((Object)currentBranch)) {
                ApiResponse apiResponse2 = ApiResponse.fail((String)"\u672c\u5730Git\u4ed3\u5e93\u672a\u627e\u5230\u4efb\u4f55\u5206\u652f");
                return apiResponse2;
            }
            ApiResponse apiResponse = ApiResponse.success((Object)currentBranch, (String)"");
            return apiResponse;
        }
        catch (IOException e) {
            return ApiResponse.fail((String)("\u672c\u5730Git\u4ed3\u5e93\u6253\u5f00\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }
}

