/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.file.resource.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.file.resource.dao.ResClassifyMapper;
import com.jxdinfo.hussar.file.resource.dto.ClassifyDto;
import com.jxdinfo.hussar.file.resource.model.ResClassify;
import com.jxdinfo.hussar.file.resource.service.ResClassifyService;
import com.jxdinfo.hussar.file.resource.vo.ClassifyTreeVo;
import com.jxdinfo.hussar.file.resource.vo.ParentClassifyVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
@HussarTransactional
public class ResClassifyServiceImpl
extends HussarServiceImpl<ResClassifyMapper, ResClassify>
implements ResClassifyService {
    public List<ClassifyTreeVo> queryClassifyTree(String classifyType) {
        List resClassifyList = this.list((Wrapper)new LambdaQueryWrapper().eq(ResClassify::getClassifyType, (Object)classifyType));
        if (resClassifyList.isEmpty()) {
            return new ArrayList<ClassifyTreeVo>();
        }
        HashMap<Long, ClassifyTreeVo> nodeMap = new HashMap<Long, ClassifyTreeVo>(resClassifyList.size());
        for (ResClassify resClassify : resClassifyList) {
            ClassifyTreeVo node = new ClassifyTreeVo();
            HussarUtils.copy((Object)resClassify, (Object)node);
            node.setChildren(new ArrayList());
            nodeMap.put(node.getId(), node);
        }
        ArrayList<ClassifyTreeVo> rootNodes = new ArrayList<ClassifyTreeVo>();
        for (ClassifyTreeVo node : nodeMap.values()) {
            Long parentId = node.getParentId();
            if (HussarUtils.isEmpty((Object)parentId)) {
                rootNodes.add(node);
                continue;
            }
            ClassifyTreeVo parentNode = (ClassifyTreeVo)nodeMap.get(parentId);
            if (HussarUtils.isNotEmpty((Object)parentNode)) {
                parentNode.getChildren().add(node);
                continue;
            }
            throw new BaseException("\u7236\u7ea7\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        return rootNodes;
    }

    public Boolean addClassify(ClassifyDto classifyDto) {
        ResClassify resClassify = new ResClassify();
        long id = IdWorker.getId((Object)resClassify);
        Long parentId = classifyDto.getParentId();
        resClassify.setId(Long.valueOf(id));
        resClassify.setClassifyName(classifyDto.getClassifyName());
        resClassify.setParentId(parentId);
        resClassify.setClassifyType(classifyDto.getClassifyType());
        if (HussarUtils.equals((Object)parentId, (Object)11L) || HussarUtils.equals((Object)parentId, (Object)12L)) {
            resClassify.setClassifyLevel("2");
        } else {
            resClassify.setClassifyLevel("3");
        }
        return super.save((BaseEntity)resClassify);
    }

    public Boolean updateClassify(ClassifyDto classifyDto) {
        return super.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ResClassify::getId, (Object)classifyDto.getId())).set(ResClassify::getClassifyName, (Object)classifyDto.getClassifyName()));
    }

    public Boolean delClassify(Long id) {
        return super.removeById((Serializable)id);
    }

    public List<ParentClassifyVo> queryParentClassify(String classifyType) {
        List resClassifyList = this.list((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().ne(ResClassify::getClassifyLevel, (Object)"3")).eq(ResClassify::getClassifyType, (Object)classifyType));
        return HussarUtils.copy((Collection)resClassifyList, ParentClassifyVo.class);
    }

    public List<ParentClassifyVo> queryAllClassify(String classifyType) {
        List resClassifyList = this.list((Wrapper)new LambdaUpdateWrapper().eq(ResClassify::getClassifyType, (Object)classifyType));
        return HussarUtils.copy((Collection)resClassifyList, ParentClassifyVo.class);
    }
}

