/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.file.resource.manager.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.file.resource.dto.AttachmentDecentralizedDto;
import com.jxdinfo.hussar.file.resource.dto.AttachmentDto;
import com.jxdinfo.hussar.file.resource.manager.IAttachmentManager;
import com.jxdinfo.hussar.file.resource.service.IAttachmentService;
import com.jxdinfo.hussar.file.resource.vo.AttachmentVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttachmentManagerImpl
implements IAttachmentManager {
    @Autowired
    private ISysUsersService usersService;
    @Autowired
    private ISysStruService struService;
    @Autowired
    private ISysOrganService organService;
    @Autowired
    private IAttachmentService attachmentService;

    public Page<AttachmentVo> attachementList(AttachmentDto attachmentDto) {
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)currentUser)) {
            return null;
        }
        String tenantCode = currentUser.getTenantCode();
        String tenantConnName = currentUser.getExtendUserMap().get("connName").toString();
        String currentStruId = Optional.ofNullable(currentUser.getDeptId()).map(String::valueOf).orElse(null);
        if (tenantCode == null || tenantCode.isEmpty()) {
            attachmentDto.setStruIds(this.getCurrentStruIds("master"));
            attachmentDto.setCurrentStruId(currentStruId);
            return this.attachmentService.getAccachmentList(attachmentDto);
        }
        attachmentDto.setTenantCode(tenantCode);
        attachmentDto.setStruIds(this.getCurrentStruIds(tenantConnName));
        attachmentDto.setCurrentStruId(currentStruId);
        List uploadPerIds = this.attachmentService.getUploadPerIds("master", attachmentDto.getUploadPerName());
        List tenantUploadPerIds = this.attachmentService.getUploadPerIds(tenantConnName, attachmentDto.getUploadPerName());
        uploadPerIds.addAll(tenantUploadPerIds);
        attachmentDto.setUploadPerIds(uploadPerIds);
        Page resultPage = this.attachmentService.getTenantAttachmentList(attachmentDto);
        List attachmentVoList = resultPage.getRecords();
        this.handleTenantAttachmentVos(attachmentVoList, tenantConnName);
        resultPage.setRecords(attachmentVoList);
        return resultPage;
    }

    public List<Long> getCurrentStruIds(String connName) {
        Long currentUserStruId = null;
        String currentUserStruFid = null;
        List<Long> struIds = new ArrayList<Long>();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (HussarUtils.isNotEmpty((Object)securityUser)) {
            Long l = currentUserStruId = securityUser.getExtendUserMap().get("deptId") != null && !"".equals(securityUser.getExtendUserMap().get("deptId")) ? Long.valueOf(securityUser.getExtendUserMap().get("deptId").toString()) : null;
        }
        if (currentUserStruId != null) {
            currentUserStruFid = ((SysStru)((LambdaQueryChainWrapper)this.struService.lambdaQuery(connName).eq(SysStru::getId, currentUserStruId)).one()).getStruFid();
        }
        if (currentUserStruFid != null) {
            struIds = ((LambdaQueryChainWrapper)this.struService.lambdaQuery(connName).like(SysStru::getStruFid, currentUserStruFid)).list().stream().map(SysStru::getId).collect(Collectors.toList());
        }
        return struIds;
    }

    public Page<AttachmentVo> handleAttachmentVoPage(Page<AttachmentVo> page, String connName) {
        List attachmentVos = page.getRecords();
        Map<Long, AttachmentVo> attachmentVoMap = attachmentVos.stream().collect(Collectors.toMap(AttachmentVo::getFileId, attachmentVo -> attachmentVo));
        HashMap<Long, AttachmentVo> tenantAttachmentVoMap = new HashMap<Long, AttachmentVo>();
        for (Map.Entry<Long, AttachmentVo> attachmentVoEntry : attachmentVoMap.entrySet()) {
            if (attachmentVoEntry.getValue().getUploadPerName() != null && !attachmentVoEntry.getValue().getUploadPerName().isEmpty()) continue;
            tenantAttachmentVoMap.put(attachmentVoEntry.getKey(), attachmentVoEntry.getValue());
        }
        ArrayList<AttachmentVo> tenantAttachmentVos = new ArrayList();
        if (tenantAttachmentVoMap.isEmpty()) {
            return page;
        }
        tenantAttachmentVos = this.attachmentService.getAttachmentListByFileIds(new ArrayList(tenantAttachmentVoMap.keySet()));
        this.handleTenantAttachmentVos(tenantAttachmentVos, connName);
        for (AttachmentVo attachmentVo2 : tenantAttachmentVos) {
            if (!tenantAttachmentVoMap.containsKey(attachmentVo2.getFileId())) continue;
            tenantAttachmentVoMap.put(attachmentVo2.getFileId(), attachmentVo2);
        }
        for (Map.Entry entry : tenantAttachmentVoMap.entrySet()) {
            if (!attachmentVoMap.containsKey(entry.getKey())) continue;
            attachmentVoMap.put((Long)entry.getKey(), (AttachmentVo)entry.getValue());
        }
        page.setRecords(new ArrayList<AttachmentVo>(attachmentVoMap.values()));
        return page;
    }

    public void handleTenantAttachmentVos(List<AttachmentVo> attachmentVos, String connName) {
        List uploadPerIds = attachmentVos.stream().map(AttachmentVo::getUploadPer).filter(HussarUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
        Map uploadPerMap = new HashMap();
        Map uploadTenantPerMap = new HashMap();
        if (HussarUtils.isNotEmpty(uploadPerIds)) {
            uploadPerMap = this.attachmentService.getUploadPerMap("master", uploadPerIds);
            uploadTenantPerMap = this.attachmentService.getUploadPerMap(connName, uploadPerIds);
            uploadPerMap.putAll(uploadTenantPerMap);
        }
        List struIds = attachmentVos.stream().map(AttachmentVo::getDeptName).filter(HussarUtils::isNotEmpty).map(Long::parseLong).collect(Collectors.toList());
        Map deptNameStruMap = new HashMap();
        Map tenantDeptNameStruMap = new HashMap();
        if (HussarUtils.isNotEmpty(struIds)) {
            deptNameStruMap = this.attachmentService.getUploadOrganMap("master", struIds);
            tenantDeptNameStruMap = this.attachmentService.getUploadOrganMap(connName, struIds);
            deptNameStruMap.putAll(tenantDeptNameStruMap);
        }
        for (AttachmentVo attachment : attachmentVos) {
            Long struId;
            Long uploadPerId = attachment.getUploadPer() != null ? Long.valueOf(Long.parseLong(attachment.getUploadPer())) : null;
            Long l = struId = attachment.getDeptName() != null ? Long.valueOf(Long.parseLong(attachment.getDeptName())) : null;
            if (uploadPerMap.containsKey(uploadPerId)) {
                attachment.setUploadPer((String)uploadPerMap.get(uploadPerId));
            }
            if (struId != null && struId == 0L) {
                attachment.setDeptName(null);
                continue;
            }
            if (!deptNameStruMap.containsKey(struId)) continue;
            attachment.setDeptName((String)deptNameStruMap.get(struId));
        }
    }

    public String decentralizeFile(AttachmentDecentralizedDto attachmentDecentralizedDto) {
        if (HussarUtils.isEmpty((Object)attachmentDecentralizedDto.getAttachmentIds())) {
            throw new BaseException("\u65e0\u8981\u88ab\u4e0b\u653e\u7684\u9644\u4ef6");
        }
        if (HussarUtils.isAllEmpty((Object[])new Object[]{attachmentDecentralizedDto.getDecentralizedOrganIds(), attachmentDecentralizedDto.getDecentralizedTenantCodes()})) {
            throw new BaseException("\u65e0\u8981\u4e0b\u653e\u7684\u7ec4\u7ec7\u6216\u5e94\u7528");
        }
        List attachmentUpdatingList = attachmentDecentralizedDto.getAttachmentIds().stream().map(attachmentId -> {
            AttachmentManagerModel attachmentManagerModel = new AttachmentManagerModel();
            attachmentManagerModel.setId(attachmentId);
            attachmentManagerModel.setDecentralizedOrgan(attachmentDecentralizedDto.getDecentralizedOrganIdStr());
            attachmentManagerModel.setDecentralizedApp(attachmentDecentralizedDto.getDecentralizedTenantCodeStr());
            return attachmentManagerModel;
        }).collect(Collectors.toList());
        if (this.attachmentService.updateBatchById(attachmentUpdatingList)) {
            return "\u4e0b\u653e\u6210\u529f\uff01";
        }
        throw new BaseException("\u4e0b\u653e\u5931\u8d25\uff01");
    }
}

