/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.file.resource.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.file.resource.dto.AttachmentDecentralizedDto;
import com.jxdinfo.hussar.file.resource.dto.AttachmentDto;
import com.jxdinfo.hussar.file.resource.dto.ClassifyDto;
import com.jxdinfo.hussar.file.resource.dto.ResFileClassifyDto;
import com.jxdinfo.hussar.file.resource.manager.IAttachmentManager;
import com.jxdinfo.hussar.file.resource.service.ResClassifyService;
import com.jxdinfo.hussar.file.resource.service.ResFileClassifyService;
import com.jxdinfo.hussar.file.resource.vo.AttachmentVo;
import com.jxdinfo.hussar.file.resource.vo.ClassifyTreeVo;
import com.jxdinfo.hussar.file.resource.vo.ParentClassifyVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/resource"})
public class AttachementController {
    @Autowired
    private IAttachmentManager attachmentManager;
    @Autowired
    private ResClassifyService resClassifyService;
    @Autowired
    private ResFileClassifyService resFileClassifyService;

    @PostMapping(value={"/attachmentList"})
    public ApiResponse<Page<AttachmentVo>> attachmentList(@RequestBody AttachmentDto attachmentDto) {
        return ApiResponse.success((Object)this.attachmentManager.attachementList(attachmentDto));
    }

    @PostMapping(value={"/decentralizeFile"})
    public ApiResponse<String> decentralizeFile(@RequestBody AttachmentDecentralizedDto attachmentDecentralizedDto) {
        return ApiResponse.success((String)this.attachmentManager.decentralizeFile(attachmentDecentralizedDto));
    }

    @GetMapping(value={"/queryClassifyTree"})
    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u5206\u7c7b\u6811", notes="\u67e5\u8be2\u8d44\u6e90\u5206\u7c7b\u6811")
    @AuditLog(moduleName="\u67e5\u8be2\u8d44\u6e90\u5206\u7c7b\u6811", eventDesc="\u67e5\u8be2\u8d44\u6e90\u5206\u7c7b\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ClassifyTreeVo>> queryClassifyTree(@RequestParam String classifyType) {
        return ApiResponse.success((Object)this.resClassifyService.queryClassifyTree(classifyType));
    }

    @PostMapping(value={"/addClassify"})
    @ApiOperation(value="\u65b0\u589e\u8d44\u6e90\u5206\u7c7b", notes="\u65b0\u589e\u8d44\u6e90\u5206\u7c7b")
    @AuditLog(moduleName="\u65b0\u589e\u8d44\u6e90\u5206\u7c7b", eventDesc="\u65b0\u589e\u8d44\u6e90\u5206\u7c7b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addClassify(@RequestBody ClassifyDto classifyDto) {
        return ApiResponse.success((Object)this.resClassifyService.addClassify(classifyDto));
    }

    @PostMapping(value={"/updateClassify"})
    @ApiOperation(value="\u4fee\u6539\u8d44\u6e90\u5206\u7c7b", notes="\u4fee\u6539\u8d44\u6e90\u5206\u7c7b")
    @AuditLog(moduleName="\u4fee\u6539\u8d44\u6e90\u5206\u7c7b", eventDesc="\u4fee\u6539\u8d44\u6e90\u5206\u7c7b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updateClassify(@RequestBody ClassifyDto classifyDto) {
        return ApiResponse.success((Object)this.resClassifyService.updateClassify(classifyDto));
    }

    @PostMapping(value={"/delClassify"})
    @ApiOperation(value="\u5220\u9664\u8d44\u6e90\u5206\u7c7b", notes="\u5220\u9664\u8d44\u6e90\u5206\u7c7b")
    @AuditLog(moduleName="\u5220\u9664\u8d44\u6e90\u5206\u7c7b", eventDesc="\u5220\u9664\u8d44\u6e90\u5206\u7c7b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> delClassify(@RequestBody Long id) {
        return ApiResponse.success((Object)this.resClassifyService.delClassify(id));
    }

    @GetMapping(value={"/queryParentClassify"})
    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u7236\u7ea7\u5206\u7c7b", notes="\u67e5\u8be2\u8d44\u6e90\u7236\u7ea7\u5206\u7c7b")
    @AuditLog(moduleName="\u67e5\u8be2\u8d44\u6e90\u7236\u7ea7\u5206\u7c7b", eventDesc="\u67e5\u8be2\u8d44\u6e90\u7236\u7ea7\u5206\u7c7b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ParentClassifyVo>> queryParentClassify(@RequestParam String classifyType) {
        return ApiResponse.success((Object)this.resClassifyService.queryParentClassify(classifyType));
    }

    @PostMapping(value={"/uploadClassifyFile"})
    @ApiOperation(value="\u4e0a\u4f20\u9644\u4ef6\u65f6\u9009\u62e9\u5206\u7c7b", notes="\u4e0a\u4f20\u9644\u4ef6\u65f6\u9009\u62e9\u5206\u7c7b")
    @AuditLog(moduleName="\u4e0a\u4f20\u9644\u4ef6\u65f6\u9009\u62e9\u5206\u7c7b", eventDesc="\u4e0a\u4f20\u9644\u4ef6\u65f6\u9009\u62e9\u5206\u7c7b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> uploadClassifyFile(@RequestBody List<ResFileClassifyDto> resFileClassifyDtos) {
        return ApiResponse.success((Object)this.resFileClassifyService.uploadClassifyFile(resFileClassifyDtos));
    }

    @PostMapping(value={"/editClassifyFile"})
    @ApiOperation(value="\u7f16\u8f91\u9644\u4ef6", notes="\u7f16\u8f91\u9644\u4ef6")
    @AuditLog(moduleName="\u7f16\u8f91\u9644\u4ef6", eventDesc="\u7f16\u8f91\u9644\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> editClassifyFile(@RequestBody ResFileClassifyDto resFileClassifyDto) {
        return ApiResponse.success((Object)this.resFileClassifyService.editClassifyFile(resFileClassifyDto));
    }

    @PostMapping(value={"/delClassifyFile"})
    @ApiOperation(value="\u5220\u9664\u9644\u4ef6\u5206\u7c7b\u5173\u8054\u4fe1\u606f", notes="\u5220\u9664\u9644\u4ef6\u5206\u7c7b\u5173\u8054\u4fe1\u606f")
    @AuditLog(moduleName="\u5220\u9664\u9644\u4ef6\u5206\u7c7b\u5173\u8054\u4fe1\u606f", eventDesc="\u5220\u9664\u9644\u4ef6\u5206\u7c7b\u5173\u8054\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> delClassifyFile(@RequestBody Long fileId) {
        return ApiResponse.success((Object)this.resFileClassifyService.delClassifyFile(fileId));
    }

    @GetMapping(value={"/queryAllClassify"})
    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5206\u7c7b", notes="\u67e5\u8be2\u6240\u6709\u5206\u7c7b")
    @AuditLog(moduleName="\u67e5\u8be2\u6240\u6709\u5206\u7c7b", eventDesc="\u67e5\u8be2\u6240\u6709\u5206\u7c7b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ParentClassifyVo>> queryAllClassify(@RequestParam String classifyType) {
        return ApiResponse.success((Object)this.resClassifyService.queryAllClassify(classifyType));
    }
}

