/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.dao.SysExcelTaskMapper;
import com.jxdinfo.hussar.excel.dto.ExcelImportTaskDto;
import com.jxdinfo.hussar.excel.dto.ExcelTaskDto;
import com.jxdinfo.hussar.excel.enums.TipConstantsEnum;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.model.SysExcelTaskVo;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.template.print.enums.TemplateEnum;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.excel.service.impl.sysExcelTaskServiceImpl")
public class SysExcelTaskServiceImpl
extends HussarServiceImpl<SysExcelTaskMapper, SysExcelTask>
implements ISysExcelTaskService {
    @Resource
    private SysExcelTaskMapper sysExcelTaskMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Resource
    private ISysDicRefService sysDicRefService;
    private static final String SECURITY_LEVEL = "security_level";

    public Long newExcelTask(Integer excelType, String taskType) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysExcelTask sysExcelTask = new SysExcelTask();
        long taskId = IdWorker.getId((Object)sysExcelTask);
        sysExcelTask.setId(Long.valueOf(taskId));
        sysExcelTask.setExcelType(excelType);
        sysExcelTask.setTaskType(taskType);
        sysExcelTask.setCreateName(securityUser.getUserName());
        sysExcelTask.setCreator(securityUser.getId());
        if (!this.save((BaseEntity)sysExcelTask)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_TASK_FAIL.getMessage()));
        }
        return taskId;
    }

    public Long newExcelTaskWithSecurity(Integer excelType, String taskType, String securityLevel) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysExcelTask sysExcelTask = new SysExcelTask();
        long taskId = IdWorker.getId((Object)sysExcelTask);
        sysExcelTask.setId(Long.valueOf(taskId));
        sysExcelTask.setExcelType(excelType);
        sysExcelTask.setTaskType(taskType);
        sysExcelTask.setCreateName(securityUser.getUserName());
        sysExcelTask.setCreator(securityUser.getId());
        Integer secLevel = HussarUtils.isNotEmpty((Object)securityLevel) ? Integer.valueOf(securityLevel) : null;
        sysExcelTask.setSecurityLevel(secLevel);
        if (!this.save((BaseEntity)sysExcelTask)) {
            throw new HussarException("\u4efb\u52a1\u751f\u6210\u5931\u8d25\uff01");
        }
        return taskId;
    }

    public Page<SysExcelTask> getExcelTaskList(PageInfo pageInfo, ExcelTaskDto excelTaskDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_PAGE_EMPTY.getMessage()));
        }
        excelTaskDto.setCreateName(SqlQueryUtil.transferSpecialChar((String)excelTaskDto.getCreateName()));
        page.setRecords(this.sysExcelTaskMapper.selectExcelTaskList(page, excelTaskDto));
        return page;
    }

    public Page<SysExcelTaskVo> getExcelTaskVoList(PageInfo pageInfo, ExcelTaskDto excelTaskDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        excelTaskDto.setCreateName(SqlQueryUtil.transferSpecialChar((String)excelTaskDto.getCreateName()));
        List<SysExcelTaskVo> sysExcelTaskVos = this.sysExcelTaskMapper.selectExcelTaskVoList(page, excelTaskDto);
        List secDicList = this.sysDicRefService.getDictByType(SECURITY_LEVEL);
        Map<String, String> secDicMap = secDicList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        for (SysExcelTaskVo sysExcelTaskVo : sysExcelTaskVos) {
            if (!HussarUtils.isNotEmpty((Object)sysExcelTaskVo.getSecurityLevel())) continue;
            sysExcelTaskVo.setSecurityLevelLabel(secDicMap.get(String.valueOf(sysExcelTaskVo.getSecurityLevel())));
        }
        page.setRecords(sysExcelTaskVos);
        return page;
    }

    public boolean batchDeleteTask(String taskId) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_RECORD_DELETE_NOT_EMPTY.getMessage()));
        }
        List<String> idList = Arrays.asList(taskId.split(","));
        List idLongList = idList.stream().map(Long::valueOf).collect(Collectors.toList());
        List tasks = this.sysExcelTaskMapper.selectBatchIds(idLongList);
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        for (SysExcelTask sysExcelTask : tasks) {
            if (HussarUtils.isNotEmpty((Object)sysExcelTask.getTaskFile())) {
                fileIdList.add(sysExcelTask.getTaskFile());
            }
            if (!HussarUtils.isNotEmpty((Object)sysExcelTask.getCheckFile())) continue;
            fileIdList.add(sysExcelTask.getCheckFile());
        }
        int result = this.sysExcelTaskMapper.deleteBatchIds(idLongList);
        if (result < 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return true;
    }

    public SysExcelTask getExcelTaskById(Long taskId) {
        return (SysExcelTask)this.sysExcelTaskMapper.selectById(taskId);
    }

    public SysExcelTask getExcelTaskByFileId(Long fileId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysExcelTask::getTaskFile, (Object)fileId)).or()).eq(SysExcelTask::getCheckFile, (Object)fileId);
        SysExcelTask sysExcelTask = (SysExcelTask)this.iSysExcelTaskService.getOne((Wrapper)lambdaQueryWrapper);
        return sysExcelTask;
    }

    public Long newExcelImportTask(ExcelImportTaskDto excelImportTaskDto) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysExcelTask sysExcelTask = new SysExcelTask();
        sysExcelTask.setExcelName(excelImportTaskDto.getTemplateName());
        sysExcelTask.setBusinessId(excelImportTaskDto.getBusinessId());
        sysExcelTask.setExcelType(excelImportTaskDto.getExcelType());
        sysExcelTask.setTaskType(excelImportTaskDto.getTaskType());
        sysExcelTask.setCreateName(securityUser.getUserName());
        if (!this.save((BaseEntity)sysExcelTask)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)TemplateEnum.TASK_GENERATION_FAILED.getMessage()));
        }
        return sysExcelTask.getId();
    }
}

