/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.service.impl;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.builder.I18nHeaderBuilder;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.enums.TipConstantsEnum;
import com.jxdinfo.hussar.excel.listener.HussarBaseExcelListener;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.model.TplSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.excel.util.MergeExcelSheetUtil;
import com.jxdinfo.hussar.lang.enums.LangEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.beans.ClassPathResource;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.excel.service.impl.hussarBaseImportExcelServiceImpl")
public class HussarBaseExcelServiceImpl
implements IHussarBaseExcelService {
    public static final String SYSTEM_TEMP_PATH = "java.io.tmpdir";
    public static final String XLSX_SUFFIX = ".xlsx";
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseExcelServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService excelTaskService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;

    public void exportExcelByClass(List<ClassSheetMsg> classSheetMsgs, String excelName, Long taskId) {
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        CompletableFuture.runAsync(() -> {
            if (HussarUtils.isNotEmpty((Object)classSheetMsgs)) {
                Object fileOutputStream = null;
                try {
                    ArrayList<String> tempFileNames = new ArrayList<String>();
                    for (ClassSheetMsg classSheetMsg : classSheetMsgs) {
                        String dir = System.getProperty(SYSTEM_TEMP_PATH);
                        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
                        this.makeClassSheetFile(tempFileName, classSheetMsg, task);
                        tempFileNames.add(tempFileName);
                    }
                    String dir = System.getProperty(SYSTEM_TEMP_PATH);
                    String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
                    MergeExcelSheetUtil.mergeExcel(tempFileNames, (String)tempFileName);
                    Long ossId = this.sendFileToOss(tempFileName);
                    task.setTaskFile(ossId);
                    task.setFileName(excelName);
                    task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_SUCCESS.getMessage()));
                    task.setTaskStatus(Integer.valueOf(8));
                    this.excelTaskService.updateById((Object)task);
                }
                catch (Exception e) {
                    task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION.getMessage()) + e.getMessage());
                    task.setTaskStatus(Integer.valueOf(9));
                    this.excelTaskService.updateById((Object)task);
                    throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION_EXCEL.getMessage()), e);
                }
            } else {
                task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_DATASET_EMPTY.getMessage()));
                task.setTaskStatus(Integer.valueOf(9));
                this.excelTaskService.updateById((Object)task);
                throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION_EXCEL.getMessage()) + TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_DATASET_EMPTY.getMessage()));
            }
        }, hussarBaseExcelExecutor);
    }

    public void exportExcelByTpl(List<TplSheetMsg> tplSheetMsgs, String excelName, Long taskId) {
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        CompletableFuture.runAsync(() -> {
            if (HussarUtils.isNotEmpty((Object)tplSheetMsgs)) {
                try {
                    ArrayList<String> tempFileNames = new ArrayList<String>();
                    for (TplSheetMsg tplSheetMsg : tplSheetMsgs) {
                        String dir = System.getProperty(SYSTEM_TEMP_PATH);
                        String tempFileNameForTpl = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
                        this.makeTplSheetFile(tempFileNameForTpl, tplSheetMsg, task);
                        tempFileNames.add(tempFileNameForTpl);
                    }
                    String dir = System.getProperty(SYSTEM_TEMP_PATH);
                    String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + XLSX_SUFFIX;
                    MergeExcelSheetUtil.mergeExcel(tempFileNames, (String)tempFileName);
                    Long ossId = this.sendFileToOss(tempFileName);
                    task.setTaskFile(ossId);
                    task.setFileName(excelName);
                    task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_SUCCESS.getMessage()));
                    task.setTaskStatus(Integer.valueOf(8));
                    this.excelTaskService.updateById((Object)task);
                }
                catch (Exception e) {
                    task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION.getMessage()) + e.getMessage());
                    task.setTaskStatus(Integer.valueOf(9));
                    this.excelTaskService.updateById((Object)task);
                    throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION_EXCEL.getMessage()) + e.getMessage(), e);
                }
            } else {
                task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_DATASET_EMPTY.getMessage()));
                task.setTaskStatus(Integer.valueOf(9));
                this.excelTaskService.updateById((Object)task);
                throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION_EXCEL.getMessage()) + TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_DATASET_EMPTY.getMessage()));
            }
        }, hussarBaseExcelExecutor);
    }

    public void makeClassSheetFile(String tempFileName, ClassSheetMsg classSheetMsg, SysExcelTask task) {
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFileName);){
            HussarBaseExcelWriteUtils.writeClassSheet((FileOutputStream)fileOutputStream, (ClassSheetMsg)classSheetMsg);
        }
        catch (Exception e) {
            task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION.getMessage()) + e.getMessage());
            task.setTaskStatus(Integer.valueOf(9));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FILE_PROCESS_ERROR.getMessage()) + e.getMessage(), e);
        }
    }

    public void makeI18nClassSheetFile(String tempFileName, ClassSheetMsg classSheetMsg, SysExcelTask task) {
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(tempFileName);
            HussarBaseExcelWriteUtils.writeI18nClassSheet((FileOutputStream)fileOutputStream, (ClassSheetMsg)classSheetMsg, (I18nHeaderBuilder)new I18nHeaderBuilder());
            fileOutputStream.close();
        }
        catch (Exception e) {
            String errorMsg = TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION.getMessage()) + e.getMessage();
            task.setShowMsg(errorMsg);
            task.setTaskStatus(Integer.valueOf(9));
            this.excelTaskService.updateById((Object)task);
            LOGGER.error("\u56fd\u9645\u5316Excel\u5bfc\u51fa\u5931\u8d25: {}", (Object)errorMsg, (Object)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FILE_PROCESS_ERROR.getMessage()) + e.getMessage(), (Throwable)e);
        }
        finally {
            if (fileOutputStream != null) {
                HussarUtils.closeQuietly((Closeable)fileOutputStream);
            }
        }
    }

    public void makeTplSheetFile(String tempFileName, TplSheetMsg tplSheetMsg, SysExcelTask task) {
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFileName);){
            HussarBaseExcelWriteUtils.writeTplSheet((FileOutputStream)fileOutputStream, (TplSheetMsg)tplSheetMsg);
        }
        catch (Exception e) {
            task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_EXPORT_EXCEPTION.getMessage()) + e.getMessage());
            task.setTaskStatus(Integer.valueOf(9));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FILE_PROCESS_ERROR.getMessage()) + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImportTpl(HttpServletResponse response, String downLoadFileName, String tplFileName) {
        InputStream inputStream = null;
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("multipart/form-data");
            downLoadFileName = this.protectionStatusConfigBoService.isFenBaoEnable() != false ? URLEncoder.encode("\uff08" + TranslateUtil.getTranslateName((String)TipConstantsEnum.TRANSLATE_DICT_CONSTANT_PUBLIC.getMessage()) + "\uff09" + "-" + downLoadFileName + XLSX_SUFFIX, "UTF-8") : URLEncoder.encode(downLoadFileName + XLSX_SUFFIX, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            tplFileName = HussarUtils.isEmpty((Object)tplFileName) ? "userImportTpl" : tplFileName;
            Locale locale = LocaleContextHolder.getLocale();
            String lang = locale.toLanguageTag();
            String langModify = lang.replace("-", "").toUpperCase();
            if (!LangEnum.ZH_CN.getLangValue().equals(lang)) {
                if (HussarUtils.isEmpty((Object)tplFileName)) {
                    tplFileName = "userImportTpl" + langModify;
                    ExcelConstants.TemplateMap.put(tplFileName, "static/" + tplFileName + XLSX_SUFFIX);
                } else {
                    tplFileName = tplFileName + langModify;
                    ExcelConstants.TemplateMap.put(tplFileName, "static/" + tplFileName + XLSX_SUFFIX);
                }
            }
            ClassPathResource resource = new ClassPathResource((String)ExcelConstants.TemplateMap.get(tplFileName));
            inputStream = resource.getStream();
            Workbook workbook = HussarBaseExcelWriteUtils.judegExcelEdition((String)downLoadFileName, (InputStream)inputStream);
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("inputStream close IOException:" + e.getMessage());
                }
            }
        }
    }

    public Map checkExcelSheets(InputStream inputStream, List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, Map<String, Integer> excludeColumnIndexesMap) {
        return this.checkExcelSheets(inputStream, importSheetMsgs, scenario, taskId, excludeColumnIndexesMap, new HashMap<Integer, List<String>>());
    }

    public Map checkExcelSheets(InputStream input, List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) {
        return this.checkExcelSheets(input, importSheetMsgs, scenario, taskId, null, excludeColumnIndexesMap, selectParamMap);
    }

    public Map checkExcelSheets(InputStream input, List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, List<Object> otherParams, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) {
        LinkedHashMap<String, Object> checkMessageMap = new LinkedHashMap<String, Object>();
        checkMessageMap.put("taskId", taskId.toString());
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setCheckScenario(scenario);
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_VERIFICATION_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(1));
        this.excelTaskService.updateById((Object)task);
        try {
            int len;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((len = input.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
            ByteArrayInputStream inputStreamA = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ByteArrayInputStream inputStreamB = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)inputStreamA).build();
            List readSheets = EasyExcelFactory.read((InputStream)inputStreamB).build().excelExecutor().sheetList();
            if (HussarUtils.isNotEmpty((Object)readSheets)) {
                LinkedList<JSONObject> checkMessageList = new LinkedList<JSONObject>();
                for (int i = 0; i < importSheetMsgs.size(); ++i) {
                    HussarBaseExcelListener easyExcelListener = new HussarBaseExcelListener(task, otherParams, this.excelTaskService, this.ossService, importSheetMsgs.get(i).getCustomExcelServiceImpl(), importSheetMsgs.get(i).getClazz(), scenario, excludeColumnIndexesMap, selectParamMap);
                    ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)importSheetMsgs.get(i).getSheetNo()).registerReadListener(easyExcelListener)).headRowNumber(Integer.valueOf(0))).build();
                    readSheet.setClazz(importSheetMsgs.get(i).getClazz());
                    excelReader.read(new ReadSheet[]{readSheet});
                    JSONObject checkMessage = new JSONObject();
                    if ("1".equals(scenario)) {
                        checkMessage = easyExcelListener.getInitNum();
                    } else if ("2".equals(scenario)) {
                        checkMessage = easyExcelListener.getNotInitNum();
                    }
                    String sheetName = ((ReadSheet)readSheets.get(i)).getSheetName();
                    checkMessage.put("sheetName", (Object)sheetName);
                    checkMessageList.add(checkMessage);
                }
                checkMessageMap.put("checkMessages", checkMessageList);
                task.setCheckResult(((Object)checkMessageMap).toString());
                this.excelTaskService.updateById((Object)task);
            }
            excelReader.finish();
            ((InputStream)inputStreamA).close();
            ((InputStream)inputStreamB).close();
            input.close();
        }
        catch (Exception e) {
            task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_VERIFICATION_EXCEPTION.getMessage()) + e.getMessage());
            task.setTaskStatus(Integer.valueOf(3));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_EXCEPTION_EXCEL.getMessage()) + e.getMessage(), (Throwable)e);
        }
        return checkMessageMap;
    }

    public void importExcelSheets(List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, Map<String, Integer> excludeColumnIndexesMap) {
        this.importExcelSheets(importSheetMsgs, scenario, taskId, null, excludeColumnIndexesMap);
    }

    public void importExcelSheets(List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, List<Object> otherParams, Map<String, Integer> excludeColumnIndexesMap) {
        SysExcelTask task = this.excelTaskService.getExcelTaskById(taskId);
        Long taskFileId = task.getTaskFile();
        ApiResponse oss = this.ossService.backgroundDownload(taskFileId);
        byte[] data = (byte[])oss.getData();
        HussarBaseMultipartFile file = new HussarBaseMultipartFile("TemporaryFile.xlsx".replace(XLSX_SUFFIX, ""), "TemporaryFile.xlsx".replace(XLSX_SUFFIX, ""), "application/octet-stream", data);
        task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_PROGRESS.getMessage()));
        task.setTaskStatus(Integer.valueOf(4));
        this.excelTaskService.updateById((Object)task);
        try {
            InputStream inputStream = file.getInputStream();
            ExcelReader excelReader = EasyExcelFactory.read((InputStream)inputStream).build();
            for (int i = 0; i < importSheetMsgs.size(); ++i) {
                HussarBaseExcelListener easyExcelListener = new HussarBaseExcelListener(task, otherParams, this.excelTaskService, this.ossService, importSheetMsgs.get(i).getCustomExcelServiceImpl(), importSheetMsgs.get(i).getClazz(), scenario, excludeColumnIndexesMap, null);
                ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcelFactory.readSheet((Integer)importSheetMsgs.get(i).getSheetNo()).registerReadListener(easyExcelListener)).headRowNumber(Integer.valueOf(0))).build();
                readSheet.setClazz(importSheetMsgs.get(i).getClazz());
                excelReader.read(new ReadSheet[]{readSheet});
            }
            excelReader.finish();
            inputStream.close();
        }
        catch (Exception e) {
            task.setShowMsg(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_EXCEPTION.getMessage()) + e.getMessage());
            task.setTaskStatus(Integer.valueOf(6));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new RuntimeException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_IMPORT_EXCEPTION_EXCEL.getMessage()) + e.getMessage(), e);
        }
    }

    public void downloadExcelFile(Long fileId, HttpServletResponse response) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        SysExcelTask sysExcelTask = this.excelTaskService.getExcelTaskByFileId(fileId);
        if (apiResponse == null || !apiResponse.isSuccess()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_FILE_DOWNLOAD_FAIL.getMessage()));
        }
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = sysExcelTask.getFileName();
            if (fileId.equals(sysExcelTask.getCheckFile())) {
                fileName = fileName.substring(0, fileName.length() - 5) + TranslateUtil.getTranslateName((String)TipConstantsEnum.EXCEL_VERIFICATION_RESULT.getMessage()) + XLSX_SUFFIX;
            }
            if ((fileName = URLEncoder.encode(fileName, "UTF-8")).contains("+")) {
                fileName = fileName.replace("+", "%20");
            }
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.write((byte[])((byte[])apiResponse.getData()), (OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long sendFileToOss(String fileName) {
        try (FileInputStream fileInputStream = new FileInputStream(fileName);){
            Long ossId;
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile("TemporaryFile.xlsx".replace(XLSX_SUFFIX, ""), "TemporaryFile.xlsx".replace(XLSX_SUFFIX, ""), "application/octet-stream", (InputStream)fileInputStream);
            ApiResponse ossResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            Long l = ossId = (Long)ossResponse.getData();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

