/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.dao.SysExcelTaskMapper;
import com.jxdinfo.hussar.excel.dto.ExcelTaskDto;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.excel.service.impl.sysExcelTaskServiceImpl")
public class SysExcelTaskServiceImpl
extends HussarServiceImpl<SysExcelTaskMapper, SysExcelTask>
implements ISysExcelTaskService {
    @Resource
    private SysExcelTaskMapper sysExcelTaskMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;

    public Long newExcelTask(Integer excelType, String taskType) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysExcelTask sysExcelTask = new SysExcelTask();
        long taskId = IdWorker.getId((Object)sysExcelTask);
        sysExcelTask.setId(Long.valueOf(taskId));
        sysExcelTask.setExcelType(excelType);
        sysExcelTask.setTaskType(taskType);
        sysExcelTask.setCreateName(securityUser.getUserName());
        sysExcelTask.setCreator(securityUser.getId());
        if (!this.save((BaseEntity)sysExcelTask)) {
            throw new HussarException("\u4efb\u52a1\u751f\u6210\u5931\u8d25\uff01");
        }
        return taskId;
    }

    public Page<SysExcelTask> getExcelTaskList(PageInfo pageInfo, ExcelTaskDto excelTaskDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        excelTaskDto.setCreateName(SqlQueryUtil.transferSpecialChar((String)excelTaskDto.getCreateName()));
        page.setRecords(this.sysExcelTaskMapper.selectExcelTaskList(page, excelTaskDto));
        return page;
    }

    public boolean batchDeleteTask(String taskId) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u64cd\u4f5c\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> idList = Arrays.asList(taskId.split(","));
        List idLongList = idList.stream().map(Long::valueOf).collect(Collectors.toList());
        List tasks = this.sysExcelTaskMapper.selectBatchIds(idLongList);
        ArrayList<Long> fileIdList = new ArrayList<Long>();
        for (SysExcelTask sysExcelTask : tasks) {
            if (HussarUtils.isNotEmpty((Object)sysExcelTask.getTaskFile())) {
                fileIdList.add(sysExcelTask.getTaskFile());
            }
            if (!HussarUtils.isNotEmpty((Object)sysExcelTask.getCheckFile())) continue;
            fileIdList.add(sysExcelTask.getCheckFile());
        }
        int result = this.sysExcelTaskMapper.deleteBatchIds(idLongList);
        if (result < 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return true;
    }

    public SysExcelTask getExcelTaskById(Long taskId) {
        return (SysExcelTask)this.sysExcelTaskMapper.selectById(taskId);
    }

    public SysExcelTask getExcelTaskByFileId(Long fileId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysExcelTask::getTaskFile, (Object)fileId)).or()).eq(SysExcelTask::getCheckFile, (Object)fileId);
        SysExcelTask sysExcelTask = (SysExcelTask)this.iSysExcelTaskService.getOne((Wrapper)lambdaQueryWrapper);
        return sysExcelTask;
    }
}

