/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.listener;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.handler.CommentErrorWriteHandler;
import com.jxdinfo.hussar.excel.handler.CommentNewWriteHandler;
import com.jxdinfo.hussar.excel.handler.CommentUpdateWriteHandler;
import com.jxdinfo.hussar.excel.handler.DataValidationSheetWriteHandler;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.web.multipart.MultipartFile;

public class HussarBaseExcelListener<T>
extends AnalysisEventListener<T> {
    private SysExcelTask task;
    private List<Object> otherParams;
    private List rootDataList = new ArrayList();
    private List successDataList = new ArrayList();
    private List<ExcelImportMsg<T>> errDataList = new ArrayList<ExcelImportMsg<T>>();
    private List<ExcelImportMsg<T>> newDataList = new ArrayList<ExcelImportMsg<T>>();
    private List<ExcelImportMsg<T>> updateDataList = new ArrayList<ExcelImportMsg<T>>();
    private List<ExcelImportMsg<T>> existDataList = new ArrayList<ExcelImportMsg<T>>();
    private Object customExcelCheckResult = null;
    private ISysExcelTaskService excelTaskService;
    private IHussarBaseCustomExcelService customExcelService;
    private OssService ossService;
    private List list = new ArrayList();
    private Class<T> clazz;
    private Map<Integer, String> indexNameMap;
    private int headLineNumber = 0;
    private int lineNumber = 0;
    private String scenario;
    private Long checkFile;
    private final Map<String, Integer> excludeColumnIndexesMap;
    private Map<Integer, List<String>> selectParamMap;

    public HussarBaseExcelListener(SysExcelTask task, List<Object> otherParams, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService customExcelService, Class clazz, String scenario, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) throws NoSuchFieldException {
        this.task = task;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.customExcelService = customExcelService;
        this.clazz = clazz;
        this.scenario = scenario;
        this.indexNameMap = this.getIndexNameMap(clazz);
        this.excludeColumnIndexesMap = excludeColumnIndexesMap;
        this.selectParamMap = selectParamMap;
        this.otherParams = otherParams;
    }

    public HussarBaseExcelListener(SysExcelTask task, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService customExcelService, Class clazz, String scenario, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) throws NoSuchFieldException {
        this.task = task;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.customExcelService = customExcelService;
        this.clazz = clazz;
        this.scenario = scenario;
        this.indexNameMap = this.getIndexNameMap(clazz);
        this.excludeColumnIndexesMap = excludeColumnIndexesMap;
        this.selectParamMap = selectParamMap;
    }

    public HussarBaseExcelListener(SysExcelTask task, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService customExcelService, Class clazz, String scenario, Map<String, Integer> excludeColumnIndexesMap) throws NoSuchFieldException {
        this.task = task;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.customExcelService = customExcelService;
        this.clazz = clazz;
        this.scenario = scenario;
        this.indexNameMap = this.getIndexNameMap(clazz);
        this.excludeColumnIndexesMap = excludeColumnIndexesMap;
    }

    public void invoke(T data, AnalysisContext context) {
        ++this.lineNumber;
        Map indexDataMap = HussarUtils.toMap(data);
        ArrayList<String> indexNameList = new ArrayList<String>(this.indexNameMap.values());
        ArrayList rowDataList = new ArrayList(indexDataMap.values());
        for (int i = 0; i < rowDataList.size(); ++i) {
            String cellData = (String)rowDataList.get(i);
            if (cellData != null && cellData.contains("*")) {
                cellData = cellData.replace("*", "");
                rowDataList.set(i, cellData);
                continue;
            }
            if (cellData != null) continue;
            rowDataList.remove(i);
            --i;
        }
        if (HussarUtils.equals((Object)0, (Object)this.headLineNumber) && rowDataList.size() > 1) {
            for (Map.Entry<String, Integer> entry : this.excludeColumnIndexesMap.entrySet()) {
                if (rowDataList.contains(entry.getKey())) continue;
                rowDataList.add(entry.getValue(), entry.getKey());
            }
        }
        if (indexNameList.equals(rowDataList)) {
            this.headLineNumber = this.lineNumber;
        }
        this.list.add(data);
    }

    @HussarTransactional
    public void doAfterAllAnalysed(AnalysisContext context) {
        block13: {
            if (this.headLineNumber == 0) {
                this.task.setShowMsg("\u89e3\u6790excel\u51fa\u9519\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u683c\u5f0f\u7684excel");
                this.task.setTaskStatus(Integer.valueOf(3));
                this.excelTaskService.updateById((Object)this.task);
                throw new BaseException("\u89e3\u6790excel\u51fa\u9519\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u683c\u5f0f\u7684excel");
            }
            this.list.subList(0, this.headLineNumber).clear();
            List handleDataList = this.customExcelService.handleDataBeforeImport(this.list, this.task.getId());
            if (!HussarUtils.isNull((Object)handleDataList)) {
                this.list = handleDataList;
            }
            try {
                if (this.list.size() != 0) {
                    ExcelCheckResult result = this.customExcelService.check(this.list, this.task.getId(), this.otherParams);
                    this.rootDataList = result.getRootDatas();
                    this.successDataList = result.getSuccessDatas();
                    this.errDataList = result.getErrDatas();
                    this.newDataList = result.getNewDatas();
                    this.existDataList = result.getExistDatas();
                    this.updateDataList = result.getUpdateDatas();
                    this.customExcelCheckResult = result.getCheckMsg();
                    if (HussarUtils.isNotEmpty(this.errDataList)) {
                        this.makeErrMsgExcel(this.task, this.errDataList);
                        this.task.setTaskStatus(Integer.valueOf(3));
                        this.task.setShowMsg("\u5bfc\u5165\u6587\u4ef6\u586b\u5199\u9519\u8bef");
                        this.excelTaskService.updateById((Object)this.task);
                    } else if ("1".equals(this.scenario)) {
                        if (this.newDataList.size() != 0 || this.existDataList.size() != 0) {
                            this.makeNewAndExistMsgExcel(this.task, this.newDataList, this.existDataList);
                        }
                        this.task.setShowMsg("\u5bfc\u5165\u6821\u9a8c\u901a\u8fc7");
                        this.task.setTaskStatus(Integer.valueOf(2));
                        this.excelTaskService.updateById((Object)this.task);
                    } else if ("2".equals(this.scenario)) {
                        if (this.newDataList.size() != 0 || this.updateDataList.size() != 0 || this.existDataList.size() != 0) {
                            this.makeNewAndUpdateMsgExcel(this.task, this.newDataList, this.updateDataList, this.existDataList);
                        }
                        this.task.setShowMsg("\u5bfc\u5165\u6821\u9a8c\u901a\u8fc7");
                        this.task.setTaskStatus(Integer.valueOf(2));
                        this.excelTaskService.updateById((Object)this.task);
                    } else {
                        this.saveOrUpdate(this.task);
                    }
                    break block13;
                }
                this.task.setTaskStatus(Integer.valueOf(3));
                this.task.setShowMsg("excel\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a");
                this.excelTaskService.updateById((Object)this.task);
                throw new BaseException("excel\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a");
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        this.list.clear();
    }

    public void saveOrUpdate(SysExcelTask task) {
        List newData;
        HussarFixedCacheUtil.evict((String)"excel_check_info", (Object)("hussar-excel" + task.getId() + ":checkResult"));
        if ("3".equals(this.scenario)) {
            if (this.newDataList.size() != 0) {
                newData = this.newDataList.stream().map(ExcelImportMsg::getObject).collect(Collectors.toList());
                this.customExcelService.saveData(newData, this.otherParams);
            }
            task.setShowMsg("\u5bfc\u5165\u6210\u529f");
            task.setTaskStatus(Integer.valueOf(5));
            this.excelTaskService.updateById((Object)task);
        }
        if ("4".equals(this.scenario)) {
            if (this.newDataList.size() != 0) {
                newData = this.newDataList.stream().map(ExcelImportMsg::getObject).collect(Collectors.toList());
                this.customExcelService.saveData(newData, this.otherParams);
            }
            if (this.updateDataList.size() != 0) {
                List updateData = this.updateDataList.stream().map(ExcelImportMsg::getObject).collect(Collectors.toList());
                this.customExcelService.updateData(updateData, this.otherParams);
            }
            task.setShowMsg("\u5bfc\u5165\u6210\u529f");
            task.setTaskStatus(Integer.valueOf(5));
            this.excelTaskService.updateById((Object)task);
        }
    }

    private void makeErrMsgExcel(SysExcelTask task, List<ExcelImportMsg<T>> errorList) throws IOException {
        List<Map<Integer, Map<Integer, String>>> errorMsgList = errorList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
        String dir = System.getProperty("java.io.tmpdir");
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
        FileOutputStream os = new FileOutputStream(tempFileName);
        List<Map<String, String>> commentList = HussarBaseExcelListener.writeHandlerList(errorMsgList, "\u9519\u8bef\u6570\u636e\u4fe1\u606f");
        CommentErrorWriteHandler commentErrorWriteHandler = new CommentErrorWriteHandler(commentList, "xlsx");
        ArrayList<Object> writeHandlerList = new ArrayList<Object>();
        writeHandlerList.add(commentErrorWriteHandler);
        if (HussarUtils.isNotEmpty(this.selectParamMap)) {
            writeHandlerList.add(new DataValidationSheetWriteHandler(this.selectParamMap));
        }
        HussarBaseExcelWriteUtils.writeMsgExcel((OutputStream)os, (List)this.rootDataList, this.clazz, writeHandlerList, (String)"\u9519\u8bef\u6570\u636e\u4fe1\u606f");
        FileInputStream inputStream = new FileInputStream(tempFileName);
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(".xlsx", ""), tempFileName.replace(".xlsx", ""), "application/octet-stream", (InputStream)inputStream);
        ApiResponse errorFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        this.checkFile = (Long)errorFileResponse.getData();
        task.setCheckFile(this.checkFile);
    }

    private void makeNewAndExistMsgExcel(SysExcelTask task, List<ExcelImportMsg<T>> newList, List<ExcelImportMsg<T>> existList) throws IOException {
        ArrayList<Object> writeHandlerList = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty(newList)) {
            List<Map<Integer, Map<Integer, String>>> newMsgList = newList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
            List<Map<String, String>> newCommentList = HussarBaseExcelListener.writeHandlerList(newMsgList, "\u6807\u8bb0\u65b0\u589e\u548c\u5df2\u5b58\u5728\u6570\u636e\u4fe1\u606f");
            CommentNewWriteHandler commentNewWriteHandler = new CommentNewWriteHandler(newCommentList, "xlsx");
            writeHandlerList.add(commentNewWriteHandler);
        }
        String dir = System.getProperty("java.io.tmpdir");
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
        FileOutputStream os = new FileOutputStream(tempFileName);
        if (HussarUtils.isNotEmpty(this.selectParamMap)) {
            writeHandlerList.add(new DataValidationSheetWriteHandler(this.selectParamMap));
        }
        HussarBaseExcelWriteUtils.writeMsgExcel((OutputStream)os, (List)this.rootDataList, this.clazz, writeHandlerList, (String)"\u6807\u8bb0\u65b0\u589e\u548c\u5df2\u5b58\u5728\u6570\u636e\u4fe1\u606f");
        FileInputStream inputStream = new FileInputStream(tempFileName);
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(".xlsx", ""), tempFileName.replace(".xlsx", ""), "application/octet-stream", (InputStream)inputStream);
        ApiResponse checkFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        task.setCheckFile((Long)checkFileResponse.getData());
        this.checkFile = (Long)checkFileResponse.getData();
    }

    private void makeNewAndUpdateMsgExcel(SysExcelTask task, List<ExcelImportMsg<T>> newList, List<ExcelImportMsg<T>> updateList, List<ExcelImportMsg<T>> existList) throws IOException {
        ArrayList<Object> writeHandlerList = new ArrayList<Object>();
        if (HussarUtils.isNotEmpty(newList)) {
            List<Map<Integer, Map<Integer, String>>> newMsgList = newList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
            List<Map<String, String>> newCommentList = HussarBaseExcelListener.writeHandlerList(newMsgList, "\u6807\u8bb0\u65b0\u589e\u548c\u66f4\u65b0\u6570\u636e\u4fe1\u606f");
            CommentNewWriteHandler commentNewWriteHandler = new CommentNewWriteHandler(newCommentList, "xlsx");
            writeHandlerList.add(commentNewWriteHandler);
        }
        if (HussarUtils.isNotEmpty(this.selectParamMap)) {
            writeHandlerList.add(new DataValidationSheetWriteHandler(this.selectParamMap));
        }
        if (HussarUtils.isNotEmpty(updateList)) {
            List<Map<Integer, Map<Integer, String>>> updateMsgList = updateList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
            List<Map<String, String>> updateCommentList = HussarBaseExcelListener.writeHandlerList(updateMsgList, "\u6807\u8bb0\u65b0\u589e\u548c\u66f4\u65b0\u6570\u636e\u4fe1\u606f");
            CommentUpdateWriteHandler commentUpdateWriteHandler = new CommentUpdateWriteHandler(updateCommentList, "xlsx");
            writeHandlerList.add(commentUpdateWriteHandler);
        }
        String dir = System.getProperty("java.io.tmpdir");
        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
        FileOutputStream os = new FileOutputStream(tempFileName);
        HussarBaseExcelWriteUtils.writeMsgExcel((OutputStream)os, (List)this.rootDataList, this.clazz, writeHandlerList, (String)"\u6807\u8bb0\u65b0\u589e\u548c\u66f4\u65b0\u6570\u636e\u4fe1\u606f");
        FileInputStream inputStream = new FileInputStream(tempFileName);
        HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(".xlsx", ""), tempFileName.replace(".xlsx", ""), "application/octet-stream", (InputStream)inputStream);
        ApiResponse checkFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
        task.setCheckFile((Long)checkFileResponse.getData());
        this.checkFile = (Long)checkFileResponse.getData();
    }

    private static List<Map<String, String>> writeHandlerList(List<Map<Integer, Map<Integer, String>>> msgList, String sheetName) {
        ArrayList<Map<String, String>> commentList = new ArrayList<Map<String, String>>();
        msgList.forEach(map -> {
            int rowIndex = -1;
            int colIndex = -1;
            String commentMsg = "";
            for (Integer key : map.keySet()) {
                rowIndex = key;
                Map comMap = (Map)map.get(key);
                for (Integer comKey : comMap.keySet()) {
                    colIndex = comKey;
                    commentMsg = (String)comMap.get(comKey);
                    commentList.add(CommentErrorWriteHandler.createCommentMap((String)sheetName, (int)rowIndex, (int)colIndex, (String)commentMsg));
                }
            }
        });
        return commentList;
    }

    private Map<Integer, String> getIndexNameMap(Class clazz) throws NoSuchFieldException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            field.setAccessible(true);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int index = excelProperty.index();
            index = index == -1 ? i : index;
            String[] values = excelProperty.value();
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                value.append(v);
            }
            result.put(index, value.toString());
        }
        return result;
    }

    public JSONObject getInitNum() {
        JSONObject json = new JSONObject();
        int rootDataNum = this.rootDataList.size();
        if (HussarUtils.isNotEmpty((Object)rootDataNum)) {
            json.put("rootNum", (Object)rootDataNum);
        } else {
            json.put("rootNum", (Object)"null");
        }
        int newDataNum = this.newDataList.size();
        if (HussarUtils.isNotEmpty((Object)newDataNum)) {
            json.put("newNum", (Object)newDataNum);
        } else {
            json.put("newNum", (Object)"null");
        }
        int existDataNum = this.existDataList.size();
        if (HussarUtils.isNotEmpty((Object)existDataNum)) {
            json.put("existNum", (Object)existDataNum);
        } else {
            json.put("existNum", (Object)"null");
        }
        int errNum = this.errDataList.size();
        if (HussarUtils.isNotEmpty((Object)errNum)) {
            json.put("errNum", (Object)errNum);
        }
        if (HussarUtils.isNotEmpty((Object)this.customExcelCheckResult)) {
            json.put("customExcelCheckResult", this.customExcelCheckResult);
        }
        if (HussarUtils.isNotEmpty((Object)this.checkFile)) {
            json.put("checkFileId", (Object)this.checkFile);
        }
        return json;
    }

    public JSONObject getNotInitNum() {
        JSONObject json = new JSONObject();
        int rootDataNum = this.rootDataList.size();
        if (HussarUtils.isNotEmpty((Object)rootDataNum)) {
            json.put("rootNum", (Object)rootDataNum);
        } else {
            json.put("rootNum", (Object)"null");
        }
        int newDataNum = this.newDataList.size();
        if (HussarUtils.isNotEmpty((Object)newDataNum)) {
            json.put("newNum", (Object)newDataNum);
        } else {
            json.put("newNum", (Object)"null");
        }
        int updateDataNum = this.updateDataList.size();
        if (HussarUtils.isNotEmpty((Object)updateDataNum)) {
            json.put("updateNum", (Object)updateDataNum);
        } else {
            json.put("updateNum", (Object)"null");
        }
        int errNum = this.errDataList.size();
        if (HussarUtils.isNotEmpty((Object)errNum)) {
            json.put("errNum", (Object)errNum);
        }
        if (HussarUtils.isNotEmpty((Object)this.customExcelCheckResult)) {
            json.put("customExcelCheckResult", this.customExcelCheckResult);
        }
        if (HussarUtils.isNotEmpty((Object)this.checkFile)) {
            json.put("checkFileId", (Object)this.checkFile);
        }
        return json;
    }
}

