/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.excel.dto.ExcelTaskDto;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.model.SysExcelTaskVo;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"EXCEl\u64cd\u4f5c"})
@RestController(value="com.jxdinfo.hussar.excel.controller.hussarBaseExcelController")
@RequestMapping(value={"/hussarBase/excel"})
public class HussarBaseExcelController {
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;
    @Autowired
    private IHussarBaseExcelService ihussarBaseExcelService;

    @ApiOperation(value="excel\u5bfc\u51fa\u5bfc\u5165\u8bb0\u5f55\u4fdd\u5b58", notes="excel\u5bfc\u51fa\u5bfc\u5165\u8bb0\u5f55\u4fdd\u5b58")
    @CheckPermission(value={"hussarBase:excel:newExcelTask"})
    @GetMapping(value={"/newExcelTask"})
    @AuditLog(moduleName="excel", eventDesc="excel\u8bb0\u5f55\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> newExcelTask(@ApiParam(value="excel\u64cd\u4f5c\u4e1a\u52a1\u7c7b\u578b") @RequestParam Integer excelType, @ApiParam(value="\u5bfc\u5165\u5bfc\u51fa\u7c7b\u578b") @RequestParam String taskType) {
        return ApiResponse.success((Object)this.iSysExcelTaskService.newExcelTask(excelType, taskType));
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f", notes="\u6839\u636eid\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f")
    @GetMapping(value={"/searchExcelTask"})
    @AuditLog(moduleName="excel", eventDesc="\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    @CheckPermission(value={"hussarBase:excel:searchExcelTask"})
    public ApiResponse<SysExcelTaskVo> searchExcelTask(@ApiParam(value="\u4efb\u52a1\u8bb0\u5f55ID") @RequestParam Long taskId) {
        SysExcelTask sysExcelTask = this.iSysExcelTaskService.getExcelTaskById(taskId);
        SysExcelTaskVo sysExcelTaskVo = new SysExcelTaskVo();
        BeanUtils.copyProperties((Object)sysExcelTask, (Object)sysExcelTaskVo);
        if (HussarUtils.isNotEmpty((Object)sysExcelTask.getTaskFile())) {
            sysExcelTaskVo.setTaskFile(String.valueOf(sysExcelTask.getTaskFile()));
        }
        if (HussarUtils.isNotEmpty((Object)sysExcelTask.getCheckFile())) {
            sysExcelTaskVo.setCheckFile(String.valueOf(sysExcelTask.getCheckFile()));
        }
        return ApiResponse.success((Object)sysExcelTaskVo);
    }

    @ApiOperation(value="\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/getExcelTaskList"})
    @AuditLog(moduleName="excel", eventDesc="\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysExcelTask>> getExcelTaskList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="excel\u65e5\u5fd7DTO") ExcelTaskDto excelTaskDto) {
        return ApiResponse.success((Object)this.iSysExcelTaskService.getExcelTaskList(pageInfo, excelTaskDto));
    }

    @ApiOperation(value="\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", notes="\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55")
    @PostMapping(value={"/batchDeleteTask"})
    @AuditLog(moduleName="\u5bfc\u51fa\u4fe1\u606f", eventDesc="\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> batchDeleteTask(@ApiParam(value="\u5220\u9664excel\u64cd\u4f5c\u65e5\u5fd7id\u5b57\u7b26\u4e32") @RequestBody String taskId) {
        this.iSysExcelTaskService.batchDeleteTask(taskId);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/downloadExcelFile"})
    @ApiOperation(value="excel\u6587\u4ef6\u4e0b\u8f7d", notes="excel\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="excel", eventDesc="excel\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    @CheckPermission(value={"hussarBase:excel:downloadExcelFile"})
    public void downloadExcelFile(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId, HttpServletResponse response) {
        this.ihussarBaseExcelService.downloadExcelFile(fileId, response);
    }
}

