/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.constants.ExcelConstants;
import com.jxdinfo.hussar.excel.listener.HussarBaseExcelListener;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.model.ImportSheetMsg;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.model.TplSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelWriteUtils;
import com.jxdinfo.hussar.excel.util.MergeExcelSheetUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.beans.ClassPathResource;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.excel.service.impl.hussarBaseImportExcelServiceImpl")
public class HussarBaseExcelServiceImpl
implements IHussarBaseExcelService {
    private Logger logger = LoggerFactory.getLogger(HussarBaseExcelServiceImpl.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService excelTaskService;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;

    public void exportExcelByClass(List<ClassSheetMsg> classSheetMsgs, String excelName, Long taskId) {
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setShowMsg("\u5bfc\u51fa\u4e2d");
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        CompletableFuture.runAsync(() -> {
            if (HussarUtils.isNotEmpty((Object)classSheetMsgs)) {
                Object fileOutputStream = null;
                try {
                    ArrayList<String> tempFileNames = new ArrayList<String>();
                    for (ClassSheetMsg classSheetMsg : classSheetMsgs) {
                        String dir = System.getProperty("java.io.tmpdir");
                        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
                        this.makeClassSheetFile(tempFileName, classSheetMsg, task);
                        tempFileNames.add(tempFileName);
                    }
                    String dir = System.getProperty("java.io.tmpdir");
                    String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
                    MergeExcelSheetUtil.mergeExcel(tempFileNames, (String)tempFileName);
                    Long ossId = this.sendFileToOss(tempFileName);
                    task.setTaskFile(ossId);
                    task.setFileName(excelName);
                    task.setShowMsg("\u5bfc\u51fa\u6210\u529f");
                    task.setTaskStatus(Integer.valueOf(8));
                    this.excelTaskService.updateById((Object)task);
                }
                catch (Exception e) {
                    task.setShowMsg("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
                    task.setTaskStatus(Integer.valueOf(9));
                    this.excelTaskService.updateById((Object)task);
                    throw new RuntimeException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a", e);
                }
            } else {
                task.setShowMsg("\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                task.setTaskStatus(Integer.valueOf(9));
                this.excelTaskService.updateById((Object)task);
                throw new RuntimeException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
            }
        }, hussarBaseExcelExecutor);
    }

    public void exportExcelByTpl(List<TplSheetMsg> tplSheetMsgs, String excelName, Long taskId) {
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setShowMsg("\u5bfc\u51fa\u4e2d");
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        CompletableFuture.runAsync(() -> {
            if (HussarUtils.isNotEmpty((Object)tplSheetMsgs)) {
                try {
                    ArrayList<String> tempFileNames = new ArrayList<String>();
                    for (TplSheetMsg tplSheetMsg : tplSheetMsgs) {
                        String dir = System.getProperty("java.io.tmpdir");
                        String tempFileNameForTpl = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
                        this.makeTplSheetFile(tempFileNameForTpl, tplSheetMsg, task);
                        tempFileNames.add(tempFileNameForTpl);
                    }
                    String dir = System.getProperty("java.io.tmpdir");
                    String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
                    MergeExcelSheetUtil.mergeExcel(tempFileNames, (String)tempFileName);
                    Long ossId = this.sendFileToOss(tempFileName);
                    task.setTaskFile(ossId);
                    task.setFileName(excelName);
                    task.setShowMsg("\u5bfc\u51fa\u6210\u529f");
                    task.setTaskStatus(Integer.valueOf(8));
                    this.excelTaskService.updateById((Object)task);
                }
                catch (Exception e) {
                    task.setShowMsg("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
                    task.setTaskStatus(Integer.valueOf(9));
                    this.excelTaskService.updateById((Object)task);
                    throw new RuntimeException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage(), e);
                }
            } else {
                task.setShowMsg("\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                task.setTaskStatus(Integer.valueOf(9));
                this.excelTaskService.updateById((Object)task);
                throw new RuntimeException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
            }
        }, hussarBaseExcelExecutor);
    }

    public void makeClassSheetFile(String tempFileName, ClassSheetMsg classSheetMsg, SysExcelTask task) {
        task.setShowMsg("\u5bfc\u51fa\u4e2d");
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(tempFileName);
            HussarBaseExcelWriteUtils.writeClassSheet((FileOutputStream)fileOutputStream, (ClassSheetMsg)classSheetMsg);
            fileOutputStream.close();
        }
        catch (Exception e) {
            task.setShowMsg("\u5bfc\u51fa\u5f02\u5e38:" + e.getMessage());
            task.setTaskStatus(Integer.valueOf(9));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new RuntimeException("EXCEL\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
        finally {
            if (fileOutputStream != null) {
                HussarUtils.closeQuietly((Closeable)fileOutputStream);
            }
        }
    }

    public void makeTplSheetFile(String tempFileName, TplSheetMsg tplSheetMsg, SysExcelTask task) {
        task.setShowMsg("\u5bfc\u51fa\u4e2d");
        task.setTaskStatus(Integer.valueOf(7));
        this.excelTaskService.updateById((Object)task);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(tempFileName);
            HussarBaseExcelWriteUtils.writeTplSheet((FileOutputStream)fileOutputStream, (TplSheetMsg)tplSheetMsg);
            fileOutputStream.close();
        }
        catch (Exception e) {
            task.setShowMsg("\u5bfc\u51fa\u5f02\u5e38:" + e.getMessage());
            task.setTaskStatus(Integer.valueOf(9));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new RuntimeException("EXCEL\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
        finally {
            if (fileOutputStream != null) {
                HussarUtils.closeQuietly((Closeable)fileOutputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadImportTpl(HttpServletResponse response, String downLoadFileName, String tplFileName) {
        InputStream inputStream = null;
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentType("multipart/form-data");
            downLoadFileName = URLEncoder.encode(downLoadFileName + ".xlsx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + downLoadFileName);
            tplFileName = HussarUtils.isEmpty((Object)tplFileName) ? "userImportTpl" : tplFileName;
            ClassPathResource resource = new ClassPathResource((String)ExcelConstants.TemplateMap.get(tplFileName));
            inputStream = resource.getStream();
            Workbook workbook = HussarBaseExcelWriteUtils.judegExcelEdition((String)downLoadFileName, (InputStream)inputStream);
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.logger.debug("inputStream close IOException:" + e.getMessage());
                }
            }
        }
    }

    public Map checkExcelSheets(InputStream input, List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, List<Object> otherParams, Map<String, Integer> excludeColumnIndexesMap, Map<Integer, List<String>> selectParamMap) {
        LinkedHashMap<String, Object> checkMessageMap = new LinkedHashMap<String, Object>();
        checkMessageMap.put("taskId", taskId.toString());
        SysExcelTask task = new SysExcelTask();
        task.setId(taskId);
        task.setCheckScenario(scenario);
        task.setShowMsg("\u5bfc\u5165\u6821\u9a8c\u4e2d");
        task.setTaskStatus(Integer.valueOf(1));
        this.excelTaskService.updateById((Object)task);
        try {
            int len;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((len = input.read(buffer)) > -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            byteArrayOutputStream.flush();
            ByteArrayInputStream inputStreamA = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ByteArrayInputStream inputStreamB = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStreamA).build();
            List readSheets = EasyExcel.read((InputStream)inputStreamB).build().excelExecutor().sheetList();
            if (HussarUtils.isNotEmpty((Object)readSheets)) {
                LinkedList<JSONObject> checkMessageList = new LinkedList<JSONObject>();
                for (int i = 0; i < importSheetMsgs.size(); ++i) {
                    HussarBaseExcelListener easyExcelListener = new HussarBaseExcelListener(task, otherParams, this.excelTaskService, this.ossService, importSheetMsgs.get(i).getCustomExcelServiceImpl(), importSheetMsgs.get(i).getClazz(), scenario, excludeColumnIndexesMap, selectParamMap);
                    ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)importSheetMsgs.get(i).getSheetNo()).registerReadListener(easyExcelListener)).headRowNumber(Integer.valueOf(0))).build();
                    readSheet.setClazz(importSheetMsgs.get(i).getClazz());
                    excelReader.read(new ReadSheet[]{readSheet});
                    JSONObject checkMessage = new JSONObject();
                    if ("1".equals(scenario)) {
                        checkMessage = easyExcelListener.getInitNum();
                    } else if ("2".equals(scenario)) {
                        checkMessage = easyExcelListener.getNotInitNum();
                    }
                    String sheetName = ((ReadSheet)readSheets.get(i)).getSheetName();
                    checkMessage.put("sheetName", (Object)sheetName);
                    checkMessageList.add(checkMessage);
                }
                checkMessageMap.put("checkMessages", checkMessageList);
                task.setCheckResult(((Object)checkMessageMap).toString());
                this.excelTaskService.updateById((Object)task);
            }
            excelReader.finish();
            ((InputStream)inputStreamA).close();
            ((InputStream)inputStreamB).close();
            input.close();
        }
        catch (Exception e) {
            task.setShowMsg("\u6821\u9a8c\u5f02\u5e38\uff1a" + e.getMessage());
            task.setTaskStatus(Integer.valueOf(3));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new BaseException("EXCEL\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
        return checkMessageMap;
    }

    public void importExcelSheets(List<ImportSheetMsg> importSheetMsgs, String scenario, Long taskId, List<Object> otherParams, Map<String, Integer> excludeColumnIndexesMap) {
        SysExcelTask task = this.excelTaskService.getExcelTaskById(taskId);
        Long taskFileId = task.getTaskFile();
        ApiResponse oss = this.ossService.backgroundDownload(taskFileId);
        byte[] data = (byte[])oss.getData();
        HussarBaseMultipartFile file = new HussarBaseMultipartFile("TemporaryFile.xlsx".replace(".xlsx", ""), "TemporaryFile.xlsx".replace(".xlsx", ""), "application/octet-stream", data);
        task.setShowMsg("\u5bfc\u5165\u4e2d");
        task.setTaskStatus(Integer.valueOf(4));
        this.excelTaskService.updateById((Object)task);
        try {
            InputStream inputStream = file.getInputStream();
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();
            for (int i = 0; i < importSheetMsgs.size(); ++i) {
                HussarBaseExcelListener easyExcelListener = new HussarBaseExcelListener(task, otherParams, this.excelTaskService, this.ossService, importSheetMsgs.get(i).getCustomExcelServiceImpl(), importSheetMsgs.get(i).getClazz(), scenario, excludeColumnIndexesMap, null);
                ReadSheet readSheet = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)importSheetMsgs.get(i).getSheetNo()).registerReadListener(easyExcelListener)).headRowNumber(Integer.valueOf(0))).build();
                readSheet.setClazz(importSheetMsgs.get(i).getClazz());
                excelReader.read(new ReadSheet[]{readSheet});
            }
            excelReader.finish();
            inputStream.close();
        }
        catch (Exception e) {
            task.setShowMsg("\u5bfc\u5165\u5f02\u5e38:" + e.getMessage());
            task.setTaskStatus(Integer.valueOf(6));
            this.excelTaskService.updateById((Object)task);
            e.printStackTrace();
            throw new RuntimeException("EXCEL\u5bfc\u5165\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
    }

    public void downloadExcelFile(Long fileId, HttpServletResponse response) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        SysExcelTask sysExcelTask = this.excelTaskService.getExcelTaskByFileId(fileId);
        if (apiResponse == null || !apiResponse.isSuccess()) {
            throw new BaseException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
        }
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = sysExcelTask.getFileName();
            if (fileId.equals(sysExcelTask.getCheckFile())) {
                fileName = fileName.substring(0, fileName.length() - 5) + "-\u6821\u9a8c\u7ed3\u679c.xlsx";
            }
            if ((fileName = URLEncoder.encode(fileName, "UTF-8")).contains("+")) {
                fileName = fileName.replaceAll("\\+", "%20");
            }
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.write((byte[])((byte[])apiResponse.getData()), (OutputStream)os);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Long sendFileToOss(String fileName) {
        FileInputStream fileInputStream = null;
        try {
            Long ossId;
            fileInputStream = new FileInputStream(fileName);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile("TemporaryFile.xlsx".replace(".xlsx", ""), "TemporaryFile.xlsx".replace(".xlsx", ""), "application/octet-stream", (InputStream)fileInputStream);
            ApiResponse ossResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            Long l = ossId = (Long)ossResponse.getData();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (fileInputStream != null) {
                HussarUtils.closeQuietly((Closeable)fileInputStream);
            }
        }
    }
}

