/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.excel.listener.HussarBaseExcelListener;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.CustomMergeStrategy;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.excel.service.impl.hussarBaseImportExcelServiceImpl")
public class HussarBaseImportExcelServiceImpl
implements IHussarBaseExcelService {
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService excelTaskService;
    @Autowired
    private ExecutorService hussarBaseExcelExecutor;

    public void importExcel(MultipartFile file, IHussarBaseCustomExcelService customCheckService, Class clazz, String strategy, Long taskId) {
        try (InputStream fileInputStream = file.getInputStream();){
            HussarBaseExcelListener easyExcelListener = new HussarBaseExcelListener(this.hussarBaseExcelExecutor, taskId, this.excelTaskService, this.ossService, customCheckService, clazz, strategy);
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)fileInputStream, (Class)clazz, easyExcelListener).sheet().headRowNumber(Integer.valueOf(2))).doRead();
        }
        catch (IOException e) {
            SysExcelTask task = new SysExcelTask();
            task.setErrorMsg(e.getMessage());
            task.setTaskStatus(Integer.valueOf(-1));
            this.excelTaskService.updateById((Object)task);
            throw new BaseException("EXCEL\u5bfc\u5165\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void exportExcel(List details, List data, Class deClazz, Class clazz, String sheetName, Long taskId) {
        try {
            SysExcelTask task = new SysExcelTask();
            task.setId(taskId);
            CompletableFuture.runAsync(() -> {
                if (HussarUtils.isNotEmpty((Object)data)) {
                    FileOutputStream fileOutputStream = null;
                    Object inputStream = null;
                    try {
                        String dir = System.getProperty("java.io.tmpdir");
                        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
                        fileOutputStream = new FileOutputStream(tempFileName);
                        HussarBaseExcelUtils.writeExcelNum((OutputStream)fileOutputStream, (List)details, (List)data, (Class)deClazz, (Class)clazz, (String)"\u5bfc\u51fa\u63cf\u8ff0", (String)sheetName);
                        this.importExcelAndUpdate(taskId, tempFileName, sheetName, 6);
                        fileOutputStream.close();
                        if (fileOutputStream == null) return;
                    }
                    catch (Exception e) {
                        try {
                            task.setErrorMsg(e.toString());
                            task.setTaskStatus(Integer.valueOf(-1));
                            this.excelTaskService.updateById((Object)task);
                            throw new BaseException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (fileOutputStream == null) throw throwable;
                            IOUtils.closeQuietly(fileOutputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    return;
                }
                task.setErrorMsg("\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                task.setExcelName("\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                task.setTaskStatus(Integer.valueOf(-1));
                this.excelTaskService.updateById((Object)task);
                throw new BaseException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
            }, this.hussarBaseExcelExecutor);
        }
        catch (Exception e) {
            throw new BaseException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void exportExcel(List details, List data, Class deClazz, Class clazz, String sheetName, Long taskId, CustomMergeStrategy customMergeStrategy) {
        try {
            SysExcelTask task = new SysExcelTask();
            task.setId(taskId);
            CompletableFuture.runAsync(() -> {
                if (HussarUtils.isNotEmpty((Object)data)) {
                    FileOutputStream fileOutputStream = null;
                    Object inputStream = null;
                    try {
                        String dir = System.getProperty("java.io.tmpdir");
                        String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
                        fileOutputStream = new FileOutputStream(tempFileName);
                        HussarBaseExcelUtils.writeExcelNum((OutputStream)fileOutputStream, (List)details, (List)data, (Class)deClazz, (Class)clazz, (String)"\u5bfc\u51fa\u63cf\u8ff0", (String)sheetName, (CustomMergeStrategy)customMergeStrategy);
                        this.importExcelAndUpdate(taskId, tempFileName, sheetName, 6);
                        fileOutputStream.close();
                        if (fileOutputStream == null) return;
                    }
                    catch (Exception e) {
                        try {
                            task.setErrorMsg(e.toString());
                            task.setTaskStatus(Integer.valueOf(-1));
                            this.excelTaskService.updateById((Object)task);
                            throw new BaseException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            if (fileOutputStream == null) throw throwable;
                            IOUtils.closeQuietly(fileOutputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                    return;
                }
                task.setErrorMsg("\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                task.setExcelName("\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
                task.setTaskStatus(Integer.valueOf(-1));
                this.excelTaskService.updateById((Object)task);
                throw new BaseException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a\u5bfc\u51fa\u6570\u636e\u96c6\u5408\u4e3a\u7a7a");
            }, this.hussarBaseExcelExecutor);
        }
        catch (Exception e) {
            throw new BaseException("EXCEL\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void importExcelAndUpdate(Long taskId, String fileNmae, String documentName, Integer status) {
        SysExcelTask task = new SysExcelTask();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(fileNmae);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile("TemporaryFile.xlsx".replace(".xlsx", ""), "TemporaryFile.xlsx".replace(".xlsx", ""), "application/octet-stream", (InputStream)fileInputStream);
            ApiResponse ossResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            task.setId(taskId);
            task.setTaskStatus(status);
            if (-1 == status) {
                task.setErrorFile((Long)ossResponse.getData());
            } else {
                task.setTaskFile((Long)ossResponse.getData());
            }
            task.setExcelName(documentName + Java8DateUtils.getCurrentDateDTimeStr());
            this.excelTaskService.updateById((Object)task);
        }
        catch (Exception e) {
            task.setErrorMsg(e.toString());
            task.setTaskStatus(Integer.valueOf(-1));
            this.excelTaskService.updateById((Object)task);
            throw new BaseException("EXCEL\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                IOUtils.closeQuietly((InputStream)fileInputStream);
            }
        }
    }
}

