/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.excel.dto.ExcelTaskDto;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"EXCEl\u64cd\u4f5c"})
@RestController(value="com.jxdinfo.hussar.excel.controller.hussarBaseExcelController")
@RequestMapping(value={"/hussarBase/excel"})
public class HussarBaseExcelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseExcelController.class);
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;

    @GetMapping(value={"/download"})
    @ApiOperation(value="excel\u6587\u4ef6\u4e0b\u8f7d", notes="excel\u6587\u4ef6\u4e0b\u8f7d")
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u673a\u6784\u7ef4\u62a4", eventDesc="excel\u6587\u4ef6\u4e0b\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void download(@ApiParam(value="\u6587\u4ef6id") @RequestParam Long fileId, HttpServletResponse response) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        SysExcelTask sysExcelTask = this.iSysExcelTaskService.getExcelTaskByFileId(fileId);
        if (apiResponse == null || !apiResponse.isSuccess()) {
            throw new BaseException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01");
        }
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = URLEncoder.encode(sysExcelTask.getExcelName() + ".xlsx", "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.write((byte[])((byte[])apiResponse.getData()), (OutputStream)os);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868")
    @GetMapping(value={"/excelTaskList"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<SysExcelTask>> employeeInfoList(@ApiParam(value="\u5206\u9875\u4fe1\u606f") PageInfo pageInfo, @ApiParam(value="excel\u65e5\u5fd7DTO") ExcelTaskDto excelTaskDto) {
        return ApiResponse.success((Object)this.iSysExcelTaskService.getExcelTaskList(pageInfo, excelTaskDto));
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f", notes="\u6839\u636eid\u83b7\u53d6excel\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f")
    @GetMapping(value={"/searchExcelTask"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysExcelTask> searchExcelTask(@ApiParam(value="\u8bb0\u5f55ID") @RequestParam Long taskId) {
        return ApiResponse.success((Object)this.iSysExcelTaskService.getExcelTaskById(taskId));
    }

    @ApiOperation(value="excel\u5bfc\u51fa\u5bfc\u5165\u8bb0\u5f55\u4fdd\u5b58", notes="excel\u5bfc\u51fa\u5bfc\u5165\u8bb0\u5f55\u4fdd\u5b58")
    @CheckPermission(value={"hussarBase:excel:excelExportAdd"})
    @GetMapping(value={"/excelExportAdd"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="excel\u8bb0\u5f55\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> excelExportSave(@ApiParam(value="\u5bfc\u5165\u5bfc\u51fa\u7c7b\u578b") @RequestParam Integer excelType, @ApiParam(value="excel\u64cd\u4f5c\u7c7b\u578b") @RequestParam String taskType) {
        return this.iSysExcelTaskService.saveExcelExportLog(excelType, taskType);
    }

    @ApiOperation(value="\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", notes="\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55")
    @PostMapping(value={"/batchDeleteTask"})
    @AuditLog(moduleName="\u5bfc\u51fa\u4fe1\u606f", eventDesc="\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Object> batchDeleteTask(@ApiParam(value="\u5220\u9664excel\u64cd\u4f5c\u65e5\u5fd7id\u5b57\u7b26\u4e32") @RequestBody String taskId) {
        this.iSysExcelTaskService.batchDeleteTask(taskId);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }
}

