/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.dao.SysExcelTaskMapper;
import com.jxdinfo.hussar.excel.dto.ExcelTaskDto;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.excel.service.impl.sysExcelTaskServiceImpl")
public class SysExcelTaskServiceImpl
extends HussarServiceImpl<SysExcelTaskMapper, SysExcelTask>
implements ISysExcelTaskService {
    @Resource
    private SysExcelTaskMapper sysExcelTaskMapper;
    @Autowired
    private OssService ossService;
    @Autowired
    private ISysExcelTaskService iSysExcelTaskService;

    public Page<SysExcelTask> getExcelTaskList(PageInfo pageInfo, ExcelTaskDto excelTaskDto) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        page.setRecords(this.sysExcelTaskMapper.selectExcelTaskList(page, excelTaskDto));
        return page;
    }

    public ApiResponse<Long> saveExcelExportLog(Integer excelType, String taskType) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        SysExcelTask sysExcelTask = new SysExcelTask();
        long kaskId = IdWorker.getId((Object)sysExcelTask);
        sysExcelTask.setId(Long.valueOf(kaskId));
        sysExcelTask.setCreateName(securityUser.getUserName());
        sysExcelTask.setCreator(securityUser.getId());
        sysExcelTask.setTaskStatus(Integer.valueOf(0));
        sysExcelTask.setTaskType(taskType);
        sysExcelTask.setExcelType(excelType);
        if (this.save((BaseEntity)sysExcelTask)) {
            return ApiResponse.success((Object)kaskId, (String)"1");
        }
        return ApiResponse.success((int)0, (String)"0");
    }

    public boolean batchDeleteTask(String taskId) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u64cd\u4f5c\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] ids = taskId.split(",");
        ArrayList<String> taskIdList = new ArrayList<String>();
        for (String id : ids) {
            SysExcelTask sysExcelTask = (SysExcelTask)this.sysExcelTaskMapper.selectById((Serializable)((Object)id));
            if (!ToolUtil.isEmpty((Object)sysExcelTask.getTaskFile())) {
                try {
                    ApiResponse apiResponse = this.ossService.deleteFile(sysExcelTask.getTaskFile());
                }
                catch (Exception e) {
                    throw new BaseException("\u65e5\u5fd7\u6587\u4ef6\u5220\u9664\u5f02\u5e38\uff1a", (Throwable)e);
                }
            }
            taskIdList.add(id);
        }
        List cdids = taskIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        int result = this.sysExcelTaskMapper.deleteBatchIds(cdids);
        if (result < 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return true;
    }

    public SysExcelTask getExcelTaskById(Long taskId) {
        return (SysExcelTask)this.sysExcelTaskMapper.selectById(taskId);
    }

    public SysExcelTask getExcelTaskByFileId(Long fileId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(SysExcelTask::getTaskFile, (Object)fileId)).or()).eq(SysExcelTask::getErrorFile, (Object)fileId);
        SysExcelTask sysExcelTask = (SysExcelTask)this.iSysExcelTaskService.getOne((Wrapper)lambdaQueryWrapper);
        return sysExcelTask;
    }
}

