/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.listener;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.util.StringUtils;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportErr;
import com.jxdinfo.hussar.excel.model.SysExcelTask;
import com.jxdinfo.hussar.excel.service.IHussarBaseCustomExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.excel.util.HussarBaseExcelUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.springframework.web.multipart.MultipartFile;

public class HussarBaseExcelListener<T>
extends AnalysisEventListener<T> {
    private Long taskId;
    private List<T> successList = new ArrayList<T>();
    private List<T> updateList = new ArrayList<T>();
    private List<T> rootData = new ArrayList<T>();
    private List<ExcelImportErr<T>> errList = new ArrayList<ExcelImportErr<T>>();
    private ExecutorService hussarBaseExcelExecutor;
    private ISysExcelTaskService excelTaskService;
    private IHussarBaseCustomExcelService excelCheckService;
    private OssService ossService;
    private List<T> list = new ArrayList<T>();
    private Class<T> clazz;
    private String strategy;

    public HussarBaseExcelListener(ExecutorService hussarBaseExcelExecutor, Long taskId, ISysExcelTaskService excelTaskService, OssService ossService, IHussarBaseCustomExcelService excelCheckService, Class clazz, String strategy) {
        this.hussarBaseExcelExecutor = hussarBaseExcelExecutor;
        this.taskId = taskId;
        this.excelTaskService = excelTaskService;
        this.ossService = ossService;
        this.excelCheckService = excelCheckService;
        this.clazz = clazz;
        this.strategy = strategy;
    }

    public void invoke(T data, AnalysisContext context) {
        this.list.add(data);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        List handleDataList = this.excelCheckService.handleDataBeforeImport(this.list);
        if (!HussarUtils.isNull((Object)handleDataList)) {
            this.list = handleDataList;
        }
        CompletableFuture.runAsync(() -> {
            SysExcelTask task = (SysExcelTask)this.excelTaskService.getById((Serializable)this.taskId);
            try {
                if (this.excelCheckService != null && this.excelTaskService != null) {
                    if (this.list.size() != 0) {
                        task.setTaskStatus(Integer.valueOf(2));
                        task.setDataTotal(Integer.valueOf(this.list.size()));
                        this.excelTaskService.updateById((Object)task);
                        ExcelCheckResult result = this.excelCheckService.check(this.list, this.strategy);
                        task.setTaskStatus(Integer.valueOf(3));
                        task.setDataSuccess(Integer.valueOf(HussarUtils.isNotEmpty((Object)result.getSuccessDatas()) ? result.getSuccessDatas().size() : 0));
                        task.setDataError(Integer.valueOf(HussarUtils.isNotEmpty((Object)result.getErrDatas()) ? result.getErrDatas().size() : 0));
                        this.successList = result.getSuccessDatas();
                        this.updateList = result.getUpdateDatas();
                        this.rootData = result.getRootDatas();
                        this.errList = result.getErrDatas();
                        this.excelTaskService.updateById((Object)task);
                        if (this.successList.size() == 0 && this.updateList.size() == 0 && this.errList.size() == 0) {
                            task.setTaskStatus(Integer.valueOf(4));
                            this.excelTaskService.updateById((Object)task);
                        } else if (this.errList.size() == 0) {
                            if ("1".equals(this.strategy) || "4".equals(this.strategy)) {
                                this.excelCheckService.saveData(this.successList);
                            }
                            if (this.strategy.equals("2") && this.updateList.size() > 0) {
                                this.excelCheckService.updateData(this.updateList);
                            }
                            task.setTaskStatus(Integer.valueOf(4));
                            this.excelTaskService.updateById((Object)task);
                        }
                    } else {
                        task.setTaskStatus(Integer.valueOf(-1));
                        task.setErrorMsg("excel\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a");
                        task.setExcelName("excel\u6587\u4ef6\u6570\u636e\u4e3a\u7a7a\uff01");
                        this.excelTaskService.updateById((Object)task);
                    }
                }
                this.exportErrorExcel(task);
                this.list.clear();
            }
            catch (Exception e) {
                task.setTaskStatus(Integer.valueOf(-1));
                task.setErrorMsg(e.toString());
                this.excelTaskService.updateById((Object)task);
                throw new BaseException("\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }, this.hussarBaseExcelExecutor);
    }

    private void exportErrorExcel(SysExcelTask task) throws IOException {
        List errMsgList = this.errList.stream().map(excelImportErr -> excelImportErr.getCellMap()).collect(Collectors.toList());
        if (this.errList.size() > 0 && HussarUtils.isNotEmpty(this.rootData)) {
            String dir = System.getProperty("java.io.tmpdir");
            String tempFileName = dir + File.separator + UUID.randomUUID().toString().replace("-", "").toLowerCase() + ".xlsx";
            FileOutputStream os = new FileOutputStream(tempFileName);
            HussarBaseExcelUtils.writeExcel((OutputStream)os, this.rootData, this.clazz, errMsgList, (String)"\u5bfc\u5165\u9519\u8bef\u4fe1\u606f");
            FileInputStream inputStream = new FileInputStream(tempFileName);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(tempFileName.replace(".xlsx", ""), tempFileName.replace(".xlsx", ""), "application/octet-stream", (InputStream)inputStream);
            ApiResponse errorFileResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            task.setErrorFile((Long)errorFileResponse.getData());
            task.setTaskStatus(Integer.valueOf(-1));
            task.setExcelName("\u9519\u8bef\u63cf\u8ff0" + Java8DateUtils.getCurrentDateDTimeStr());
            this.excelTaskService.updateById((Object)task);
        }
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        if (this.clazz != null) {
            try {
                Map<Integer, String> indexNameMap = this.getIndexNameMap(this.clazz);
                Set<Integer> keySet = indexNameMap.keySet();
                for (Integer key : keySet) {
                    if (StringUtils.isEmpty((CharSequence)headMap.get(key))) {
                        this.saveTask("\u89e3\u6790excel\u51fa\u9519\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u683c\u5f0f\u7684excel");
                        throw new BaseException("\u89e3\u6790excel\u51fa\u9519\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u683c\u5f0f\u7684excel");
                    }
                    if (headMap.get(key).replace("*", "").equals(indexNameMap.get(key))) continue;
                    this.saveTask("\u89e3\u6790excel\u51fa\u9519\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u683c\u5f0f\u7684excel");
                    throw new BaseException("\u89e3\u6790excel\u51fa\u9519\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u683c\u5f0f\u7684excel");
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
    }

    private void saveTask(String s) {
        SysExcelTask task = (SysExcelTask)this.excelTaskService.getById((Serializable)this.taskId);
        task.setErrorMsg(s);
        task.setExcelName(s);
        task.setTaskStatus(Integer.valueOf(-1));
        this.excelTaskService.updateById((Object)task);
    }

    public Map<Integer, String> getIndexNameMap(Class clazz) throws NoSuchFieldException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = clazz.getDeclaredField(fields[i].getName());
            field.setAccessible(true);
            ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
            if (excelProperty == null) continue;
            int index = excelProperty.index();
            index = index == -1 ? i : index;
            String[] values = excelProperty.value();
            StringBuilder value = new StringBuilder();
            for (String v : values) {
                value.append(v);
            }
            result.put(index, value.toString());
        }
        return result;
    }
}

