/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.style;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class I18nColumnWidthStrategy
implements CellWriteHandler {
    private final Map<String, Integer> fieldWidthMap = new HashMap<String, Integer>();
    private final Map<String, String> fieldHeaderMap;
    private final Map<Integer, Integer> appliedColumns = new HashMap<Integer, Integer>();

    public I18nColumnWidthStrategy(Class<?> clazz, Map<String, String> fieldHeaderMap) {
        this.fieldHeaderMap = fieldHeaderMap;
        this.parseColumnWidthAnnotations(clazz);
    }

    private void parseColumnWidthAnnotations(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            ColumnWidth columnWidth = field.getAnnotation(ColumnWidth.class);
            int width = -1;
            if (columnWidth != null) {
                width = columnWidth.value();
            }
            if (width <= 0) continue;
            this.fieldWidthMap.put(field.getName(), width);
        }
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        if (HussarUtils.isNotEmpty((Object)head)) {
            Sheet sheet = writeSheetHolder.getSheet();
            int columnIndex = cell.getColumnIndex();
            if (this.appliedColumns.containsKey(columnIndex)) {
                return;
            }
            String headerValue = this.getCellValueAsString(cell);
            if (headerValue == null || headerValue.isEmpty()) {
                return;
            }
            Optional<String> fieldName = this.fieldHeaderMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(headerValue)).map(Map.Entry::getKey).findFirst();
            if (fieldName.isPresent() && this.fieldWidthMap.containsKey(fieldName.get())) {
                int width = this.fieldWidthMap.get(fieldName.get());
                sheet.setColumnWidth(columnIndex, width * 256);
                this.appliedColumns.put(columnIndex, width);
            }
        }
    }

    private String getCellValueAsString(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue().toString();
                }
                return String.valueOf(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return String.valueOf(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return this.getFormulaCellValue(cell);
            }
            case BLANK: {
                return "";
            }
        }
        return "";
    }

    private String getFormulaCellValue(Cell cell) {
        Workbook workbook = cell.getSheet().getWorkbook();
        FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
        try {
            CellValue cellValue = evaluator.evaluate(cell);
            if (cellValue == null) {
                return "";
            }
            switch (cellValue.getCellType()) {
                case STRING: {
                    return cellValue.getStringValue();
                }
                case NUMERIC: {
                    return String.valueOf(cellValue.getNumberValue());
                }
                case BOOLEAN: {
                    return String.valueOf(cellValue.getBooleanValue());
                }
            }
            return "";
        }
        catch (Exception e) {
            return cell.getCellFormula();
        }
    }
}

