/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.builder;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.jxdinfo.hussar.excel.style.I18nColumnWidthStrategy;
import com.jxdinfo.hussar.excel.util.TarnsExcelUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class I18nHeaderBuilder {
    public ExcelWriterBuilder buildI18nHeader(ExcelWriterBuilder writerBuilder, Class<?> clazz) {
        HeaderInfo headerInfo = this.generateI18nHeaders(clazz);
        writerBuilder = (ExcelWriterBuilder)writerBuilder.head(headerInfo.headers);
        writerBuilder.registerWriteHandler((WriteHandler)new I18nColumnWidthStrategy(clazz, headerInfo.fieldMapping));
        return writerBuilder;
    }

    private HeaderInfo generateI18nHeaders(Class<?> clazz) {
        List fields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(ExcelProperty.class)).sorted(Comparator.comparingInt(field -> field.getAnnotation(ExcelProperty.class).index())).collect(Collectors.toList());
        ArrayList<List<String>> headers = new ArrayList<List<String>>();
        HashMap<String, String> fieldMapping = new HashMap<String, String>();
        for (Field field2 : fields) {
            ExcelProperty excelProperty = field2.getAnnotation(ExcelProperty.class);
            String[] headerValues = excelProperty.value();
            List columnHeaders = Arrays.stream(headerValues).map(value -> TarnsExcelUtil.translate(value, value)).collect(Collectors.toList());
            headers.add(columnHeaders);
            for (String columnHeader : columnHeaders) {
                fieldMapping.put(field2.getName(), columnHeader);
            }
        }
        return new HeaderInfo(headers, fieldMapping);
    }

    private static class HeaderInfo {
        final List<List<String>> headers;
        final Map<String, String> fieldMapping;

        HeaderInfo(List<List<String>> headers, Map<String, String> fieldMapping) {
            this.headers = headers;
            this.fieldMapping = fieldMapping;
        }
    }
}

