/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.MyEasyExcel;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelGenerateException;
import com.alibaba.excel.write.builder.AbstractExcelWriterParameterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import java.util.Collection;
import java.util.function.Supplier;

public class MyExcelWriterSheetBuilder
extends AbstractExcelWriterParameterBuilder<ExcelWriterSheetBuilder, WriteSheet> {
    private ExcelWriter excelWriter;
    private final WriteSheet writeSheet = new WriteSheet();

    public MyExcelWriterSheetBuilder() {
    }

    public MyExcelWriterSheetBuilder(ExcelWriter excelWriter) {
        this.excelWriter = excelWriter;
    }

    public MyExcelWriterSheetBuilder sheetNo(Integer sheetNo) {
        this.writeSheet.setSheetNo(sheetNo);
        return this;
    }

    public MyExcelWriterSheetBuilder sheetName(String sheetName) {
        this.writeSheet.setSheetName(sheetName);
        return this;
    }

    public WriteSheet build() {
        return this.writeSheet;
    }

    public void doWrite(Collection<?> data) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet()' to call this method");
        }
        this.excelWriter.write(data, this.build());
    }

    public void doFill(Object data) {
        this.doFill(data, (FillConfig)null);
    }

    public void doFill(Object data, FillConfig fillConfig) {
        if (this.excelWriter == null) {
            throw new ExcelGenerateException("Must use 'EasyExcelFactory.write().sheet()' to call this method");
        }
        this.excelWriter.fill(data, fillConfig, this.build());
    }

    public void finish() {
        this.excelWriter.finish();
    }

    public void doWrite(Supplier<Collection<?>> supplier) {
        this.doWrite(supplier.get());
    }

    public void doFill(Supplier<Object> supplier) {
        this.doFill(supplier.get());
    }

    public void doFill(Supplier<Object> supplier, FillConfig fillConfig) {
        this.doFill(supplier.get(), fillConfig);
    }

    public ExcelWriterTableBuilder table() {
        return this.table(null);
    }

    public ExcelWriterTableBuilder table(Integer tableNo) {
        ExcelWriterTableBuilder excelWriterTableBuilder = new ExcelWriterTableBuilder(this.excelWriter, this.build());
        if (tableNo != null) {
            excelWriterTableBuilder.tableNo(tableNo);
        }
        return excelWriterTableBuilder;
    }

    protected WriteSheet parameter() {
        return this.writeSheet;
    }
}

