/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class CustomMergeStrategy
implements CellWriteHandler {
    private List<Integer> targetColumnIndex;
    private List<List<Integer>> mergeColDataGroupCountList;
    private Integer rowIndex;

    public CustomMergeStrategy(List<Integer> targetColumnIndex, List<List<Integer>> mergeColDataGroupCountList, Integer rowIndex) {
        this.targetColumnIndex = targetColumnIndex;
        this.mergeColDataGroupCountList = mergeColDataGroupCountList;
        this.rowIndex = rowIndex;
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> list, Cell cell, Head head, Integer integer, Boolean isHead) {
        if (isHead.booleanValue()) {
            return;
        }
        this.merge(writeSheetHolder.getSheet(), cell);
    }

    protected void merge(Sheet sheet, Cell cell) {
        if (null == this.rowIndex) {
            this.rowIndex = cell.getRowIndex();
        }
        if (cell.getRowIndex() == this.rowIndex.intValue() && this.targetColumnIndex.contains(cell.getColumnIndex())) {
            AtomicInteger i = new AtomicInteger(0);
            Optional<Integer> first = this.targetColumnIndex.stream().filter(col -> {
                i.getAndIncrement();
                return col.intValue() == cell.getColumnIndex();
            }).findFirst();
            this.mergeGroupColumn(sheet, first.get());
        }
    }

    private void mergeGroupColumn(Sheet sheet, Integer index) {
        int rowCount = this.rowIndex;
        int i = 0;
        for (i = 0; i < this.targetColumnIndex.size() && !this.targetColumnIndex.get(i).equals(index); ++i) {
        }
        for (Integer count : this.mergeColDataGroupCountList.get(i)) {
            if (count == 1) {
                rowCount += count.intValue();
                continue;
            }
            CellRangeAddress cellRangeAddress = new CellRangeAddress(rowCount, rowCount + count - 1, index.intValue(), index.intValue());
            sheet.addMergedRegionUnsafe(cellRangeAddress);
            rowCount += count.intValue();
        }
    }
}

