/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.lang.service.ISysMultiLangMgtBoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class TarnsExcelUtil {
    private static ISysMultiLangMgtBoService sysMultiLangMgtService = TarnsExcelUtil.initSysMultiLangMgtService();
    private static String LANG_TEXT = "langText";

    private static ISysMultiLangMgtBoService initSysMultiLangMgtService() {
        try {
            return (ISysMultiLangMgtBoService)SpringContextHolder.getBean(ISysMultiLangMgtBoService.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String translate(String key, String defaultValue) {
        Locale locale = LocaleContextHolder.getLocale();
        if (!TranslateUtil.getIsEnable() || TranslateUtil.getDefaultLang().equals(locale.toLanguageTag())) {
            return defaultValue;
        }
        String lang = locale.toLanguageTag();
        if (HussarUtils.isEmpty((Object)key) || key == null) {
            return null;
        }
        Map langMap = (Map)sysMultiLangMgtService.getTextByLangKey(key).getData();
        if (!langMap.containsKey(LANG_TEXT) || HussarUtils.isEmpty(langMap.get(LANG_TEXT)) || HussarUtils.isEmpty(((Map)langMap.get(LANG_TEXT)).get(lang))) {
            return defaultValue;
        }
        return (String)((Map)langMap.get(LANG_TEXT)).get(lang);
    }
}

