/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.handler;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class CustomSheetWriteHandler
implements SheetWriteHandler {
    private Map<Integer, Short> styleMap;

    public CustomSheetWriteHandler(Map<Integer, Short> styleMap) {
        this.styleMap = styleMap;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        if (HussarUtils.isEmpty(this.styleMap)) {
            return;
        }
        for (Map.Entry<Integer, Short> entry : this.styleMap.entrySet()) {
            SXSSFSheet sxssfSheet = (SXSSFSheet)writeSheetHolder.getSheet();
            CellStyle cellStyle = writeWorkbookHolder.getCachedWorkbook().createCellStyle();
            cellStyle.setDataFormat(entry.getValue().shortValue());
            sxssfSheet.setDefaultColumnStyle(entry.getKey().intValue(), cellStyle);
        }
    }
}

