/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.excel.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.CaseFormat;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import io.swagger.annotations.ApiModelProperty;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class ExcelUtils {
    private static final String XLSX = ".xlsx";
    private static final String XLS = ".xls";
    public static final String ROW_MERGE = "row_merge";
    public static final String COLUMN_MERGE = "column_merge";
    private static final String ROW_NUM = "rowNum";
    private static final String ROW_TIPS = "rowTips";
    private static final int CELL_OTHER = 0;
    private static final int CELL_ROW_MERGE = 1;
    private static final int CELL_COLUMN_MERGE = 2;
    private static final int IMG_HEIGHT = 30;
    private static final int IMG_WIDTH = 30;
    private static final int BYTES_DEFAULT_LENGTH = 10240;

    public static Map<String, List<?>> readFileManySheetToObj(MultipartFile file, Map<String, Class<?>> classMap, Map<String, Map<String, String>> dict) throws Exception {
        return ExcelUtils.readExcelManySheetToObj(file, classMap, dict);
    }

    public static <T> List<T> getBeanList(JSONArray array, Class<T> clazz, Map<String, Map<String, String>> dict) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < array.size(); ++i) {
            list.add(ExcelUtils.getBean(clazz, array.getJSONObject(i), dict));
        }
        return list;
    }

    private static <T> T getBean(Class<T> c, JSONObject obj, Map<String, Map<String, String>> dict) throws Exception {
        T t = c.newInstance();
        Field[] fields = c.getDeclaredFields();
        ArrayList<String> errMsgList = new ArrayList<String>();
        boolean hasRowTipsField = false;
        for (Field field : fields) {
            ExcelUtils.setFieldValue(t, field, obj, errMsgList, dict);
        }
        if (errMsgList.isEmpty() && !hasRowTipsField) {
            return t;
        }
        StringBuilder sb = new StringBuilder();
        int size = errMsgList.size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                sb.append((String)errMsgList.get(i));
                continue;
            }
            sb.append((String)errMsgList.get(i)).append(";");
        }
        for (Field field : fields) {
            if (!field.getName().equals(ROW_TIPS)) continue;
            field.setAccessible(true);
            field.set(t, sb.toString());
        }
        return t;
    }

    private static <T> void setFieldValue(T t, Field field, JSONObject obj, List<String> errMsgList, Map<String, Map<String, String>> dict) {
        block33: {
            ApiModelProperty annotation = field.getAnnotation(ApiModelProperty.class);
            if (annotation == null) {
                return;
            }
            String cname = annotation.value();
            if (cname.trim().isEmpty()) {
                return;
            }
            String val = null;
            if (obj.containsKey((Object)cname)) {
                val = ExcelUtils.getString(obj.getString(cname));
                if (HussarUtils.isNotEmpty(dict) && dict.containsKey(cname)) {
                    Map<String, String> map = dict.get(cname);
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        if (!val.equals(entry.getValue())) continue;
                        val = entry.getKey();
                    }
                }
            }
            if (val == null) {
                return;
            }
            field.setAccessible(true);
            String fieldClassName = field.getType().getSimpleName();
            try {
                if ("String".equalsIgnoreCase(fieldClassName)) {
                    field.set(t, val);
                    break block33;
                }
                if ("boolean".equalsIgnoreCase(fieldClassName)) {
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        List<String> value = Arrays.asList("0", "1");
                        if (value.contains(val)) {
                            field.set(t, !"0".equals(val));
                            if (!"0".equals(val)) {
                                val = "true";
                            }
                        }
                        field.set(t, Boolean.valueOf(val));
                    } else {
                        field.set(t, null);
                    }
                    break block33;
                }
                if ("int".equalsIgnoreCase(fieldClassName) || "Integer".equals(fieldClassName)) {
                    try {
                        if (HussarUtils.isNotEmpty((Object)val)) {
                            field.set(t, Integer.valueOf(val));
                            break block33;
                        }
                        field.set(t, null);
                    }
                    catch (NumberFormatException e) {
                        errMsgList.add(String.format("[%s]\u7684\u503c\u683c\u5f0f\u4e0d\u6b63\u786e(\u5f53\u524d\u503c\u4e3a%s)", cname, val));
                    }
                    break block33;
                }
                if ("double".equalsIgnoreCase(fieldClassName)) {
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        field.set(t, Double.valueOf(val));
                    } else {
                        field.set(t, null);
                    }
                } else if ("long".equalsIgnoreCase(fieldClassName)) {
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        field.set(t, Long.valueOf(val));
                    } else {
                        field.set(t, null);
                    }
                } else if ("BigDecimal".equalsIgnoreCase(fieldClassName)) {
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        field.set(t, new BigDecimal(val));
                    } else {
                        field.set(t, null);
                    }
                } else if ("LocalDateTime".equalsIgnoreCase(fieldClassName)) {
                    if (HussarUtils.isNotEmpty((Object)val)) {
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-M-d H:mm:ss");
                        LocalDateTime localDateTime = LocalDateTime.parse(val, formatter);
                        field.set(t, localDateTime);
                    } else {
                        field.set(t, null);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static Map<String, List<?>> readExcelManySheetToObj(MultipartFile mFile, Map<String, Class<?>> classMap, Map<String, Map<String, String>> dict) throws Exception {
        Workbook book = ExcelUtils.getWorkbook(mFile, null);
        if (book == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < book.getNumberOfSheets(); ++i) {
            Sheet sheet = book.getSheetAt(i);
            JSONArray arr = ExcelUtils.readSheet(sheet);
            map.put(sheet.getSheetName(), ExcelUtils.getBeanList(arr, classMap.get(sheet.getSheetName()), dict));
        }
        book.close();
        return map;
    }

    private static Workbook getWorkbook(MultipartFile mFile, File file) throws IOException {
        XSSFWorkbook book;
        String fileName;
        InputStream in;
        boolean fileNotExist;
        boolean bl = fileNotExist = file == null || !file.exists();
        if (mFile == null && fileNotExist) {
            return null;
        }
        if (mFile != null) {
            in = mFile.getInputStream();
            fileName = ExcelUtils.getString(mFile.getOriginalFilename()).toLowerCase();
        } else {
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            fileName = file.getName().toLowerCase();
        }
        if (fileName.endsWith(XLSX)) {
            book = new XSSFWorkbook(in);
        } else if (fileName.endsWith(XLS)) {
            POIFSFileSystem poifsFileSystem = new POIFSFileSystem(in);
            book = new HSSFWorkbook(poifsFileSystem);
        } else {
            return null;
        }
        in.close();
        return book;
    }

    private static JSONArray readSheet(Sheet sheet) {
        int rowStart = sheet.getFirstRowNum();
        int rowEnd = sheet.getLastRowNum();
        Row headRow = sheet.getRow(rowStart);
        if (headRow == null) {
            return new JSONArray();
        }
        int cellStart = headRow.getFirstCellNum();
        short cellEnd = headRow.getLastCellNum();
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        for (int j = cellStart; j < cellEnd; ++j) {
            String val = ExcelUtils.getCellValue(headRow.getCell(j));
            if (val == null || val.trim().isEmpty()) continue;
            keyMap.put(j, val);
        }
        if (keyMap.isEmpty()) {
            return (JSONArray)Collections.emptyList();
        }
        JSONArray array = new JSONArray();
        if (rowStart == rowEnd) {
            JSONObject obj = new JSONObject();
            obj.put(ROW_NUM, (Object)1);
            Iterator iterator = keyMap.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                obj.put((String)keyMap.get(i), (Object)"");
            }
            return array;
        }
        for (int i = rowStart + 1; i <= rowEnd; ++i) {
            Row eachRow = sheet.getRow(i);
            JSONObject obj = new JSONObject();
            obj.put(ROW_NUM, (Object)(i + 1));
            StringBuilder sb = new StringBuilder();
            for (int k = cellStart; k < cellEnd; ++k) {
                if (eachRow == null) continue;
                String val = ExcelUtils.getCellValue(eachRow.getCell(k));
                sb.append(val);
                obj.put((String)keyMap.get(k), (Object)val);
            }
            if (sb.length() <= 0) continue;
            array.add((Object)obj);
        }
        return array;
    }

    private static String getCellValue(Cell cell) {
        if (cell == null || cell.getCellTypeEnum() == CellType.BLANK) {
            return "";
        }
        if (cell.getCellTypeEnum() == CellType.STRING) {
            String val = cell.getStringCellValue();
            if (val == null || val.trim().isEmpty()) {
                return "";
            }
            return val.trim();
        }
        if (cell.getCellTypeEnum() == CellType.NUMERIC) {
            String s = cell.getNumericCellValue() + "";
            if (Pattern.matches(".*\\.0*", s)) {
                return s.split("\\.")[0];
            }
            return s;
        }
        if (cell.getCellTypeEnum() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue() + "";
        }
        return cell.getCellFormula();
    }

    public static void exportManySheet(HttpServletResponse response, String fileName, Map<String, List<List<Object>>> sheetMap, Map<String, List<Map<Integer, List<String>>>> selectMap) {
        ExcelUtils.export(response, fileName, sheetMap, selectMap);
    }

    private static void export(HttpServletResponse response, String fileName, Map<String, List<List<Object>>> sheetMap, Map<String, List<Map<Integer, List<String>>>> selectMap) {
        SXSSFWorkbook book = new SXSSFWorkbook();
        Set<Map.Entry<String, List<List<Object>>>> entries = sheetMap.entrySet();
        for (Map.Entry<String, List<List<Object>>> entry : entries) {
            List<List<Object>> sheetDataList = entry.getValue();
            SXSSFSheet sheet = book.createSheet(entry.getKey());
            Drawing patriarch = sheet.createDrawingPatriarch();
            CellStyle headStyle = book.createCellStyle();
            headStyle.setFillForegroundColor(IndexedColors.GREY_80_PERCENT.index);
            headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            headStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.index);
            CellStyle rowStyle = book.createCellStyle();
            rowStyle.setAlignment(HorizontalAlignment.CENTER);
            rowStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            sheet.setDefaultColumnWidth(30);
            int rowLength = sheetDataList.size();
            int columnLength = sheetDataList.get(0).size();
            int[][] mergeArray = new int[rowLength][columnLength];
            for (int i = 0; i < sheetDataList.size(); ++i) {
                Row row = sheet.createRow(i);
                List<Object> rowList = sheetDataList.get(i);
                for (int j = 0; j < rowList.size(); ++j) {
                    Object o = rowList.get(j);
                    int v = 0;
                    if (o instanceof URL) {
                        ExcelUtils.setCellPicture(book, row, patriarch, i, j, (URL)o);
                    } else {
                        Cell cell = row.createCell(j);
                        v = i == 0 ? ExcelUtils.setCellValue(cell, o, headStyle) : ExcelUtils.setCellValue(cell, o, rowStyle);
                    }
                    mergeArray[i][j] = v;
                }
            }
            ExcelUtils.mergeCells((Sheet)sheet, mergeArray);
            if (selectMap == null) continue;
            selectMap.forEach((arg_0, arg_1) -> ExcelUtils.lambda$export$0(entry, selectMap, (Sheet)sheet, arg_0, arg_1));
        }
        if (response != null) {
            try {
                ExcelUtils.write(response, book, fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void mergeCells(Sheet sheet, int[][] mergeArray) {
        for (int x = 0; x < mergeArray.length; ++x) {
            int[] arr = mergeArray[x];
            boolean merge = false;
            int y1 = 0;
            int y2 = 0;
            for (int y = 0; y < arr.length; ++y) {
                int value = arr[y];
                if (value == 2) {
                    if (!merge) {
                        y1 = y;
                    }
                    y2 = y;
                    merge = true;
                    continue;
                }
                merge = false;
                if (y1 > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(x, x, y1 - 1, y2));
                }
                y1 = 0;
                y2 = 0;
            }
            if (y1 <= 0) continue;
            sheet.addMergedRegion(new CellRangeAddress(x, x, y1 - 1, y2));
        }
        int xLen = mergeArray.length;
        int yLen = mergeArray[0].length;
        for (int y = 0; y < yLen; ++y) {
            boolean merge = false;
            int x1 = 0;
            int x2 = 0;
            for (int x = 0; x < xLen; ++x) {
                int value = mergeArray[x][y];
                if (value == 1) {
                    if (!merge) {
                        x1 = x;
                    }
                    x2 = x;
                    merge = true;
                    continue;
                }
                merge = false;
                if (x1 > 0) {
                    sheet.addMergedRegion(new CellRangeAddress(x1 - 1, x2, y, y));
                }
                x1 = 0;
                x2 = 0;
            }
            if (x1 <= 0) continue;
            sheet.addMergedRegion(new CellRangeAddress(x1 - 1, x2, y, y));
        }
    }

    private static void write(HttpServletResponse response, SXSSFWorkbook book, String fileName) throws IOException {
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        String name = URLEncoder.encode(fileName + XLSX, "UTF-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + name);
        ServletOutputStream out = response.getOutputStream();
        book.write((OutputStream)out);
        out.flush();
        out.close();
    }

    private static int setCellValue(Cell cell, Object o, CellStyle style) {
        cell.setCellStyle(style);
        if (o == null) {
            cell.setCellType(CellType.STRING);
            cell.setCellValue("");
            return 0;
        }
        if (o instanceof String || o instanceof Long) {
            String s = o.toString();
            if (ExcelUtils.isNumeric(s) && s.length() < 8) {
                cell.setCellType(CellType.NUMERIC);
                if (HussarUtils.isNotEmpty((Object)s)) {
                    cell.setCellValue(Double.parseDouble(s));
                } else {
                    cell.setCellValue("");
                }
                return 0;
            }
            cell.setCellType(CellType.STRING);
            cell.setCellValue(s);
            if (s.equals(ROW_MERGE)) {
                return 1;
            }
            if (s.equals(COLUMN_MERGE)) {
                return 2;
            }
            return 0;
        }
        if (o instanceof Integer || o instanceof Double || o instanceof Float) {
            cell.setCellType(CellType.NUMERIC);
            if (HussarUtils.isNotEmpty((Object)o)) {
                cell.setCellValue(Double.parseDouble(o.toString()));
            } else {
                cell.setCellValue("");
            }
            return 0;
        }
        if (o instanceof Boolean) {
            cell.setCellType(CellType.BOOLEAN);
            if (HussarUtils.isNotEmpty((Object)o)) {
                cell.setCellValue(((Boolean)o).booleanValue());
            } else {
                cell.setCellValue("");
            }
            return 0;
        }
        if (o instanceof BigDecimal) {
            cell.setCellType(CellType.STRING);
            if (HussarUtils.isNotEmpty((Object)o)) {
                cell.setCellValue(o.toString());
            } else {
                cell.setCellValue("");
            }
            return 0;
        }
        if (o instanceof LocalDateTime) {
            cell.setCellType(CellType.STRING);
            if (HussarUtils.isNotEmpty((Object)o)) {
                cell.setCellValue(ExcelUtils.formatDate(o));
            } else {
                cell.setCellValue("");
            }
            return 0;
        }
        cell.setCellType(CellType.STRING);
        cell.setCellValue(o.toString());
        return 0;
    }

    private static void setCellPicture(SXSSFWorkbook wb, Row sr, Drawing<?> patriarch, int x, int y, URL url) {
        sr.setHeight((short)900);
        try (InputStream is = url.openStream();
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int rc;
            byte[] buff = new byte[10240];
            while ((rc = is.read(buff, 0, 10240)) > 0) {
                outputStream.write(buff, 0, rc);
            }
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, 0, 0, y, x, y + 1, x + 1);
            anchor.setAnchorType(ClientAnchor.AnchorType.MOVE_AND_RESIZE);
            patriarch.createPicture((ClientAnchor)anchor, wb.addPicture(outputStream.toByteArray(), 5));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String formatDate(Object o) {
        if (o == null) {
            return "";
        }
        DateTimeFormatter inputFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        LocalDateTime localDateTime = LocalDateTime.parse(o.toString(), inputFormatter);
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return localDateTime.format(outputFormatter);
    }

    private static void setSelect(Sheet sheet, Map<Integer, List<String>> selectMap) {
        if (selectMap == null || selectMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<Integer, List<String>>> entrySet = selectMap.entrySet();
        for (Map.Entry<Integer, List<String>> entry : entrySet) {
            int y = entry.getKey();
            List<String> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            String[] arr = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                arr[i] = list.get(i);
            }
            DataValidationHelper helper = sheet.getDataValidationHelper();
            CellRangeAddressList addressList = new CellRangeAddressList(1, 65000, y, y);
            DataValidationConstraint dvc = helper.createExplicitListConstraint(arr);
            DataValidation dv = helper.createValidation(dvc, addressList);
            if (dv instanceof HSSFDataValidation) {
                dv.setSuppressDropDownArrow(false);
            } else {
                dv.setSuppressDropDownArrow(true);
                dv.setShowErrorBox(true);
            }
            sheet.addValidationData(dv);
        }
    }

    private static boolean isNumeric(String str) {
        if (Objects.nonNull(str) && "0.0".equals(str)) {
            return true;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String getString(String s) {
        if (s == null) {
            return "";
        }
        if (s.isEmpty()) {
            return s;
        }
        return s.trim();
    }

    public static <K, V> boolean isMapContained(Map<K, V> largerMap, Map<K, V> smallerMap) {
        for (Map.Entry<K, V> entry : smallerMap.entrySet()) {
            if (largerMap.containsKey(entry.getKey()) && largerMap.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean haveCommonKeys(Map<String, Map<String, String>> dict, Map<String, Object> data) {
        HashMap<String, Map<String, String>> upperDict = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : dict.entrySet()) {
            upperDict.put(entry.getKey().toUpperCase(), entry.getValue());
        }
        dict.putAll(upperDict);
        Set upperCaseSet1 = dict.keySet().stream().map(String::toUpperCase).collect(Collectors.toSet());
        Set upperCaseSet2 = data.keySet().stream().map(String::toUpperCase).collect(Collectors.toSet());
        upperCaseSet1.retainAll(upperCaseSet2);
        return !upperCaseSet1.isEmpty();
    }

    public static List<String> camelToSnake(List<String> camelCases) {
        if (HussarUtils.isEmpty(camelCases)) {
            return new ArrayList<String>();
        }
        return camelCases.stream().map(camelCase -> CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, camelCase)).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$export$0(Map.Entry entry, Map selectMap, Sheet sheet, String k, List v) {
        if (((String)entry.getKey()).equals(k)) {
            for (Map integerListMap : (List)selectMap.get(k)) {
                ExcelUtils.setSelect(sheet, integerListMap);
            }
        }
    }
}

