/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.elect.signature.service.impl;

import com.jxdinfo.hussar.common.utils.TranslateUtil;
import com.jxdinfo.hussar.elect.signature.dto.ContractPageLinkDto;
import com.jxdinfo.hussar.elect.signature.dto.ContractSendDto;
import com.jxdinfo.hussar.elect.signature.dto.ContractSignLinkDto;
import com.jxdinfo.hussar.elect.signature.dto.SignerInfo;
import com.jxdinfo.hussar.elect.signature.enums.SignTipsEnum;
import com.jxdinfo.hussar.elect.signature.properties.HussarElectSignatureProperties;
import com.jxdinfo.hussar.elect.signature.service.IHussarElectSignatureService;
import com.jxdinfo.hussar.elect.signature.vo.ContractSendVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.qiyuesuo.sdk.v2.SdkClient;
import com.qiyuesuo.sdk.v2.bean.Action;
import com.qiyuesuo.sdk.v2.bean.Contract;
import com.qiyuesuo.sdk.v2.bean.Signatory;
import com.qiyuesuo.sdk.v2.bean.Stamper;
import com.qiyuesuo.sdk.v2.bean.User;
import com.qiyuesuo.sdk.v2.http.FileItem;
import com.qiyuesuo.sdk.v2.http.StreamFile;
import com.qiyuesuo.sdk.v2.json.JSONUtils;
import com.qiyuesuo.sdk.v2.request.ContractDraftRequest;
import com.qiyuesuo.sdk.v2.request.ContractPageRequest;
import com.qiyuesuo.sdk.v2.request.ContractSendRequest;
import com.qiyuesuo.sdk.v2.request.ContractViewPageRequest;
import com.qiyuesuo.sdk.v2.request.DocumentAddByFileRequest;
import com.qiyuesuo.sdk.v2.request.DocumentAddByTemplateRequest;
import com.qiyuesuo.sdk.v2.request.SdkRequest;
import com.qiyuesuo.sdk.v2.response.ContractPageResult;
import com.qiyuesuo.sdk.v2.response.DocumentAddResult;
import com.qiyuesuo.sdk.v2.response.SdkResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class HussarElectSignatureServiceImpl
implements IHussarElectSignatureService {
    @Resource
    private HussarElectSignatureProperties hussarElectSignatureProperties;
    @Resource
    private OssService ossService;

    public ContractSendVo contractSend(ContractSendDto contractSendDto) {
        Long documentId;
        ContractSendVo contractSendVo = new ContractSendVo();
        SdkClient sdkClient = this.getSdkClient();
        if (HussarUtils.isEmpty((Object)sdkClient)) {
            return contractSendVo;
        }
        if (HussarUtils.isEmpty((Object)contractSendDto)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_CONTRACT_DTO_EMPTY.getMessage()));
            }
            throw new HussarException("\u53d1\u8d77\u7b7e\u7f72\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String subject = contractSendDto.getContractSubject();
        String templateId = contractSendDto.getTemplateId();
        String templateName = contractSendDto.getTemplateName();
        String fileInfoId = contractSendDto.getFileInfoId();
        List signerList = contractSendDto.getSignerList();
        boolean ordinal = contractSendDto.isOrdinal();
        String qysBusinessId = contractSendDto.getQysBusinessId();
        if (HussarUtils.isEmpty((Object)subject) || HussarUtils.isEmpty((Object)signerList) || HussarUtils.isEmpty((Object)ordinal)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_THEME_SIGNER_ORDINAL_QYSID_EMPTY.getMessage()));
            }
            throw new HussarException("\u5408\u540c\u4e3b\u9898\u3001\u5408\u540c\u7b7e\u7f72\u4eba\u3001\u662f\u5426\u4e3a\u987a\u5e8f\u7b7e\u7f72\u3001\u5951\u7ea6\u9501\u4e1a\u52a1id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional<SignerInfo> incompleteSigner = signerList.stream().filter(signerInfo -> HussarUtils.isEmpty((Object)signerInfo.getType()) || HussarUtils.isEmpty((Object)signerInfo.getCompanyName()) || HussarUtils.isEmpty((Object)signerInfo.getPhoneNumber()) || HussarUtils.isEmpty((Object)signerInfo.getSigningKeyword())).findFirst();
        if (incompleteSigner.isPresent()) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_SIGNER_LIST_NOT_COMPLETE.getMessage()));
            }
            throw new HussarException("\u7b7e\u7f72\u4eba\u5217\u8868\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        boolean isValid = false;
        if (HussarUtils.isNotEmpty((Object)fileInfoId)) {
            isValid = true;
        } else if (HussarUtils.isNotEmpty((Object)templateId) && HussarUtils.isNotEmpty((Object)templateName)) {
            isValid = true;
        }
        if (!isValid) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_CONTRACT_ID_TEMPLATE_NOT_SATISFY.getMessage()));
            }
            throw new HussarException("\u5408\u540c\u9644\u4ef6ID\u548c\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u6ee1\u8db3\u4ee5\u4e0b\u6761\u4ef6\u4e4b\u4e00\uff1a1. \u9644\u4ef6ID\u4e0d\u4e3a\u7a7a\uff1b2. \u6a21\u677fID\u548c\u6a21\u677f\u540d\u79f0\u540c\u65f6\u4e0d\u4e3a\u7a7a");
        }
        Contract contract = new Contract();
        contract.setBizId(qysBusinessId);
        contract.setSubject(subject);
        contract.setSend(Boolean.valueOf(false));
        contract.setOrdinal(Boolean.valueOf(ordinal));
        HussarElectSignatureServiceImpl.initializeSignatories(contract, signerList);
        ContractDraftRequest contractDraftRequest = new ContractDraftRequest(contract);
        String contractDraftResponse = sdkClient.service((SdkRequest)contractDraftRequest);
        SdkResponse contractDraftResponseObj = JSONUtils.toQysResponse((String)contractDraftResponse, Contract.class);
        if (!"00000000".equals(contractDraftResponseObj.getResponseCode())) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SING_CREATE_DRAFT_FAIL.getMessage()));
            }
            throw new HussarException("\u521b\u5efa\u5408\u540c\u8349\u7a3f\u5931\u8d25");
        }
        Contract contractResult = (Contract)contractDraftResponseObj.getResult();
        Long contractId = contractResult.getId();
        contractSendVo.setContractId(contractId);
        contractSendVo.setSendFlag(false);
        HussarElectSignatureServiceImpl.assignActionIdAndSignatoryId(signerList, contractResult);
        if (HussarUtils.isNotEmpty((Object)fileInfoId)) {
            ApiResponse downloadResponse = this.ossService.backgroundDownload(Long.valueOf(fileInfoId));
            if (downloadResponse == null || !downloadResponse.isSuccess() || downloadResponse.getData() == null) {
                return contractSendVo;
            }
            AttachmentManagerModelVo managerModelVo = this.ossService.getByFileId(Long.valueOf(fileInfoId));
            String title = managerModelVo.getFileName();
            String suffix = managerModelVo.getAttachmentType();
            byte[] fileBytes = (byte[])downloadResponse.getData();
            DocumentAddByFileRequest addDocRequest = new DocumentAddByFileRequest(contractId, (FileItem)new StreamFile((InputStream)new ByteArrayInputStream(fileBytes)), suffix, title);
            String addDocResponse = sdkClient.service((SdkRequest)addDocRequest);
            SdkResponse addDocResponseObj = JSONUtils.toQysResponse((String)addDocResponse, DocumentAddResult.class);
            if (!"00000000".equals(addDocResponseObj.getResponseCode())) {
                return contractSendVo;
            }
            documentId = ((DocumentAddResult)addDocResponseObj.getResult()).getDocumentId();
        } else {
            DocumentAddByTemplateRequest addTempRequest = new DocumentAddByTemplateRequest(contractId, Long.valueOf(templateId), null, templateName);
            String addTempResponse = sdkClient.service((SdkRequest)addTempRequest);
            SdkResponse addTempResponseObj = JSONUtils.toQysResponse((String)addTempResponse, DocumentAddResult.class);
            if (!"00000000".equals(addTempResponseObj.getResponseCode())) {
                return contractSendVo;
            }
            documentId = ((DocumentAddResult)addTempResponseObj.getResult()).getDocumentId();
        }
        List<Stamper> stampers = HussarElectSignatureServiceImpl.createStampers(signerList, documentId);
        ContractSendRequest contractSendRequest = new ContractSendRequest(contractId, stampers);
        String contractSendResponse = sdkClient.service((SdkRequest)contractSendRequest);
        SdkResponse contractSendResponseObj = JSONUtils.toQysResponse((String)contractSendResponse, String.class);
        if ("00000000".equals(contractSendResponseObj.getResponseCode())) {
            contractSendVo.setSendFlag(true);
        }
        return contractSendVo;
    }

    private static void initializeSignatories(Contract contract, List<SignerInfo> signerList) {
        for (SignerInfo signerInfo : signerList) {
            String type = signerInfo.getType();
            Signatory signatory = new Signatory();
            signatory.setTenantName(signerInfo.getCompanyName());
            if ("COMPANY".equals(type)) {
                signatory.setTenantType("COMPANY");
                signerInfo.setTypeValue("COMPANY");
                signatory.setReceiver(new User(signerInfo.getSignerName(), signerInfo.getPhoneNumber(), "MOBILE"));
                Action action = new Action("COMPANY", 0);
                signatory.addAction(action);
            } else {
                signatory.setTenantType("PERSONAL");
                signerInfo.setTypeValue("PERSONAL");
                signatory.setReceiver(new User(signerInfo.getPhoneNumber(), "MOBILE"));
            }
            contract.addSignatory(signatory);
        }
    }

    private static void assignActionIdAndSignatoryId(List<SignerInfo> signerList, Contract contractResult) {
        List signatories = contractResult.getSignatories();
        Map<String, Signatory> signatoryMap = signatories.stream().collect(Collectors.toMap(signatory -> signatory.getReceiver().getContact(), signatory -> signatory, (existing, replacement) -> existing));
        signerList.forEach(signInfo -> {
            String phoneNumber = signInfo.getPhoneNumber();
            Signatory signatory = (Signatory)signatoryMap.get(phoneNumber);
            if (HussarUtils.isNotEmpty((Object)signatory)) {
                signInfo.setSignatoryId(signatory.getId());
                if ("COMPANY".equals(signatory.getTenantType())) {
                    signInfo.setActionId(((Action)signatory.getActions().get(0)).getId());
                }
            }
        });
    }

    private static List<Stamper> createStampers(List<SignerInfo> signerList, Long documentId) {
        return signerList.stream().map(signerInfo -> {
            Stamper stamper = new Stamper();
            stamper.setType(signerInfo.getType());
            stamper.setDocumentId(documentId);
            stamper.setKeyword(signerInfo.getSigningKeyword());
            stamper.setSignatoryId(signerInfo.getSignatoryId());
            if ("COMPANY".equals(signerInfo.getType())) {
                stamper.setActionId(signerInfo.getActionId());
            }
            return stamper;
        }).collect(Collectors.toList());
    }

    public String getContractSignLink(ContractSignLinkDto contractSignLinkDto) {
        SdkClient sdkClient = this.getSdkClient();
        if (HussarUtils.isEmpty((Object)sdkClient)) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)contractSignLinkDto)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_CONTRACT_SIGN_LINK_EMPTY.getMessage()));
            }
            throw new HussarException("\u83b7\u53d6\u5408\u540c\u7b7e\u7f72\u94fe\u63a5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String contractId = contractSignLinkDto.getContractId();
        String contactMobile = contractSignLinkDto.getContactMobile();
        if (HussarUtils.isEmpty((Object)contractId) || HussarUtils.isEmpty((Object)contactMobile)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_CONTRACT_ID_SIGNER_PHONENUM_EMPTY.getMessage()));
            }
            throw new HussarException("\u5408\u540cID\u548c\u7b7e\u7f72\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractPageRequest request = new ContractPageRequest(Long.valueOf(contractId), new User(contactMobile, "MOBILE"), "");
        String pageType = "SIGN";
        request.setPageType(pageType);
        String response = sdkClient.service((SdkRequest)request);
        SdkResponse responseObj = JSONUtils.toQysResponse((String)response, ContractPageResult.class);
        if ("00000000".equals(responseObj.getResponseCode())) {
            ContractPageResult result = (ContractPageResult)responseObj.getResult();
            return result.getPageUrl();
        }
        throw new HussarException(responseObj.getMessage());
    }

    public String getContractPageLink(ContractPageLinkDto contractPageLinkDto) {
        SdkClient sdkClient = this.getSdkClient();
        if (HussarUtils.isEmpty((Object)sdkClient)) {
            return null;
        }
        if (HussarUtils.isEmpty((Object)contractPageLinkDto)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_CONTRACT_PAGE_LINK_EMPTY.getMessage()));
            }
            throw new HussarException("\u83b7\u53d6\u5408\u540c\u6d4f\u89c8\u94fe\u63a5\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String contractId = contractPageLinkDto.getContractId();
        if (HussarUtils.isEmpty((Object)contractId)) {
            if (TranslateUtil.getIsEnable()) {
                throw new HussarException(TranslateUtil.getTranslateName((String)SignTipsEnum.SIGN_CONTRACT_ID_EMPTY.getMessage()));
            }
            throw new HussarException("\u5408\u540cID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ContractViewPageRequest request = new ContractViewPageRequest(Long.valueOf(contractId));
        String response = sdkClient.service((SdkRequest)request);
        SdkResponse responseObj = JSONUtils.toQysResponse((String)response, ContractPageResult.class);
        if ("00000000".equals(responseObj.getResponseCode())) {
            ContractPageResult result = (ContractPageResult)responseObj.getResult();
            return result.getPageUrl();
        }
        throw new HussarException(responseObj.getMessage());
    }

    private SdkClient getSdkClient() {
        if (!this.hussarElectSignatureProperties.isEnabled()) {
            return null;
        }
        if (!"qys".equals(this.hussarElectSignatureProperties.getType())) {
            return null;
        }
        HussarElectSignatureProperties.Qys qysConfig = this.hussarElectSignatureProperties.getQys();
        String serveUrl = qysConfig.getServerUrl();
        String accessKey = qysConfig.getAccessKey();
        String accessSecret = qysConfig.getAccessSecret();
        return new SdkClient(serveUrl, accessKey, accessSecret);
    }
}

