/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.auth.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.constant.app.LogLevelConstant;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWebServiceAuthDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebserviceAuthInfoDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceAuthenticationService;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthParamsUnique;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLVo;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.EaiWebServiceTemplateVo;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.EaiWsParamsPackageVo;
import com.jxdinfo.hussar.eai.webservice.auth.server.factory.EaiWebServiceAuthenticationFactory;
import com.jxdinfo.hussar.eai.webservice.auth.server.service.impl.CommonWebServiceAuthImpl;
import com.jxdinfo.hussar.eai.webservice.common.dto.WebServiceInvokeParamsDto;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAuthWsdlInfo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiWebserviceTemplate;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiWebserviceTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiHeaderMap;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EngineService(value="com.jxdinfo.hussar.eai.webservice.auth.server.service.impl.webServiceAuthenticationServiceImpl", type=DataServiceType.PERMANENT)
public class WebServiceAuthenticationServiceImpl
extends CommonWebServiceAuthImpl
implements IWebServiceAuthenticationService<EaiWebServiceAuthDto> {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceAuthenticationServiceImpl.class);
    private static final String GET_WS_TOKEN_STATUS = "GET_WS_TOKEN_STATUS";
    private static final Integer GET_TOKEN_LOADING_MAX_COUNT = 10;
    private static final Long GET_TOKEN_LOADING_TIME = 100L;
    private static final String TOKEN_GETING = "0";
    @Resource
    private EaiAppStatusBaseService eaiAppStatusService;
    @Resource
    private IEaiHttpParamsService httpParamsService;
    @Resource
    private IApiCallSpecificationInfoService apiCallSpecificationInfoService;
    @Resource
    protected IEaiHttpExtendService httpExtendService;
    @Resource
    private IEaiWebserviceTemplateService webserviceTemplateService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    private static final String HTTP_TYPE = "HTTP_TYPE";
    private static final String TEMPLATE_ID = "templateId";
    @Resource
    IEaiAuthWsdlInfoService iEaiAuthWsdlInfoService;

    public ApiResponse<Long> webserviceAuthSave(HttpAuthDto tokenDto) {
        EaiWebserviceTemplate eaiHttpTemplateOld;
        JSONObject first = (JSONObject)tokenDto.getHttpAuth().get(0);
        EaiWebserviceTemplate templateDto = (EaiWebserviceTemplate)JSONObject.parseObject((String)first.toJSONString(), EaiWebserviceTemplate.class);
        if (first.containsKey((Object)HTTP_TYPE)) {
            templateDto.setAuthType(first.getString(HTTP_TYPE));
        }
        if (null != (eaiHttpTemplateOld = this.getEaiWebserviceTemplate(templateDto.getApplicationCode()))) {
            EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplateOld.getAuthType()).getAuthKey()).webserviceAuthEdit(tokenDto, eaiHttpTemplateOld, templateDto);
            this.eaiAppStatusService.resetStatus(eaiHttpTemplateOld.getApplicationCode());
        }
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)templateDto.getAuthType()).getAuthKey()).webserviceAuthInfoSave(tokenDto);
    }

    public ApiResponse<EaiApiResponseVo> tokenVerify(WebServiceAuthVerfiyDto webServiceAuthVerfiyDto, boolean isPublished) {
        List httpHeader;
        String appCode = webServiceAuthVerfiyDto.getApplicationCode();
        String serviceId = webServiceAuthVerfiyDto.getServiceId();
        List httpBody = webServiceAuthVerfiyDto.getHttpBody();
        if (HussarUtils.isNotEmpty((Object)httpBody)) {
            httpBody = ((AuthWSDLParams)httpBody.get(0)).getItems();
        }
        if (HussarUtils.isNotEmpty((Object)(httpHeader = webServiceAuthVerfiyDto.getHttpHeader()))) {
            httpHeader = ((AuthWSDLParams)httpHeader.get(0)).getItems();
        }
        Map<String, List<EaiHttpParamsDto>> tokenMap = this.getEaiApiParams(serviceId, webServiceAuthVerfiyDto.getEaiWebserviceTemplate().getId(), httpBody, httpHeader, webServiceAuthVerfiyDto.getTokenVerifys(), null, "2", isPublished);
        EaiWsApiParams testParams = webServiceAuthVerfiyDto.getWsApiParams();
        WebServiceInvokeParamsDto tokenParams = this.webServiceRequestService.getWebserviceRequestParams(tokenMap, testParams, Boolean.valueOf(isPublished));
        SOAPMessage tokenResponse = this.webServiceRequestService.getWebserviceResp(tokenParams, testParams, Boolean.valueOf(!isPublished));
        JSONObject tokenResp = null;
        EaiApiResponse response = null;
        if (webServiceAuthVerfiyDto.isHasCache()) {
            response = (EaiApiResponse)HussarCacheUtil.get((String)appCode, (Object)appCode);
            if (null == response) {
                logger.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u4ece\u7f13\u5b58{}-{}\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230TOKEN,\u91cd\u65b0\u53d1\u8d77token\u8bf7\u6c42", (Object)appCode, (Object)appCode);
                this.pushMsg(serviceId, "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u4ece\u7f13\u5b58\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230TOKEN\uff0c\u91cd\u65b0\u53d1\u8d77token\u8bf7\u6c42", LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
                if (StringUtil.isNotEmpty((Object)HussarCacheUtil.get((String)appCode, (Object)GET_WS_TOKEN_STATUS)) && TOKEN_GETING.equals(HussarCacheUtil.get((String)appCode, (Object)GET_WS_TOKEN_STATUS))) {
                    int count = 0;
                    try {
                        while (TOKEN_GETING.equals(HussarCacheUtil.get((String)appCode, (Object)GET_WS_TOKEN_STATUS))) {
                            logger.info("TOKEN\u9274\u6743\u9a8c\u8bc1:{}-{},\u5f53\u524dtoken\u72b6\u6001\u4f4d\uff1a{}-\u6b63\u5728\u83b7\u53d6\uff0c\u7b2c{}\u6b21loading", new Object[]{appCode, appCode, HussarCacheUtil.get((String)appCode, (Object)GET_WS_TOKEN_STATUS), count + 1});
                            if (count < GET_TOKEN_LOADING_MAX_COUNT) {
                                ++count;
                                Thread.sleep(GET_TOKEN_LOADING_TIME);
                                continue;
                            }
                            logger.info("TOKEN\u9274\u6743\u9a8c\u8bc1:loading\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650{}\u6b21,\u6e05\u7a7a\u7f13\u5b58{}-{}", new Object[]{GET_TOKEN_LOADING_MAX_COUNT, appCode, appCode});
                            HussarCacheUtil.evict((String)appCode, (Object)appCode);
                            tokenResp = this.webServiceRequestService.getWebserviceResp(tokenResponse);
                            break;
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error("Interrupted!", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    response = (EaiApiResponse)HussarCacheUtil.get((String)appCode, (Object)appCode);
                } else {
                    tokenResp = this.webServiceRequestService.getWebserviceResp(tokenResponse);
                }
            } else {
                logger.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u4ece\u7f13\u5b58{}-{}\u4e2d\u83b7\u53d6\u5230TOKEN", (Object)appCode, (Object)appCode);
            }
        } else {
            tokenResp = this.webServiceRequestService.getWebserviceResp(tokenResponse);
        }
        List<Object> eaiParamsItems = Lists.newArrayListWithCapacity((int)10);
        if (null != response) {
            if (null == response.getBody()) {
                return this.tokenRreponseDataPackage(tokenParams, response, eaiParamsItems, false);
            }
        } else {
            if (HussarUtils.isNotEmpty((Object)tokenResp)) {
                return this.tokenRreponseDataPackage(tokenParams, tokenResponse, true);
            }
            this.pushMsg(serviceId, "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u63a5\u53e3\u54cd\u5e94\u53c2\u6570\u662f\u7a7a", isPublished);
            return this.tokenRreponseDataPackage(tokenParams, response, eaiParamsItems, false);
        }
        eaiParamsItems = this.analysisBody(response.getBody());
        return this.checkTokenValue(webServiceAuthVerfiyDto, tokenParams, response, eaiParamsItems, isPublished);
    }

    public ApiResponse<EaiApiResponseVo> authVerify(WebServiceAuthVerfiyDto authVerifyDto) {
        if (HussarUtils.isNotEmpty((Object)authVerifyDto.getHttpBody())) {
            authVerifyDto.setHttpBody(((AuthWSDLParams)authVerifyDto.getHttpBody().get(0)).getItems());
        }
        return this.apiAuthVerify(authVerifyDto);
    }

    public ApiResponse<EaiApiResponseVo> apiAuthVerify(WebServiceAuthVerfiyDto authVerifyDto) {
        authVerifyDto.setHasCache(true);
        this.pushMsg(authVerifyDto.getServiceId(), "\u5f00\u59cb\u8fdb\u884c\u63a5\u53e3\u9a8c\u8bc1", LogLevelConstant.LOG_LEVEL_INFO, null, false);
        EaiWebserviceTemplate eaiHttpTemplate = this.getEaiWebserviceTemplate(authVerifyDto.getApplicationCode());
        if (null == eaiHttpTemplate) {
            this.pushMsg(authVerifyDto.getServiceId(), "\u83b7\u53d6\u9274\u6743\u6a21\u677f:\u3010\u65e0\u9274\u6743\u3011", LogLevelConstant.LOG_LEVEL_INFO, null, false);
            return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.HTTPTYPE_NOAUTH.getAuthKey()).webServiceAuthVerify(authVerifyDto, false, 0);
        }
        authVerifyDto.setEaiWebserviceTemplate(eaiHttpTemplate);
        this.pushMsg(authVerifyDto.getServiceId(), "\u83b7\u53d6\u9274\u6743\u6a21\u677f:\u3010" + LogMsgConstant.getType((String)eaiHttpTemplate.getAuthType()) + "\u3011", LogLevelConstant.LOG_LEVEL_INFO, null, false);
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getAuthType()).getAuthKey()).webServiceAuthVerify(authVerifyDto, false, 0);
    }

    @EngineMethod(des="WebService\u9274\u6743\u9a8c\u8bc1", paramDes={"WebServiceAuthVerfiyDto"}, returnDes="ApiResponse<EaiApiResponseVo>")
    public ApiResponse<EaiApiResponseVo> apiInvoke(WebServiceAuthVerfiyDto authVerifyDto) {
        authVerifyDto.setHasCache(true);
        EaiWebserviceTemplate eaiWebserviceTemplate = this.getEaiWebserviceTemplatePublished(authVerifyDto.getApplicationCode());
        if (null == eaiWebserviceTemplate) {
            return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.HTTPTYPE_NOAUTH.getAuthKey()).webServiceAuthVerify(authVerifyDto, true, 0);
        }
        authVerifyDto.setEaiWebserviceTemplate(eaiWebserviceTemplate);
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiWebserviceTemplate.getAuthType()).getAuthKey()).webServiceAuthVerify(authVerifyDto, true, 0);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> webserviceAuthVerifySave(WebServiceAuthVerfiyDto authVerifyDto) {
        EaiWebserviceTemplate eaiHttpTemplate = this.getEaiWebserviceTemplate(authVerifyDto.getApplicationCode());
        String stepCodeCurrent = "9";
        this.deleteInfo(authVerifyDto.getApplicationCode(), stepCodeCurrent);
        EaiHttpExtend extend = new EaiHttpExtend();
        extend.setExtendId(Long.valueOf(IdWorker.getId((Object)new EaiHttpExtend())));
        extend.setStepCode(stepCodeCurrent);
        extend.setRemark("http\u9274\u6743\u9a8c\u8bc1\u4fdd\u5b58");
        extend.setTemplateId(eaiHttpTemplate.getId());
        this.httpExtendService.save((Object)extend);
        EaiWsApiParams eaiWsApiParams = authVerifyDto.getWsApiParams();
        EaiAuthWsdlInfo eaiAuthWsdlInfo = new EaiAuthWsdlInfo();
        eaiAuthWsdlInfo.setWsdlPath(eaiWsApiParams.getWsdlPath());
        eaiAuthWsdlInfo.setWsdlAddress(eaiWsApiParams.getAddress());
        eaiAuthWsdlInfo.setWsdlService(eaiWsApiParams.getServiceName());
        eaiAuthWsdlInfo.setServicePort(eaiWsApiParams.getPortName());
        eaiAuthWsdlInfo.setWsdlOperation(eaiWsApiParams.getOperationName());
        eaiAuthWsdlInfo.setExtendId(extend.getExtendId());
        eaiAuthWsdlInfo.setWsdlId(Long.valueOf(eaiWsApiParams.getId()));
        eaiAuthWsdlInfo.setId(EngineUtil.getId());
        this.iEaiAuthWsdlInfoService.save((Object)eaiAuthWsdlInfo);
        EaiHttpVerifyBase httpVerifyBase = this.insertHttpVerify(extend.getExtendId());
        ArrayList httpParams = Lists.newArrayListWithCapacity((int)10);
        this.getHttpParams(httpParams, authVerifyDto.getHttpHeader(), TOKEN_GETING, httpVerifyBase);
        if (null != authVerifyDto.getHttpBody()) {
            this.getHttpParams(httpParams, authVerifyDto.getHttpBody(), "1", httpVerifyBase);
        }
        this.getHttpParams(httpParams, authVerifyDto.getHttpHeader(), "3", httpVerifyBase);
        this.httpParamsService.saveBatch((Collection)httpParams);
        this.saveCallInfo(authVerifyDto, eaiHttpTemplate);
        if (HussarUtils.isNotEmpty((Object)authVerifyDto.getCallSpecificaList())) {
            EaiWebserviceTemplate templateUpdate = new EaiWebserviceTemplate();
            templateUpdate.setId(eaiHttpTemplate.getId());
            templateUpdate.setTemplateType(TOKEN_GETING);
            this.webserviceTemplateService.updateById((Object)templateUpdate);
        }
        return ApiResponse.success();
    }

    public ApiResponse<EaiWebServiceTemplateVo> webserviceAuthDetail(String applicationCode) {
        EaiWebserviceTemplate eaiHttpTemplate = this.getEaiWebserviceTemplateDetail(applicationCode);
        if (null == eaiHttpTemplate) {
            return ApiResponse.success();
        }
        EaiWebServiceTemplateVo eaiWebServiceTemplateVo = new EaiWebServiceTemplateVo();
        BeanUtil.copyProperties((Object)eaiHttpTemplate, (Object)eaiWebServiceTemplateVo);
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getAuthType()).getAuthKey()).webServiceAuthDetail(eaiWebServiceTemplateVo);
    }

    public ApiResponse<EaiWebServiceTemplateVo> webserviceAuthVerfiyDetail(String applicationCode, Boolean publish) {
        EaiWebserviceTemplate eaiWebserviceTemplate = publish != false ? this.getPublishWebserviceTemplate(applicationCode) : this.getWebserviceTemplate(applicationCode);
        if (null == eaiWebserviceTemplate) {
            return ApiResponse.success();
        }
        EaiHttpExtend finalStep = this.getCertainStepByTemplateId(eaiWebserviceTemplate.getId(), "9");
        if (null == finalStep) {
            return ApiResponse.success();
        }
        EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)finalStep.getExtendId()));
        if (null == httpVerifyBase) {
            return ApiResponse.success();
        }
        List params = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
        List<EaiHttpParams> header = params.stream().filter(p -> TOKEN_GETING.equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> body = params.stream().filter(p -> "1".equals(p.getParamsPosition())).collect(Collectors.toList());
        Map<Long, CommonConstant> commonConstantsMap = this.getCommonConstantsMap(eaiWebserviceTemplate.getApplicationCode());
        Map<Long, EaiApplicationAuth> applicationAuthMap = this.getEaiApplicationAuthMap(eaiWebserviceTemplate.getApplicationCode());
        WebserviceAuthInfoDto paramsVo = this.getEaiVerfiyWebserviceParams(eaiWebserviceTemplate, header, body, commonConstantsMap, applicationAuthMap);
        EaiWebServiceTemplateVo templateVo = new EaiWebServiceTemplateVo();
        templateVo.setAuthVerify(httpVerifyBase);
        if (HussarUtils.isNotEmpty((Object)paramsVo.getWsApiParams())) {
            templateVo.setWsApiParams(paramsVo.getWsApiParams());
            AuthWSDLVo authWSDLVos = this.getAuthWSDLVo(applicationCode, paramsVo.getWsApiParams().getWsdlPath());
            templateVo.setAuthWSDLVos(authWSDLVos);
        }
        templateVo.setHttpBody(paramsVo.getHttpBody());
        templateVo.setHttpHeader(paramsVo.getHttpHeader());
        templateVo.setApplicationCode(applicationCode);
        List specificationInfoDtos = this.apiCallSpecificationInfoService.selectCallInfoListByApiId(eaiWebserviceTemplate.getId());
        templateVo.setCallSpecificaList(specificationInfoDtos);
        return ApiResponse.success((Object)templateVo);
    }

    private EaiWebserviceTemplate getPublishWebserviceTemplate(String applicationCode) {
        EaiWebserviceTemplate eaiHttpTemplate = (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).isNull(EaiWebserviceTemplate::getTemplateType));
        return eaiHttpTemplate;
    }

    private EaiWebserviceTemplate getWebserviceTemplate(String applicationCode) {
        EaiWebserviceTemplate eaiHttpTemplate = (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).in(EaiWebserviceTemplate::getTemplateType, Arrays.asList(TOKEN_GETING, "1")));
        return eaiHttpTemplate;
    }

    private WebserviceAuthInfoDto getEaiVerfiyWebserviceParams(EaiWebserviceTemplate eaiWebserviceTemplate, List<EaiHttpParams> header, List<EaiHttpParams> body, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap) {
        EaiHttpExtend eaiHttpExtend;
        LambdaQueryWrapper wsdlWrapper;
        EaiAuthWsdlInfo eaiAuthWsdlInfo;
        WebserviceAuthInfoDto paramsVo = new WebserviceAuthInfoDto();
        Long tempId = eaiWebserviceTemplate.getId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)tempId);
        List eaiHttpExtends = this.httpExtendService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends) && HussarUtils.isNotEmpty((Object)(eaiAuthWsdlInfo = (EaiAuthWsdlInfo)this.iEaiAuthWsdlInfoService.getOne((Wrapper)(wsdlWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAuthWsdlInfo::getExtendId, (Object)(eaiHttpExtend = eaiHttpExtends.stream().filter(f -> "9".equals(f.getStepCode())).findFirst().orElseGet(EaiHttpExtend::new)).getExtendId())))))) {
            EaiWsApiParams wsApiParams = new EaiWsApiParams();
            wsApiParams.setId(String.valueOf(eaiAuthWsdlInfo.getWsdlId()));
            wsApiParams.setAddress(eaiAuthWsdlInfo.getWsdlAddress());
            wsApiParams.setOperationName(eaiAuthWsdlInfo.getWsdlOperation());
            wsApiParams.setPortName(eaiAuthWsdlInfo.getServicePort());
            wsApiParams.setServiceName(eaiAuthWsdlInfo.getWsdlService());
            wsApiParams.setWsdlPath(eaiAuthWsdlInfo.getWsdlPath());
            paramsVo.setWsApiParams(wsApiParams);
        }
        paramsVo.setHttpHeader(this.getSourceName(header, commonConstantsMap, applicationAuthMap));
        paramsVo.setHttpBody(this.getSourceName(body, commonConstantsMap, applicationAuthMap));
        return paramsVo;
    }

    private WebserviceAuthInfoDto getEaiWebserviceParams(EaiWebserviceTemplate eaiWebserviceTemplate, List<EaiHttpParams> header, List<EaiHttpParams> body, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap) {
        Long tempId;
        LambdaQueryWrapper queryWrapper;
        List eaiHttpExtends;
        WebserviceAuthInfoDto paramsVo = new WebserviceAuthInfoDto();
        if (HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthType().equals(eaiWebserviceTemplate.getAuthType()) && HussarUtils.isNotEmpty((Object)(eaiHttpExtends = this.httpExtendService.list((Wrapper)(queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)(tempId = eaiWebserviceTemplate.getId()))))))) {
            EaiHttpExtend eaiHttpExtend = eaiHttpExtends.stream().filter(f -> "2".equals(f.getStepCode())).findFirst().orElseGet(EaiHttpExtend::new);
            LambdaQueryWrapper wsdlWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAuthWsdlInfo::getExtendId, (Object)eaiHttpExtend.getExtendId());
            EaiAuthWsdlInfo eaiAuthWsdlInfo = (EaiAuthWsdlInfo)this.iEaiAuthWsdlInfoService.getOne((Wrapper)wsdlWrapper);
            EaiWsApiParams wsApiParams = new EaiWsApiParams();
            wsApiParams.setId(String.valueOf(eaiAuthWsdlInfo.getWsdlId()));
            wsApiParams.setAddress(eaiAuthWsdlInfo.getWsdlAddress());
            wsApiParams.setOperationName(eaiAuthWsdlInfo.getWsdlOperation());
            wsApiParams.setPortName(eaiAuthWsdlInfo.getServicePort());
            wsApiParams.setServiceName(eaiAuthWsdlInfo.getWsdlService());
            wsApiParams.setWsdlPath(eaiAuthWsdlInfo.getWsdlPath());
            paramsVo.setWsApiParams(wsApiParams);
        }
        paramsVo.setHttpHeader(this.getSourceName(header, commonConstantsMap, applicationAuthMap));
        paramsVo.setHttpBody(this.getSourceName(body, commonConstantsMap, applicationAuthMap));
        return paramsVo;
    }

    public ApiResponse authParamsUniquenessValidation(AuthParamsUnique authParamsUnique) {
        List httpHeader = authParamsUnique.getHttpHeader();
        this.authParamsCheck(httpHeader, "HEADER");
        List bodyParam = authParamsUnique.getHttpBody();
        this.authParamsCheck(bodyParam, "BODY");
        EaiWsParamsPackageVo wsParamsPackageVo = authParamsUnique.getAuthosissionParams();
        if (HussarUtils.isNotEmpty((Object)wsParamsPackageVo)) {
            List header = wsParamsPackageVo.getHttpHeader();
            List rheader = BeanUtil.copyProperties((Collection)header, EaiHttpParams.class);
            this.paramsPositionCheck(rheader, "HEADER");
            List body = wsParamsPackageVo.getHttpBody();
            List rbody = BeanUtil.copyProperties((Collection)body, EaiHttpParams.class);
            this.paramsPositionCheck(rbody, "BODY");
        }
        return ApiResponse.success();
    }

    public ApiResponse selectWebserviceTemplateInfos(String applicationCode, boolean published) {
        return null;
    }

    public ApiResponse selectWebserviceTemplateInfosWithNewIds(String applicationCode) {
        EaiWebserviceTemplate eaiWebserviceTemplate = this.getNotNullEaiWebserviceTemplate(applicationCode);
        if (eaiWebserviceTemplate == null) {
            return ApiResponse.success();
        }
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiWebserviceTemplate.getAuthType()).getAuthKey()).selectWebServiceTemplateInfosWithNewIds(applicationCode, Boolean.valueOf(false));
    }

    public ApiResponse selectWebserviceTemplateInfosPublishingWithNewIds(String applicationCode) {
        EaiWebserviceTemplate eaiHttpTemplate = this.getEaiWebserviceTemplatePublishing(applicationCode);
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getAuthType()).getAuthKey()).selectWebServiceTemplateInfosWithNewIds(applicationCode, Boolean.valueOf(true));
    }

    public ApiResponse<Boolean> saveWebserviceTemplateInfos(EaiWebServiceAuthDto eaiwebserviceAuthDto) {
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiwebserviceAuthDto.getEaiHttpTemplate().getAuthType()).getAuthKey()).saveWebServiceTemplateInfos(eaiwebserviceAuthDto);
    }

    public ApiResponse<Boolean> updateWebserviceTemplateInfos(EaiWebServiceAuthDto eaiwebserviceAuthDto) {
        return EaiWebServiceAuthenticationFactory.getInvokeAuth(HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiwebserviceAuthDto.getEaiHttpTemplate().getAuthType()).getAuthKey()).updateWebServiceTemplateInfos(eaiwebserviceAuthDto);
    }

    public ApiResponse<String> verifyCommonParamsHasUse(CommonConstant commonParams, Long commonParamId) {
        return null;
    }

    public ApiResponse<Boolean> deleteAuthParamsByAppcode(String appCode) {
        return null;
    }

    @Override
    public EaiWebserviceTemplate getPublishEaiWebserviceTemplate(String applicationCode) {
        return null;
    }

    private void deleteInfo(String applicationCode, String stepCodeCurrent) {
        EaiHttpExtend eaiHttpExtend;
        EaiWebserviceTemplate eaiHttpTemplateOld = this.getEaiWebserviceTemplate(applicationCode);
        if (null != eaiHttpTemplateOld && null != (eaiHttpExtend = (EaiHttpExtend)this.httpExtendService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiHttpTemplateOld.getId())).eq(EaiHttpExtend::getStepCode, (Object)stepCodeCurrent)))) {
            EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)eaiHttpExtend.getExtendId()));
            this.httpParamsService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
            this.httpVerifyBaseService.removeById((Serializable)httpVerifyBase.getExtendId());
            this.httpExtendService.removeById((Serializable)eaiHttpExtend.getExtendId());
            this.iEaiAuthWsdlInfoService.removeById((Serializable)eaiHttpExtend.getExtendId());
        }
    }

    protected void saveCallInfo(WebServiceAuthVerfiyDto authVerifyDto, EaiWebserviceTemplate eaiWebserviceTemplate) {
        this.apiCallSpecificationInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(ApiCallSpecificationInfo::getApiId, (Object)eaiWebserviceTemplate.getId()));
        List specificaList = authVerifyDto.getCallSpecificaList();
        if (HussarUtils.isNotEmpty((Object)specificaList)) {
            ArrayList infoList = Lists.newArrayListWithExpectedSize((int)10);
            specificaList.forEach(s -> {
                s.setApiId(eaiWebserviceTemplate.getId());
                s.setSpecificatId(Long.valueOf(IdWorker.getId((Object)new ApiCallSpecificationInfo())));
                ApiCallSpecificationInfo callSpecificationInfo = new ApiCallSpecificationInfo();
                BeanUtil.copy((Object)s, (Object)callSpecificationInfo);
                infoList.add(callSpecificationInfo);
            });
            this.apiCallSpecificationInfoService.saveBatch((Collection)infoList);
        }
    }

    public ApiResponse<EaiApiResponseVo> tokenRreponseDataPackage(WebServiceInvokeParamsDto requestParam, SOAPMessage response, Boolean tokenVerfiy) {
        EaiApiResponseVo responseVo = new EaiApiResponseVo();
        Map<String, Object> tokenRequestMap = this.requestParamsPackage(requestParam);
        responseVo.setTokenRequestParams(tokenRequestMap);
        EaiApiResponse eaiApiResponse = new EaiApiResponse();
        JSONObject body = this.webServiceRequestService.getWebserviceResp(response);
        if (HussarUtils.isNotEmpty((Object)body.get((Object)"header"))) {
            RmiApiHeaderMap rmiApiHeaderMap = new RmiApiHeaderMap();
            Object o = body.get((Object)"header");
            if (HussarUtils.isNotEmpty((Object)o)) {
                if (o instanceof Map) {
                    for (Map.Entry entry : ((Map)o).entrySet()) {
                        rmiApiHeaderMap.addHeader((String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                eaiApiResponse.setHeader(rmiApiHeaderMap);
            }
        }
        eaiApiResponse.setBody(body.get((Object)"body"));
        responseVo.setTokenResponse(eaiApiResponse);
        List<EaiParamsItems> eaiParamsItems = this.analysisBody(body);
        responseVo.setTokenHttpResult(eaiParamsItems);
        if (tokenVerfiy.booleanValue()) {
            return ApiResponse.success((Object)responseVo);
        }
        return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)responseVo, (String)"\u83b7\u53d6TOKEN\u5931\u8d25\uff01");
    }

    public ApiResponse<EaiApiResponseVo> tokenRreponseDataPackage(WebServiceInvokeParamsDto requestParam, EaiApiResponse response, List<EaiParamsItems> eaiParamsItems, Boolean tokenVerfiy) {
        EaiApiResponseVo responseVo = new EaiApiResponseVo();
        Map<String, Object> tokenRequestMap = this.requestParamsPackage(requestParam);
        responseVo.setTokenRequestParams(tokenRequestMap);
        responseVo.setTokenResponse(response);
        responseVo.setTokenHttpResult(eaiParamsItems);
        if (tokenVerfiy.booleanValue()) {
            return ApiResponse.success((Object)responseVo);
        }
        return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)responseVo, (String)"\u83b7\u53d6TOKEN\u5931\u8d25\uff01");
    }

    private List<EaiParamsItems> analysisBody(Object body) {
        ArrayList templates = Lists.newArrayListWithCapacity((int)10);
        if (null != body && body instanceof JSONObject) {
            WebServiceAuthenticationServiceImpl.analysisJsonObject((JSONObject)body, templates);
        }
        return templates;
    }

    public static void analysisJsonObject(JSONObject jsonObject, List<EaiParamsItems> templates) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            EaiParamsItems t = new EaiParamsItems();
            t.setName((String)entry.getKey());
            if (entry.getValue() instanceof JSONArray) {
                Object obT = ((JSONArray)entry.getValue()).get(0);
                t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                if (obT instanceof JSONObject) {
                    ArrayList tt = Lists.newArrayListWithCapacity((int)10);
                    WebServiceAuthenticationServiceImpl.analysisJsonObject((JSONObject)obT, tt);
                    t.setItems((List)tt);
                } else {
                    t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
                }
            } else if (entry.getValue() instanceof JSONObject) {
                t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                ArrayList tt = Lists.newArrayListWithCapacity((int)10);
                WebServiceAuthenticationServiceImpl.analysisJsonObject((JSONObject)entry.getValue(), tt);
            } else {
                t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
            }
            templates.add(t);
        }
    }

    private ApiResponse<EaiApiResponseVo> checkTokenValue(WebServiceAuthVerfiyDto tokenDto, WebServiceInvokeParamsDto requestParam, EaiApiResponse response, List<EaiParamsItems> eaiParamsItems, boolean isPublished) {
        if (tokenDto.isHasCheckTokenValue()) {
            List<EaiParamsPosition> eaiParamsPositions = this.queryAuthParamsPosition(tokenDto.getEaiWebserviceTemplate().getId(), "3");
            if (HussarUtils.isEmpty(eaiParamsPositions)) {
                return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, false);
            }
            ArrayList expressionParams = Lists.newArrayListWithCapacity((int)10);
            eaiParamsPositions.forEach(position -> {
                List httpParams = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
                if (HussarUtils.isNotEmpty((Object)httpParams)) {
                    httpParams = httpParams.stream().filter(p -> TOKEN_GETING.equals(p.getParamsFrom()) && p.getParamsValue().contains("$BODY.")).collect(Collectors.toList());
                    expressionParams.addAll(httpParams);
                }
            });
            Boolean tokenValueIsNull = true;
            if (HussarUtils.isNotEmpty((Object)expressionParams)) {
                for (EaiHttpParams expressionParam : expressionParams) {
                    Map<String, Object> valueMap = this.getValueMap(expressionParam.getParamsNameEn(), response);
                    Object tokenValue = this.expressionEngineService.executeExpression(expressionParam.getParamsValue(), valueMap, isPublished);
                    if (null != tokenValue) continue;
                    this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1,\u89e3\u6790\u9274\u6743\u53c2\u6570\u5931\u8d25\uff1a" + expressionParam.getParamsValue() + "\u89e3\u6790\u503c\u4e3a\u7a7a", isPublished);
                    tokenValueIsNull = false;
                    break;
                }
            }
            if (!tokenValueIsNull.booleanValue()) {
                return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, false);
            }
        }
        return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, true);
    }
}

