/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.auth.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.ExpressionEngineService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.constant.app.LogLevelConstant;
import com.jxdinfo.hussar.eai.common.util.ApplicationAuthMapUtils;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.WebSocketUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebserviceAuthInfoDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IWebServiceRequestService;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLVo;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.EaiWsParamsVo;
import com.jxdinfo.hussar.eai.webservice.common.dto.WebServiceInvokeParamsDto;
import com.jxdinfo.hussar.eai.webservice.common.service.ISoapBuilder;
import com.jxdinfo.hussar.eai.webservice.common.util.SoapMessageUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAuthWsdlInfo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiWebserviceTemplate;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiWebserviceTemplateService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonWebServiceAuthImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonWebServiceAuthImpl.class);
    @Resource
    protected IEaiHttpExtendService httpExtendService;
    @Resource
    protected IEaiParamsPositionService paramsPositionService;
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    @Resource
    private IEaiWebserviceTemplateService webserviceTemplateService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    private static final String FAIL_MSG = "failMsg";
    private static final String API_CALL_RESULT = "apiCallResult";
    private static final String BOOLEAN_TRUE_CONDITIONVALUE = "1";
    @Resource
    protected ExpressionEngineService expressionEngineService;
    @Resource
    IEaiAuthWsdlInfoService eaiAuthWsdlInfoService;
    @Resource
    ISoapBuilder soapBuilder;
    @Resource
    IConstantVersionService constantVersionService;
    @Resource
    protected IWebServiceRequestService webServiceRequestService;
    @Resource
    IAuthWsdlInfoService authWsdlInfoService;
    @Resource
    protected IEaiHttpParamsService httpParamsService;
    private static final String ERROR = "%s\u4e2d\uff0c\u53c2\u6570\u540d\u79f0%s\u91cd\u590d";
    private static final String HTTP_HEADER = "$HEADER";
    private static final String HTTP_BODY = "$BODY";
    private static final String PARAMSFROM_EXPRESSION_BODY = "$BODY.";
    private static final String PARAMSFROM_EXPRESSION_HEADER = "$HEADER.";

    public EaiWebserviceTemplate getEaiWebserviceTemplateDetail(String applicationCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).in(EaiWebserviceTemplate::getTemplateType, Arrays.asList("0", BOOLEAN_TRUE_CONDITIONVALUE, "2")));
    }

    public EaiWebserviceTemplate getEaiWebserviceTemplate(String applicationCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).in(EaiWebserviceTemplate::getTemplateType, Arrays.asList("0", BOOLEAN_TRUE_CONDITIONVALUE)));
    }

    public EaiWebserviceTemplate getNotNullEaiWebserviceTemplate(String applicationCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).isNotNull(EaiWebserviceTemplate::getTemplateType));
    }

    public EaiWebserviceTemplate getEaiWebserviceTemplatePublished(String applicationCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).isNull(EaiWebserviceTemplate::getTemplateType));
    }

    public EaiWebserviceTemplate getEaiWebserviceTemplatePublishing(String applicationCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).eq(EaiWebserviceTemplate::getTemplateType, (Object)"2"));
    }

    public EaiWebserviceTemplate getPublishEaiWebserviceTemplate(String applicationCode) {
        return (EaiWebserviceTemplate)this.webserviceTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)applicationCode)).isNull(EaiWebserviceTemplate::getTemplateType));
    }

    public Map<Long, CommonConstant> getCommonConstantsMap(String applicationCode) {
        List commonConstants = this.commonConstantService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)applicationCode));
        return commonConstants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
    }

    public Map<Long, EaiApplicationAuth> getEaiApplicationAuthMap(String applicationCode) {
        List applicationAuths = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)applicationCode));
        return applicationAuths.stream().collect(Collectors.toMap(EaiApplicationAuth::getParamsId, Function.identity()));
    }

    protected Map<String, List<EaiHttpParamsDto>> getApiParams(String serviceId, Long templateId, List<EaiHttpParamsDto> bodyParams, List<EaiHttpParamsDto> headerParams, Object httpResultBody, String step, boolean isPublished) {
        Map<Object, Object> paramsPosissionsMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            paramsPosissionsMap = this.queryAuthParamsPositionMap(templateId, step);
        }
        List paramsHeaderToken = Lists.newArrayListWithCapacity((int)10);
        List paramsBodyToken = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<Object, Object> entry : paramsPosissionsMap.entrySet()) {
            if ("0".equals(entry.getKey())) {
                paramsHeaderToken = JSON.parseArray((String)((EaiParamsPosition)entry.getValue()).getEffective(), EaiHttpParamsDto.class);
                continue;
            }
            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(entry.getKey())) {
                paramsBodyToken = JSON.parseArray((String)((EaiParamsPosition)entry.getValue()).getEffective(), EaiHttpParamsDto.class);
                continue;
            }
            throw new BaseException("\u4e0d\u652f\u6301\u6b64\u4f4d\u7f6e\u7684\u7c7b\u578b");
        }
        Map<Object, Object> paramsHeaderTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsBodyTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtil.isNotEmpty((Collection)paramsHeaderToken)) {
            paramsHeaderTokenMap = paramsHeaderToken.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        if (CollectionUtil.isNotEmpty((Collection)paramsBodyToken)) {
            paramsBodyTokenMap = paramsBodyToken.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        Map<Object, Object> paramsHeaderUriMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsBodyUrinMap = Maps.newHashMapWithExpectedSize((int)10);
        if (HussarUtils.isNotEmpty(headerParams)) {
            paramsHeaderUriMap = headerParams.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        if (HussarUtils.isNotEmpty(bodyParams)) {
            paramsBodyUrinMap = bodyParams.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        Map paramsHeaderMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsHeaderTokenMap, (Map)paramsHeaderUriMap);
        Map paramsBodyMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsBodyTokenMap, (Map)paramsBodyUrinMap);
        return this.resetApiParams(serviceId, new ArrayList<EaiHttpParamsDto>(paramsHeaderMergeMap.values()), new ArrayList<EaiHttpParamsDto>(paramsBodyMergeMap.values()), httpResultBody, isPublished);
    }

    protected Map<String, List<EaiHttpParamsDto>> resetApiParams(String serviceId, List<EaiHttpParamsDto> headers, List<EaiHttpParamsDto> bodys, Object httpResultBody, boolean isPublished) {
        List<Object> header = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(headers)) {
            header = this.analysisTestRequestParams(serviceId, headers, null, httpResultBody, isPublished);
            this.pushMsg(serviceId, "\u5b8c\u6210header\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(serviceId, "\u65e0header\u53c2\u6570", isPublished);
        }
        this.pushMsg(serviceId, "\u5f00\u59cb\u89e3\u6790body\u53c2\u6570...", isPublished);
        List<Object> body = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(bodys)) {
            body = this.analysisTestRequestParams(serviceId, bodys, null, httpResultBody, isPublished);
            this.pushMsg(serviceId, "\u5b8c\u6210body\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(serviceId, "\u65e0body\u53c2\u6570", isPublished);
        }
        HashMap<String, List<EaiHttpParamsDto>> map = new HashMap<String, List<EaiHttpParamsDto>>();
        map.put("header", header);
        map.put("body", body);
        return map;
    }

    public List<EaiHttpParamsDto> analysisTestRequestParams(String serviceId, List<EaiHttpParamsDto> httpParamsDtos, Map<Long, EaiHttpParamsDto> tokenVerifyMap, Object httpResultBody, boolean isPublished) {
        if (CollectionUtil.isNotEmpty(httpParamsDtos)) {
            Map<Object, Object> commonConstantsMap = Maps.newHashMapWithExpectedSize((int)10);
            List httpParamsConstant = httpParamsDtos.stream().filter(p -> BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getParamsFrom())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(httpParamsConstant)) {
                List commonConstants;
                Set constantId = httpParamsConstant.stream().map(EaiHttpParamsDto::getParamsValue).collect(Collectors.toSet());
                if (isPublished) {
                    commonConstants = this.constantVersionService.listByIds(constantId);
                    if (HussarUtils.isNotEmpty((Object)commonConstants)) {
                        ArrayList constants = new ArrayList(commonConstants.size());
                        commonConstants.forEach(constantVersion -> {
                            CommonConstant constant = new CommonConstant();
                            constant.setApplicationCode(constantVersion.getApplicationCode());
                            constant.setConstantClassify(constantVersion.getConstantClassify());
                            constant.setConstantName(constantVersion.getConstantName());
                            constant.setConstantNameEn(constantVersion.getConstantNameEn());
                            constant.setConstantValue(constantVersion.getConstantValue());
                            constant.setId(constantVersion.getId());
                            constant.setParamstype(constantVersion.getParamstype());
                            constant.setRemark(constantVersion.getRemark());
                            constant.setCreateBy(constantVersion.getCreateBy());
                            constant.setEditBy(constantVersion.getEditBy());
                            constant.setCreateTime(constantVersion.getCreateTime());
                            constant.setCreator(constantVersion.getCreator());
                            constant.setLastEditor(constantVersion.getLastEditor());
                            constant.setLastTime(constantVersion.getLastTime());
                            constants.add(constant);
                        });
                        commonConstantsMap = constants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
                    }
                } else {
                    commonConstants = this.commonConstantService.listByIds(constantId);
                    this.pushMsg(serviceId, LogMsgConstant.getParamsCommonConstant((Integer)commonConstants.size()), isPublished);
                    commonConstantsMap = commonConstants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
                }
            }
            for (EaiHttpParamsDto paramsDto : httpParamsDtos) {
                paramsDto = (EaiHttpParamsDto)JSON.parseObject((String)JSON.toJSONString((Object)paramsDto.getKeyValue()), EaiHttpParamsDto.class);
                String name = paramsDto.getParamsNameEn();
                Object value = paramsDto.getParamsValue();
                if ("0".equals(paramsDto.getParamsFrom())) {
                    if (HussarUtils.isNotEmpty((Object)paramsDto.getParamsValue())) {
                        Map<String, Object> valueMap = this.getValueMap(paramsDto.getParamsValue(), httpResultBody);
                        value = this.expressionEngineService.executeExpression(paramsDto.getParamsValue(), valueMap, isPublished);
                    }
                    this.pushMsg(serviceId, LogMsgConstant.getParamsFunc((String)name, (Object)value), isPublished);
                } else if (BOOLEAN_TRUE_CONDITIONVALUE.equals(paramsDto.getParamsFrom())) {
                    if (commonConstantsMap.containsKey(Long.valueOf(paramsDto.getParamsValue()))) {
                        value = ((CommonConstant)commonConstantsMap.get(Long.valueOf(paramsDto.getParamsValue()))).getConstantValue();
                        this.pushMsg(serviceId, LogMsgConstant.getConstantValue((String)name, (Object)value), isPublished);
                    }
                } else if ("2".equals(paramsDto.getParamsFrom())) {
                    if (CollectionUtil.isNotEmpty(tokenVerifyMap)) {
                        value = tokenVerifyMap.get(Long.parseLong(paramsDto.getParamsValue())).getParamsValue();
                        this.pushMsg(serviceId, LogMsgConstant.getParamsAuthValue((String)name, (Object)value), isPublished);
                    }
                } else {
                    value = paramsDto.getKeyValue();
                    this.pushMsg(serviceId, LogMsgConstant.getParamsApiValue((String)name, (Object)value), isPublished);
                }
                paramsDto.setKeyValue(value);
            }
        }
        return httpParamsDtos;
    }

    protected EaiWsApiParams getTestParams(Long templateId, String step) {
        EaiWsApiParams eaiWsApiParams = new EaiWsApiParams();
        EaiHttpExtend extend = this.getCertainStepByTemplateId(templateId, step);
        EaiAuthWsdlInfo eaiAuthWsdlInfo = (EaiAuthWsdlInfo)this.eaiAuthWsdlInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiAuthWsdlInfo::getExtendId, (Object)extend.getExtendId()));
        if (HussarUtils.isNotEmpty((Object)eaiAuthWsdlInfo)) {
            eaiWsApiParams.setWsdlPath(eaiAuthWsdlInfo.getWsdlPath());
            eaiWsApiParams.setServiceName(eaiAuthWsdlInfo.getWsdlService());
            eaiWsApiParams.setPortName(eaiAuthWsdlInfo.getServicePort());
            eaiWsApiParams.setOperationName(eaiAuthWsdlInfo.getWsdlOperation());
            eaiWsApiParams.setAddress(eaiAuthWsdlInfo.getWsdlAddress());
            eaiWsApiParams.setId(String.valueOf(eaiAuthWsdlInfo.getWsdlId()));
        }
        return eaiWsApiParams;
    }

    protected SOAPMessage getRequestSOAP(WebServiceInvokeParamsDto requestParams) {
        return this.soapBuilder.buildInputMessage(requestParams);
    }

    protected ApiResponse<EaiApiResponseVo> parseFinalResponse(WebServiceAuthVerfiyDto authVerifyDto, WebServiceInvokeParamsDto requestParams, SOAPMessage soapRequest, SOAPMessage response, EaiApiResponseVo apiResponseVo, Boolean isPublished) {
        ApiResponse<EaiApiResponseVo> eaiApiResponseVo = HussarUtils.isNotEmpty((Object)authVerifyDto.getOutMapping()) ? this.outUriRreponseDataPackage(authVerifyDto.getServiceId(), requestParams, response, apiResponseVo, authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), true, isPublished) : this.authReponseDataPackage(authVerifyDto.getServiceId(), requestParams, soapRequest, response, apiResponseVo, authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), true, isPublished);
        return eaiApiResponseVo;
    }

    protected Map<String, List<EaiHttpParamsDto>> getEaiApiParams(String serviceId, Long templateId, List<AuthWSDLParams> bodyParams, List<AuthWSDLParams> headerParams, List<EaiHttpParamsDto> authParams, Object httpResultBody, String step, boolean isPublished) {
        Map<Object, Object> paramsPosissionsMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)templateId)) {
            paramsPosissionsMap = this.queryAuthParamsPositionMap(templateId, step);
        }
        List<Object> paramsHeaderToken = Lists.newArrayListWithCapacity((int)10);
        List<Object> paramsBodyToken = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<Object, Object> entry : paramsPosissionsMap.entrySet()) {
            if ("0".equals(entry.getKey())) {
                paramsHeaderToken = this.getWSDLParams(JSON.parseArray((String)((EaiParamsPosition)entry.getValue()).getEffective(), EaiHttpParams.class));
                continue;
            }
            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(entry.getKey())) {
                paramsBodyToken = this.getWSDLParams(JSON.parseArray((String)((EaiParamsPosition)entry.getValue()).getEffective(), EaiHttpParams.class));
                continue;
            }
            throw new BaseException("\u4e0d\u652f\u6301\u6b64\u4f4d\u7f6e\u7684\u7c7b\u578b");
        }
        Map<Object, Object> paramsHeaderTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsBodyTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtil.isNotEmpty((Collection)paramsHeaderToken)) {
            paramsHeaderTokenMap = paramsHeaderToken.stream().collect(Collectors.toMap(AuthWSDLParams::getName, Function.identity()));
        }
        if (CollectionUtil.isNotEmpty((Collection)paramsBodyToken)) {
            paramsBodyTokenMap = paramsBodyToken.stream().collect(Collectors.toMap(AuthWSDLParams::getName, Function.identity()));
        }
        Map<Object, Object> paramsHeaderUriMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsBodyUrinMap = Maps.newHashMapWithExpectedSize((int)10);
        if (HussarUtils.isNotEmpty(headerParams)) {
            paramsHeaderUriMap = headerParams.stream().collect(Collectors.toMap(AuthWSDLParams::getName, Function.identity()));
        }
        if (HussarUtils.isNotEmpty(bodyParams)) {
            paramsBodyUrinMap = bodyParams.stream().collect(Collectors.toMap(AuthWSDLParams::getName, Function.identity()));
        }
        Map paramsHeaderMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsHeaderTokenMap, (Map)paramsHeaderUriMap);
        Map paramsBodyMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsBodyTokenMap, (Map)paramsBodyUrinMap);
        return this.resetParams(serviceId, new ArrayList<AuthWSDLParams>(paramsHeaderMergeMap.values()), new ArrayList<AuthWSDLParams>(paramsBodyMergeMap.values()), httpResultBody, authParams, isPublished);
    }

    protected Map<String, List<EaiHttpParamsDto>> resetParams(String serviceId, List<AuthWSDLParams> headers, List<AuthWSDLParams> bodys, Object httpResultBody, List<EaiHttpParamsDto> authParams, boolean isPublished) {
        List<Object> header = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(headers)) {
            header = this.analysisHttpRequestParams(serviceId, headers, authParams, httpResultBody, isPublished);
            this.pushMsg(serviceId, "\u5b8c\u6210header\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(serviceId, "\u65e0header\u53c2\u6570", isPublished);
        }
        this.pushMsg(serviceId, "\u5f00\u59cb\u89e3\u6790body\u53c2\u6570...", isPublished);
        List<Object> body = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(bodys)) {
            body = this.analysisHttpRequestParams(serviceId, bodys, authParams, httpResultBody, isPublished);
            this.pushMsg(serviceId, "\u5b8c\u6210body\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(serviceId, "\u65e0body\u53c2\u6570", isPublished);
        }
        HashMap<String, List<EaiHttpParamsDto>> map = new HashMap<String, List<EaiHttpParamsDto>>();
        map.put("header", header);
        map.put("body", body);
        return map;
    }

    public void pushMsg(String serviceId, String msg, String type, Throwable exception, boolean isPublished) {
        if (!isPublished) {
            WebSocketUtil.senMsg((String)serviceId, (String)msg, (String)type, (Throwable)exception);
        }
    }

    public void pushMsg(String serviceId, String msg, boolean isPublished) {
        this.pushMsg(serviceId, msg, LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
    }

    public List<EaiHttpParamsDto> analysisHttpRequestParams(String serviceId, List<AuthWSDLParams> httpParamsDtos, List<EaiHttpParamsDto> authParams, boolean isPublished) {
        return this.analysisHttpRequestParams(serviceId, httpParamsDtos, authParams, null, isPublished);
    }

    private AuthWSDLParams getAuthIds(AuthWSDLParams httpParamsDto, List<EaiHttpParamsDto> authParams) {
        Optional<EaiHttpParamsDto> eaiHttpParamsDto;
        EaiApplicationAuth eaiApplicationAuth;
        if (HussarUtils.isEmpty(authParams)) {
            return httpParamsDto;
        }
        if ("2".equals(httpParamsDto.getParamsFrom()) && HussarUtils.isNotEmpty((Object)(eaiApplicationAuth = (EaiApplicationAuth)this.applicationAuthService.getById((Serializable)Long.valueOf(httpParamsDto.getParamsValue())))) && (eaiHttpParamsDto = authParams.stream().filter(f -> f.getParamsNameEn().equals(eaiApplicationAuth.getParamsNameEn())).findFirst()).isPresent()) {
            httpParamsDto.setKeyValue(eaiHttpParamsDto.get().getKeyValue());
        }
        if (HussarUtils.isNotEmpty((Object)httpParamsDto.getItems())) {
            List<AuthWSDLParams> items = this.getAuthIds(httpParamsDto.getItems(), authParams);
            httpParamsDto.setItems(items);
        }
        return httpParamsDto;
    }

    private List<AuthWSDLParams> getAuthIds(List<AuthWSDLParams> httpParamsDtos, List<EaiHttpParamsDto> authParams) {
        for (AuthWSDLParams httpParamsDto : httpParamsDtos) {
            Optional<EaiHttpParamsDto> eaiHttpParamsDto;
            EaiApplicationAuth eaiApplicationAuth;
            if ("2".equals(httpParamsDto.getParamsFrom()) && HussarUtils.isNotEmpty((Object)(eaiApplicationAuth = (EaiApplicationAuth)this.applicationAuthService.getById((Serializable)Long.valueOf(httpParamsDto.getParamsValue())))) && (eaiHttpParamsDto = authParams.stream().filter(f -> f.getParamsNameEn().equals(eaiApplicationAuth.getParamsNameEn())).findFirst()).isPresent()) {
                httpParamsDto.setKeyValue((Object)eaiHttpParamsDto.get().getParamsValue());
            }
            if (!HussarUtils.isNotEmpty((Object)httpParamsDto.getItems())) continue;
            List<AuthWSDLParams> items = this.getAuthIds(httpParamsDto.getItems(), authParams);
            httpParamsDto.setItems(items);
        }
        return httpParamsDtos;
    }

    private void getConstantIds(List<AuthWSDLParams> httpParamsDtos, List<String> ids) {
        for (AuthWSDLParams httpParamsDto : httpParamsDtos) {
            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(httpParamsDto.getParamsFrom())) {
                ids.add(httpParamsDto.getParamsValue());
            }
            if (!HussarUtils.isNotEmpty((Object)httpParamsDto.getItems())) continue;
            this.getConstantIds(httpParamsDto.getItems(), ids);
        }
    }

    private void getAuthWSDLParams(String serviceId, List<AuthWSDLParams> httpParamsDtos, List<EaiHttpParamsDto> authParams, Map<Long, CommonConstant> commonConstantsMap, List<EaiHttpParamsDto> eaiHttpParamsDtos, Object httpResultBody, Boolean isPublished) {
        for (AuthWSDLParams paramsDto : httpParamsDtos) {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto = (EaiHttpParamsDto)BeanUtil.copyProperties((Object)paramsDto, EaiHttpParamsDto.class);
            String name = paramsDto.getName();
            eaiHttpParamsDto.setParamsNameEn(name);
            Object value = null;
            if ("0".equals(paramsDto.getParamsFrom())) {
                if (HussarUtils.isNotEmpty((Object)paramsDto.getParamsValue())) {
                    Map<String, Object> valueMap = this.getValueMap(paramsDto.getParamsValue(), httpResultBody);
                    value = this.expressionEngineService.executeExpression(paramsDto.getParamsValue(), valueMap, isPublished.booleanValue());
                }
                this.pushMsg(serviceId, LogMsgConstant.getParamsFunc((String)name, value), isPublished);
            } else if (BOOLEAN_TRUE_CONDITIONVALUE.equals(paramsDto.getParamsFrom())) {
                if (commonConstantsMap.containsKey(Long.valueOf(paramsDto.getParamsValue()))) {
                    value = commonConstantsMap.get(Long.valueOf(paramsDto.getParamsValue())).getConstantValue();
                    this.pushMsg(serviceId, LogMsgConstant.getConstantValue((String)name, (Object)value), isPublished);
                }
            } else if ("2".equals(paramsDto.getParamsFrom())) {
                paramsDto = this.getAuthIds(paramsDto, authParams);
                value = paramsDto.getKeyValue();
            } else {
                value = paramsDto.getKeyValue();
                this.pushMsg(serviceId, LogMsgConstant.getParamsApiValue((String)name, (Object)value), isPublished);
            }
            eaiHttpParamsDto.setKeyValue(value);
            if (HussarUtils.isNotEmpty((Object)paramsDto.getItems())) {
                ArrayList<EaiHttpParamsDto> child = new ArrayList<EaiHttpParamsDto>();
                this.getAuthWSDLParams(serviceId, paramsDto.getItems(), authParams, commonConstantsMap, child, httpResultBody, isPublished);
                eaiHttpParamsDto.setKeyValue(this.toMaps(child));
            }
            eaiHttpParamsDtos.add(eaiHttpParamsDto);
        }
    }

    private Map<String, Object> toMaps(List<EaiHttpParamsDto> eaiHttpParamsDtos) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(eaiHttpParamsDtos)) {
            for (EaiHttpParamsDto eaiHttpParamsDto : eaiHttpParamsDtos) {
                Map<String, Object> childMap = this.toMaps(eaiHttpParamsDto);
                map.putAll(childMap);
            }
        }
        return map;
    }

    private Map<String, Object> toMaps(EaiHttpParamsDto eaiHttpParamsDto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)eaiHttpParamsDto)) {
            Object obj = eaiHttpParamsDto.getKeyValue();
            if (!(obj instanceof List)) {
                if (obj instanceof EaiHttpParamsDto) {
                    Map<String, Object> childMap = this.toMaps((EaiHttpParamsDto)obj);
                    map.put(eaiHttpParamsDto.getParamsNameEn(), childMap);
                } else {
                    map.put(eaiHttpParamsDto.getParamsNameEn(), eaiHttpParamsDto.getKeyValue());
                }
            } else {
                Map<Object, Object> childMap = new HashMap();
                if (HussarUtils.isNotEmpty((Object)obj) && ((List)obj).get(0) instanceof EaiHttpParamsDto) {
                    for (Object child : (List)obj) {
                        childMap = this.toMaps((EaiHttpParamsDto)child);
                    }
                    map.put(eaiHttpParamsDto.getParamsNameEn(), childMap);
                }
                map.put(eaiHttpParamsDto.getParamsNameEn(), eaiHttpParamsDto.getKeyValue());
            }
        }
        return map;
    }

    public List<EaiHttpParamsDto> analysisHttpRequestParams(String serviceId, List<AuthWSDLParams> httpParamsDtos, List<EaiHttpParamsDto> authParams, Object httpResultBody, boolean isPublished) {
        ArrayList<EaiHttpParamsDto> eaiHttpParamsDtos = new ArrayList<EaiHttpParamsDto>();
        if (CollectionUtil.isNotEmpty(httpParamsDtos)) {
            Map<Object, Object> commonConstantsMap = Maps.newHashMapWithExpectedSize((int)10);
            ArrayList<String> constantId = new ArrayList<String>();
            this.getConstantIds(httpParamsDtos, constantId);
            if (CollectionUtil.isNotEmpty(constantId)) {
                if (isPublished) {
                    List commonConstants = this.constantVersionService.listByIds(constantId);
                    if (HussarUtils.isNotEmpty((Object)commonConstants)) {
                        ArrayList<CommonConstant> constants = new ArrayList<CommonConstant>(commonConstants.size());
                        for (ConstantVersion constantVersion : commonConstants) {
                            CommonConstant constant = new CommonConstant();
                            constant.setApplicationCode(constantVersion.getApplicationCode());
                            constant.setConstantClassify(constantVersion.getConstantClassify());
                            constant.setConstantName(constantVersion.getConstantName());
                            constant.setConstantNameEn(constantVersion.getConstantNameEn());
                            constant.setConstantValue(constantVersion.getConstantValue());
                            constant.setId(constantVersion.getId());
                            constant.setParamstype(constantVersion.getParamstype());
                            constant.setRemark(constantVersion.getRemark());
                            constant.setCreateBy(constantVersion.getCreateBy());
                            constant.setEditBy(constantVersion.getEditBy());
                            constant.setCreateTime(constantVersion.getCreateTime());
                            constant.setCreator(constantVersion.getCreator());
                            constant.setLastEditor(constantVersion.getLastEditor());
                            constant.setLastTime(constantVersion.getLastTime());
                            constants.add(constant);
                        }
                        commonConstantsMap = constants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
                    }
                } else {
                    List commonConstants = this.commonConstantService.listByIds(constantId);
                    this.pushMsg(serviceId, LogMsgConstant.getParamsCommonConstant((Integer)commonConstants.size()), isPublished);
                    commonConstantsMap = commonConstants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
                }
            }
            this.getAuthWSDLParams(serviceId, httpParamsDtos, authParams, commonConstantsMap, eaiHttpParamsDtos, httpResultBody, isPublished);
        }
        return eaiHttpParamsDtos;
    }

    public HashMap<String, Object> getRequestParamMap(List<EaiHttpParamsDto> paramsDtos) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(paramsDtos)) {
            for (EaiHttpParamsDto httpParamsDto : paramsDtos) {
                map.put(httpParamsDto.getParamsNameEn(), httpParamsDto.getKeyValue());
            }
        }
        return map;
    }

    public List<AuthWSDLParams> getWSDLParams(List<EaiHttpParams> webServiceParams) {
        ArrayList<AuthWSDLParams> authWSDLParams = new ArrayList<AuthWSDLParams>();
        if (CollectionUtil.isNotEmpty(webServiceParams)) {
            for (EaiHttpParams p : webServiceParams) {
                AuthWSDLParams params = new AuthWSDLParams();
                if (HussarUtils.isNotEmpty((Object)p.getParamsValue()) && HussarUtils.isEmpty((Object)p.getParamsFrom())) {
                    params = (AuthWSDLParams)JSON.parseObject((String)p.getParamsValue(), AuthWSDLParams.class);
                    params.setMapping(Integer.valueOf(p.getParamsPosition()));
                    params.setParamsPosition(p.getParamsPosition());
                } else {
                    BeanUtil.copy((Object)p, (Object)params);
                    params.setKeyValue((Object)p.getParamsValue());
                    params.setName(p.getParamsNameEn());
                    params.setParamsPosition(p.getParamsPosition());
                }
                authWSDLParams.add(params);
            }
        }
        return authWSDLParams;
    }

    public void getHttpParams(List<EaiHttpParams> webServiceParams, List<AuthWSDLParams> authWSDLParams, String paramsPosition, EaiHttpVerifyBase httpVerifyBase) {
        if (CollectionUtil.isNotEmpty(authWSDLParams)) {
            for (AuthWSDLParams p : authWSDLParams) {
                EaiHttpParams params = new EaiHttpParams();
                BeanUtil.copy((Object)p, (Object)params);
                params.setParamsId(Long.valueOf(IdWorker.getId((Object)new EaiHttpParams())));
                params.setHttpId(httpVerifyBase.getHttpBaseId());
                params.setParamsPosition(paramsPosition);
                params.setParamsNameEn(p.getName());
                params.setParamsName(p.getSourceName());
                params.setRemark(p.getRemark());
                params.setParamsValue(JSON.toJSONString((Object)p));
                webServiceParams.add(params);
            }
        }
    }

    public ApiResponse<EaiApiResponseVo> authReponseDataPackage(String serviceId, WebServiceInvokeParamsDto requestParam, SOAPMessage request, SOAPMessage response, EaiApiResponseVo eaiApiResponseVo, List<EaiParamsItems> outMapping, List<ApiCallSpecificationInfo> callSpecificationInfoDtos, boolean isSuccess, boolean isPublished) {
        JSONObject bodyObject;
        EaiApiResponse eaiApiResponse = new EaiApiResponse();
        String str = null;
        if (HussarUtils.isNotEmpty((Object)response)) {
            str = SoapMessageUtil.soapMessage2Xml((SOAPMessage)response);
            eaiApiResponse.setBody((Object)str);
        }
        if (HussarUtils.isNotEmpty((Object)request)) {
            String req = SoapMessageUtil.soapMessage2Xml((SOAPMessage)request);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("body", req);
            eaiApiResponseVo.setOuturlRequestParams(map);
        }
        eaiApiResponseVo.setOuturlResponse(eaiApiResponse);
        JSONObject resp = this.webServiceRequestService.getWebserviceResp(response);
        String operationName = requestParam.getWsdlOperation().getOperationName();
        LOGGER.info("\u8c03\u7528{}\u65b9\u6cd5\u6210\u529f\uff0c\u8fd4\u56dejson\u5bf9\u8c61{}", (Object)operationName, (Object)(resp == null ? null : resp.toJSONString()));
        JSONObject object = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)resp) && resp.containsKey((Object)"body") && HussarUtils.isNotEmpty(outMapping) && (bodyObject = resp.getJSONObject("body")) != null) {
            object.put("body", (Object)bodyObject.getJSONObject(outMapping.get(0).getMappingName()));
        }
        Map<String, Object> judgeResultMap = this.judgeApiCall(callSpecificationInfoDtos, object, isPublished);
        boolean apiCallResult = (Boolean)judgeResultMap.get(API_CALL_RESULT);
        String failMsg = (String)judgeResultMap.get(FAIL_MSG);
        if (HussarUtils.isNotEmpty((Object)resp)) {
            try {
                Object body = null;
                if (resp.containsKey((Object)"body")) {
                    body = ParamsConvertUtil.parseWebServiceResult((Object)resp.get((Object)"body"), outMapping);
                }
                if (apiCallResult) {
                    eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.success(body));
                } else {
                    eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)body, (String)("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38:" + failMsg)));
                    isSuccess = false;
                }
            }
            catch (Exception e) {
                eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)resp, (String)(HussarUtils.isEmpty((Object)e.getMessage()) ? "\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25,\u8bf7\u68c0\u67e5\u51fa\u53c2\u914d\u7f6e" : e.getMessage())));
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
        }
        if (isSuccess) {
            if (apiCallResult) {
                this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u6210\u529f", isPublished);
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
            this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38", LogLevelConstant.LOG_LEVEL_WARN, null, isPublished);
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)resp, (String)("\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25:" + failMsg)));
        } else {
            this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38", LogLevelConstant.LOG_LEVEL_ERROR, null, isPublished);
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)resp, (String)"\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38"));
        }
        return ApiResponse.success((Object)eaiApiResponseVo);
    }

    public ApiResponse<EaiApiResponseVo> outUriRreponseDataPackage(String serviceId, WebServiceInvokeParamsDto requestParam, SOAPMessage response, EaiApiResponseVo eaiApiResponseVo, List<EaiParamsItems> outMapping, List<ApiCallSpecificationInfo> callSpecificationInfoDtos, boolean isSuccess, boolean isPublished) {
        JSONObject bodyObject;
        Map<String, Object> outurlRequestMap = this.requestParamsPackage(requestParam);
        eaiApiResponseVo.setOuturlRequestParams(outurlRequestMap);
        EaiApiResponse eaiApiResponse = new EaiApiResponse();
        String str = null;
        if (HussarUtils.isNotEmpty((Object)response)) {
            str = SoapMessageUtil.soapMessage2Xml((SOAPMessage)response);
            eaiApiResponse.setBody((Object)str);
        }
        eaiApiResponseVo.setOuturlResponse(eaiApiResponse);
        JSONObject resp = this.webServiceRequestService.getWebserviceResp(response, outMapping);
        String operationName = requestParam.getWsdlOperation().getOperationName();
        LOGGER.info("\u8c03\u7528{}\u65b9\u6cd5\u6210\u529f\uff0c\u8fd4\u56dejson\u5bf9\u8c61{}", (Object)operationName, (Object)(resp == null ? null : resp.toJSONString()));
        JSONObject object = new JSONObject();
        if (HussarUtils.isNotEmpty((Object)resp) && resp.containsKey((Object)"body") && HussarUtils.isNotEmpty(outMapping) && (bodyObject = resp.getJSONObject("body")) != null) {
            object.put("body", (Object)bodyObject.getJSONObject(outMapping.get(0).getMappingName()));
        }
        Map<String, Object> judgeResultMap = this.judgeApiCall(callSpecificationInfoDtos, object, isPublished);
        boolean apiCallResult = (Boolean)judgeResultMap.get(API_CALL_RESULT);
        String failMsg = (String)judgeResultMap.get(FAIL_MSG);
        if (HussarUtils.isNotEmpty((Object)resp) && HussarUtils.isNotEmpty(outMapping)) {
            try {
                Object body = null;
                if (resp.containsKey((Object)"body")) {
                    body = ParamsConvertUtil.parseWebServiceResult((Object)resp.get((Object)"body"), outMapping);
                }
                if (HussarUtils.isNotEmpty(body) && body instanceof Map) {
                    String key = String.valueOf(((Map)body).keySet().iterator().next());
                    body = ((Map)body).get(key);
                }
                if (apiCallResult) {
                    eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.success((Object)body));
                } else {
                    eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)body, (String)("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38:" + failMsg)));
                }
            }
            catch (Exception e) {
                eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)resp, (String)(HussarUtils.isEmpty((Object)e.getMessage()) ? "\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25,\u8bf7\u68c0\u67e5\u51fa\u53c2\u914d\u7f6e" : e.getMessage())));
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
        }
        if (isSuccess) {
            if (apiCallResult) {
                this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u6210\u529f", isPublished);
            } else {
                this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38", LogLevelConstant.LOG_LEVEL_WARN, null, isPublished);
                eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)resp, (String)("\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25:" + failMsg)));
            }
        } else {
            this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38", LogLevelConstant.LOG_LEVEL_ERROR, null, isPublished);
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)resp, (String)"\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38"));
        }
        return ApiResponse.success((Object)eaiApiResponseVo);
    }

    private Map<String, Object> judgeApiCall(List<ApiCallSpecificationInfo> callSpecificationInfoDtos, JSONObject apiResponse, Boolean isPublished) {
        HashMap judgeResultMap = Maps.newHashMapWithExpectedSize((int)2);
        boolean apiCallResult = true;
        String failMsg = null;
        if (CollectionUtil.isNotEmpty(callSpecificationInfoDtos)) {
            if (HussarUtils.isEmpty((Object)apiResponse)) {
                apiCallResult = false;
            } else {
                for (ApiCallSpecificationInfo p : callSpecificationInfoDtos) {
                    Map<String, Object> valueMap = this.getValueMap(p.getParamName(), apiResponse);
                    Object o = this.expressionEngineService.executeExpression(p.getParamName(), valueMap, isPublished.booleanValue());
                    if ("00".equals(p.getJudgeCondition())) {
                        if (null == o) {
                            apiCallResult = false;
                            failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1anull", p.getShowParamName());
                            break;
                        }
                        if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == Integer.valueOf(p.getParamType()).intValue()) {
                            boolean conditionValueValue = false;
                            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getConditionValue())) {
                                conditionValueValue = true;
                            }
                            if ((Boolean)o == false != conditionValueValue) continue;
                            apiCallResult = false;
                            failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u7b49\u4e8e%s", p.getShowParamName(), o, String.valueOf(conditionValueValue));
                            break;
                        }
                        if (this.isEqualsCondition(p.getParamType(), o, p.getConditionValue())) continue;
                        apiCallResult = false;
                        failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u7b49\u4e8e%s", p.getShowParamName(), o, p.getConditionValue());
                        break;
                    }
                    if ("01".equals(p.getJudgeCondition())) {
                        if (null == o) continue;
                        if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == Integer.valueOf(p.getParamType()).intValue()) {
                            boolean conditionValueValue = false;
                            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getConditionValue())) {
                                conditionValueValue = true;
                            }
                            if ((Boolean)o != conditionValueValue) continue;
                            apiCallResult = false;
                            failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u4e0d\u7b49\u4e8e%s", p.getShowParamName(), o, String.valueOf(conditionValueValue));
                            break;
                        }
                        if (!this.isEqualsCondition(p.getParamType(), o, p.getConditionValue())) continue;
                        apiCallResult = false;
                        failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u4e0d\u7b49\u4e8e%s", p.getShowParamName(), o, p.getConditionValue());
                        break;
                    }
                    if (!"02".equals(p.getJudgeCondition())) continue;
                    if (null == o) {
                        apiCallResult = false;
                        failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1anull", p.getShowParamName());
                        break;
                    }
                    if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == Integer.valueOf(p.getParamType()).intValue()) {
                        boolean conditionValueValue = false;
                        if (BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getConditionValue())) {
                            conditionValueValue = true;
                        }
                        if ((Boolean)o == false != conditionValueValue) continue;
                        apiCallResult = false;
                        failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u5728(%s)\u4e4b\u5185", p.getShowParamName(), o, String.valueOf(conditionValueValue));
                        break;
                    }
                    if (HussarUtils.isNotEmpty((Object)p.getConditionValue())) {
                        List values = Stream.of(p.getConditionValue().split(",")).collect(Collectors.toList());
                        if (values.size() == 1) {
                            if (this.isEqualsCondition(p.getParamType(), values.get(0), p.getConditionValue())) continue;
                            apiCallResult = false;
                            failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u5728(%s)\u4e4b\u5185", p.getShowParamName(), o, p.getConditionValue());
                            break;
                        }
                        if (values.contains(o.toString())) continue;
                        apiCallResult = false;
                        failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u5728(%s)\u4e4b\u5185", p.getShowParamName(), o, p.getConditionValue());
                        break;
                    }
                    apiCallResult = false;
                    failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u5728(%s)\u4e4b\u5185", p.getShowParamName(), o, p.getConditionValue());
                    break;
                }
            }
        }
        judgeResultMap.put(API_CALL_RESULT, apiCallResult);
        judgeResultMap.put(FAIL_MSG, failMsg);
        return judgeResultMap;
    }

    private boolean isEqualsCondition(String type, Object currentValue, String conditionValue) {
        Object parseValue = ParamsConvertUtil.parseDataType((Object)currentValue, (Integer)Integer.valueOf(type), (boolean)true);
        Object parseConditionValue = ParamsConvertUtil.parseDataType((Object)conditionValue, (Integer)Integer.valueOf(type), (boolean)true);
        return HussarUtils.equals((Object)parseValue, (Object)parseConditionValue);
    }

    public AuthWSDLVo getAuthWSDLVo(String appCode, String wsdlPath) {
        return this.authWsdlInfoService.getLocalWsdlInfo(appCode, wsdlPath);
    }

    public WebserviceAuthInfoDto getEaiWebserviceAuthParams(List<EaiHttpParams> header, List<EaiHttpParams> body, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap, EaiAuthWsdlInfo eaiAuthWsdlInfo) {
        WebserviceAuthInfoDto paramsVo = new WebserviceAuthInfoDto();
        paramsVo.setHttpBody(this.getSourceName(body, commonConstantsMap, applicationAuthMap));
        paramsVo.setHttpHeader(this.getSourceName(header, commonConstantsMap, applicationAuthMap));
        EaiWsApiParams eaiWsApiParams = new EaiWsApiParams();
        eaiWsApiParams.setId(String.valueOf(eaiAuthWsdlInfo.getWsdlId()));
        eaiWsApiParams.setServiceName(eaiAuthWsdlInfo.getWsdlService());
        eaiWsApiParams.setPortName(eaiAuthWsdlInfo.getServicePort());
        eaiWsApiParams.setOperationName(eaiAuthWsdlInfo.getWsdlOperation());
        eaiWsApiParams.setAddress(eaiAuthWsdlInfo.getWsdlAddress());
        eaiWsApiParams.setWsdlPath(eaiAuthWsdlInfo.getWsdlPath());
        paramsVo.setWsApiParams(eaiWsApiParams);
        return paramsVo;
    }

    public Map<String, Object> requestParamsPackage(WebServiceInvokeParamsDto requestParam) {
        return (Map)JSON.parseObject((String)JSON.toJSONString((Object)requestParam), Map.class);
    }

    public EaiHttpVerifyBase insertHttpVerify(Long extendId) {
        EaiHttpVerifyBase httpVerifyBase = new EaiHttpVerifyBase();
        httpVerifyBase.setHttpBaseId(Long.valueOf(IdWorker.getId((Object)new EaiHttpVerifyBase())));
        httpVerifyBase.setExtendId(extendId);
        this.httpVerifyBaseService.save((Object)httpVerifyBase);
        return httpVerifyBase;
    }

    private List<AuthWSDLParams> authWSDLParamsItems(List<AuthWSDLParams> list, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap) {
        ArrayList<AuthWSDLParams> authWSDLParams = new ArrayList<AuthWSDLParams>();
        if (HussarUtils.isEmpty(list)) {
            return null;
        }
        for (AuthWSDLParams authWSDLParam : list) {
            if (HussarUtils.isNotEmpty((Object)authWSDLParam.getItems())) {
                List<AuthWSDLParams> items = this.authWSDLParamsItems(authWSDLParam.getItems(), commonConstantsMap, applicationAuthMap);
                authWSDLParam.setItems(items);
            }
            String paramsFrom = authWSDLParam.getParamsFrom();
            String val = authWSDLParam.getParamsValue();
            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(paramsFrom)) {
                authWSDLParam.setSourceName(commonConstantsMap.get(Long.valueOf(val)).getConstantNameEn());
            } else if ("2".equals(paramsFrom) && HussarUtils.isNotEmpty((Object)val) && null != applicationAuthMap.get(Long.valueOf(val))) {
                authWSDLParam.setSourceName(applicationAuthMap.get(Long.valueOf(val)).getParamsNameEn());
            } else if ("0".equals(paramsFrom)) {
                authWSDLParam.setSourceName(authWSDLParam.getParamsValue());
            }
            authWSDLParams.add(authWSDLParam);
        }
        return authWSDLParams;
    }

    public void getAuthParams(List<EaiWsParamsVo> params, List<EaiWsParamsVo> authParams) {
        if (CollectionUtil.isNotEmpty(params)) {
            for (EaiWsParamsVo p : params) {
                if (HussarUtils.isEmpty((Object)p.getParamsNameEn())) {
                    p.setParamsNameEn(p.getParamsName());
                }
                if ("2".equals(p.getParamsFrom())) {
                    authParams.add(p);
                    continue;
                }
                if (!HussarUtils.isEmpty((Object)p.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)p.getParamsValue())) continue;
                List authWSDLParams = JSON.parseArray((String)p.getParamsValue(), AuthWSDLParams.class);
                for (AuthWSDLParams authWSDLParam : authWSDLParams) {
                    if (!"2".equals(authWSDLParam.getParamsFrom())) continue;
                    EaiWsParamsVo eaiHttpParams = new EaiWsParamsVo();
                    BeanUtil.copyProperties((Object)authWSDLParam, (Object)eaiHttpParams);
                    eaiHttpParams.setParamsName(authWSDLParam.getName());
                    authParams.add(eaiHttpParams);
                }
            }
        }
    }

    public List<AuthWSDLParams> getSourceName(List<EaiHttpParams> params, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap) {
        ArrayList paramsVos = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(params)) {
            for (EaiHttpParams p : params) {
                AuthWSDLParams pVo = new AuthWSDLParams();
                if (!HussarUtils.isNotEmpty((Object)p.getParamsValue())) continue;
                pVo = (AuthWSDLParams)JSON.parseObject((String)p.getParamsValue(), AuthWSDLParams.class);
                if (HussarUtils.isEmpty((Object)pVo.getParamsFrom())) {
                    List<AuthWSDLParams> items = this.authWSDLParamsItems(pVo.getItems(), commonConstantsMap, applicationAuthMap);
                    pVo.setItems(items);
                    pVo.setParamsValue(null);
                } else if (BOOLEAN_TRUE_CONDITIONVALUE.equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(commonConstantsMap.get(Long.valueOf(pVo.getParamsValue())).getConstantNameEn());
                } else if ("2".equals(pVo.getParamsFrom()) && HussarUtils.isNotEmpty((Object)pVo.getParamsValue()) && null != applicationAuthMap.get(Long.valueOf(pVo.getParamsValue()))) {
                    pVo.setSourceName(applicationAuthMap.get(Long.valueOf(pVo.getParamsValue())).getParamsNameEn());
                } else if ("0".equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(pVo.getParamsValue());
                }
                paramsVos.add(pVo);
            }
        }
        return paramsVos;
    }

    public List<EaiWsParamsVo> getAuthSourceName(List<EaiWsParamsVo> params, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap) {
        ArrayList paramsVos = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(params)) {
            for (EaiWsParamsVo pVo : params) {
                if (BOOLEAN_TRUE_CONDITIONVALUE.equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(commonConstantsMap.get(Long.valueOf(pVo.getParamsValue())).getConstantNameEn());
                } else if ("2".equals(pVo.getParamsFrom()) && HussarUtils.isNotEmpty((Object)pVo.getParamsValue()) && null != applicationAuthMap.get(Long.valueOf(pVo.getParamsValue()))) {
                    pVo.setSourceName(applicationAuthMap.get(Long.valueOf(pVo.getParamsValue())).getParamsNameEn());
                } else if ("0".equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(pVo.getParamsValue());
                }
                paramsVos.add(pVo);
            }
        }
        return paramsVos;
    }

    public EaiHttpExtend getCertainStepByTemplateId(Long templateId, String stepcod) {
        return (EaiHttpExtend)this.httpExtendService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)templateId)).eq(EaiHttpExtend::getStepCode, (Object)stepcod));
    }

    public Map<String, EaiParamsPosition> queryAuthParamsPositionMap(Long templateId, String stepCode) {
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(templateId, stepCode);
        List eaiParamsPositions = this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
        return eaiParamsPositions.stream().collect(Collectors.toMap(EaiParamsPosition::getParamsPosition, Function.identity()));
    }

    public List<AuthWSDLParams> queryTokenParamsMap(Long templateId, String stepCode) {
        LambdaQueryWrapper queryParamsWrapper;
        List list;
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(templateId, stepCode);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendThird.getExtendId());
        EaiHttpVerifyBase eaiHttpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiHttpVerifyBase) && HussarUtils.isNotEmpty((Object)(list = this.httpParamsService.list((Wrapper)(queryParamsWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)eaiHttpVerifyBase.getHttpBaseId())))))) {
            return this.getWSDLParams(list);
        }
        return null;
    }

    public List<EaiParamsPosition> queryAuthParamsPosition(Long templateId, String stepCode) {
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(templateId, stepCode);
        return this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
    }

    public void paramsPositionCheck(List<EaiHttpParams> paramsDtos, String tip) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            List paramsName = paramsDtos.stream().map(EaiHttpParams::getParamsNameEn).collect(Collectors.toList());
            HashSet paramsNameSet = Sets.newHashSetWithExpectedSize((int)10);
            for (String paramName : paramsName) {
                if (paramsNameSet.contains(paramName)) {
                    throw new BaseException(String.format(ERROR, tip, paramName));
                }
                paramsNameSet.add(paramName);
            }
        }
    }

    public void authParamsCheck(List<AuthWSDLParams> paramsDtos, String tip) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            List paramsName = paramsDtos.stream().map(AuthWSDLParams::getName).collect(Collectors.toList());
            HashSet paramsNameSet = Sets.newHashSetWithExpectedSize((int)10);
            for (String paramName : paramsName) {
                if (paramsNameSet.contains(paramName)) {
                    throw new BaseException(String.format(ERROR, tip, paramName));
                }
                paramsNameSet.add(paramName);
            }
            for (AuthWSDLParams paramsDto : paramsDtos) {
                if (!HussarUtils.isNotEmpty((Object)paramsDto.getItems())) continue;
                this.authParamsCheck(paramsDto.getItems(), tip);
            }
        }
    }

    public Map<String, Object> getValueMap(String paramsDto, EaiApiResponse apiResponseVo) {
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)5);
        if (paramsDto.contains(PARAMSFROM_EXPRESSION_BODY)) {
            valueMap.put(HTTP_BODY, apiResponseVo.getBody());
        } else if (paramsDto.contains(PARAMSFROM_EXPRESSION_HEADER)) {
            valueMap.put(HTTP_HEADER, apiResponseVo.getHeader());
        }
        return valueMap;
    }

    public Map<String, Object> getValueMap(String paramsDto, Object apiResponseVo) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>(5);
        if (HussarUtils.isEmpty((Object)apiResponseVo)) {
            return valueMap;
        }
        if (apiResponseVo instanceof JSONObject) {
            if (paramsDto.contains(PARAMSFROM_EXPRESSION_BODY)) {
                valueMap.put(HTTP_BODY, ((JSONObject)apiResponseVo).get((Object)"body"));
            } else if (paramsDto.contains(PARAMSFROM_EXPRESSION_HEADER)) {
                valueMap.put(HTTP_HEADER, ((JSONObject)apiResponseVo).get((Object)"header"));
            }
        }
        return valueMap;
    }
}

