/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.auth.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLServiceVo;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLVo;
import com.jxdinfo.hussar.eai.webservice.common.entity.WSDLinfo;
import com.jxdinfo.hussar.eai.webservice.common.service.IWsdlConnService;
import com.jxdinfo.hussar.eai.webservice.common.service.IWsdlSaveService;
import com.jxdinfo.hussar.eai.webservice.common.vo.LocalWSDLServiceVo;
import com.jxdinfo.hussar.eai.webservice.common.vo.WSDLServiceVo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAppWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IWsdlInfoService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.auth.server.service.impl.authWsdlInfoServiceImpl")
public class AuthWsdlInfoServiceImpl
implements IAuthWsdlInfoService {
    @Resource
    IWsdlConnService wsdlConnService;
    @Resource
    IWsdlSaveService iWsdlSaveService;
    @Resource
    IWsdlInfoService iWsdlInfoService;

    public AuthWSDLVo getAndSaveWsdlInfo(String appCode, String wsdlPath) {
        LocalWSDLServiceVo wsdLinfoDto = this.wsdlConnService.connAndSave(appCode, wsdlPath);
        AuthWSDLVo wsdlServiceVos = (AuthWSDLVo)BeanUtil.copy((Object)wsdLinfoDto, AuthWSDLVo.class);
        return wsdlServiceVos;
    }

    public AuthWSDLVo getLocalWsdlInfo(String appCode, String wsdlPath) {
        EaiAppWsdl eaiAppWsdl = this.iWsdlSaveService.getWsdlContent(appCode, wsdlPath);
        WSDLinfo wsdLinfoDto = null;
        Long id = null;
        if (HussarUtils.isEmpty((Object)eaiAppWsdl)) {
            LocalWSDLServiceVo localWSDLServiceVo = this.wsdlConnService.connAndSave(appCode, wsdlPath);
            wsdLinfoDto = localWSDLServiceVo.getWsdLinfoDto();
            id = localWSDLServiceVo.getWsdlId();
        } else {
            wsdLinfoDto = (WSDLinfo)JSON.parseObject((String)eaiAppWsdl.getWsdlContent(), WSDLinfo.class);
            id = eaiAppWsdl.getId();
        }
        List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
        List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, WSDLServiceVo.class);
        AuthWSDLVo authWSDLVo = new AuthWSDLVo();
        authWSDLVo.setWsdlServiceVos(BeanUtil.copyProperties((Collection)wsdlServiceVos, AuthWSDLServiceVo.class));
        authWSDLVo.setWsdlId(id);
        return authWSDLVo;
    }

    public List<AuthWSDLVo> getWsdlInfoByAppCode(String applicationCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiAppWsdl::getApplicationCode, (Object)applicationCode);
        List eaiAppWsdls = this.iWsdlInfoService.list((Wrapper)queryWrapper);
        ArrayList<AuthWSDLVo> list = new ArrayList<AuthWSDLVo>();
        if (HussarUtils.isNotEmpty((Object)eaiAppWsdls)) {
            for (EaiAppWsdl eaiAppWsdl : eaiAppWsdls) {
                AuthWSDLVo localWSDLServiceVo = new AuthWSDLVo();
                WSDLinfo wsdLinfoDto = (WSDLinfo)JSON.parseObject((String)eaiAppWsdl.getWsdlContent(), WSDLinfo.class);
                List wsdlServiceDtos = wsdLinfoDto.getWsdlServiceDtos();
                List wsdlServiceVos = BeanUtil.copy((Collection)wsdlServiceDtos, AuthWSDLServiceVo.class);
                localWSDLServiceVo.setWsdlServiceVos(wsdlServiceVos);
                localWSDLServiceVo.setWsdlId(eaiAppWsdl.getId());
                localWSDLServiceVo.setApplicationCode(applicationCode);
                localWSDLServiceVo.setWsdlPath(eaiAppWsdl.getWsdlPath());
                list.add(localWSDLServiceVo);
            }
        }
        return list;
    }
}

