/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.auth.server.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiTokenInvali;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiTokenInvaliService;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IAuthWsRecycleService;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAuthWsdlInfo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiWebserviceTemplate;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAuthWsdlInfoService;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiWebserviceTemplateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.auth.server.service.impl.AuthWsRecycleServiceImpl")
public class AuthWsRecycleServiceImpl
implements IAuthWsRecycleService {
    @Resource
    private IEaiWebserviceTemplateService eaiWebserviceTemplateService;
    @Resource
    private IEaiHttpVerifyBaseService eaiHttpVerifyBaseService;
    @Resource
    private IEaiHttpExtendService eaiHttpExtendService;
    @Resource
    private IEaiAuthWsdlInfoService eaiAuthWsdlInfoService;
    @Resource
    private IEaiHttpParamsService httpParamsService;
    @Resource
    private IEaiTokenInvaliService eaiTokenInvaliService;

    @HussarTransactional
    public void removeAll(String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiWebserviceTemplate::getApplicationCode, (Object)appCode);
        List list = this.eaiWebserviceTemplateService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)list)) {
            List id = list.stream().map(EaiWebserviceTemplate::getId).collect(Collectors.toList());
            this.eaiWebserviceTemplateService.removeByIds(id);
            LambdaQueryWrapper extendQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{EaiHttpExtend::getExtendId}).in(EaiHttpExtend::getTemplateId, id);
            List eaiHttpExtends = this.eaiHttpExtendService.list((Wrapper)extendQueryWrapper);
            if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
                List<Long> extendIdList = eaiHttpExtends.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
                this.removeTokenInval(extendIdList);
                this.removeHttpBase(extendIdList);
                this.removeAuthWsInfo(extendIdList);
            }
        }
    }

    private void removeTokenInval(List<Long> list) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiTokenInvali::getExtendId, list);
        this.eaiTokenInvaliService.remove((Wrapper)queryWrapper);
    }

    private void removeAuthWsInfo(List<Long> list) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiAuthWsdlInfo::getExtendId, list);
        this.eaiAuthWsdlInfoService.remove((Wrapper)queryWrapper);
    }

    private void removeHttpBase(List<Long> list) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{EaiHttpVerifyBase::getHttpBaseId}).in(EaiHttpVerifyBase::getExtendId, list);
        List eaiHttpVerifyBaseList = this.eaiHttpVerifyBaseService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)eaiHttpVerifyBaseList)) {
            List<Long> ids = eaiHttpVerifyBaseList.stream().map(EaiHttpVerifyBase::getHttpBaseId).collect(Collectors.toList());
            this.eaiHttpVerifyBaseService.removeByIds(ids);
            this.removeHttpParams(ids);
        }
    }

    private void removeHttpParams(List<Long> list) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiHttpParams::getHttpId, list);
        this.httpParamsService.remove((Wrapper)queryWrapper);
    }
}

