/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.auth.server.manager.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiTokenInvali;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiTokenInvaliService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.impl.HttpAuthenticationTokenManagerServiceImpl;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWebServiceAuthDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.EaiWsApiParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebServiceAuthVerfiyDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.dto.WebserviceAuthInfoDto;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IEaiWebserviceAuthenticationManagerExtendService;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLParams;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.AuthWSDLVo;
import com.jxdinfo.hussar.eai.webservice.auth.api.vo.EaiWebServiceTemplateVo;
import com.jxdinfo.hussar.eai.webservice.auth.server.factory.EaiWebServiceAuthenticationFactory;
import com.jxdinfo.hussar.eai.webservice.auth.server.manager.CommomWebServiceAuthWayManager;
import com.jxdinfo.hussar.eai.webservice.common.dto.WebServiceInvokeParamsDto;
import com.jxdinfo.hussar.eai.webservice.common.util.SoapMessageUtil;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiAuthWsdlInfo;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiWebserviceTemplate;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiAuthWsdlInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.webservice.auth.server.manager.base.webServiceAuthenticationTokenManagerServiceImpl")
public class WebServiceAuthenticationTokenManagerServiceImpl
extends CommomWebServiceAuthWayManager
implements IEaiWebserviceAuthenticationManagerExtendService<EaiWebServiceAuthDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAuthenticationTokenManagerServiceImpl.class);
    private static final String GET_WS_TOKEN_STATUS = "GET_WS_TOKEN_STATUS";
    private static final String TOKEN_GETING = "0";
    private static final String TOKEN_GOT = "1";
    private static final Long GET_TOKEN_LOADING_TIME = 100L;
    private static final Integer GET_TOKEN_LOADING_MAX_COUNT = 10;
    @Resource
    protected IEaiHttpExtendService httpExtendService;
    @Resource
    protected IEaiParamsPositionService paramsPositionService;
    @Resource
    private IEaiAuthWsdlInfoService eaiAuthWsdlInfoService;
    @Resource
    private IEaiHttpParamsService httpParamsService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    @Resource
    private IEaiTokenInvaliService tokenInvaliService;

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> webserviceAuthInfoSave(HttpAuthDto tokenDto) {
        EaiWebserviceTemplate templateDto = this.saveFirstStep(tokenDto);
        String key = String.format("eai:api:debug:token:%s", templateDto.getApplicationCode());
        try {
            HussarCacheUtil.evictKeysLike((String)key, (String)key);
        }
        catch (Exception e) {
            LOGGER.warn("\u6e05\u7a7awebservice token\u7f13\u5b58", (Throwable)e);
        }
        JSONObject second = (JSONObject)tokenDto.getHttpAuth().get(1);
        EaiHttpExtend extendsecond = new EaiHttpExtend();
        extendsecond.setExtendId(Long.valueOf(IdWorker.getId((Object)new EaiHttpExtend())));
        extendsecond.setStepCode("2");
        extendsecond.setRemark("http\u9274\u6743\u7b2c\u4e8c\u6b65\uff1a\u83b7\u53d6token");
        extendsecond.setTemplateId(templateDto.getId());
        this.httpExtendService.save((Object)extendsecond);
        WebServiceAuthVerfiyDto eaiTokenDto = (WebServiceAuthVerfiyDto)JSON.parseObject((String)second.toString(), WebServiceAuthVerfiyDto.class);
        EaiHttpVerifyBase httpVerifyBase = this.insertHttpVerify(extendsecond.getExtendId());
        List<EaiHttpParams> httpParams = this.paddingHttpParamsInfo(eaiTokenDto, httpVerifyBase);
        this.httpParamsService.saveBatch(httpParams);
        EaiWsApiParams eaiWsApiParams = eaiTokenDto.getWsApiParams();
        EaiAuthWsdlInfo eaiAuthWsdlInfo = this.getEaiAuthWsdlInfo(eaiWsApiParams, extendsecond.getExtendId());
        this.eaiAuthWsdlInfoService.save((Object)eaiAuthWsdlInfo);
        List tokenInvalis = eaiTokenDto.getTokenInvalis();
        for (EaiTokenInvali v : tokenInvalis) {
            v.setExtendId(extendsecond.getExtendId());
        }
        this.tokenInvaliService.saveBatch((Collection)tokenInvalis);
        this.saveHttpParamsPosition(tokenDto, templateDto, "3", 2);
        return ApiResponse.success((Object)templateDto.getId());
    }

    public ApiResponse<Boolean> webserviceAuthEdit(HttpAuthDto tokenDto, EaiWebserviceTemplate eaiWebserviceTemplateOld, EaiWebserviceTemplate currentTemp) {
        EaiHttpExtend extendSecond;
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(eaiWebserviceTemplateOld.getId(), "3");
        if (null != extendThird) {
            this.paramsPositionService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
            this.httpExtendService.removeById((Serializable)extendThird.getExtendId());
        }
        if (null != (extendSecond = this.getCertainStepByTemplateId(eaiWebserviceTemplateOld.getId(), "2"))) {
            EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendSecond.getExtendId()));
            this.tokenInvaliService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)extendSecond.getExtendId()));
            this.httpVerifyBaseService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendSecond.getExtendId()));
            this.eaiAuthWsdlInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiAuthWsdlInfo::getExtendId, (Object)extendSecond.getExtendId()));
            if (null != httpVerifyBase) {
                this.httpParamsService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
            }
            this.httpExtendService.removeById((Serializable)extendSecond.getExtendId());
        }
        this.webserviceTemplateService.removeById((Serializable)eaiWebserviceTemplateOld.getId());
        this.httpExtendService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiWebserviceTemplateOld.getId())).eq(EaiHttpExtend::getStepCode, (Object)TOKEN_GOT));
        if (null != tokenDto) {
            this.deleteFinalStep(tokenDto, eaiWebserviceTemplateOld, currentTemp);
        }
        return ApiResponse.success();
    }

    public ApiResponse<EaiApiResponseVo> webServiceAuthVerify(WebServiceAuthVerfiyDto authVerifyDto, boolean isPublished, int repeatCount) {
        String appCode = authVerifyDto.getApplicationCode();
        AssertUtil.isNotEmpty((String)appCode, (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.initHttpAuthVerify(authVerifyDto.getServiceId(), "TOKEN\u9274\u6743", isPublished);
        WebServiceAuthVerfiyDto authVerifyDtoClone = (WebServiceAuthVerfiyDto)JSON.parseObject((String)JSON.toJSONString((Object)authVerifyDto), authVerifyDto.getClass());
        EaiWebserviceTemplate eaiHttpTemplate = authVerifyDto.getEaiWebserviceTemplate();
        List bodyParams = authVerifyDto.getHttpBody();
        List header = authVerifyDto.getHttpHeader();
        List<AuthWSDLParams> params = this.queryTokenParamsMap(eaiHttpTemplate.getId(), "2");
        List<AuthWSDLParams> tokenHeader = null;
        List tokenBody = null;
        if (HussarUtils.isNotEmpty(params)) {
            tokenHeader = params.stream().filter(p -> TOKEN_GETING.equals(p.getParamsPosition())).collect(Collectors.toList());
            tokenBody = params.stream().filter(p -> TOKEN_GOT.equals(p.getParamsPosition())).collect(Collectors.toList());
        }
        Map<String, List<EaiHttpParamsDto>> tokenMap = this.getEaiApiParams(authVerifyDto.getServiceId(), eaiHttpTemplate.getId(), tokenBody, tokenHeader, authVerifyDto.getTokenVerifys(), null, "2", isPublished);
        EaiWsApiParams testParams = this.getTestParams(eaiHttpTemplate.getId(), "2");
        WebServiceInvokeParamsDto tokenParams = this.webServiceRequestService.getWebserviceRequestParams(tokenMap, testParams, Boolean.valueOf(isPublished), Boolean.valueOf(false), Boolean.valueOf(true));
        SOAPMessage tokenSoapMessage = this.getRequestSOAP(tokenParams);
        JSONObject tokenResp = null;
        String cacheKey = StringUtil.isNotEmpty((Object)authVerifyDto.getDebugCacheKey()) ? authVerifyDto.getDebugCacheKey() : String.format("ws_%s", authVerifyDto.getApplicationCode());
        if (authVerifyDto.isHasCache() && HussarCacheUtil.containKey((String)cacheKey, (Object)cacheKey)) {
            tokenResp = (JSONObject)HussarCacheUtil.get((String)cacheKey, (Object)cacheKey);
        } else {
            try {
                HussarCacheUtil.put((String)cacheKey, (Object)GET_WS_TOKEN_STATUS, (Object)TOKEN_GETING);
                SOAPMessage tokenResponse = this.webServiceRequestService.getWebserviceResp(tokenSoapMessage, testParams, Boolean.valueOf(!isPublished));
                tokenResp = this.webServiceRequestService.getWebserviceResp(tokenResponse);
                if (tokenResp != null) {
                    HussarCacheUtil.put((String)cacheKey, (Object)cacheKey, (Object)tokenResp);
                }
                HussarCacheUtil.evict((String)cacheKey, (Object)GET_WS_TOKEN_STATUS);
            }
            catch (BaseException e) {
                EaiApiResponseVo eaiApiResponseVo = this.requestParamsInfo(tokenSoapMessage, e.getMessage());
                this.requestTokenParamsInfo(tokenSoapMessage, eaiApiResponseVo);
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
            catch (Exception ex) {
                throw new BaseException("TOKEN\u8bf7\u6c42\u5931\u8d25", (Throwable)ex);
            }
        }
        EaiApiResponseVo eaiApiResponse = new EaiApiResponseVo();
        if (HussarUtils.isNotEmpty((Object)tokenResp)) {
            EaiApiResponse eaiApiResponse1 = new EaiApiResponse();
            eaiApiResponse1.setBody((Object)tokenResp);
            eaiApiResponse.setTokenResponse(eaiApiResponse1);
        }
        this.requestTokenParamsInfo(tokenSoapMessage, eaiApiResponse);
        EaiHttpExtend extendSecond = this.getCertainStepByTemplateId(eaiHttpTemplate.getId(), "2");
        List eaiTokenInvalis = this.tokenInvaliService.list((Wrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)extendSecond.getExtendId()));
        Map<String, List<EaiHttpParamsDto>> map = null;
        try {
            map = this.getEaiApiParams(authVerifyDto.getServiceId(), eaiHttpTemplate.getId(), bodyParams, header, authVerifyDto.getTokenVerifys(), tokenResp, "3", isPublished);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6token\u5f02\u5e38", (Throwable)e);
            EaiApiResponseVo eaiApiResponseVo = new EaiApiResponseVo();
            EaiApiResponse apiResponse = new EaiApiResponse();
            apiResponse.setException("\u83b7\u53d6token\u5f02\u5e38");
            eaiApiResponseVo.setEscapeResponse((Object)apiResponse);
            return ApiResponse.success((Object)eaiApiResponseVo);
        }
        WebServiceInvokeParamsDto requestParams = this.webServiceRequestService.getWebserviceRequestParams(map, authVerifyDto.getWsApiParams(), Boolean.valueOf(isPublished), Boolean.valueOf(true), Boolean.valueOf(false));
        SOAPMessage soapMessage = this.getRequestSOAP(requestParams);
        SOAPMessage response = null;
        ApiResponse<EaiApiResponseVo> eaiApiResponseVo = null;
        try {
            response = this.webServiceRequestService.getWebserviceResp(soapMessage, authVerifyDto.getWsApiParams(), Boolean.valueOf(!isPublished));
        }
        catch (BaseException e) {
            LOGGER.error("response", (Throwable)e);
            eaiApiResponseVo = ApiResponse.success((Object)this.requestParamsInfo(soapMessage, e.getMessage()));
        }
        catch (Exception ex) {
            throw new BaseException("WEBSERVICE\u8bf7\u6c42\u5931\u8d25", (Throwable)ex);
        }
        if (eaiApiResponseVo == null) {
            this.pushMsg(authVerifyDto.getServiceId(), "\u8bf7\u6c42\u7ed3\u675f\uff0c\u5f00\u59cb\u7ec4\u88c5\u8fd4\u56de\u503c...", isPublished);
            eaiApiResponseVo = HussarUtils.isNotEmpty((Object)authVerifyDto.getOutMapping()) ? this.outUriRreponseDataPackage(authVerifyDto.getServiceId(), requestParams, response, eaiApiResponse, authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), true, isPublished) : this.authReponseDataPackage(authVerifyDto.getServiceId(), requestParams, soapMessage, response, eaiApiResponse, authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), true, isPublished);
        }
        if (HussarUtils.isEmpty((Object)eaiTokenInvalis)) {
            if (HussarUtils.isEmpty((Object)tokenResp)) {
                LOGGER.info("\u6e05\u7a7a\u7f13\u5b58{}-{}", (Object)cacheKey, (Object)cacheKey);
                HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
            }
            return eaiApiResponseVo;
        }
        boolean tokenInvali = false;
        Object object = ((EaiApiResponseVo)eaiApiResponseVo.getData()).getEscapeResponse();
        if (object instanceof ApiResponse) {
            EaiApiResponse response1 = new EaiApiResponse();
            response1.setBody(object);
            try {
                tokenInvali = this.judgeInvali(response1, eaiTokenInvalis, isPublished);
            }
            catch (Exception e) {
                LOGGER.error("\u9274\u6743\u53c2\u6570\u5931\u6548\u5224\u65ad\u5f02\u5e38", (Throwable)e);
                eaiApiResponseVo.setMsg(e.getMessage());
                return eaiApiResponseVo;
            }
            if (tokenInvali) {
                EaiApiResponse out;
                if (HussarUtils.isNotEmpty((Object)object)) {
                    ((ApiResponse)object).setMsg("token\u5df2\u5931\u6548");
                    ((ApiResponse)object).setSuccess(false);
                    ((EaiApiResponseVo)eaiApiResponseVo.getData()).setEscapeResponse(object);
                }
                if (HussarUtils.isNotEmpty((Object)(out = ((EaiApiResponseVo)eaiApiResponseVo.getData()).getOuturlResponse()))) {
                    out.setException("token\u5df2\u5931\u6548");
                    ((EaiApiResponseVo)eaiApiResponseVo.getData()).setOuturlResponse(out);
                }
                LOGGER.info("token\u5df2\u5931\u6548:{}-{}", (Object)cacheKey, (Object)cacheKey);
                if (!authVerifyDto.isHasCache()) {
                    return eaiApiResponseVo;
                }
                if (StringUtil.isNotEmpty((Object)HussarCacheUtil.get((String)cacheKey, (Object)GET_WS_TOKEN_STATUS)) && TOKEN_GETING.equals(HussarCacheUtil.get((String)cacheKey, (Object)GET_WS_TOKEN_STATUS))) {
                    int count = 0;
                    try {
                        while (TOKEN_GETING.equals(HussarCacheUtil.get((String)cacheKey, (Object)GET_WS_TOKEN_STATUS))) {
                            LOGGER.info("token\u5df2\u5931\u6548:{}-{},\u5f53\u524dtoken\u72b6\u6001\u4f4d\uff1a{}-\u6b63\u5728\u83b7\u53d6\uff0c\u7b2c{}\u6b21loading", new Object[]{cacheKey, cacheKey, HussarCacheUtil.get((String)cacheKey, (Object)GET_WS_TOKEN_STATUS), count + 1});
                            if (count < GET_TOKEN_LOADING_MAX_COUNT) {
                                ++count;
                                Thread.sleep(GET_TOKEN_LOADING_TIME);
                                continue;
                            }
                            LOGGER.info("token\u5df2\u5931\u6548,loading\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650{}\u6b21,\u6e05\u7a7a\u7f13\u5b58{}-{}", new Object[]{GET_TOKEN_LOADING_MAX_COUNT, cacheKey, cacheKey});
                            HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("Interrupted!", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                } else {
                    LOGGER.info("token\u5df2\u5931\u6548,\u6e05\u7a7a\u7f13\u5b58{}-{}", (Object)cacheKey, (Object)cacheKey);
                    HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
                }
                if (repeatCount < 2) {
                    this.pushMsg(authVerifyDto.getServiceId(), LogMsgConstant.getTestSendRe((Integer)(++repeatCount)), isPublished);
                    return this.webServiceAuthVerify(authVerifyDtoClone, isPublished, repeatCount);
                }
            }
        }
        return eaiApiResponseVo;
    }

    private void requestTokenParamsInfo(SOAPMessage soapMessage, EaiApiResponseVo eaiApiResponse) {
        if (HussarUtils.isNotEmpty((Object)soapMessage)) {
            String str = SoapMessageUtil.soapMessage2Xml((SOAPMessage)soapMessage);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("body", str);
            eaiApiResponse.setTokenRequestParams(map);
        }
    }

    public ApiResponse<EaiWebServiceTemplateVo> webServiceAuthDetail(EaiWebServiceTemplateVo eaiWebServiceTemplateVo) {
        Map<Long, CommonConstant> commonConstantsMap = this.getCommonConstantsMap(eaiWebServiceTemplateVo.getApplicationCode());
        Map<Long, EaiApplicationAuth> applicationAuthMap = this.getEaiApplicationAuthMap(eaiWebServiceTemplateVo.getApplicationCode());
        EaiHttpExtend extend = this.getCertainStepByTemplateId(eaiWebServiceTemplateVo.getId(), "2");
        if (HussarUtils.isEmpty((Object)extend)) {
            return ApiResponse.success((Object)eaiWebServiceTemplateVo);
        }
        EaiHttpVerifyBase verifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extend.getExtendId()));
        List params = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)verifyBase.getHttpBaseId()));
        List<EaiHttpParams> header = params.stream().filter(p -> TOKEN_GETING.equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> body = params.stream().filter(p -> TOKEN_GOT.equals(p.getParamsPosition())).collect(Collectors.toList());
        EaiAuthWsdlInfo eaiAuthWsdlInfo = (EaiAuthWsdlInfo)this.eaiAuthWsdlInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiAuthWsdlInfo::getExtendId, (Object)extend.getExtendId()));
        WebserviceAuthInfoDto tokenParams = this.getEaiWebserviceAuthParams(header, body, commonConstantsMap, applicationAuthMap, eaiAuthWsdlInfo);
        eaiWebServiceTemplateVo.setAuthVerify(verifyBase);
        eaiWebServiceTemplateVo.setWsApiParams(tokenParams.getWsApiParams());
        AuthWSDLVo authWSDLVos = this.getAuthWSDLVo(eaiWebServiceTemplateVo.getApplicationCode(), tokenParams.getWsApiParams().getWsdlPath());
        eaiWebServiceTemplateVo.setAuthWSDLVos(authWSDLVos);
        eaiWebServiceTemplateVo.setHttpBody(tokenParams.getHttpBody());
        eaiWebServiceTemplateVo.setHttpHeader(tokenParams.getHttpHeader());
        List invalis = this.tokenInvaliService.list((Wrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)extend.getExtendId()));
        eaiWebServiceTemplateVo.setTokenInvalis(invalis);
        Map<String, EaiParamsPosition> paramsPosissionMap = this.queryAuthParamsPositionMap(eaiWebServiceTemplateVo.getId(), "3");
        this.getWsAuthPosissionParams(eaiWebServiceTemplateVo, commonConstantsMap, applicationAuthMap, paramsPosissionMap);
        return ApiResponse.success((Object)eaiWebServiceTemplateVo);
    }

    private String getKey() {
        return EaiWebServiceAuthenticationFactory.getRegisterExtra(HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey()).get(0);
    }

    private Map<String, String> getDomain() {
        return EaiWebServiceAuthenticationFactory.getRegisterExtraDomain(HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey());
    }

    public ApiResponse<EaiWebServiceAuthDto> selectWebServiceTemplateInfos(String applicationCode, boolean published) {
        EaiWebServiceAuthDto dto = this.commonSelect(applicationCode, published);
        HashMap map = new HashMap();
        List eaiHttpExtends = dto.getHttpExtend();
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
            List ids = eaiHttpExtends.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
            ArrayList eaiTokenInvalis = new ArrayList();
            for (Long id : ids) {
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)id);
                List list1 = this.tokenInvaliService.list((Wrapper)queryWrapper);
                if (!HussarUtils.isNotEmpty((Object)list1)) continue;
                eaiTokenInvalis.addAll(list1);
            }
            String mapperFullPath = this.getKey();
            map.put(mapperFullPath, eaiTokenInvalis);
            HashMap mapperDomain = Maps.newHashMapWithExpectedSize((int)1);
            mapperDomain.put(mapperFullPath, this.getDomain().get(mapperFullPath));
            dto.setMapperDomain((Map)mapperDomain);
            dto.setExtendDto(map);
        }
        return ApiResponse.success((Object)dto);
    }

    public ApiResponse<EaiWebServiceAuthDto> selectWebServiceTemplateInfosWithNewIds(String applicationCode, Boolean publishing) {
        EaiWebServiceAuthDto dto = this.commonSelectNew(applicationCode, publishing);
        HashMap map = new HashMap();
        List eaiHttpExtends = dto.getHttpExtend();
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
            ArrayList<EaiTokenInvali> extraValues = new ArrayList<EaiTokenInvali>();
            Map cmaps = dto.getIdMaps();
            if (HussarUtils.isNotEmpty((Object)cmaps)) {
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiTokenInvali::getExtendId, (Collection)cmaps.keySet().stream().collect(Collectors.toList()));
                List list1 = this.tokenInvaliService.list((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)list1)) {
                    for (EaiTokenInvali eaiTokenInvali : list1) {
                        eaiTokenInvali.setExtendId((Long)cmaps.get(eaiTokenInvali.getExtendId()));
                        eaiTokenInvali.setInvalidationId(EngineUtil.getId());
                        extraValues.add(eaiTokenInvali);
                    }
                }
                map.put(this.getKey(), extraValues);
                dto.setExtendDto(map);
            }
        }
        return ApiResponse.success((Object)dto);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> saveWebServiceTemplateInfos(EaiWebServiceAuthDto eaiWebServiceAuthDto) {
        List list;
        boolean common = this.commonSaveOrUpdateById(eaiWebServiceAuthDto, true);
        Map map = eaiWebServiceAuthDto.getExtendDto();
        boolean extra = true;
        List tokenInvalilist = (List)map.get(this.getKey());
        if (HussarUtils.isNotEmpty((Object)tokenInvalilist) && HussarUtils.isNotEmpty(list = tokenInvalilist.stream().map(o -> (EaiTokenInvali)o).collect(Collectors.toList()))) {
            extra = this.tokenInvaliService.saveBatch(list);
        }
        if (common && extra) {
            return ApiResponse.success((Object)true);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> updateWebServiceTemplateInfos(EaiWebServiceAuthDto eaiWebServiceAuthDto) {
        List list;
        Map map = eaiWebServiceAuthDto.getExtendDto();
        boolean common = this.commonSaveOrUpdateById(eaiWebServiceAuthDto, false);
        boolean extra = true;
        List tokenInvalilist = (List)map.get(this.getKey());
        if (HussarUtils.isNotEmpty((Object)tokenInvalilist) && HussarUtils.isNotEmpty(list = tokenInvalilist.stream().map(o -> (EaiTokenInvali)o).collect(Collectors.toList()))) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiTokenInvali::getExtendId, (Collection)eaiWebServiceAuthDto.getExtendIds());
            this.tokenInvaliService.remove((Wrapper)queryWrapper);
            extra = this.tokenInvaliService.saveBatch(list);
        }
        if (common && extra) {
            return ApiResponse.success((Object)true);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    public void authParamsValueCleanImpl(EaiWebserviceTemplate eaiWebServiceTemplate, Long authParamId) {
        this.updateParamsValue(authParamId, eaiWebServiceTemplate, "2");
        this.positionUpdateParamsValue(eaiWebServiceTemplate, authParamId, "3");
        this.updateParamsValue(authParamId, eaiWebServiceTemplate, "9");
    }

    public boolean verifyAuthParamHasUse(EaiWebserviceTemplate eaiWebServiceTemplate, Long authParamId, String paramsPosition) {
        this.verifyHasUseInStep(authParamId, eaiWebServiceTemplate, "2", paramsPosition);
        this.verifyPositionHasUserposition(eaiWebServiceTemplate, authParamId, "3", paramsPosition);
        this.verifyHasUseInStep(authParamId, eaiWebServiceTemplate, "9", paramsPosition);
        return false;
    }

    public void afterPropertiesSet() throws Exception {
        EaiWebServiceAuthenticationFactory.registerAuth(HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey(), this);
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(IEaiTokenInvaliService.class.getName());
        HashMap mapperDomain = Maps.newHashMapWithExpectedSize((int)1);
        mapperDomain.put(IEaiTokenInvaliService.class.getName(), EaiTokenInvali.class.getName());
        EaiWebServiceAuthenticationFactory.registerExtra(HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey(), list);
        EaiWebServiceAuthenticationFactory.registerExtraDomain(HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey(), mapperDomain);
    }

    private WebserviceAuthInfoDto packageEaiTokenDto(EaiWebserviceTemplate webserviceTemplate, WebServiceAuthVerfiyDto authVerifyDto) {
        WebserviceAuthInfoDto eaiTokenDto = new WebserviceAuthInfoDto();
        EaiHttpExtend extendSencod = this.getCertainStepByTemplateId(webserviceTemplate.getId(), "2");
        EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendSencod.getExtendId()));
        eaiTokenDto.setHttpVerifyBase(httpVerifyBase);
        List eaiHttpParams = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
        List httpParamsHeader = eaiHttpParams.stream().filter(p -> TOKEN_GETING.equals(p.getParamsPosition())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(httpParamsHeader)) {
            eaiTokenDto.setHeader(httpParamsHeader);
        }
        if (HussarUtils.isNotEmpty((Object)httpVerifyBase.getContentType())) {
            List httpParamsBody = eaiHttpParams.stream().filter(p -> TOKEN_GOT.equals(p.getParamsPosition())).collect(Collectors.toList());
            eaiTokenDto.setBody(httpParamsBody);
        }
        EaiWsApiParams eaiWsApiParams = new EaiWsApiParams();
        eaiTokenDto.setId(webserviceTemplate.getId());
        return eaiTokenDto;
    }

    private boolean judgeInvali(EaiApiResponse outurlResponse, List<EaiTokenInvali> eaiTokenInvalis, Boolean isPublished) {
        boolean tokenInvali = false;
        for (EaiTokenInvali p : eaiTokenInvalis) {
            List values;
            Set valueSet;
            Map<String, Object> valueMap = this.getValueMap(p.getParamName(), outurlResponse);
            Object o = this.expressionEngineService.executeExpression(p.getParamName(), valueMap, isPublished.booleanValue());
            if (HussarUtils.isEmpty((Object)o)) break;
            if ("00".equals(p.getJudgeCondition())) {
                if (!o.toString().equals(p.getConditionValue())) continue;
                tokenInvali = true;
                break;
            }
            if ("01".equals(p.getJudgeCondition())) {
                if (o.toString().equals(p.getConditionValue())) continue;
                tokenInvali = true;
                break;
            }
            if (!"02".equals(p.getJudgeCondition()) || !HussarUtils.isNotEmpty((Object)p.getConditionValue()) || !(valueSet = (values = Stream.of(p.getConditionValue().split(",")).collect(Collectors.toList())).stream().collect(Collectors.toSet())).contains(o.toString())) continue;
            tokenInvali = true;
            break;
        }
        return tokenInvali;
    }

    private EaiAuthWsdlInfo getEaiAuthWsdlInfo(EaiWsApiParams eaiWsApiParams, Long extId) {
        EaiAuthWsdlInfo eaiAuthWsdlInfo = new EaiAuthWsdlInfo();
        eaiAuthWsdlInfo.setId(EngineUtil.getId());
        eaiAuthWsdlInfo.setWsdlPath(eaiWsApiParams.getWsdlPath());
        eaiAuthWsdlInfo.setWsdlId(Long.valueOf(eaiWsApiParams.getId()));
        eaiAuthWsdlInfo.setWsdlService(eaiWsApiParams.getServiceName());
        eaiAuthWsdlInfo.setServicePort(eaiWsApiParams.getPortName());
        eaiAuthWsdlInfo.setWsdlOperation(eaiWsApiParams.getOperationName());
        eaiAuthWsdlInfo.setWsdlAddress(eaiWsApiParams.getAddress());
        eaiAuthWsdlInfo.setExtendId(extId);
        return eaiAuthWsdlInfo;
    }
}

