/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.webservice.auth.server.factory;

import com.google.common.collect.Maps;
import com.jxdinfo.hussar.eai.webservice.auth.api.service.IEaiWebserviceAuthenticationManagerExtendService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class EaiWebServiceAuthenticationFactory {
    private static Map<String, IEaiWebserviceAuthenticationManagerExtendService> httpAuthMap = Maps.newHashMapWithExpectedSize((int)10);
    private static Map<String, List<String>> httpKeyMap = new HashMap<String, List<String>>();
    private static Map<String, Map<String, String>> httpKeyMapMapperDomain = new HashMap<String, Map<String, String>>();

    public static IEaiWebserviceAuthenticationManagerExtendService getInvokeAuth(String httpAuthMark) {
        return httpAuthMap.get(httpAuthMark);
    }

    public static void registerAuth(String httpAuthMark, IEaiWebserviceAuthenticationManagerExtendService handler) {
        if (HussarUtils.isEmpty((Object)httpAuthMark) && handler == null) {
            return;
        }
        httpAuthMap.put(httpAuthMark, handler);
    }

    public static void registerExtra(String mapperMark, List<String> mapper) {
        if (HussarUtils.isEmpty((Object)mapperMark) && HussarUtils.isEmpty(mapper)) {
            return;
        }
        httpKeyMap.put(mapperMark, mapper);
    }

    public static void registerExtraDomain(String mapperMark, Map<String, String> mapperDomain) {
        if (HussarUtils.isEmpty((Object)mapperMark) && HussarUtils.isEmpty(mapperDomain)) {
            return;
        }
        httpKeyMapMapperDomain.put(mapperMark, mapperDomain);
    }

    public static List<String> getRegisterExtra(String httpAuthMark) {
        return httpKeyMap.get(httpAuthMark);
    }

    public static Map<String, String> getRegisterExtraDomain(String httpAuthMark) {
        return httpKeyMapMapperDomain.get(httpAuthMark);
    }
}

