/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.jxdinfo.hussar.common.treemodel.AbstractNoIconHussarLazyTreeDefinition;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.plugin.context.MigrationReadonlyContext;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class EaiMigrationUtil {
    public static <T extends AbstractNoIconHussarLazyTreeDefinition> void fillHasChildren(T node) {
        if (HussarUtils.isNotEmpty(node)) {
            List children = node.getChildren();
            if (HussarUtils.isNotEmpty((Object)children)) {
                node.setHasChildren(Boolean.valueOf(true));
                for (AbstractNoIconHussarLazyTreeDefinition dictDumpVo : children) {
                    EaiMigrationUtil.fillHasChildren(dictDumpVo);
                }
            } else {
                node.setHasChildren(Boolean.valueOf(false));
            }
        }
    }

    public static <T extends AbstractNoIconHussarLazyTreeDefinition> void fillHasChildren(List<T> nodeList) {
        if (HussarUtils.isNotEmpty(nodeList)) {
            for (AbstractNoIconHussarLazyTreeDefinition node : nodeList) {
                EaiMigrationUtil.fillHasChildren(node);
            }
        }
    }

    public static <T> boolean getDataUpdateFlag(T obj1, T obj2, List<Function<T, Object>> functions) {
        boolean flag = false;
        for (Function<T, Object> function : functions) {
            if (HussarUtils.equals((Object)function.apply(obj1), (Object)function.apply(obj2))) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static <T> int getChangeTypeFromObj(T newObj, T oldObj, List<Function<T, Object>> functionList) {
        int changeType = AppMigrationDataChangeTypeEnum.UNCHANGED.getType();
        if (ToolUtil.isNotEmpty(oldObj)) {
            if (EaiMigrationUtil.getDataUpdateFlag(newObj, oldObj, functionList)) {
                changeType = AppMigrationDataChangeTypeEnum.UPDATE.getType();
            }
        } else {
            changeType = AppMigrationDataChangeTypeEnum.ADD.getType();
        }
        return changeType;
    }

    public static <T, R extends MigrationReadonlyContext> List<T> getListDataFromJsonFile(R context, String key, String value, Class<T> clazz) {
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute(key)))) {
            try {
                byte[] bytes = context.getPayloadAsByteArray(value);
                CollectionType javaType = IdempotentJsonUtils.getTypeFactory().constructCollectionType(List.class, clazz);
                if (ToolUtil.isNotEmpty((Object)bytes)) {
                    return (List)IdempotentJsonUtils.getObjectMapper().readValue(bytes, (JavaType)javaType);
                }
            }
            catch (IOException e) {
                return new ArrayList();
            }
        }
        return new ArrayList();
    }

    public static <R extends MigrationReadonlyContext> Map<Long, List<Long>> getMapDataFromJsonFile(R context, String key, String value) {
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute(key)))) {
            return (Map)context.getPayloadAsJson(value, (TypeReference)new TypeReference<Map<Long, List<Long>>>(){});
        }
        return new HashMap<Long, List<Long>>();
    }

    public static <T, R extends MigrationReadonlyContext> T getDataFromJsonFile(R context, String key, String value, Class<T> clazz) {
        if (HussarUtils.isNotBlank((CharSequence)((String)context.getAttribute(key)))) {
            return (T)context.getPayloadAsJson(value, clazz);
        }
        return null;
    }

    public static <T extends EaiCommonResourcesDto> void replaceCommonResources(List<T> httpAuthResourcesDtos, EaiCommonResourcesDto commonResources) {
        if (HussarUtils.isNotEmpty(httpAuthResourcesDtos)) {
            for (EaiCommonResourcesDto h : httpAuthResourcesDtos) {
                h.setConnectionList(commonResources.getConnectionList());
                h.setConstantList(commonResources.getConstantList());
                h.setCommonLogicList(commonResources.getCommonLogicList());
                h.setWsdlList(commonResources.getWsdlList());
                h.setStructureList(commonResources.getStructureList());
            }
        }
    }
}

