/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.eai.migration.business.constant.SysAdminConstant;
import com.jxdinfo.hussar.eai.migration.business.service.HussarEaiMigrationDumpAuthCheckService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.service.impl.HussarEaiMigrationDumpAuthCheckServiceImpl")
public class HussarEaiMigrationDumpAuthCheckServiceImpl
implements HussarEaiMigrationDumpAuthCheckService {
    @Resource
    private ISysAppDevelopTeamService sysAppDevelopTeamService;
    @Resource
    private ISysApplicationService sysApplicationService;
    private static final String ERROR = "\u5f53\u524d\u7528\u6237\u65e0\u5e94\u7528\u5bfc\u51fa\u6743\u9650";

    public void check(String appCode) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user != null && HussarUtils.isNotEmpty((Object)user.getRolesList())) {
            boolean b;
            if (user.getRolesList().contains(SysAdminConstant.SUPER_ADMIN) || user.getRolesList().contains(SysAdminConstant.PLATFORM_ADMIN)) {
                return;
            }
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode);
            SysApplication sysApplication = (SysApplication)this.sysApplicationService.getOne((Wrapper)queryWrapper);
            if (sysApplication != null && (b = this.sysAppDevelopTeamService.checkCurrentUserInTeam(sysApplication.getId()).booleanValue())) {
                return;
            }
        }
        throw new BaseException(ERROR);
    }
}

