/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiGetAppCodeNameService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiNewAppService;
import com.jxdinfo.hussar.iam.client.dto.ClientDto;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.iam.client.vo.ClientInfoVo;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.service.impl.EaiNewAppServiceImpl")
public class EaiNewAppServiceImpl
implements IEaiNewAppService {
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private IHussarIamClientModelService iHussarIamClientModelService;
    @Autowired
    private ISysAppClientService sysAppClientService;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Autowired
    private ISysAppGroupService sysAppGroupService;
    @Autowired
    private IEaiGetAppCodeNameService eaiGetAppCodeNameService;
    private static final String ERROR_MSG = "\u521b\u5efa\u5e94\u7528\u5ba2\u6237\u7aef\u4fe1\u606f\u5931\u8d25";

    public Boolean addApp(SysApplicationDto sysApplicationDto) {
        AssertUtil.isNotEmpty((String)sysApplicationDto.getAppCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        sysApplicationDto.setId(EngineUtil.getId());
        sysApplicationDto.setAppStatus("1");
        sysApplicationDto.setReleaseStatus("0");
        sysApplicationDto.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        sysApplicationDto.setOpenClient(Boolean.valueOf(true));
        ApiResponse clientInfo = this.iHussarIamClientModelService.getClientInfo();
        ClientDto clientDto = new ClientDto();
        clientDto.setClientSecret(((ClientInfoVo)clientInfo.getData()).getClientSecret());
        clientDto.setAppId(sysApplicationDto.getId());
        clientDto.setClientId(((ClientInfoVo)clientInfo.getData()).getClientId());
        clientDto.setAccessTokenValidTime(1800L);
        try {
            ApiResponse response = this.iHussarIamClientModelService.saveClientModels(clientDto);
            ClientVo data = (ClientVo)response.getData();
            SysAppClient appClient = new SysAppClient();
            appClient.setAppId(sysApplicationDto.getId());
            appClient.setClientModelId(data.getId());
            this.sysAppClientService.save((Object)appClient);
        }
        catch (Exception e) {
            throw new BaseException(ERROR_MSG, (Throwable)e);
        }
        String teamName = sysApplicationDto.getAppName() + "\u5f00\u53d1\u56e2\u961f";
        AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
        developTeamDto.setTeamId(EngineUtil.getId());
        developTeamDto.setAppId(sysApplicationDto.getId());
        developTeamDto.setTeamName(teamName);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (HussarUtils.isEmpty((Object)user)) {
            ArrayList<Long> userLists = new ArrayList<Long>();
            userLists.add(sysApplicationDto.getCreator());
            developTeamDto.setUserIds(userLists);
        } else {
            developTeamDto.setUserIds(Arrays.asList(BaseSecurityUtil.getUser().getId()));
        }
        developTeamDto.setOpenTeam(sysApplicationDto.getOpenTeam());
        String finalName = this.eaiGetAppCodeNameService.getAppName(sysApplicationDto.getAppName());
        sysApplicationDto.setAppName(finalName);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppGroup::getGroupType, (Object)"1");
        SysAppGroup appGroup = (SysAppGroup)this.sysAppGroupService.getOne((Wrapper)queryWrapper);
        sysApplicationDto.setAppGroupId(appGroup.getId());
        this.sysApplicationService.save((Object)sysApplicationDto);
        developTeamDto.setAppId(sysApplicationDto.getId());
        this.developTeamService.saveAppDevelopTeam(developTeamDto);
        this.sysAppOperationLogService.saveAppOperation(sysApplicationDto.getId(), "2");
        HussarApplicationCallBackFactory.addCallback((SysApplication)sysApplicationDto);
        HussarCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return Boolean.TRUE;
    }
}

