/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.datasource.rdb.model.EaiQuerySqlConf;
import com.jxdinfo.hussar.eai.datasource.rdb.service.IEaiQuerySqlConfService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiMigrationRemoveApiService;
import com.jxdinfo.hussar.eai.webservice.manager.api.model.EaiEditApiWsdl;
import com.jxdinfo.hussar.eai.webservice.manager.api.service.IEaiEditApiWsdlService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.service.impl.EaiMigrationRemoveApiServiceImpl")
public class EaiMigrationRemoveApiServiceImpl
implements IEaiMigrationRemoveApiService {
    @Resource
    private IEaiApiInfoService apiInfoService;
    @Resource
    private IEaiEditApiService eaiEditApiService;
    @Resource
    private EaiCanvasInfoService eaiCanvasInfoService;
    @Resource
    private IEaiEditApiWsdlService eaiEditApiWsdlService;
    @Resource
    private IEaiQuerySqlConfService eaiQuerySqlConfService;
    @Resource
    private IApiCallSpecificationInfoService apiCallSpecificationInfoService;

    public boolean removeById(Long apiId, String appCode) {
        this.apiInfoService.removeById((Serializable)apiId);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiId);
        List editApiList = this.eaiEditApiService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)editApiList)) {
            for (EditApi editApi : editApiList) {
                this.eaiEditApiService.removeById((Serializable)editApi.getId());
                this.eaiCanvasInfoService.deleteApiCanvasInfo(editApi);
            }
        }
        LambdaQueryWrapper cWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiCallSpecificationInfo::getApiId, (Object)apiId);
        this.apiCallSpecificationInfoService.remove((Wrapper)cWrapper);
        LambdaQueryWrapper wsdlWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiEditApiWsdl::getApiId, (Object)apiId);
        this.eaiEditApiWsdlService.remove((Wrapper)wsdlWrapper);
        LambdaQueryWrapper sqlWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiQuerySqlConf::getApiId, (Object)apiId);
        this.eaiQuerySqlConfService.remove((Wrapper)sqlWrapper);
        EaiAppEditManager.getInstance().call(appCode);
        return true;
    }
}

