/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiVersionVo;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiAppAuthVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.IEaiApplicationManagementService;
import com.jxdinfo.hussar.eai.atomicbase.api.open.service.EaiApiVersionService;
import com.jxdinfo.hussar.eai.logsinfo.api.model.EaiPublishLog;
import com.jxdinfo.hussar.eai.logsinfo.api.service.IEaiPublishLogService;
import com.jxdinfo.hussar.eai.migration.business.enums.AppMigrationDataChangeTypeEnum;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiMigrationDumpVersionService;
import com.jxdinfo.hussar.eai.migration.business.vo.AppChangeTypeVo;
import com.jxdinfo.hussar.eai.migration.business.vo.AppVersionPageVo;
import com.jxdinfo.hussar.eai.migration.business.vo.EaiPublishRemarkVo;
import com.jxdinfo.hussar.eai.migration.business.vo.ExternalApiListVo;
import com.jxdinfo.hussar.eai.migration.business.vo.ExternalAppListVo;
import com.jxdinfo.hussar.eai.migration.business.vo.ExternalResourceListVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.service.impl.EaiMigrationDumpVersionServiceImpl")
public class EaiMigrationDumpVersionServiceImpl
implements IEaiMigrationDumpVersionService {
    @Resource
    private IEaiApplyService eaiApplyService;
    @Resource
    private IEaiPublishLogService eaiPublishLogService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private IEaiApplicationManagementService eaiApplicationManagementService;
    @Autowired
    private EaiApiVersionService eaiApiVersionService;

    public Page<AppVersionPageVo> getAppVersionPage(PageInfo pageInfo, String appCode) {
        if (ToolUtil.isEmpty((Object)appCode)) {
            throw new BaseException("\u672a\u4f20\u9012\u5e94\u7528\u6807\u8bc6");
        }
        if (ToolUtil.isEmpty((Object)pageInfo.getCurrent())) {
            pageInfo.setCurrent(1L);
        }
        if (ToolUtil.isEmpty((Object)pageInfo.getSize())) {
            pageInfo.setSize(10L);
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        SysApplication application = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode));
        List applyList = this.eaiApplyService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApply::getApplyCode, (Object)appCode)).eq(EaiApply::getResourceStatus, (Object)"1"));
        List publishLogList = new ArrayList();
        HashMap<String, EaiApply> applyMap = new HashMap();
        if (ToolUtil.isNotEmpty((Object)applyList)) {
            List publishIds = applyList.stream().map(EaiApply::getResourceId).collect(Collectors.toList());
            applyMap = applyList.stream().collect(Collectors.toMap(EaiApply::getResourceId, Function.identity()));
            publishLogList = this.eaiPublishLogService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(EaiPublishLog::getPublishId, publishIds));
        }
        if (ToolUtil.isEmpty(publishLogList)) {
            return page;
        }
        ArrayList<AppVersionPageVo> resultList = new ArrayList<AppVersionPageVo>();
        boolean flag = false;
        for (EaiPublishLog publishLog : publishLogList) {
            resultList.add(this.fillAppVersionPageVo(publishLog, applyMap));
            if (!application.getAppVersion().equals(publishLog.getLogVersion())) continue;
            flag = true;
        }
        if (!flag) {
            AppVersionPageVo pageVo = new AppVersionPageVo();
            pageVo.setApplyName(application.getAppName());
            pageVo.setApplyCode(application.getAppCode());
            pageVo.setLogVersion(application.getAppVersion());
            resultList.add(pageVo);
        }
        resultList.sort((o1, o2) -> {
            Integer v1 = Integer.valueOf(o1.getLogVersion().replace("v", ""));
            Integer v2 = Integer.valueOf(o2.getLogVersion().replace("v", ""));
            return v2.compareTo(v1);
        });
        page.setTotal((long)resultList.size());
        int start = Integer.parseInt(String.valueOf((pageInfo.getCurrent() - 1L) * pageInfo.getSize()));
        int end = Integer.parseInt(String.valueOf(pageInfo.getCurrent() * pageInfo.getSize()));
        end = Math.min(end, resultList.size());
        page.setRecords(resultList.subList(start, end));
        return page;
    }

    public List<AppChangeTypeVo> getChangeTypeDict() {
        return AppMigrationDataChangeTypeEnum.getAppChangeVos();
    }

    public List<ExternalAppListVo> getExternalAppList(String appCode) {
        if (ToolUtil.isEmpty((Object)appCode)) {
            return new ArrayList<ExternalAppListVo>();
        }
        ArrayList externalAppListVos = Lists.newArrayListWithCapacity((int)5);
        ApiResponse listAppAuth = this.eaiApplicationManagementService.eaiAppAuth(appCode);
        if (listAppAuth.isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)listAppAuth.getData()))) {
            for (EaiAppAuthVo appAuth : (List)listAppAuth.getData()) {
                ExternalAppListVo externalAppListVo = new ExternalAppListVo();
                externalAppListVo.setId(Long.valueOf(appAuth.getAppId()));
                externalAppListVo.setAppName(appAuth.getApplicationName());
                externalAppListVo.setAppCode(appAuth.getApplicationCode());
                externalAppListVos.add(externalAppListVo);
            }
        }
        return externalAppListVos;
    }

    public List<ExternalResourceListVo> getExternalResourceList(Long externalApiVersionId) {
        if (ToolUtil.isEmpty((Object)externalApiVersionId)) {
            return new ArrayList<ExternalResourceListVo>();
        }
        ArrayList externalResourceListVos = Lists.newArrayListWithCapacity((int)5);
        ApiResponse listApiResponse = this.eaiApiVersionService.openApiReferencingResources(externalApiVersionId);
        if (listApiResponse.isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)listApiResponse.getData()))) {
            ((List)listApiResponse.getData()).forEach(s -> {
                ExternalResourceListVo resourceVo = new ExternalResourceListVo();
                resourceVo.setId(s.getId());
                resourceVo.setName(s.getStructureName());
                resourceVo.setCode(s.getStructureCode());
                externalResourceListVos.add(resourceVo);
            });
        }
        return externalResourceListVos.stream().filter(er -> ToolUtil.isNotEmpty((Object)er.getName())).collect(Collectors.toList());
    }

    public List<ExternalApiListVo> getExternalApiList(String appCode, String externalAppCode) {
        if (ToolUtil.isEmpty((Object)appCode) || ToolUtil.isEmpty((Object)externalAppCode)) {
            return new ArrayList<ExternalApiListVo>();
        }
        ArrayList externalApiListVos = Lists.newArrayListWithCapacity((int)5);
        ApiResponse appApiAuthByCanvasFlagReponse = this.eaiApplicationManagementService.getAppApiAuthByCanvasFlag(externalAppCode, appCode, false);
        if (appApiAuthByCanvasFlagReponse.isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)appApiAuthByCanvasFlagReponse.getData()))) {
            for (ApiVersionVo apiVersion : (List)appApiAuthByCanvasFlagReponse.getData()) {
                ExternalApiListVo externalApi = new ExternalApiListVo();
                externalApi.setApiVersionId(apiVersion.getId());
                externalApi.setId(apiVersion.getApiId());
                externalApi.setApiName(apiVersion.getApiName());
                externalApi.setApiCode(apiVersion.getApiCode());
                externalApiListVos.add(externalApi);
            }
        }
        return externalApiListVos;
    }

    private AppVersionPageVo fillAppVersionPageVo(EaiPublishLog publishLog, Map<String, EaiApply> applyMap) {
        AppVersionPageVo pageVo = new AppVersionPageVo();
        EaiApply eaiApply = applyMap.get(String.valueOf(publishLog.getPublishId()));
        if (ToolUtil.isNotEmpty((Object)eaiApply)) {
            pageVo.setApplyId(eaiApply.getApplyId());
            pageVo.setApplyName(eaiApply.getApplyName());
            pageVo.setApplyCode(eaiApply.getApplyCode());
            pageVo.setFinishTime(eaiApply.getLastTime());
            pageVo.setApplyBy(eaiApply.getApplyBy());
        }
        pageVo.setLogName(publishLog.getLogName());
        pageVo.setLogVersion(publishLog.getLogVersion());
        List eaiPublishTestVos = JSON.parseArray((String)publishLog.getRemark(), EaiPublishRemarkVo.class);
        pageVo.setDetailInfo(eaiPublishTestVos);
        return pageVo;
    }
}

