/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiGetAppCodeNameService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.service.impl.EaiGetAppCodeNameServiceImpl")
public class EaiGetAppCodeNameServiceImpl
implements IEaiGetAppCodeNameService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ISysAppRecycleService sysAppRecycleService;

    public String getAppCode(String appCode) {
        LambdaQueryWrapper eqWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)appCode);
        long count = this.sysApplicationService.count((Wrapper)eqWrapper);
        LambdaQueryWrapper recycleeqWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppCode, (Object)appCode);
        long recycleCount = this.sysAppRecycleService.count((Wrapper)recycleeqWrapper);
        if (count <= 0L && recycleCount <= 0L) {
            return appCode;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SysApplication::getAppCode}).likeRight(SysApplication::getAppCode, (Object)appCode);
        List sysApplications = this.sysApplicationService.list((Wrapper)queryWrapper);
        LambdaQueryWrapper recycleWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SysAppRecycle::getAppCode}).likeRight(SysAppRecycle::getAppCode, (Object)appCode);
        List sysRecycleApplications = this.sysAppRecycleService.list((Wrapper)recycleWrapper);
        ArrayList list = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)sysApplications)) {
            List appList = sysApplications.stream().map(SysApplication::getAppCode).collect(Collectors.toList());
            list.addAll(appList);
        }
        if (HussarUtils.isNotEmpty((Object)sysRecycleApplications)) {
            List recycleList = sysRecycleApplications.stream().map(SysAppRecycle::getAppCode).collect(Collectors.toList());
            list.addAll(recycleList);
        }
        if (HussarUtils.isEmpty(list)) {
            return appCode;
        }
        int num = 1;
        String newCode = appCode;
        while (list.contains(newCode)) {
            newCode = this.newAppCode(appCode, num);
            ++num;
        }
        newCode = this.getAppCode(newCode);
        return newCode;
    }

    public String getAppName(String name) {
        LambdaQueryWrapper eqWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppName, (Object)name);
        long count = this.sysApplicationService.count((Wrapper)eqWrapper);
        LambdaQueryWrapper recycleeqWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecycle::getAppName, (Object)name);
        long recycleCount = this.sysAppRecycleService.count((Wrapper)recycleeqWrapper);
        if (count <= 0L && recycleCount <= 0L) {
            return name;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SysApplication::getAppName}).likeRight(SysApplication::getAppName, (Object)name);
        List sysApplications = this.sysApplicationService.list((Wrapper)queryWrapper);
        LambdaQueryWrapper recycleWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SysAppRecycle::getAppName}).likeRight(SysAppRecycle::getAppName, (Object)name);
        List sysRecycleApplications = this.sysAppRecycleService.list((Wrapper)recycleWrapper);
        ArrayList list = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)sysApplications)) {
            List appList = sysApplications.stream().map(SysApplication::getAppName).collect(Collectors.toList());
            list.addAll(appList);
        }
        if (HussarUtils.isNotEmpty((Object)sysRecycleApplications)) {
            List recycleList = sysRecycleApplications.stream().map(SysAppRecycle::getAppName).collect(Collectors.toList());
            list.addAll(recycleList);
        }
        if (HussarUtils.isEmpty(list)) {
            return name;
        }
        int i = 0;
        String finalName = name;
        while (list.contains(finalName)) {
            finalName = String.format("%s_%s", name, ++i);
        }
        finalName = this.getAppName(finalName);
        return finalName;
    }

    private String newAppCode(String appCode, int num) {
        return appCode + num;
    }
}

