/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.AuthHTTPBodyParams;
import com.jxdinfo.hussar.eai.common.util.ExpressionRegUtil;
import com.jxdinfo.hussar.eai.migration.business.model.AuthParamsValue;
import com.jxdinfo.hussar.eai.migration.business.service.IEaiAuthResourceIdsService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value=" com.jxdinfo.hussar.eai.migration.business.service.impl.EaiAuthResourceIdsServiceImpl")
public class EaiAuthResourceIdsServiceImpl
implements IEaiAuthResourceIdsService {
    @Resource
    private IEaiApplicationAuthService eaiApplicationAuthService;

    public List<Long> getPositionResourceIds(List<EaiParamsPosition> positionList) {
        if (HussarUtils.isEmpty(positionList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> constantIds = new ArrayList<Long>();
        for (EaiParamsPosition position : positionList) {
            if (!HussarUtils.isNotEmpty((Object)position.getEffective())) continue;
            List list = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
            for (EaiHttpParams httpParams : list) {
                String paramsValue = httpParams.getParamsValue();
                if (!"1".equals(httpParams.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                Long constantVersionId = Long.valueOf(paramsValue);
                constantIds.add(constantVersionId);
            }
        }
        return constantIds;
    }

    public List<EaiParamsPosition> replaceAuthParams(List<EaiParamsPosition> positionList) {
        if (HussarUtils.isEmpty(positionList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> authParamsIds = new ArrayList<Long>();
        for (EaiParamsPosition position : positionList) {
            if (!HussarUtils.isNotEmpty((Object)position.getEffective())) continue;
            List list = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
            for (EaiHttpParams httpParams : list) {
                String paramsValue = httpParams.getParamsValue();
                if (!"2".equals(httpParams.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                Long authParamsId = Long.valueOf(paramsValue);
                authParamsIds.add(authParamsId);
            }
        }
        if (HussarUtils.isNotEmpty(authParamsIds)) {
            List applicationAuths = this.eaiApplicationAuthService.listByIds(authParamsIds);
            Map map = applicationAuths.stream().collect(Collectors.toMap(EaiApplicationAuth::getParamsId, Function.identity()));
            if (HussarUtils.isNotEmpty((Object)applicationAuths)) {
                for (EaiParamsPosition position : positionList) {
                    if (!HussarUtils.isNotEmpty((Object)position.getEffective())) continue;
                    List list = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
                    for (EaiHttpParams httpParams : list) {
                        String paramsValue = httpParams.getParamsValue();
                        if (!"2".equals(httpParams.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                        Long authParamsId = Long.valueOf(paramsValue);
                        if (map.containsKey(authParamsId)) {
                            paramsValue = ((EaiApplicationAuth)map.get(authParamsId)).getParamsNameEn();
                        }
                        httpParams.setParamsValue(paramsValue);
                    }
                    position.setEffective(JSON.toJSONString((Object)list));
                }
            }
        }
        return positionList;
    }

    public List<EaiHttpParams> replaceHttpParams(List<EaiHttpParams> httpParamsList) {
        if (HussarUtils.isEmpty(httpParamsList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> authParamsIds = new ArrayList<Long>();
        for (EaiHttpParams httpParams : httpParamsList) {
            String paramsValue = httpParams.getParamsValue();
            if (!HussarUtils.isNotEmpty((Object)paramsValue) || !"2".equals(httpParams.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue)) continue;
            AuthHTTPBodyParams newParam = (AuthHTTPBodyParams)JSON.parseObject((String)paramsValue, AuthHTTPBodyParams.class);
            authParamsIds.add(Long.valueOf(newParam.getParamsValue()));
        }
        if (HussarUtils.isNotEmpty(authParamsIds)) {
            List applicationAuths = this.eaiApplicationAuthService.listByIds(authParamsIds);
            Map map = applicationAuths.stream().collect(Collectors.toMap(EaiApplicationAuth::getParamsId, Function.identity()));
            if (HussarUtils.isNotEmpty((Object)applicationAuths)) {
                for (EaiHttpParams httpParam : httpParamsList) {
                    String paramsValue = httpParam.getParamsValue();
                    if (!HussarUtils.isNotEmpty((Object)paramsValue) || !"2".equals(httpParam.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                    AuthHTTPBodyParams newParam = (AuthHTTPBodyParams)JSON.parseObject((String)paramsValue, AuthHTTPBodyParams.class);
                    Long authParamsId = Long.valueOf(newParam.getParamsValue());
                    if (map.containsKey(authParamsId)) {
                        newParam.setParamsValue(((EaiApplicationAuth)map.get(authParamsId)).getParamsNameEn());
                    }
                    httpParam.setParamsValue(JSON.toJSONString((Object)newParam));
                }
            }
        }
        return httpParamsList;
    }

    public List<Long> getConstantIdsFromVerifyBase(List<EaiHttpVerifyBase> verifyBaseList) {
        if (HussarUtils.isEmpty(verifyBaseList)) {
            return Collections.emptyList();
        }
        ArrayList<Long> constantVersionIds = new ArrayList<Long>();
        for (EaiHttpVerifyBase verifyBase : verifyBaseList) {
            String httpUrl;
            List ids;
            if (!"1".equals(verifyBase.getHttpUrlType()) || !HussarUtils.isNotEmpty((Object)verifyBase.getHttpUrl()) || !HussarUtils.isNotEmpty((Object)(ids = ExpressionRegUtil.findConstantIds((String)(httpUrl = verifyBase.getHttpUrl()))))) continue;
            constantVersionIds.addAll(ids);
        }
        return constantVersionIds;
    }

    public void getResourceIds(List<Long> constantIds, List<Long> structureIds, List<EaiHttpParams> httpParamsList) {
        for (EaiHttpParams httpParams : httpParamsList) {
            AuthParamsValue authParamsValue;
            boolean isException;
            block3: {
                String paramsValue = httpParams.getParamsValue();
                if (!HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                isException = false;
                authParamsValue = new AuthParamsValue();
                try {
                    authParamsValue = (AuthParamsValue)JSON.parseObject((String)paramsValue, AuthParamsValue.class);
                }
                catch (Exception e) {
                    isException = true;
                    if (!"1".equals(httpParams.getParamsFrom())) break block3;
                    constantIds.add(Long.valueOf(paramsValue));
                }
            }
            if (isException) continue;
            this.addAuthParamResourceIds(constantIds, structureIds, authParamsValue);
        }
    }

    public void replaceResourceIds(Map<Long, Long> constantIds, Map<Long, Long> structureIds, List<EaiHttpParams> httpParamsList) {
        for (EaiHttpParams httpParams : httpParamsList) {
            AuthParamsValue authParamsValue;
            boolean isException;
            block3: {
                String paramsValue = httpParams.getParamsValue();
                if (!HussarUtils.isNotEmpty((Object)paramsValue)) continue;
                isException = false;
                authParamsValue = new AuthParamsValue();
                try {
                    authParamsValue = (AuthParamsValue)JSON.parseObject((String)paramsValue, AuthParamsValue.class);
                }
                catch (Exception e) {
                    isException = true;
                    if (!"1".equals(httpParams.getParamsFrom()) || !constantIds.containsKey(Long.valueOf(paramsValue))) break block3;
                    httpParams.setParamsValue(String.valueOf(constantIds.get(Long.valueOf(paramsValue))));
                }
            }
            if (isException) continue;
            this.replaceAuthParamResourceIds(constantIds, structureIds, authParamsValue);
            httpParams.setParamsValue(JSON.toJSONString((Object)authParamsValue));
        }
    }

    public void replaceConstantIdsFromVerifyBase(List<EaiHttpVerifyBase> verifyBaseList, Map<Long, Long> constantIds) {
        if (HussarUtils.isEmpty(verifyBaseList)) {
            return;
        }
        for (EaiHttpVerifyBase verifyBase : verifyBaseList) {
            String httpUrl;
            List ids;
            if (!"1".equals(verifyBase.getHttpUrlType()) || !HussarUtils.isNotEmpty((Object)verifyBase.getHttpUrl()) || !HussarUtils.isNotEmpty((Object)(ids = ExpressionRegUtil.findConstantIds((String)(httpUrl = verifyBase.getHttpUrl()))))) continue;
            for (Long id : ids) {
                if (!constantIds.containsKey(id)) continue;
                httpUrl = httpUrl.replace("\"" + id + "\"", "\"" + constantIds.get(id) + "\"");
            }
            verifyBase.setHttpUrl(httpUrl);
        }
    }

    public void replacePositionResourceIds(List<EaiParamsPosition> paramsPositionList, Map<Long, Long> constantIdMap) {
        for (EaiParamsPosition position : paramsPositionList) {
            if (!HussarUtils.isNotEmpty((Object)position.getEffective())) continue;
            List list = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
            for (EaiHttpParams httpParams : list) {
                String paramsValue = httpParams.getParamsValue();
                if (!"1".equals(httpParams.getParamsFrom()) || !HussarUtils.isNotEmpty((Object)paramsValue) || !constantIdMap.containsKey(Long.valueOf(paramsValue))) continue;
                httpParams.setParamsValue(String.valueOf(constantIdMap.get(Long.valueOf(paramsValue))));
            }
            position.setEffective(JSON.toJSONString((Object)list));
        }
    }

    private void replaceAuthParamResourceIds(Map<Long, Long> constantIds, Map<Long, Long> structureIds, AuthParamsValue authParamsValue) {
        List children;
        String quoteStrucId;
        List ids;
        String paramsValue = authParamsValue.getParamsValue();
        if ("1".equals(authParamsValue.getParamsFrom()) && HussarUtils.isNotEmpty((Object)paramsValue) && HussarUtils.isNotEmpty(constantIds) && constantIds.containsKey(Long.valueOf(paramsValue))) {
            authParamsValue.setParamsValue(String.valueOf(constantIds.get(Long.valueOf(paramsValue))));
        }
        if ("0".equals(authParamsValue.getParamsFrom()) && HussarUtils.isNotEmpty((Object)paramsValue) && HussarUtils.isNotEmpty((Object)(ids = ExpressionRegUtil.findConstantIds((String)paramsValue))) && HussarUtils.isNotEmpty(constantIds)) {
            for (Long id : ids) {
                if (!constantIds.containsKey(id)) continue;
                paramsValue = paramsValue.replace("\"" + id + "\"", "\"" + constantIds.get(id) + "\"");
            }
            authParamsValue.setParamsValue(paramsValue);
        }
        if (HussarUtils.isNotEmpty((Object)(quoteStrucId = authParamsValue.getQuoteStructureId())) && HussarUtils.isNotEmpty(structureIds) && structureIds.containsKey(Long.valueOf(quoteStrucId))) {
            authParamsValue.setQuoteStructureId(String.valueOf(structureIds.get(Long.valueOf(quoteStrucId))));
        }
        if (HussarUtils.isNotEmpty((Object)(children = authParamsValue.getItems()))) {
            for (AuthParamsValue child : children) {
                this.replaceAuthParamResourceIds(constantIds, structureIds, child);
            }
            authParamsValue.setItems(children);
        }
    }

    private void addAuthParamResourceIds(List<Long> constantIds, List<Long> structureIds, AuthParamsValue authParamsValue) {
        List children;
        String quoteStrucId;
        String paramsValue;
        if ("1".equals(authParamsValue.getParamsFrom()) && HussarUtils.isNotEmpty((Object)(paramsValue = authParamsValue.getParamsValue()))) {
            constantIds.add(Long.valueOf(paramsValue));
        }
        if ("0".equals(authParamsValue.getParamsFrom()) && HussarUtils.isNotEmpty((Object)authParamsValue.getParamsValue())) {
            constantIds.addAll(ExpressionRegUtil.findConstantIds((String)authParamsValue.getParamsValue()));
        }
        if (HussarUtils.isNotEmpty((Object)(quoteStrucId = authParamsValue.getQuoteStructureId()))) {
            structureIds.add(Long.valueOf(quoteStrucId));
        }
        if (HussarUtils.isNotEmpty((Object)(children = authParamsValue.getItems()))) {
            for (AuthParamsValue child : children) {
                this.addAuthParamResourceIds(constantIds, structureIds, child);
            }
        }
    }
}

