/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.migration.business.resources.service.IEaiCleanStructureItemService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.service.impl.EaiCleanStructureItemServiceImpl")
public class EaiCleanStructureItemServiceImpl
implements IEaiCleanStructureItemService {
    @Resource
    private IStructureVersionService structureVersionService;

    public void cleanItems(List<StructureVersion> structureVersions) {
        this.cleanItems(structureVersions, null);
    }

    private void cleanItems(List<StructureVersion> structureVersions, List<Long> oldIds) {
        if (HussarUtils.isNotEmpty(structureVersions)) {
            if (HussarUtils.isNotEmpty(oldIds)) {
                oldIds.addAll(structureVersions.stream().map(StructureVersion::getId).collect(Collectors.toList()));
            } else {
                oldIds = structureVersions.stream().map(StructureVersion::getId).collect(Collectors.toList());
            }
            ArrayList<Long> newIds = new ArrayList<Long>();
            for (StructureVersion structureVersion : structureVersions) {
                List structureItems;
                String val = structureVersion.getStructureValues();
                if (!HussarUtils.isNotEmpty((Object)val) || !HussarUtils.isNotEmpty((Object)(structureItems = JSON.parseArray((String)val, StructureItems.class)))) continue;
                this.cleanItems(structureItems, oldIds, newIds);
                structureVersion.setStructureValues(JSON.toJSONString((Object)structureItems));
            }
            if (HussarUtils.isNotEmpty(newIds)) {
                List structureVersions1 = this.structureVersionService.listByIds(newIds);
                if (HussarUtils.isNotEmpty(oldIds)) {
                    oldIds.addAll(newIds);
                } else {
                    oldIds = newIds;
                }
                this.cleanItems(structureVersions1, oldIds);
                structureVersions.addAll(structureVersions1);
            }
        }
    }

    private void cleanItems(List<StructureItems> structureItems, List<Long> oldIds, List<Long> newIds) {
        for (StructureItems structureItem : structureItems) {
            if (HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId())) {
                structureItem.setItems(Collections.emptyList());
                Long id = Long.valueOf(structureItem.getQuoteStructureId());
                if (oldIds.contains(id)) continue;
                oldIds.add(id);
                newIds.add(id);
                continue;
            }
            if (EaiDataType.DATA_TYPE_LIST.getType() != structureItem.getType().intValue() || EaiDataType.DATA_TYPE_STRUCTURE.getType() != structureItem.getItemType().intValue()) continue;
            this.cleanItems(structureItem.getItems(), oldIds, newIds);
        }
    }
}

