/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.migration.business.resources.extra.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.migration.business.resources.extra.service.IEaiExtraResourcesService;
import com.jxdinfo.hussar.eai.migration.dto.EaiCommonResourcesDto;
import com.jxdinfo.hussar.eai.migration.enums.ApplicationMigrationExportEnum;
import com.jxdinfo.hussar.eai.migration.enums.EaiServiceTypeEnum;
import com.jxdinfo.hussar.eai.migration.manifest.EaiServiceManiFest;
import com.jxdinfo.hussar.eai.migration.resources.extra.dto.EaiExtraResourceDto;
import com.jxdinfo.hussar.eai.migration.resources.service.IEaiResourcesService;
import com.jxdinfo.hussar.eai.migration.util.MigrationUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.service.IEaiLogicVersionService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.migration.business.resources.extra.service.impl.EaiExtraResourcesServiceImpl")
public class EaiExtraResourcesServiceImpl
implements IEaiExtraResourcesService {
    @Autowired
    private IApiVersionService apiVersionService;
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Autowired
    private ICanvasInfoService canvasInfoService;
    @Autowired
    private IEaiEditApiService eaiEditApiService;
    @Autowired
    private IEaiLogicVersionService eaiLogicVersionService;
    @Autowired
    private IEaiResourcesInfoService eaiResourcesInfoService;
    public static final String RESOURCE_SPLIT_STR = ":";

    public EaiCommonResourcesDto getDumpResources(SysApplication sysApplication, String appVersion, String args) {
        LambdaQueryWrapper queryWrapper;
        List<String> versions;
        EaiCommonResourcesDto eaiCommonResourcesDto = new EaiCommonResourcesDto();
        List editApis = (List)HussarCacheUtil.get((String)this.getEditApiCacheKey(sysApplication, appVersion), (Object)this.getEditApiCacheKey(sysApplication, appVersion));
        List logics = (List)HussarCacheUtil.get((String)this.getLogicCacheKey(sysApplication, appVersion), (Object)this.getLogicCacheKey(sysApplication, appVersion));
        List<Object> canvasIds = new ArrayList();
        if (HussarUtils.isEmpty((Object)editApis)) {
            versions = this.getVersions(appVersion);
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiVersion::getApplicationCode, (Object)sysApplication.getAppCode())).in(EaiApiVersion::getApiVersion, versions);
            List apiVersions = this.apiVersionService.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)apiVersions)) {
                editApis = this.eaiEditApiService.list((Wrapper)new LambdaQueryWrapper().in(EditApi::getApiId, (Collection)apiVersions.stream().map(EaiApiVersion::getApiVersionId).collect(Collectors.toList())));
            }
        }
        if (HussarUtils.isEmpty((Object)editApis)) {
            return eaiCommonResourcesDto;
        }
        canvasIds = editApis.stream().map(EditApi::getCanvasId).collect(Collectors.toList());
        if (HussarUtils.isEmpty((Object)logics)) {
            versions = this.getVersions(appVersion);
            queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LogicVersion::getApplicationCode, (Object)sysApplication.getAppCode())).in(LogicVersion::getLogicVersion, versions);
            List logicVersions = this.eaiLogicVersionService.list((Wrapper)queryWrapper);
            List ids = logicVersions.stream().map(LogicVersion::getCanvasId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(ids)) {
                canvasIds.addAll(ids);
            }
        } else {
            List ids = logics.stream().map(LogicVersion::getCanvasId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(ids)) {
                canvasIds.addAll(ids);
            }
        }
        if (HussarUtils.isEmpty(canvasIds)) {
            return eaiCommonResourcesDto;
        }
        List canvasInfoList = this.canvasInfoService.listByIds(canvasIds = canvasIds.stream().distinct().collect(Collectors.toList()));
        if (HussarUtils.isEmpty((Object)canvasInfoList)) {
            return eaiCommonResourcesDto;
        }
        List<String> apiIds = canvasInfoList.stream().map(CanvasInfo::getApiCodes).collect(Collectors.toList());
        List<Long> ids = this.getApiIds(apiIds);
        if (HussarUtils.isEmpty(ids)) {
            return eaiCommonResourcesDto;
        }
        LambdaQueryWrapper resourceQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiResourcesInfo::getResourceRelationId, ids)).eq(EaiResourcesInfo::getDeleteState, (Object)"0");
        List resourcesInfos = this.eaiResourcesInfoService.list((Wrapper)resourceQueryWrapper);
        List apiVersions = null;
        if (HussarUtils.isNotEmpty((Object)resourcesInfos)) {
            LambdaQueryWrapper queryWrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiApiVersion::getApiVersionId, (Collection)resourcesInfos.stream().map(EaiResourcesInfo::getResourceVersionId).collect(Collectors.toList()));
            apiVersions = this.apiVersionService.list((Wrapper)queryWrapper2);
        }
        if (HussarUtils.isEmpty(apiVersions)) {
            return eaiCommonResourcesDto;
        }
        ArrayList<EaiExtraResourceDto> list = new ArrayList<EaiExtraResourceDto>(apiVersions.size());
        HashMap<String, String> map = new HashMap<String, String>();
        List<Long> versionIds = apiVersions.stream().map(EaiApiVersion::getApiId).collect(Collectors.toList());
        Map<Long, List<EaiApiVersion>> real = this.getRealApiVersions(editApis, canvasInfoList, versionIds);
        Map<Long, List<LogicVersion>> realLogic = this.getRealLogicVersions(logics, canvasInfoList, versionIds);
        if (HussarUtils.isEmpty(real)) {
            return eaiCommonResourcesDto;
        }
        for (EaiApiVersion apiVersion : apiVersions) {
            List<LogicVersion> logicVersionList;
            List<EaiApiVersion> apiVersionList = real.get(apiVersion.getApiId());
            if (HussarUtils.isNotEmpty(apiVersionList)) {
                for (EaiApiVersion curr : apiVersionList) {
                    EaiExtraResourceDto eaiExtraResourceDto = this.createEaiExtraResourceDto(apiVersion, curr, map, sysApplication);
                    list.add(eaiExtraResourceDto);
                }
            }
            if (!HussarUtils.isNotEmpty(realLogic) || !HussarUtils.isNotEmpty(logicVersionList = realLogic.get(apiVersion.getApiVersionId()))) continue;
            for (LogicVersion curr : logicVersionList) {
                EaiExtraResourceDto eaiExtraResourceDto = this.createEaiExtraResourceDto(apiVersion, curr, map, sysApplication);
                list.add(eaiExtraResourceDto);
            }
        }
        eaiCommonResourcesDto.setResult(list);
        return eaiCommonResourcesDto;
    }

    private EaiExtraResourceDto createEaiExtraResourceDto(EaiApiVersion apiVersion, EaiApiVersion curr, Map<String, String> map, SysApplication sysApplication) {
        EaiExtraResourceDto eaiExtraResourceDto = new EaiExtraResourceDto();
        eaiExtraResourceDto.setCode(curr.getApiCode());
        eaiExtraResourceDto.setName(curr.getApiName());
        eaiExtraResourceDto.setAppCode(curr.getApplicationCode());
        eaiExtraResourceDto.setAppName(sysApplication.getAppName());
        eaiExtraResourceDto.setType(EaiResourcesEnum.API.getType());
        eaiExtraResourceDto.setExtraApiCode(apiVersion.getApiCode());
        eaiExtraResourceDto.setExtraApiName(apiVersion.getApiName());
        eaiExtraResourceDto.setExtraAppCode(apiVersion.getApplicationCode());
        if (map.containsKey(apiVersion.getApplicationCode())) {
            eaiExtraResourceDto.setExtraAppName(map.get(apiVersion.getApplicationCode()));
        } else {
            SysApplication extraApp = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)apiVersion.getApplicationCode()));
            eaiExtraResourceDto.setExtraAppName(extraApp.getAppName());
            map.put(apiVersion.getApplicationCode(), extraApp.getAppName());
        }
        return eaiExtraResourceDto;
    }

    private EaiExtraResourceDto createEaiExtraResourceDto(EaiApiVersion apiVersion, LogicVersion curr, Map<String, String> map, SysApplication sysApplication) {
        EaiExtraResourceDto eaiExtraResourceDto = new EaiExtraResourceDto();
        eaiExtraResourceDto.setCode(curr.getLogicCode());
        eaiExtraResourceDto.setName(curr.getLogicName());
        eaiExtraResourceDto.setAppCode(curr.getApplicationCode());
        eaiExtraResourceDto.setAppName(sysApplication.getAppName());
        eaiExtraResourceDto.setType(EaiResourcesEnum.LOGIC.getType());
        eaiExtraResourceDto.setExtraApiCode(apiVersion.getApiCode());
        eaiExtraResourceDto.setExtraApiName(apiVersion.getApiName());
        eaiExtraResourceDto.setAppCode(apiVersion.getApplicationCode());
        if (map.containsKey(apiVersion.getApplicationCode())) {
            eaiExtraResourceDto.setExtraAppName(map.get(apiVersion.getApplicationCode()));
        } else {
            SysApplication extraApp = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)apiVersion.getApplicationCode()));
            map.put(apiVersion.getApplicationCode(), extraApp.getAppName());
        }
        return eaiExtraResourceDto;
    }

    private Map<Long, List<EaiApiVersion>> getRealApiVersions(List<EditApi> editApis, List<CanvasInfo> canvasInfoList, List<Long> versionIds) {
        HashMap<Long, Long> canvasIdMap = new HashMap<Long, Long>();
        for (Long versionId : versionIds) {
            for (CanvasInfo canvasInfo : canvasInfoList) {
                if (!HussarUtils.isNotEmpty((Object)canvasInfo.getApiCodes()) || !canvasInfo.getApiCodes().contains(String.valueOf(versionId))) continue;
                canvasIdMap.put(canvasInfo.getId(), versionId);
            }
        }
        if (HussarUtils.isNotEmpty(editApis)) {
            HashMap<Long, List<EaiApiVersion>> map = new HashMap<Long, List<EaiApiVersion>>();
            for (EditApi editApi : editApis) {
                List<EaiApiVersion> apiVersions;
                if (!canvasIdMap.containsKey(editApi.getCanvasId())) continue;
                EaiApiVersion apiVersion = (EaiApiVersion)this.apiVersionService.getById((Serializable)editApi.getApiId());
                if (map.containsKey(canvasIdMap.get(editApi.getCanvasId()))) {
                    apiVersions = (List)map.get(canvasIdMap.get(editApi.getCanvasId()));
                    apiVersions.add(apiVersion);
                    map.put((Long)canvasIdMap.get(editApi.getCanvasId()), apiVersions);
                    continue;
                }
                apiVersions = new ArrayList<EaiApiVersion>(1);
                apiVersions.add(apiVersion);
                map.put((Long)canvasIdMap.get(editApi.getCanvasId()), apiVersions);
            }
            return map;
        }
        return null;
    }

    private Map<Long, List<LogicVersion>> getRealLogicVersions(List<LogicVersion> logics, List<CanvasInfo> canvasInfoList, List<Long> versionIds) {
        HashMap<Long, Long> canvasIdMap = new HashMap<Long, Long>();
        for (Long versionId : versionIds) {
            for (CanvasInfo canvasInfo : canvasInfoList) {
                if (!HussarUtils.isNotEmpty((Object)canvasInfo.getApiCodes()) || !canvasInfo.getApiCodes().contains(String.valueOf(versionId))) continue;
                canvasIdMap.put(canvasInfo.getId(), versionId);
            }
        }
        if (HussarUtils.isNotEmpty(logics)) {
            HashMap<Long, List<LogicVersion>> map = new HashMap<Long, List<LogicVersion>>();
            for (LogicVersion logicVersion : logics) {
                List<LogicVersion> apiVersions;
                if (!canvasIdMap.containsKey(logicVersion.getCanvasId())) continue;
                LogicVersion logic = (LogicVersion)this.eaiLogicVersionService.getById((Serializable)logicVersion.getId());
                if (map.containsKey(canvasIdMap.get(logicVersion.getCanvasId()))) {
                    apiVersions = (List)map.get(canvasIdMap.get(logicVersion.getCanvasId()));
                    apiVersions.add(logic);
                    map.put((Long)canvasIdMap.get(logicVersion.getCanvasId()), apiVersions);
                    continue;
                }
                apiVersions = new ArrayList<LogicVersion>(1);
                apiVersions.add(logic);
                map.put((Long)canvasIdMap.get(logicVersion.getCanvasId()), apiVersions);
            }
            return map;
        }
        return null;
    }

    private List<String> getVersions(String appVersion) {
        Integer v = Integer.valueOf(appVersion.substring(1));
        ArrayList<String> versions = new ArrayList<String>(v);
        while (v > 0) {
            versions.add(String.format("v%s", v));
            Integer n = v;
            Integer n2 = v = Integer.valueOf(v - 1);
        }
        return versions;
    }

    private String getEditApiCacheKey(SysApplication sysApplication, String appVersion) {
        return String.format("hussar:eai:migration:dump:editapi_%s_%s", sysApplication.getAppCode(), appVersion);
    }

    private String getLogicCacheKey(SysApplication sysApplication, String appVersion) {
        return String.format("hussar:eai:migration:dump:logic_%s_%s", sysApplication.getAppCode(), appVersion);
    }

    private List<Long> getApiIds(List<String> apiIds) {
        ArrayList<Long> otherIds = new ArrayList<Long>();
        for (String apiCodes : apiIds) {
            if (!HussarUtils.isNotEmpty((Object)apiCodes)) continue;
            Map apiMap = (Map)JSON.parseObject((String)apiCodes, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]);
            Set keySet = apiMap.keySet();
            for (String key : keySet) {
                String[] keyArray = key.split(RESOURCE_SPLIT_STR);
                if (!ToolUtil.isNotEmpty((Object)keyArray) || keyArray.length != 2) continue;
                otherIds.add(Long.valueOf(keyArray[1]));
            }
        }
        return otherIds;
    }

    public EaiServiceManiFest resourcesMetadata() {
        return MigrationUtil.createResourcesManiFest((ApplicationMigrationExportEnum)ApplicationMigrationExportEnum.EXTRA_APP_INFO_FILE, (IEaiResourcesService)this, (EaiServiceTypeEnum)EaiServiceTypeEnum.EXTERNAL);
    }
}

